/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data;

import java.math.BigDecimal;
import org.apache.pinot.spi.data.SingleValueVisitor;

public interface MultiValueVisitor<R> {
    public R visitInt(int[] var1);

    public R visitLong(long[] var1);

    public R visitFloat(float[] var1);

    public R visitDouble(double[] var1);

    public R visitBigDecimal(BigDecimal[] var1);

    public R visitBoolean(boolean[] var1);

    public R visitTimestamp(long[] var1);

    public R visitString(String[] var1);

    public R visitJson(String[] var1);

    public R visitBytes(byte[][] var1);

    default public SingleValueVisitor<R> asSingleValueVisitor() {
        return new SingleValueVisitor<R>(){

            @Override
            public R visitInt(int value) {
                return MultiValueVisitor.this.visitInt(new int[]{value});
            }

            @Override
            public R visitLong(long value) {
                return MultiValueVisitor.this.visitLong(new long[]{value});
            }

            @Override
            public R visitFloat(float value) {
                return MultiValueVisitor.this.visitFloat(new float[]{value});
            }

            @Override
            public R visitDouble(double value) {
                return MultiValueVisitor.this.visitDouble(new double[]{value});
            }

            @Override
            public R visitBigDecimal(BigDecimal value) {
                return MultiValueVisitor.this.visitBigDecimal(new BigDecimal[]{value});
            }

            @Override
            public R visitBoolean(boolean value) {
                return MultiValueVisitor.this.visitBoolean(new boolean[]{value});
            }

            @Override
            public R visitTimestamp(long value) {
                return MultiValueVisitor.this.visitLong(new long[]{value});
            }

            @Override
            public R visitString(String value) {
                return MultiValueVisitor.this.visitString(new String[]{value});
            }

            @Override
            public R visitJson(String value) {
                return MultiValueVisitor.this.visitString(new String[]{value});
            }

            @Override
            public R visitBytes(byte[] value) {
                return MultiValueVisitor.this.visitBytes(new byte[][]{value});
            }
        };
    }
}

