/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.spi.data.ComplexFieldSpec;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DateTimeGranularitySpec;
import org.apache.pinot.spi.data.DimensionFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.MetricFieldSpec;
import org.apache.pinot.spi.data.TimeFieldSpec;
import org.apache.pinot.spi.data.TimeGranularitySpec;
import org.apache.pinot.spi.utils.EqualityUtils;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class Schema
implements Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(Schema.class);
    private String _schemaName;
    private final List<DimensionFieldSpec> _dimensionFieldSpecs = new ArrayList<DimensionFieldSpec>();
    private final List<MetricFieldSpec> _metricFieldSpecs = new ArrayList<MetricFieldSpec>();
    private TimeFieldSpec _timeFieldSpec;
    private final List<DateTimeFieldSpec> _dateTimeFieldSpecs = new ArrayList<DateTimeFieldSpec>();
    private final List<ComplexFieldSpec> _complexFieldSpecs = new ArrayList<ComplexFieldSpec>();
    private List<String> _primaryKeyColumns;
    private final TreeMap<String, FieldSpec> _fieldSpecMap = new TreeMap();
    private final List<String> _dimensionNames = new ArrayList<String>();
    private final List<String> _metricNames = new ArrayList<String>();
    private final List<String> _dateTimeNames = new ArrayList<String>();
    private boolean _hasJSONColumn;

    public static Schema fromFile(File schemaFile) throws IOException {
        return JsonUtils.fileToObject(schemaFile, Schema.class);
    }

    public static Schema fromString(String schemaString) throws IOException {
        return JsonUtils.stringToObject(schemaString, Schema.class);
    }

    public static Pair<Schema, Map<String, Object>> parseSchemaAndUnrecognizedPropsfromInputStream(InputStream schemaInputStream) throws IOException {
        return JsonUtils.inputStreamToObjectAndUnrecognizedProperties(schemaInputStream, Schema.class);
    }

    public static Schema fromInputStream(InputStream schemaInputStream) throws IOException {
        return JsonUtils.inputStreamToObject(schemaInputStream, Schema.class);
    }

    public static void validate(FieldSpec.FieldType fieldType, FieldSpec.DataType dataType) {
        block0 : switch (fieldType) {
            case DIMENSION: 
            case TIME: 
            case DATE_TIME: {
                switch (dataType) {
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case BIG_DECIMAL: 
                    case BOOLEAN: 
                    case TIMESTAMP: 
                    case STRING: 
                    case JSON: 
                    case BYTES: {
                        break block0;
                    }
                }
                throw new IllegalStateException("Unsupported data type: " + dataType + " in DIMENSION/TIME field");
            }
            case METRIC: {
                switch (dataType) {
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: 
                    case BIG_DECIMAL: 
                    case BYTES: {
                        break block0;
                    }
                }
                throw new IllegalStateException("Unsupported data type: " + dataType + " in METRIC field");
            }
            case COMPLEX: {
                switch (dataType) {
                    case STRUCT: 
                    case MAP: 
                    case LIST: {
                        break block0;
                    }
                }
                throw new IllegalStateException("Unsupported data type: " + dataType + " in COMPLEX field");
            }
            default: {
                throw new IllegalStateException("Unsupported data type: " + dataType + " for field");
            }
        }
    }

    public String getSchemaName() {
        return this._schemaName;
    }

    public void setSchemaName(String schemaName) {
        this._schemaName = schemaName;
    }

    public List<String> getPrimaryKeyColumns() {
        return this._primaryKeyColumns;
    }

    public void setPrimaryKeyColumns(List<String> primaryKeyColumns) {
        this._primaryKeyColumns = primaryKeyColumns;
    }

    public List<DimensionFieldSpec> getDimensionFieldSpecs() {
        return this._dimensionFieldSpecs;
    }

    @Deprecated
    public void setDimensionFieldSpecs(List<DimensionFieldSpec> dimensionFieldSpecs) {
        Preconditions.checkState((boolean)this._dimensionFieldSpecs.isEmpty());
        for (DimensionFieldSpec dimensionFieldSpec : dimensionFieldSpecs) {
            this.addField(dimensionFieldSpec);
        }
    }

    public List<MetricFieldSpec> getMetricFieldSpecs() {
        return this._metricFieldSpecs;
    }

    @Deprecated
    public void setMetricFieldSpecs(List<MetricFieldSpec> metricFieldSpecs) {
        Preconditions.checkState((boolean)this._metricFieldSpecs.isEmpty());
        for (MetricFieldSpec metricFieldSpec : metricFieldSpecs) {
            this.addField(metricFieldSpec);
        }
    }

    public List<DateTimeFieldSpec> getDateTimeFieldSpecs() {
        return this._dateTimeFieldSpecs;
    }

    @Deprecated
    public void setDateTimeFieldSpecs(List<DateTimeFieldSpec> dateTimeFieldSpecs) {
        Preconditions.checkState((boolean)this._dateTimeFieldSpecs.isEmpty());
        for (DateTimeFieldSpec dateTimeFieldSpec : dateTimeFieldSpecs) {
            this.addField(dateTimeFieldSpec);
        }
    }

    public TimeFieldSpec getTimeFieldSpec() {
        return this._timeFieldSpec;
    }

    @Deprecated
    public void setTimeFieldSpec(TimeFieldSpec timeFieldSpec) {
        if (timeFieldSpec != null) {
            this.addField(timeFieldSpec);
        }
    }

    public void addField(FieldSpec fieldSpec) {
        Preconditions.checkNotNull((Object)fieldSpec);
        String columnName = fieldSpec.getName();
        Preconditions.checkNotNull((Object)columnName);
        Preconditions.checkState((!this._fieldSpecMap.containsKey(columnName) ? 1 : 0) != 0, (Object)("Field spec already exists for column: " + columnName));
        FieldSpec.FieldType fieldType = fieldSpec.getFieldType();
        switch (fieldType) {
            case DIMENSION: {
                this._dimensionNames.add(columnName);
                this._dimensionFieldSpecs.add((DimensionFieldSpec)fieldSpec);
                break;
            }
            case METRIC: {
                this._metricNames.add(columnName);
                this._metricFieldSpecs.add((MetricFieldSpec)fieldSpec);
                break;
            }
            case TIME: {
                this._timeFieldSpec = (TimeFieldSpec)fieldSpec;
                break;
            }
            case DATE_TIME: {
                this._dateTimeNames.add(columnName);
                this._dateTimeFieldSpecs.add((DateTimeFieldSpec)fieldSpec);
                break;
            }
            case COMPLEX: {
                this._complexFieldSpecs.add((ComplexFieldSpec)fieldSpec);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported field type: " + fieldType);
            }
        }
        this._hasJSONColumn |= fieldSpec.getDataType().equals((Object)FieldSpec.DataType.JSON);
        this._fieldSpecMap.put(columnName, fieldSpec);
    }

    @Deprecated
    public void addField(String columnName, FieldSpec fieldSpec) {
        this.addField(fieldSpec);
    }

    public boolean removeField(String columnName) {
        FieldSpec existingFieldSpec = this._fieldSpecMap.remove(columnName);
        if (existingFieldSpec != null) {
            FieldSpec.FieldType fieldType = existingFieldSpec.getFieldType();
            switch (fieldType) {
                case DIMENSION: {
                    int index = this._dimensionNames.indexOf(columnName);
                    this._dimensionNames.remove(index);
                    this._dimensionFieldSpecs.remove(index);
                    break;
                }
                case METRIC: {
                    int index = this._metricNames.indexOf(columnName);
                    this._metricNames.remove(index);
                    this._metricFieldSpecs.remove(index);
                    break;
                }
                case TIME: {
                    this._timeFieldSpec = null;
                    break;
                }
                case DATE_TIME: {
                    int index = this._dateTimeNames.indexOf(columnName);
                    this._dateTimeNames.remove(index);
                    this._dateTimeFieldSpecs.remove(index);
                    break;
                }
                default: {
                    throw new UnsupportedOperationException("Unsupported field type: " + fieldType);
                }
            }
            return true;
        }
        return false;
    }

    public boolean hasColumn(String columnName) {
        return this._fieldSpecMap.containsKey(columnName);
    }

    @JsonIgnore
    public boolean hasJSONColumn() {
        return this._hasJSONColumn;
    }

    @JsonIgnore
    public TreeMap<String, FieldSpec> getFieldSpecMap() {
        return this._fieldSpecMap;
    }

    @JsonIgnore
    public NavigableSet<String> getColumnNames() {
        return this._fieldSpecMap.navigableKeySet();
    }

    @JsonIgnore
    public TreeSet<String> getPhysicalColumnNames() {
        TreeSet<String> physicalColumnNames = new TreeSet<String>();
        for (FieldSpec fieldSpec : this._fieldSpecMap.values()) {
            if (fieldSpec.isVirtualColumn()) continue;
            physicalColumnNames.add(fieldSpec.getName());
        }
        return physicalColumnNames;
    }

    @JsonIgnore
    public Collection<FieldSpec> getAllFieldSpecs() {
        return this._fieldSpecMap.values();
    }

    public int size() {
        return this._fieldSpecMap.size();
    }

    @JsonIgnore
    public FieldSpec getFieldSpecFor(String columnName) {
        return this._fieldSpecMap.get(columnName);
    }

    @JsonIgnore
    public MetricFieldSpec getMetricSpec(String metricName) {
        FieldSpec fieldSpec = this._fieldSpecMap.get(metricName);
        if (fieldSpec != null && fieldSpec.getFieldType() == FieldSpec.FieldType.METRIC) {
            return (MetricFieldSpec)fieldSpec;
        }
        return null;
    }

    @JsonIgnore
    public DimensionFieldSpec getDimensionSpec(String dimensionName) {
        FieldSpec fieldSpec = this._fieldSpecMap.get(dimensionName);
        if (fieldSpec != null && fieldSpec.getFieldType() == FieldSpec.FieldType.DIMENSION) {
            return (DimensionFieldSpec)fieldSpec;
        }
        return null;
    }

    @JsonIgnore
    public DateTimeFieldSpec getDateTimeSpec(String dateTimeName) {
        FieldSpec fieldSpec = this._fieldSpecMap.get(dateTimeName);
        if (fieldSpec != null && fieldSpec.getFieldType() == FieldSpec.FieldType.DATE_TIME) {
            return (DateTimeFieldSpec)fieldSpec;
        }
        return null;
    }

    @JsonIgnore
    @Nullable
    public DateTimeFieldSpec getSpecForTimeColumn(String timeColumnName) {
        FieldSpec fieldSpec = this._fieldSpecMap.get(timeColumnName);
        if (fieldSpec != null) {
            if (fieldSpec.getFieldType() == FieldSpec.FieldType.DATE_TIME) {
                return (DateTimeFieldSpec)fieldSpec;
            }
            if (fieldSpec.getFieldType() == FieldSpec.FieldType.TIME) {
                return Schema.convertToDateTimeFieldSpec((TimeFieldSpec)fieldSpec);
            }
        }
        return null;
    }

    @JsonIgnore
    public List<String> getDimensionNames() {
        return this._dimensionNames;
    }

    @JsonIgnore
    public List<String> getMetricNames() {
        return this._metricNames;
    }

    @JsonIgnore
    public List<String> getDateTimeNames() {
        return this._dateTimeNames;
    }

    public ObjectNode toJsonObject() {
        ArrayNode jsonArray;
        ObjectNode jsonObject = JsonUtils.newObjectNode();
        jsonObject.put("schemaName", this._schemaName);
        if (!this._dimensionFieldSpecs.isEmpty()) {
            jsonArray = JsonUtils.newArrayNode();
            for (DimensionFieldSpec dimensionFieldSpec : this._dimensionFieldSpecs) {
                jsonArray.add((JsonNode)dimensionFieldSpec.toJsonObject());
            }
            jsonObject.set("dimensionFieldSpecs", (JsonNode)jsonArray);
        }
        if (!this._metricFieldSpecs.isEmpty()) {
            jsonArray = JsonUtils.newArrayNode();
            for (MetricFieldSpec metricFieldSpec : this._metricFieldSpecs) {
                jsonArray.add((JsonNode)metricFieldSpec.toJsonObject());
            }
            jsonObject.set("metricFieldSpecs", (JsonNode)jsonArray);
        }
        if (this._timeFieldSpec != null) {
            jsonObject.set("timeFieldSpec", (JsonNode)this._timeFieldSpec.toJsonObject());
        }
        if (!this._dateTimeFieldSpecs.isEmpty()) {
            jsonArray = JsonUtils.newArrayNode();
            for (DateTimeFieldSpec dateTimeFieldSpec : this._dateTimeFieldSpecs) {
                jsonArray.add((JsonNode)dateTimeFieldSpec.toJsonObject());
            }
            jsonObject.set("dateTimeFieldSpecs", (JsonNode)jsonArray);
        }
        if (!this._complexFieldSpecs.isEmpty()) {
            jsonArray = JsonUtils.newArrayNode();
            for (ComplexFieldSpec complexFieldSpec : this._complexFieldSpecs) {
                jsonArray.add((JsonNode)complexFieldSpec.toJsonObject());
            }
            jsonObject.set("complexFieldSpecs", (JsonNode)jsonArray);
        }
        if (this._primaryKeyColumns != null && !this._primaryKeyColumns.isEmpty()) {
            jsonArray = JsonUtils.newArrayNode();
            for (String column : this._primaryKeyColumns) {
                jsonArray.add(column);
            }
            jsonObject.set("primaryKeyColumns", (JsonNode)jsonArray);
        }
        return jsonObject;
    }

    public String toPrettyJsonString() {
        try {
            return JsonUtils.objectToPrettyString(this.toJsonObject());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toSingleLineJsonString() {
        return this.toJsonObject().toString();
    }

    public void validate() {
        for (FieldSpec fieldSpec : this._fieldSpecMap.values()) {
            FieldSpec.FieldType fieldType = fieldSpec.getFieldType();
            FieldSpec.DataType dataType = fieldSpec.getDataType();
            String fieldName = fieldSpec.getName();
            try {
                Schema.validate(fieldType, dataType);
            }
            catch (IllegalStateException e) {
                throw new IllegalStateException(e.getMessage() + ": " + fieldName);
            }
        }
    }

    public String toString() {
        return this.toPrettyJsonString();
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        Schema that = (Schema)o;
        return EqualityUtils.isEqual(this._schemaName, that._schemaName) && EqualityUtils.isEqualIgnoreOrder(this._dimensionFieldSpecs, that._dimensionFieldSpecs) && EqualityUtils.isEqualIgnoreOrder(this._metricFieldSpecs, that._metricFieldSpecs) && EqualityUtils.isEqual(this._timeFieldSpec, that._timeFieldSpec) && EqualityUtils.isEqualIgnoreOrder(this._dateTimeFieldSpecs, that._dateTimeFieldSpecs) && EqualityUtils.isEqualIgnoreOrder(this._complexFieldSpecs, that._complexFieldSpecs) && EqualityUtils.isEqual(this._primaryKeyColumns, that._primaryKeyColumns);
    }

    public void updateBooleanFieldsIfNeeded(Schema oldSchema) {
        for (Map.Entry<String, FieldSpec> entry : this._fieldSpecMap.entrySet()) {
            FieldSpec oldFieldSpec;
            FieldSpec fieldSpec = entry.getValue();
            if (fieldSpec.getDataType() != FieldSpec.DataType.BOOLEAN || (oldFieldSpec = oldSchema.getFieldSpecFor(entry.getKey())) == null || oldFieldSpec.getDataType() != FieldSpec.DataType.STRING) continue;
            fieldSpec.setDataType(FieldSpec.DataType.STRING);
        }
    }

    public boolean isBackwardCompatibleWith(Schema oldSchema) {
        NavigableSet<String> columnNames = this.getColumnNames();
        for (Map.Entry<String, FieldSpec> entry : oldSchema.getFieldSpecMap().entrySet()) {
            String oldSchemaColumnName = entry.getKey();
            if (!columnNames.contains(oldSchemaColumnName)) {
                return false;
            }
            FieldSpec oldSchemaFieldSpec = entry.getValue();
            FieldSpec fieldSpec = this.getFieldSpecFor(oldSchemaColumnName);
            if (fieldSpec.isBackwardCompatibleWith(oldSchemaFieldSpec)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this._schemaName);
        result = EqualityUtils.hashCodeOf(result, this._dimensionFieldSpecs);
        result = EqualityUtils.hashCodeOf(result, this._metricFieldSpecs);
        result = EqualityUtils.hashCodeOf(result, this._timeFieldSpec);
        result = EqualityUtils.hashCodeOf(result, this._dateTimeFieldSpecs);
        result = EqualityUtils.hashCodeOf(result, this._complexFieldSpecs);
        result = EqualityUtils.hashCodeOf(result, this._primaryKeyColumns);
        return result;
    }

    public Schema clone() {
        Schema cloned = new SchemaBuilder().setSchemaName(this.getSchemaName()).setPrimaryKeyColumns(this.getPrimaryKeyColumns()).build();
        this.getAllFieldSpecs().forEach(fieldSpec -> cloned.addField((FieldSpec)fieldSpec));
        return cloned;
    }

    public static DateTimeFieldSpec convertToDateTimeFieldSpec(TimeFieldSpec timeFieldSpec) {
        DateTimeFieldSpec dateTimeFieldSpec = new DateTimeFieldSpec();
        TimeGranularitySpec incomingGranularitySpec = timeFieldSpec.getIncomingGranularitySpec();
        TimeGranularitySpec outgoingGranularitySpec = timeFieldSpec.getOutgoingGranularitySpec();
        dateTimeFieldSpec.setName(outgoingGranularitySpec.getName());
        dateTimeFieldSpec.setDataType(outgoingGranularitySpec.getDataType());
        int outgoingTimeSize = outgoingGranularitySpec.getTimeUnitSize();
        TimeUnit outgoingTimeUnit = outgoingGranularitySpec.getTimeType();
        String outgoingTimeFormat = outgoingGranularitySpec.getTimeFormat();
        String[] split = StringUtil.split(outgoingTimeFormat, ':', 2);
        String timeFormat = split[0].equals(DateTimeFieldSpec.TimeFormat.EPOCH.name()) ? outgoingTimeSize + ":" + outgoingTimeUnit.name() + ":EPOCH" : outgoingTimeSize + ":" + outgoingTimeUnit.name() + ":SIMPLE_DATE_FORMAT:" + split[1];
        dateTimeFieldSpec.setFormat(timeFormat);
        DateTimeGranularitySpec granularitySpec = new DateTimeGranularitySpec(outgoingTimeSize, outgoingTimeUnit);
        dateTimeFieldSpec.setGranularity(outgoingTimeSize + ":" + outgoingTimeUnit.name());
        if (timeFieldSpec.getTransformFunction() != null) {
            dateTimeFieldSpec.setTransformFunction(timeFieldSpec.getTransformFunction());
        } else if (!incomingGranularitySpec.equals(outgoingGranularitySpec)) {
            String incomingName = incomingGranularitySpec.getName();
            int incomingTimeSize = incomingGranularitySpec.getTimeUnitSize();
            TimeUnit incomingTimeUnit = incomingGranularitySpec.getTimeType();
            String incomingTimeFormat = incomingGranularitySpec.getTimeFormat();
            Preconditions.checkState(((incomingTimeFormat.equals(DateTimeFieldSpec.TimeFormat.EPOCH.toString()) || incomingTimeFormat.equals(DateTimeFieldSpec.TimeFormat.TIMESTAMP.toString())) && outgoingTimeFormat.equals(incomingTimeFormat) ? 1 : 0) != 0, (Object)"Conversion from incoming to outgoing is not supported for SIMPLE_DATE_FORMAT");
            String transformFunction = Schema.constructTransformFunctionString(incomingName, incomingTimeSize, incomingTimeUnit, outgoingTimeSize, outgoingTimeUnit);
            dateTimeFieldSpec.setTransformFunction(transformFunction);
        }
        dateTimeFieldSpec.setMaxLength(timeFieldSpec.getMaxLength());
        dateTimeFieldSpec.setDefaultNullValue(timeFieldSpec.getDefaultNullValue());
        return dateTimeFieldSpec;
    }

    private static String constructTransformFunctionString(String incomingName, int incomingTimeSize, TimeUnit incomingTimeUnit, int outgoingTimeSize, TimeUnit outgoingTimeUnit) {
        String innerFunction = incomingName;
        switch (incomingTimeUnit) {
            case MILLISECONDS: {
                break;
            }
            case SECONDS: {
                if (incomingTimeSize > 1) {
                    innerFunction = String.format("fromEpochSecondsBucket(%s, %d)", incomingName, incomingTimeSize);
                    break;
                }
                innerFunction = String.format("fromEpochSeconds(%s)", incomingName);
                break;
            }
            case MINUTES: {
                if (incomingTimeSize > 1) {
                    innerFunction = String.format("fromEpochMinutesBucket(%s, %d)", incomingName, incomingTimeSize);
                    break;
                }
                innerFunction = String.format("fromEpochMinutes(%s)", incomingName);
                break;
            }
            case HOURS: {
                if (incomingTimeSize > 1) {
                    innerFunction = String.format("fromEpochHoursBucket(%s, %d)", incomingName, incomingTimeSize);
                    break;
                }
                innerFunction = String.format("fromEpochHours(%s)", incomingName);
                break;
            }
            case DAYS: {
                if (incomingTimeSize > 1) {
                    innerFunction = String.format("fromEpochDaysBucket(%s, %d)", incomingName, incomingTimeSize);
                    break;
                }
                innerFunction = String.format("fromEpochDays(%s)", incomingName);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported incomingTimeUnit - " + incomingTimeUnit);
            }
        }
        String outerFunction = innerFunction;
        switch (outgoingTimeUnit) {
            case MILLISECONDS: {
                break;
            }
            case SECONDS: {
                if (outgoingTimeSize > 1) {
                    outerFunction = String.format("toEpochSecondsBucket(%s, %d)", innerFunction, outgoingTimeSize);
                    break;
                }
                outerFunction = String.format("toEpochSeconds(%s)", innerFunction);
                break;
            }
            case MINUTES: {
                if (outgoingTimeSize > 1) {
                    outerFunction = String.format("toEpochMinutesBucket(%s, %d)", innerFunction, outgoingTimeSize);
                    break;
                }
                outerFunction = String.format("toEpochMinutes(%s)", innerFunction);
                break;
            }
            case HOURS: {
                if (outgoingTimeSize > 1) {
                    outerFunction = String.format("toEpochHoursBucket(%s, %d)", innerFunction, outgoingTimeSize);
                    break;
                }
                outerFunction = String.format("toEpochHours(%s)", innerFunction);
                break;
            }
            case DAYS: {
                if (outgoingTimeSize > 1) {
                    outerFunction = String.format("toEpochDaysBucket(%s, %d)", innerFunction, outgoingTimeSize);
                    break;
                }
                outerFunction = String.format("toEpochDays(%s)", innerFunction);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported outgoingTimeUnit - " + outgoingTimeUnit);
            }
        }
        return outerFunction;
    }

    public static class SchemaBuilder {
        private final Schema _schema = new Schema();

        public SchemaBuilder setSchemaName(String schemaName) {
            this._schema.setSchemaName(schemaName);
            return this;
        }

        public SchemaBuilder addSingleValueDimension(String dimensionName, FieldSpec.DataType dataType) {
            this._schema.addField(new DimensionFieldSpec(dimensionName, dataType, true));
            return this;
        }

        public SchemaBuilder addSingleValueDimension(String dimensionName, FieldSpec.DataType dataType, Object defaultNullValue) {
            this._schema.addField(new DimensionFieldSpec(dimensionName, dataType, true, defaultNullValue));
            return this;
        }

        public SchemaBuilder addSingleValueDimension(String dimensionName, FieldSpec.DataType dataType, int maxLength, Object defaultNullValue) {
            Preconditions.checkArgument((dataType == FieldSpec.DataType.STRING ? 1 : 0) != 0, (Object)"The maxLength field only applies to STRING field right now");
            this._schema.addField(new DimensionFieldSpec(dimensionName, dataType, true, maxLength, defaultNullValue));
            return this;
        }

        public SchemaBuilder addMultiValueDimension(String dimensionName, FieldSpec.DataType dataType) {
            this._schema.addField(new DimensionFieldSpec(dimensionName, dataType, false));
            return this;
        }

        public SchemaBuilder addMultiValueDimension(String dimensionName, FieldSpec.DataType dataType, Object defaultNullValue) {
            this._schema.addField(new DimensionFieldSpec(dimensionName, dataType, false, defaultNullValue));
            return this;
        }

        public SchemaBuilder addMultiValueDimension(String dimensionName, FieldSpec.DataType dataType, int maxLength, Object defaultNullValue) {
            Preconditions.checkArgument((dataType == FieldSpec.DataType.STRING ? 1 : 0) != 0, (Object)"The maxLength field only applies to STRING field right now");
            this._schema.addField(new DimensionFieldSpec(dimensionName, dataType, false, maxLength, defaultNullValue));
            return this;
        }

        public SchemaBuilder addMetric(String metricName, FieldSpec.DataType dataType) {
            this._schema.addField(new MetricFieldSpec(metricName, dataType));
            return this;
        }

        public SchemaBuilder addMetric(String metricName, FieldSpec.DataType dataType, Object defaultNullValue) {
            this._schema.addField(new MetricFieldSpec(metricName, dataType, defaultNullValue));
            return this;
        }

        @Deprecated
        public SchemaBuilder addTime(TimeGranularitySpec incomingTimeGranularitySpec, @Nullable TimeGranularitySpec outgoingTimeGranularitySpec) {
            if (outgoingTimeGranularitySpec != null) {
                this._schema.addField(new TimeFieldSpec(incomingTimeGranularitySpec, outgoingTimeGranularitySpec));
            } else {
                this._schema.addField(new TimeFieldSpec(incomingTimeGranularitySpec));
            }
            return this;
        }

        public SchemaBuilder addDateTime(String name, FieldSpec.DataType dataType, String format, String granularity) {
            this._schema.addField(new DateTimeFieldSpec(name, dataType, format, granularity));
            return this;
        }

        public SchemaBuilder addDateTime(String name, FieldSpec.DataType dataType, String format, String granularity, @Nullable Object defaultNullValue, @Nullable String transformFunction) {
            DateTimeFieldSpec dateTimeFieldSpec = new DateTimeFieldSpec(name, dataType, format, granularity, defaultNullValue, transformFunction);
            this._schema.addField(dateTimeFieldSpec);
            return this;
        }

        public SchemaBuilder addComplex(String name, FieldSpec.DataType dataType) {
            this._schema.addField(new ComplexFieldSpec(name, dataType, true));
            return this;
        }

        public SchemaBuilder setPrimaryKeyColumns(List<String> primaryKeyColumns) {
            this._schema.setPrimaryKeyColumns(primaryKeyColumns);
            return this;
        }

        public Schema build() {
            try {
                this._schema.validate();
            }
            catch (Exception e) {
                throw new RuntimeException("Invalid schema", e);
            }
            return this._schema;
        }
    }
}

