/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.env;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;

public class CommonsConfigurationUtils {
    private CommonsConfigurationUtils() {
    }

    public static PropertiesConfiguration fromFile(File file) {
        try {
            PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
            propertiesConfiguration.setFile(file);
            if (file.exists()) {
                propertiesConfiguration.load((InputStream)new FileInputStream(file));
            }
            return propertiesConfiguration;
        }
        catch (FileNotFoundException | ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static PropertiesConfiguration fromInputStream(InputStream inputStream) {
        try {
            PropertiesConfiguration propertiesConfiguration = new PropertiesConfiguration();
            propertiesConfiguration.load(inputStream);
            return propertiesConfiguration;
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    public static void saveToFile(PropertiesConfiguration propertiesConfiguration, File file) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            propertiesConfiguration.save((OutputStream)fileOutputStream);
        }
        catch (IOException | ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private static Iterable<String> getIterable(Iterator<String> keys) {
        return () -> keys;
    }

    public static Stream<String> getKeysStream(Configuration configuration) {
        return StreamSupport.stream(CommonsConfigurationUtils.getIterable(configuration.getKeys()).spliterator(), false);
    }

    public static List<String> getKeys(Configuration configuration) {
        return CommonsConfigurationUtils.getKeysStream(configuration).collect(Collectors.toList());
    }

    public static Map<String, Object> toMap(Configuration configuration) {
        return CommonsConfigurationUtils.getKeysStream(configuration).collect(Collectors.toMap(key -> key, key -> CommonsConfigurationUtils.mapValue(key, configuration)));
    }

    private static Object mapValue(String key, Configuration configuration) {
        return Optional.of(configuration.getStringArray(key)).filter(values -> ((String[])values).length > 1).map(values -> Arrays.stream(values).collect(Collectors.joining(","))).orElseGet(() -> {
            Object rawProperty = configuration.getProperty(key);
            if (!CommonsConfigurationUtils.needInterpolate(rawProperty)) {
                return rawProperty;
            }
            return configuration.getString(key);
        });
    }

    public static boolean needInterpolate(Object rawProperty) {
        if (rawProperty instanceof String) {
            String strProperty = (String)rawProperty;
            return StringUtils.isNotEmpty((CharSequence)strProperty) && strProperty.startsWith("${") && strProperty.endsWith("}");
        }
        return false;
    }

    public static <T> T interpolate(Configuration configuration, String key, T defaultValue, Class<T> returnType) {
        if (Integer.class.equals(returnType)) {
            return (T)configuration.getInteger(key, (Integer)defaultValue);
        }
        if (Boolean.class.equals(returnType)) {
            return (T)configuration.getBoolean(key, (Boolean)defaultValue);
        }
        if (Long.class.equals(returnType)) {
            return (T)configuration.getLong(key, (Long)defaultValue);
        }
        if (Double.class.equals(returnType)) {
            return (T)configuration.getDouble(key, (Double)defaultValue);
        }
        throw new IllegalArgumentException(returnType + " is not a supported type for conversion.");
    }

    public static <T> T convert(Object value, Class<T> returnType) {
        if (Integer.class.equals(returnType)) {
            return (T)Integer.valueOf(value.toString());
        }
        if (Boolean.class.equals(returnType)) {
            return (T)Boolean.valueOf(value.toString());
        }
        if (Long.class.equals(returnType)) {
            return (T)Long.valueOf(value.toString());
        }
        if (Double.class.equals(returnType)) {
            return (T)Double.valueOf(value.toString());
        }
        throw new IllegalArgumentException(returnType + " is not a supported type for conversion.");
    }

    public static String replaceSpecialCharacterInPropertyValue(String value) {
        if (((String)value).isEmpty()) {
            return value;
        }
        if (((String)value).charAt(0) == ' ') {
            value = "\u0000" + (String)value;
        }
        if (((String)value).charAt(((String)value).length() - 1) == ' ') {
            value = (String)value + "\u0000";
        }
        return ((String)value).replace(",", "\u0000\u0000");
    }

    public static String recoverSpecialCharacterInPropertyValue(String value) {
        if (value.isEmpty()) {
            return value;
        }
        if (value.startsWith("\u0000 ")) {
            value = value.substring(1);
        }
        if (value.endsWith(" \u0000")) {
            value = value.substring(0, value.length() - 1);
        }
        return value.replace("\u0000\u0000", ",");
    }
}

