/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.stream;

import javax.annotation.Nullable;
import org.apache.pinot.spi.annotations.InterfaceAudience;
import org.apache.pinot.spi.annotations.InterfaceStability;
import org.apache.pinot.spi.stream.LongMsgOffset;
import org.apache.pinot.spi.stream.RowMetadata;
import org.apache.pinot.spi.stream.StreamMessage;
import org.apache.pinot.spi.stream.StreamMessageMetadata;
import org.apache.pinot.spi.stream.StreamPartitionMsgOffset;

@InterfaceAudience.Public
@InterfaceStability.Stable
public interface MessageBatch<T> {
    public int getMessageCount();

    default public int getUnfilteredMessageCount() {
        return this.getMessageCount();
    }

    @Deprecated
    public T getMessageAtIndex(int var1);

    default public byte[] getMessageBytesAtIndex(int index) {
        return (byte[])this.getMessageAtIndex(index);
    }

    default public StreamMessage<T> getStreamMessage(int index) {
        return new LegacyStreamMessage(this.getMessageBytesAtIndex(index), (StreamMessageMetadata)this.getMetadataAtIndex(index));
    }

    public int getMessageOffsetAtIndex(int var1);

    public int getMessageLengthAtIndex(int var1);

    default public RowMetadata getMetadataAtIndex(int index) {
        return null;
    }

    @Deprecated
    public long getNextStreamMessageOffsetAtIndex(int var1);

    default public StreamPartitionMsgOffset getNextStreamPartitionMsgOffsetAtIndex(int index) {
        return new LongMsgOffset(this.getNextStreamMessageOffsetAtIndex(index));
    }

    default public StreamPartitionMsgOffset getOffsetOfNextBatch() {
        return this.getNextStreamPartitionMsgOffsetAtIndex(this.getMessageCount() - 1);
    }

    default public boolean isEndOfPartitionGroup() {
        return false;
    }

    @Nullable
    default public StreamMessageMetadata getLastMessageMetadata() {
        return null;
    }

    public static class LegacyStreamMessage
    extends StreamMessage {
        public LegacyStreamMessage(byte[] value, StreamMessageMetadata metadata) {
            super(value, value.length, metadata);
        }
    }
}

