/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.stream;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.pinot.spi.stream.OffsetCriteria;
import org.apache.pinot.spi.stream.StreamConfigProperties;
import org.apache.pinot.spi.utils.DataSizeUtils;
import org.apache.pinot.spi.utils.EqualityUtils;
import org.apache.pinot.spi.utils.TimeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(StreamConfig.class);
    public static final int DEFAULT_FLUSH_THRESHOLD_ROWS = 5000000;
    public static final long DEFAULT_FLUSH_THRESHOLD_TIME_MILLIS = TimeUnit.MILLISECONDS.convert(6L, TimeUnit.HOURS);
    public static final long DEFAULT_FLUSH_THRESHOLD_SEGMENT_SIZE_BYTES = 0xC800000L;
    public static final int DEFAULT_FLUSH_AUTOTUNE_INITIAL_ROWS = 100000;
    public static final String DEFAULT_SERVER_UPLOAD_TO_DEEPSTORE = "false";
    public static final String DEFAULT_CONSUMER_FACTORY_CLASS_NAME_STRING = "org.apache.pinot.plugin.stream.kafka20.KafkaConsumerFactory";
    public static final long DEFAULT_STREAM_CONNECTION_TIMEOUT_MILLIS = 30000L;
    public static final int DEFAULT_STREAM_FETCH_TIMEOUT_MILLIS = 5000;
    public static final int DEFAULT_IDLE_TIMEOUT_MILLIS = 180000;
    private static final String SIMPLE_CONSUMER_TYPE_STRING = "simple";
    private static final double CONSUMPTION_RATE_LIMIT_NOT_SPECIFIED = -1.0;
    private final String _type;
    private final String _topicName;
    private final String _tableNameWithType;
    private final List<ConsumerType> _consumerTypes = new ArrayList<ConsumerType>();
    private final String _consumerFactoryClassName;
    private final String _decoderClass;
    private final Map<String, String> _decoderProperties = new HashMap<String, String>();
    private final long _connectionTimeoutMillis;
    private final int _fetchTimeoutMillis;
    private final long _idleTimeoutMillis;
    private final int _flushThresholdRows;
    private final long _flushThresholdTimeMillis;
    private final long _flushThresholdSegmentSizeBytes;
    private final int _flushAutotuneInitialRows;
    private final String _groupId;
    private final double _topicConsumptionRateLimit;
    private final Map<String, String> _streamConfigMap = new HashMap<String, String>();
    private OffsetCriteria _offsetCriteria;
    private final boolean _serverUploadToDeepStore;

    public StreamConfig(String tableNameWithType, Map<String, String> streamConfigMap) {
        this._type = streamConfigMap.get("streamType");
        Preconditions.checkNotNull((Object)this._type, (Object)"streamType cannot be null");
        String topicNameKey = StreamConfigProperties.constructStreamProperty(this._type, "topic.name");
        this._topicName = streamConfigMap.get(topicNameKey);
        Preconditions.checkNotNull((Object)this._topicName, (Object)("Stream topic name " + topicNameKey + " cannot be null"));
        this._tableNameWithType = tableNameWithType;
        StreamConfig.validateConsumerType(this._type, streamConfigMap);
        this._consumerTypes.add(ConsumerType.LOWLEVEL);
        String consumerFactoryClassKey = StreamConfigProperties.constructStreamProperty(this._type, "consumer.factory.class.name");
        this._consumerFactoryClassName = streamConfigMap.getOrDefault(consumerFactoryClassKey, DEFAULT_CONSUMER_FACTORY_CLASS_NAME_STRING);
        String offsetCriteriaKey = StreamConfigProperties.constructStreamProperty(this._type, "consumer.prop.auto.offset.reset");
        String offsetCriteriaValue = streamConfigMap.get(offsetCriteriaKey);
        this._offsetCriteria = offsetCriteriaValue != null ? new OffsetCriteria.OffsetCriteriaBuilder().withOffsetString(offsetCriteriaValue) : new OffsetCriteria.OffsetCriteriaBuilder().withOffsetLargest();
        String decoderClassKey = StreamConfigProperties.constructStreamProperty(this._type, "decoder.class.name");
        this._decoderClass = streamConfigMap.get(decoderClassKey);
        Preconditions.checkNotNull((Object)this._decoderClass, (Object)("Must specify decoder class name " + decoderClassKey));
        String streamDecoderPropPrefix = StreamConfigProperties.constructStreamProperty(this._type, "decoder.prop");
        for (String key : streamConfigMap.keySet()) {
            if (!key.startsWith(streamDecoderPropPrefix)) continue;
            this._decoderProperties.put(StreamConfigProperties.getPropertySuffix(key, streamDecoderPropPrefix), streamConfigMap.get(key));
        }
        long connectionTimeoutMillis = 30000L;
        String connectionTimeoutKey = StreamConfigProperties.constructStreamProperty(this._type, "connection.timeout.millis");
        String connectionTimeoutValue = streamConfigMap.get(connectionTimeoutKey);
        if (connectionTimeoutValue != null) {
            try {
                connectionTimeoutMillis = Long.parseLong(connectionTimeoutValue);
            }
            catch (Exception e) {
                LOGGER.warn("Invalid config {}: {}, defaulting to: {}", new Object[]{connectionTimeoutKey, connectionTimeoutValue, 30000L});
            }
        }
        this._connectionTimeoutMillis = connectionTimeoutMillis;
        int fetchTimeoutMillis = 5000;
        String fetchTimeoutKey = StreamConfigProperties.constructStreamProperty(this._type, "fetch.timeout.millis");
        String fetchTimeoutValue = streamConfigMap.get(fetchTimeoutKey);
        if (fetchTimeoutValue != null) {
            try {
                fetchTimeoutMillis = Integer.parseInt(fetchTimeoutValue);
            }
            catch (Exception e) {
                LOGGER.warn("Invalid config {}: {}, defaulting to: {}", new Object[]{fetchTimeoutKey, fetchTimeoutValue, 30000L});
            }
        }
        this._fetchTimeoutMillis = fetchTimeoutMillis;
        int idleTimeoutMillis = 180000;
        String idleTimeoutMillisKey = StreamConfigProperties.constructStreamProperty(this._type, "idle.timeout.millis");
        String idleTimeoutMillisValue = streamConfigMap.get(idleTimeoutMillisKey);
        if (idleTimeoutMillisValue != null) {
            try {
                idleTimeoutMillis = Integer.parseInt(idleTimeoutMillisValue);
            }
            catch (Exception e) {
                LOGGER.warn("Invalid config {}: {}, defaulting to: {}", new Object[]{idleTimeoutMillisKey, idleTimeoutMillisValue, 180000});
            }
        }
        this._idleTimeoutMillis = idleTimeoutMillis;
        this._flushThresholdRows = this.extractFlushThresholdRows(streamConfigMap);
        this._flushThresholdTimeMillis = this.extractFlushThresholdTimeMillis(streamConfigMap);
        this._flushThresholdSegmentSizeBytes = this.extractFlushThresholdSegmentSize(streamConfigMap);
        this._serverUploadToDeepStore = Boolean.parseBoolean(streamConfigMap.getOrDefault("realtime.segment.serverUploadToDeepStore", DEFAULT_SERVER_UPLOAD_TO_DEEPSTORE));
        int autotuneInitialRows = 0;
        String initialRowsValue = streamConfigMap.get("realtime.segment.flush.autotune.initialRows");
        if (initialRowsValue != null) {
            try {
                autotuneInitialRows = Integer.parseInt(initialRowsValue);
            }
            catch (Exception e) {
                LOGGER.warn("Invalid config {}: {}, defaulting to: {}", new Object[]{"realtime.segment.flush.autotune.initialRows", initialRowsValue, 100000});
            }
        }
        this._flushAutotuneInitialRows = autotuneInitialRows > 0 ? autotuneInitialRows : 100000;
        String groupIdKey = StreamConfigProperties.constructStreamProperty(this._type, "hlc.group.id");
        this._groupId = streamConfigMap.get(groupIdKey);
        String rate = streamConfigMap.get("topic.consumption.rate.limit");
        this._topicConsumptionRateLimit = rate != null ? Double.parseDouble(rate) : -1.0;
        this._streamConfigMap.putAll(streamConfigMap);
    }

    public static void validateConsumerType(String streamType, Map<String, String> streamConfigMap) {
        String consumerTypesKey = StreamConfigProperties.constructStreamProperty(streamType, "consumer.type");
        String consumerTypes = streamConfigMap.get(consumerTypesKey);
        Preconditions.checkNotNull((Object)consumerTypes, (Object)(consumerTypesKey + " cannot be null"));
        for (String consumerType : consumerTypes.split(",")) {
            Preconditions.checkState((ConsumerType.LOWLEVEL.name().equalsIgnoreCase(consumerType) || SIMPLE_CONSUMER_TYPE_STRING.equalsIgnoreCase(consumerType) ? 1 : 0) != 0, (Object)"Realtime tables with HLC consumer (consumer.type=highlevel) is no longer supported in Apache Pinot");
        }
    }

    public boolean isServerUploadToDeepStore() {
        return this._serverUploadToDeepStore;
    }

    private long extractFlushThresholdSegmentSize(Map<String, String> streamConfigMap) {
        long segmentSizeBytes = -1L;
        String key = "realtime.segment.flush.threshold.segment.size";
        String flushThresholdSegmentSizeStr = streamConfigMap.get(key);
        if (flushThresholdSegmentSizeStr == null) {
            key = "realtime.segment.flush.desired.size";
            flushThresholdSegmentSizeStr = streamConfigMap.get(key);
        }
        if (flushThresholdSegmentSizeStr != null) {
            try {
                segmentSizeBytes = DataSizeUtils.toBytes(flushThresholdSegmentSizeStr);
            }
            catch (Exception e) {
                LOGGER.warn("Invalid config {}: {}, defaulting to: {}", new Object[]{key, flushThresholdSegmentSizeStr, DataSizeUtils.fromBytes(0xC800000L)});
            }
        }
        if (segmentSizeBytes > 0L) {
            return segmentSizeBytes;
        }
        return 0xC800000L;
    }

    protected int extractFlushThresholdRows(Map<String, String> streamConfigMap) {
        String key = "realtime.segment.flush.threshold.rows";
        String flushThresholdRowsStr = streamConfigMap.get(key);
        if (flushThresholdRowsStr == null) {
            key = "realtime.segment.flush.threshold.size";
            flushThresholdRowsStr = streamConfigMap.get(key);
        }
        if (flushThresholdRowsStr != null) {
            try {
                int flushThresholdRows = Integer.parseInt(flushThresholdRowsStr);
                Preconditions.checkState((flushThresholdRows >= 0 ? 1 : 0) != 0);
                return flushThresholdRows;
            }
            catch (Exception e) {
                LOGGER.warn("Invalid config {}: {}, defaulting to: {}", new Object[]{key, flushThresholdRowsStr, 5000000});
                return 5000000;
            }
        }
        return 5000000;
    }

    protected long extractFlushThresholdTimeMillis(Map<String, String> streamConfigMap) {
        String flushThresholdTimeStr = streamConfigMap.get("realtime.segment.flush.threshold.time");
        if (flushThresholdTimeStr != null) {
            try {
                return TimeUtils.convertPeriodToMillis(flushThresholdTimeStr);
            }
            catch (Exception e) {
                try {
                    return Long.parseLong(flushThresholdTimeStr);
                }
                catch (NumberFormatException nfe) {
                    LOGGER.warn("Invalid config {}: {}, defaulting to: {}", new Object[]{"realtime.segment.flush.threshold.time", flushThresholdTimeStr, DEFAULT_FLUSH_THRESHOLD_TIME_MILLIS});
                    return DEFAULT_FLUSH_THRESHOLD_TIME_MILLIS;
                }
            }
        }
        return DEFAULT_FLUSH_THRESHOLD_TIME_MILLIS;
    }

    public String getType() {
        return this._type;
    }

    public String getTopicName() {
        return this._topicName;
    }

    public List<ConsumerType> getConsumerTypes() {
        return this._consumerTypes;
    }

    public boolean hasHighLevelConsumerType() {
        return this._consumerTypes.contains((Object)ConsumerType.HIGHLEVEL);
    }

    public boolean hasLowLevelConsumerType() {
        return this._consumerTypes.contains((Object)ConsumerType.LOWLEVEL);
    }

    public String getConsumerFactoryClassName() {
        return this._consumerFactoryClassName;
    }

    public OffsetCriteria getOffsetCriteria() {
        return this._offsetCriteria;
    }

    public void setOffsetCriteria(OffsetCriteria offsetCriteria) {
        this._offsetCriteria = offsetCriteria;
    }

    public String getDecoderClass() {
        return this._decoderClass;
    }

    public Map<String, String> getDecoderProperties() {
        return this._decoderProperties;
    }

    public long getConnectionTimeoutMillis() {
        return this._connectionTimeoutMillis;
    }

    public int getFetchTimeoutMillis() {
        return this._fetchTimeoutMillis;
    }

    public long getIdleTimeoutMillis() {
        return this._idleTimeoutMillis;
    }

    public int getFlushThresholdRows() {
        return this._flushThresholdRows;
    }

    public long getFlushThresholdTimeMillis() {
        return this._flushThresholdTimeMillis;
    }

    public long getFlushThresholdSegmentSizeBytes() {
        return this._flushThresholdSegmentSizeBytes;
    }

    public int getFlushAutotuneInitialRows() {
        return this._flushAutotuneInitialRows;
    }

    public String getGroupId() {
        return this._groupId;
    }

    public Optional<Double> getTopicConsumptionRateLimit() {
        return this._topicConsumptionRateLimit == -1.0 ? Optional.empty() : Optional.of(this._topicConsumptionRateLimit);
    }

    public String getTableNameWithType() {
        return this._tableNameWithType;
    }

    public Map<String, String> getStreamConfigsMap() {
        return this._streamConfigMap;
    }

    public String toString() {
        return "StreamConfig{_type='" + this._type + "', _topicName='" + this._topicName + "', _consumerTypes=" + this._consumerTypes + ", _consumerFactoryClassName='" + this._consumerFactoryClassName + "', _offsetCriteria='" + this._offsetCriteria + "', _connectionTimeoutMillis=" + this._connectionTimeoutMillis + ", _fetchTimeoutMillis=" + this._fetchTimeoutMillis + ", _idleTimeoutMillis=" + this._idleTimeoutMillis + ", _flushThresholdRows=" + this._flushThresholdRows + ", _flushThresholdTimeMillis=" + this._flushThresholdTimeMillis + ", _flushSegmentDesiredSizeBytes=" + this._flushThresholdSegmentSizeBytes + ", _flushAutotuneInitialRows=" + this._flushAutotuneInitialRows + ", _decoderClass='" + this._decoderClass + "', _decoderProperties=" + this._decoderProperties + ", _groupId='" + this._groupId + "', _topicConsumptionRateLimit=" + this._topicConsumptionRateLimit + ", _tableNameWithType='" + this._tableNameWithType + ", _serverUploadToDeepStore=" + this._serverUploadToDeepStore + "}";
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        StreamConfig that = (StreamConfig)o;
        return EqualityUtils.isEqual(this._connectionTimeoutMillis, that._connectionTimeoutMillis) && EqualityUtils.isEqual(this._fetchTimeoutMillis, that._fetchTimeoutMillis) && EqualityUtils.isEqual(this._idleTimeoutMillis, that._idleTimeoutMillis) && EqualityUtils.isEqual(this._flushThresholdRows, that._flushThresholdRows) && EqualityUtils.isEqual(this._flushThresholdTimeMillis, that._flushThresholdTimeMillis) && EqualityUtils.isEqual(this._flushThresholdSegmentSizeBytes, that._flushThresholdSegmentSizeBytes) && EqualityUtils.isEqual(this._flushAutotuneInitialRows, that._flushAutotuneInitialRows) && EqualityUtils.isEqual(this._type, that._type) && EqualityUtils.isEqual(this._topicName, that._topicName) && EqualityUtils.isEqual(this._consumerTypes, that._consumerTypes) && EqualityUtils.isEqual(this._consumerFactoryClassName, that._consumerFactoryClassName) && EqualityUtils.isEqual(this._offsetCriteria, that._offsetCriteria) && EqualityUtils.isEqual(this._decoderClass, that._decoderClass) && EqualityUtils.isEqual(this._decoderProperties, that._decoderProperties) && EqualityUtils.isEqual(this._groupId, that._groupId) && EqualityUtils.isEqual(this._tableNameWithType, that._tableNameWithType) && EqualityUtils.isEqual(this._topicConsumptionRateLimit, that._topicConsumptionRateLimit) && EqualityUtils.isEqual(this._streamConfigMap, that._streamConfigMap) && this._serverUploadToDeepStore == that._serverUploadToDeepStore;
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this._type);
        result = EqualityUtils.hashCodeOf(result, this._topicName);
        result = EqualityUtils.hashCodeOf(result, this._consumerTypes);
        result = EqualityUtils.hashCodeOf(result, this._consumerFactoryClassName);
        result = EqualityUtils.hashCodeOf(result, this._offsetCriteria);
        result = EqualityUtils.hashCodeOf(result, this._connectionTimeoutMillis);
        result = EqualityUtils.hashCodeOf(result, this._fetchTimeoutMillis);
        result = EqualityUtils.hashCodeOf(result, this._idleTimeoutMillis);
        result = EqualityUtils.hashCodeOf(result, this._flushThresholdRows);
        result = EqualityUtils.hashCodeOf(result, this._flushThresholdTimeMillis);
        result = EqualityUtils.hashCodeOf(result, this._flushThresholdSegmentSizeBytes);
        result = EqualityUtils.hashCodeOf(result, this._flushAutotuneInitialRows);
        result = EqualityUtils.hashCodeOf(result, this._decoderClass);
        result = EqualityUtils.hashCodeOf(result, this._decoderProperties);
        result = EqualityUtils.hashCodeOf(result, this._groupId);
        result = EqualityUtils.hashCodeOf(result, this._topicConsumptionRateLimit);
        result = EqualityUtils.hashCodeOf(result, this._streamConfigMap);
        result = EqualityUtils.hashCodeOf(result, this._tableNameWithType);
        result = EqualityUtils.hashCodeOf(result, this._serverUploadToDeepStore);
        return result;
    }

    public static enum ConsumerType {
        HIGHLEVEL,
        LOWLEVEL;

    }
}

