/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.stream;

import com.google.common.base.Joiner;

public class StreamConfigProperties {
    public static final String DOT_SEPARATOR = ".";
    public static final String STREAM_PREFIX = "stream";
    public static final String LLC_SUFFIX = ".llc";
    public static final String STREAM_TYPE = "streamType";
    public static final String STREAM_TOPIC_NAME = "topic.name";
    public static final String STREAM_CONSUMER_TYPES = "consumer.type";
    public static final String STREAM_CONSUMER_FACTORY_CLASS = "consumer.factory.class.name";
    public static final String STREAM_CONSUMER_OFFSET_CRITERIA = "consumer.prop.auto.offset.reset";
    public static final String STREAM_FETCH_TIMEOUT_MILLIS = "fetch.timeout.millis";
    public static final String STREAM_CONNECTION_TIMEOUT_MILLIS = "connection.timeout.millis";
    public static final String STREAM_IDLE_TIMEOUT_MILLIS = "idle.timeout.millis";
    public static final String STREAM_DECODER_CLASS = "decoder.class.name";
    public static final String DECODER_PROPS_PREFIX = "decoder.prop";
    public static final String GROUP_ID = "hlc.group.id";
    public static final String PARTITION_MSG_OFFSET_FACTORY_CLASS = "partition.offset.factory.class.name";
    public static final String TOPIC_CONSUMPTION_RATE_LIMIT = "topic.consumption.rate.limit";
    public static final String METADATA_POPULATE = "metadata.populate";
    public static final String SEGMENT_FLUSH_THRESHOLD_TIME = "realtime.segment.flush.threshold.time";
    public static final String DEPRECATED_SEGMENT_FLUSH_THRESHOLD_ROWS = "realtime.segment.flush.threshold.size";
    public static final String SEGMENT_FLUSH_THRESHOLD_ROWS = "realtime.segment.flush.threshold.rows";
    public static final String DEPRECATED_SEGMENT_FLUSH_DESIRED_SIZE = "realtime.segment.flush.desired.size";
    public static final String SEGMENT_FLUSH_THRESHOLD_SEGMENT_SIZE = "realtime.segment.flush.threshold.segment.size";
    public static final String SEGMENT_FLUSH_AUTOTUNE_INITIAL_ROWS = "realtime.segment.flush.autotune.initialRows";
    public static final String SEGMENT_COMMIT_TIMEOUT_SECONDS = "realtime.segment.commit.timeoutSeconds";
    public static final String SERVER_UPLOAD_TO_DEEPSTORE = "realtime.segment.serverUploadToDeepStore";

    private StreamConfigProperties() {
    }

    public static String constructStreamProperty(String streamType, String property) {
        return Joiner.on((String)DOT_SEPARATOR).join((Object)STREAM_PREFIX, (Object)streamType, new Object[]{property});
    }

    public static String getPropertySuffix(String incoming, String propertyPrefix) {
        String prefix = propertyPrefix + DOT_SEPARATOR;
        return incoming.substring(prefix.length());
    }
}

