/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.stream;

import java.util.Collections;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.stream.RowMetadata;

public class StreamMessageMetadata
implements RowMetadata {
    private final long _recordIngestionTimeMs;
    private final long _firstStreamRecordIngestionTimeMs;
    private final GenericRow _headers;
    private final Map<String, String> _metadata;

    public StreamMessageMetadata(long recordIngestionTimeMs) {
        this(recordIngestionTimeMs, Long.MIN_VALUE, null, Collections.emptyMap());
    }

    public StreamMessageMetadata(long recordIngestionTimeMs, @Nullable GenericRow headers) {
        this(recordIngestionTimeMs, Long.MIN_VALUE, headers, Collections.emptyMap());
    }

    public StreamMessageMetadata(long recordIngestionTimeMs, @Nullable GenericRow headers, Map<String, String> metadata) {
        this(recordIngestionTimeMs, Long.MIN_VALUE, headers, metadata);
    }

    public StreamMessageMetadata(long recordIngestionTimeMs, long firstStreamRecordIngestionTimeMs, @Nullable GenericRow headers, Map<String, String> metadata) {
        this._recordIngestionTimeMs = recordIngestionTimeMs;
        this._firstStreamRecordIngestionTimeMs = firstStreamRecordIngestionTimeMs;
        this._headers = headers;
        this._metadata = metadata;
    }

    @Override
    public long getRecordIngestionTimeMs() {
        return this._recordIngestionTimeMs;
    }

    @Override
    public long getFirstStreamRecordIngestionTimeMs() {
        return this._firstStreamRecordIngestionTimeMs;
    }

    @Override
    public GenericRow getHeaders() {
        return this._headers;
    }

    @Override
    public Map<String, String> getRecordMetadata() {
        return this._metadata;
    }
}

