/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.stream;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import org.apache.pinot.spi.annotations.InterfaceAudience;
import org.apache.pinot.spi.annotations.InterfaceStability;
import org.apache.pinot.spi.stream.ConsumerPartitionState;
import org.apache.pinot.spi.stream.OffsetCriteria;
import org.apache.pinot.spi.stream.PartitionGroupConsumptionStatus;
import org.apache.pinot.spi.stream.PartitionGroupMetadata;
import org.apache.pinot.spi.stream.PartitionLagState;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.stream.StreamConsumerFactory;
import org.apache.pinot.spi.stream.StreamConsumerFactoryProvider;
import org.apache.pinot.spi.stream.StreamPartitionMsgOffset;

@InterfaceAudience.Public
@InterfaceStability.Stable
public interface StreamMetadataProvider
extends Closeable {
    public int fetchPartitionCount(long var1);

    public StreamPartitionMsgOffset fetchStreamPartitionOffset(OffsetCriteria var1, long var2) throws TimeoutException;

    default public List<PartitionGroupMetadata> computePartitionGroupMetadata(String clientId, StreamConfig streamConfig, List<PartitionGroupConsumptionStatus> partitionGroupConsumptionStatuses, int timeoutMillis) throws IOException, TimeoutException {
        int partitionCount = this.fetchPartitionCount(timeoutMillis);
        ArrayList<PartitionGroupMetadata> newPartitionGroupMetadataList = new ArrayList<PartitionGroupMetadata>(partitionCount);
        for (PartitionGroupConsumptionStatus currentPartitionGroupConsumptionStatus : partitionGroupConsumptionStatuses) {
            newPartitionGroupMetadataList.add(new PartitionGroupMetadata(currentPartitionGroupConsumptionStatus.getPartitionGroupId(), currentPartitionGroupConsumptionStatus.getEndOffset()));
        }
        StreamConsumerFactory streamConsumerFactory = StreamConsumerFactoryProvider.create(streamConfig);
        for (int i = partitionGroupConsumptionStatuses.size(); i < partitionCount; ++i) {
            try (StreamMetadataProvider partitionMetadataProvider = streamConsumerFactory.createPartitionMetadataProvider(clientId, i);){
                StreamPartitionMsgOffset streamPartitionMsgOffset = partitionMetadataProvider.fetchStreamPartitionOffset(streamConfig.getOffsetCriteria(), timeoutMillis);
                newPartitionGroupMetadataList.add(new PartitionGroupMetadata(i, streamPartitionMsgOffset));
                continue;
            }
        }
        return newPartitionGroupMetadataList;
    }

    default public Map<String, PartitionLagState> getCurrentPartitionLagState(Map<String, ConsumerPartitionState> currentPartitionStateMap) {
        HashMap<String, PartitionLagState> result = new HashMap<String, PartitionLagState>();
        UnknownLagState unknownLagState = new UnknownLagState();
        currentPartitionStateMap.forEach((k, v) -> result.put((String)k, unknownLagState));
        return result;
    }

    public static class UnknownLagState
    extends PartitionLagState {
    }
}

