/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class Intern {
    public static final Intern DISABLED = new Intern(true, 0);
    private boolean _disabled;
    private int _capacity;

    public Intern(int capacity) {
        this(false, capacity);
    }

    @JsonCreator
    public Intern(@JsonProperty(value="disabled") boolean disabled, @JsonProperty(value="capacity") int capacity) {
        Preconditions.checkState((capacity > 0 || disabled ? 1 : 0) != 0, (Object)("Invalid interner capacity: " + capacity));
        Preconditions.checkState((capacity == 0 || !disabled ? 1 : 0) != 0, (Object)"Enable interning to use capacity > 0");
        this._disabled = disabled;
        this._capacity = capacity;
    }

    public boolean isDisabled() {
        return this._disabled;
    }

    public int getCapacity() {
        return this._capacity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Intern that = (Intern)o;
        return this._disabled == that._disabled && this._capacity == that._capacity;
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this._disabled, this._capacity);
    }

    public String toString() {
        return "\"disabled\":" + this._disabled + ", \"capacity\":" + this._capacity;
    }
}

