/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.pinot.spi.config.BaseJsonConfig;
import org.apache.pinot.spi.config.table.HashFunction;

public class UpsertConfig
extends BaseJsonConfig {
    @JsonPropertyDescription(value="Upsert mode.")
    private Mode _mode;
    @JsonPropertyDescription(value="Function to hash the primary key.")
    private HashFunction _hashFunction = HashFunction.NONE;
    @JsonPropertyDescription(value="Partial update strategies.")
    private Map<String, Strategy> _partialUpsertStrategies;
    @JsonPropertyDescription(value="default upsert strategy for partial mode")
    private Strategy _defaultPartialUpsertStrategy = Strategy.OVERWRITE;
    @JsonPropertyDescription(value="Class name for custom row merger implementation")
    private String _partialUpsertMergerClass;
    @JsonPropertyDescription(value="Columns for upsert comparison, default to time column")
    private List<String> _comparisonColumns;
    @JsonPropertyDescription(value="Boolean column to indicate whether a records should be deleted")
    private String _deleteRecordColumn;
    @JsonPropertyDescription(value="Boolean column to indicate whether a records is out-of-order")
    private String _outOfOrderRecordColumn;
    @JsonPropertyDescription(value="Whether to use snapshot for fast upsert metadata recovery")
    private boolean _enableSnapshot;
    @JsonPropertyDescription(value="Whether to use TTL for upsert metadata cleanup, it uses the same unit as comparison col")
    private double _metadataTTL;
    @JsonPropertyDescription(value="TTL for upsert metadata cleanup for deleted keys, it uses the same unit as comparison col")
    private double _deletedKeysTTL;
    @JsonPropertyDescription(value="Whether to preload segments for fast upsert metadata recovery")
    private boolean _enablePreload;
    @JsonPropertyDescription(value="Configure the way to provide consistent view for upsert table")
    private ConsistencyMode _consistencyMode = ConsistencyMode.NONE;
    @JsonPropertyDescription(value="Refresh interval when using the snapshot consistency mode")
    private long _upsertViewRefreshIntervalMs = 3000L;
    @JsonPropertyDescription(value="Custom class for upsert metadata manager")
    private String _metadataManagerClass;
    @JsonPropertyDescription(value="Custom configs for upsert metadata manager")
    private Map<String, String> _metadataManagerConfigs;
    @JsonPropertyDescription(value="Whether to drop out-of-order record")
    private boolean _dropOutOfOrderRecord;
    @JsonPropertyDescription(value="Whether to pause partial upsert table's partition consumption during commit")
    private boolean _allowPartialUpsertConsumptionDuringCommit;

    public UpsertConfig(Mode mode) {
        this._mode = mode;
    }

    public UpsertConfig() {
    }

    public Mode getMode() {
        return this._mode;
    }

    public void setMode(Mode mode) {
        this._mode = mode;
    }

    public HashFunction getHashFunction() {
        return this._hashFunction;
    }

    @Nullable
    public Map<String, Strategy> getPartialUpsertStrategies() {
        return this._partialUpsertStrategies;
    }

    public Strategy getDefaultPartialUpsertStrategy() {
        return this._defaultPartialUpsertStrategy;
    }

    public String getPartialUpsertMergerClass() {
        return this._partialUpsertMergerClass;
    }

    public List<String> getComparisonColumns() {
        return this._comparisonColumns;
    }

    @Nullable
    public String getDeleteRecordColumn() {
        return this._deleteRecordColumn;
    }

    @Nullable
    public String getOutOfOrderRecordColumn() {
        return this._outOfOrderRecordColumn;
    }

    public boolean isEnableSnapshot() {
        return this._enableSnapshot;
    }

    public double getMetadataTTL() {
        return this._metadataTTL;
    }

    public double getDeletedKeysTTL() {
        return this._deletedKeysTTL;
    }

    public boolean isEnablePreload() {
        return this._enablePreload;
    }

    public ConsistencyMode getConsistencyMode() {
        return this._consistencyMode;
    }

    public long getUpsertViewRefreshIntervalMs() {
        return this._upsertViewRefreshIntervalMs;
    }

    public boolean isDropOutOfOrderRecord() {
        return this._dropOutOfOrderRecord;
    }

    @Nullable
    public String getMetadataManagerClass() {
        return this._metadataManagerClass;
    }

    @Nullable
    public Map<String, String> getMetadataManagerConfigs() {
        return this._metadataManagerConfigs;
    }

    public void setHashFunction(HashFunction hashFunction) {
        this._hashFunction = hashFunction;
    }

    public void setPartialUpsertStrategies(Map<String, Strategy> partialUpsertStrategies) {
        this._partialUpsertStrategies = partialUpsertStrategies;
    }

    public void setDefaultPartialUpsertStrategy(Strategy defaultPartialUpsertStrategy) {
        this._defaultPartialUpsertStrategy = defaultPartialUpsertStrategy;
    }

    public void setPartialUpsertMergerClass(String partialUpsertMergerClass) {
        this._partialUpsertMergerClass = partialUpsertMergerClass;
    }

    public void setComparisonColumns(List<String> comparisonColumns) {
        if (CollectionUtils.isNotEmpty(comparisonColumns)) {
            this._comparisonColumns = comparisonColumns;
        }
    }

    public void setComparisonColumn(String comparisonColumn) {
        if (comparisonColumn != null) {
            this._comparisonColumns = Collections.singletonList(comparisonColumn);
        }
    }

    public void setDeleteRecordColumn(String deleteRecordColumn) {
        this._deleteRecordColumn = deleteRecordColumn;
    }

    public void setOutOfOrderRecordColumn(String outOfOrderRecordColumn) {
        this._outOfOrderRecordColumn = outOfOrderRecordColumn;
    }

    public void setEnableSnapshot(boolean enableSnapshot) {
        this._enableSnapshot = enableSnapshot;
    }

    public void setMetadataTTL(double metadataTTL) {
        this._metadataTTL = metadataTTL;
    }

    public void setDeletedKeysTTL(double deletedKeysTTL) {
        this._deletedKeysTTL = deletedKeysTTL;
    }

    public void setEnablePreload(boolean enablePreload) {
        this._enablePreload = enablePreload;
    }

    public void setConsistencyMode(ConsistencyMode consistencyMode) {
        this._consistencyMode = consistencyMode;
    }

    public void setUpsertViewRefreshIntervalMs(long upsertViewRefreshIntervalMs) {
        this._upsertViewRefreshIntervalMs = upsertViewRefreshIntervalMs;
    }

    public void setDropOutOfOrderRecord(boolean dropOutOfOrderRecord) {
        this._dropOutOfOrderRecord = dropOutOfOrderRecord;
    }

    public void setMetadataManagerClass(String metadataManagerClass) {
        this._metadataManagerClass = metadataManagerClass;
    }

    public void setMetadataManagerConfigs(Map<String, String> metadataManagerConfigs) {
        this._metadataManagerConfigs = metadataManagerConfigs;
    }

    public void setAllowPartialUpsertConsumptionDuringCommit(boolean allowPartialUpsertConsumptionDuringCommit) {
        this._allowPartialUpsertConsumptionDuringCommit = allowPartialUpsertConsumptionDuringCommit;
    }

    public boolean isAllowPartialUpsertConsumptionDuringCommit() {
        return this._allowPartialUpsertConsumptionDuringCommit;
    }

    public static enum ConsistencyMode {
        NONE,
        SYNC,
        SNAPSHOT;

    }

    public static enum Strategy {
        APPEND,
        IGNORE,
        INCREMENT,
        MAX,
        MIN,
        OVERWRITE,
        UNION;

    }

    public static enum Mode {
        FULL,
        PARTIAL,
        NONE;

    }
}

