/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table.ingestion;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.BaseJsonConfig;

public class SchemaConformingTransformerV2Config
extends BaseJsonConfig {
    @JsonPropertyDescription(value="Enable indexable extras")
    private boolean _enableIndexableExtras = true;
    @JsonPropertyDescription(value="Name of the field that should contain extra fields that are not part of the schema.")
    private String _indexableExtrasField = "json_data";
    @JsonPropertyDescription(value="Enable unindexable extras")
    private boolean _enableUnindexableExtras = true;
    @JsonPropertyDescription(value="Like indexableExtrasField except it only contains fields with the suffix in unindexableFieldSuffix.")
    private String _unindexableExtrasField = "json_data_no_idx";
    @JsonPropertyDescription(value="The suffix of fields that must be stored in unindexableExtrasField")
    private String _unindexableFieldSuffix = "_noindex";
    @JsonPropertyDescription(value="Array of flattened (dot-delimited) object paths to drop")
    private Set<String> _fieldPathsToDrop = new HashSet<String>();
    @JsonPropertyDescription(value="Array of flattened (dot-delimited) object paths not to traverse further and keep same as input. This will also skip building mergedTextIndex for the field.")
    private Set<String> _fieldPathsToPreserveInput = new HashSet<String>();
    @JsonPropertyDescription(value="Map from customized meaningful column name to json key path")
    private Map<String, String> _columnNameToJsonKeyPathMap = new HashMap<String, String>();
    @JsonPropertyDescription(value="mergedTextIndex field")
    private String _mergedTextIndexField = "__mergedTextIndex";
    @JsonPropertyDescription(value="mergedTextIndex document max length")
    private int _mergedTextIndexDocumentMaxLength = 32766;
    @JsonPropertyDescription(value="Recall that merged text index document is in the format of <value:key>. The mergedTextIndex shingling overlap length refers to the maximum search length of the value that will yield results with 100% accuracy. If the value is null, shingle index will be turned off and the value will be truncated such that the document is equal to _mergedTextIndexDocumentMaxLength")
    @Nullable
    private Integer _mergedTextIndexShinglingOverlapLength = null;
    @JsonPropertyDescription(value="mergedTextIndex binary document detection minimum length")
    private Integer _mergedTextIndexBinaryDocumentDetectionMinLength = 512;
    @JsonPropertyDescription(value="Array of paths to exclude from merged text index.")
    private Set<String> _mergedTextIndexPathToExclude = new HashSet<String>();
    @JsonPropertyDescription(value="Array of suffix to exclude from merged text index.")
    private List<String> _mergedTextIndexSuffixToExclude = Arrays.asList("_logtype", "_dictionaryVars", "_encodedVars");
    @JsonPropertyDescription(value="Dedicated fields to double ingest into json_data column")
    private Set<String> _fieldsToDoubleIngest = new HashSet<String>();

    @JsonCreator
    public SchemaConformingTransformerV2Config(@JsonProperty(value="enableIndexableExtras") @Nullable Boolean enableIndexableExtras, @JsonProperty(value="indexableExtrasField") String indexableExtrasField, @JsonProperty(value="enableUnindexableExtras") @Nullable Boolean enableUnindexableExtras, @JsonProperty(value="unindexableExtrasField") @Nullable String unindexableExtrasField, @JsonProperty(value="unindexableFieldSuffix") @Nullable String unindexableFieldSuffix, @JsonProperty(value="fieldPathsToDrop") @Nullable Set<String> fieldPathsToDrop, @JsonProperty(value="fieldPathsToKeepSameAsInput") @Nullable Set<String> fieldPathsToPreserveInput, @JsonProperty(value="mergedTextIndexField") @Nullable String mergedTextIndexField, @JsonProperty(value="mergedTextIndexDocumentMaxLength") @Nullable Integer mergedTextIndexDocumentMaxLength, @JsonProperty(value="mergedTextIndexShinglingOverlapLength") @Nullable Integer mergedTextIndexShinglingOverlapLength, @JsonProperty(value="mergedTextIndexBinaryDocumentDetectionMinLength") @Nullable Integer mergedTextIndexBinaryDocumentDetectionMinLength, @JsonProperty(value="mergedTextIndexPathToExclude") @Nullable Set<String> mergedTextIndexPathToExclude, @JsonProperty(value="fieldsToDoubleIngest") @Nullable Set<String> fieldsToDoubleIngest) {
        this.setEnableIndexableExtras(enableIndexableExtras);
        this.setIndexableExtrasField(indexableExtrasField);
        this.setEnableUnindexableExtras(enableUnindexableExtras);
        this.setUnindexableExtrasField(unindexableExtrasField);
        this.setUnindexableFieldSuffix(unindexableFieldSuffix);
        this.setFieldPathsToDrop(fieldPathsToDrop);
        this.setFieldPathsToPreserveInput(fieldPathsToPreserveInput);
        this.setMergedTextIndexField(mergedTextIndexField);
        this.setMergedTextIndexDocumentMaxLength(mergedTextIndexDocumentMaxLength);
        this.setMergedTextIndexShinglingDocumentOverlapLength(mergedTextIndexShinglingOverlapLength);
        this.setMergedTextIndexBinaryDocumentDetectionMinLength(mergedTextIndexBinaryDocumentDetectionMinLength);
        this.setMergedTextIndexPathToExclude(mergedTextIndexPathToExclude);
        this.setFieldsToDoubleIngest(fieldsToDoubleIngest);
    }

    public SchemaConformingTransformerV2Config setEnableIndexableExtras(Boolean enableIndexableExtras) {
        this._enableIndexableExtras = enableIndexableExtras == null ? this._enableUnindexableExtras : enableIndexableExtras;
        return this;
    }

    public String getIndexableExtrasField() {
        return this._enableIndexableExtras ? this._indexableExtrasField : null;
    }

    public SchemaConformingTransformerV2Config setIndexableExtrasField(String indexableExtrasField) {
        this._indexableExtrasField = indexableExtrasField == null ? this._indexableExtrasField : indexableExtrasField;
        return this;
    }

    public SchemaConformingTransformerV2Config setEnableUnindexableExtras(Boolean enableUnindexableExtras) {
        this._enableUnindexableExtras = enableUnindexableExtras == null ? this._enableUnindexableExtras : enableUnindexableExtras;
        return this;
    }

    public String getUnindexableExtrasField() {
        return this._enableUnindexableExtras ? this._unindexableExtrasField : null;
    }

    public SchemaConformingTransformerV2Config setUnindexableExtrasField(String unindexableExtrasField) {
        this._unindexableExtrasField = unindexableExtrasField == null ? this._unindexableExtrasField : unindexableExtrasField;
        return this;
    }

    public String getUnindexableFieldSuffix() {
        return this._unindexableFieldSuffix;
    }

    public SchemaConformingTransformerV2Config setUnindexableFieldSuffix(String unindexableFieldSuffix) {
        this._unindexableFieldSuffix = unindexableFieldSuffix == null ? this._unindexableFieldSuffix : unindexableFieldSuffix;
        return this;
    }

    public Set<String> getFieldPathsToDrop() {
        return this._fieldPathsToDrop;
    }

    public SchemaConformingTransformerV2Config setFieldPathsToDrop(Set<String> fieldPathsToDrop) {
        this._fieldPathsToDrop = fieldPathsToDrop == null ? this._fieldPathsToDrop : fieldPathsToDrop;
        return this;
    }

    public Set<String> getFieldPathsToPreserveInput() {
        return this._fieldPathsToPreserveInput;
    }

    public SchemaConformingTransformerV2Config setFieldPathsToPreserveInput(Set<String> fieldPathsToPreserveInput) {
        this._fieldPathsToPreserveInput = fieldPathsToPreserveInput == null ? this._fieldPathsToPreserveInput : fieldPathsToPreserveInput;
        return this;
    }

    public Map<String, String> getColumnNameToJsonKeyPathMap() {
        return this._columnNameToJsonKeyPathMap;
    }

    public SchemaConformingTransformerV2Config setColumnNameToJsonKeyPathMap(Map<String, String> columnNameToJsonKeyPathMap) {
        this._columnNameToJsonKeyPathMap = columnNameToJsonKeyPathMap == null ? this._columnNameToJsonKeyPathMap : columnNameToJsonKeyPathMap;
        return this;
    }

    public String getMergedTextIndexField() {
        return this._mergedTextIndexField;
    }

    public SchemaConformingTransformerV2Config setMergedTextIndexField(String mergedTextIndexField) {
        this._mergedTextIndexField = mergedTextIndexField == null ? this._mergedTextIndexField : mergedTextIndexField;
        return this;
    }

    public Integer getMergedTextIndexDocumentMaxLength() {
        return this._mergedTextIndexDocumentMaxLength;
    }

    public SchemaConformingTransformerV2Config setMergedTextIndexDocumentMaxLength(Integer mergedTextIndexDocumentMaxLength) {
        this._mergedTextIndexDocumentMaxLength = mergedTextIndexDocumentMaxLength == null ? this._mergedTextIndexDocumentMaxLength : mergedTextIndexDocumentMaxLength;
        return this;
    }

    public Integer getMergedTextIndexShinglingOverlapLength() {
        return this._mergedTextIndexShinglingOverlapLength;
    }

    public SchemaConformingTransformerV2Config setMergedTextIndexShinglingDocumentOverlapLength(Integer mergedTextIndexShinglingOverlapLength) {
        this._mergedTextIndexShinglingOverlapLength = mergedTextIndexShinglingOverlapLength;
        return this;
    }

    public Integer getMergedTextIndexBinaryDocumentDetectionMinLength() {
        return this._mergedTextIndexBinaryDocumentDetectionMinLength;
    }

    public SchemaConformingTransformerV2Config setMergedTextIndexBinaryDocumentDetectionMinLength(Integer mergedTextIndexBinaryDocumentDetectionMinLength) {
        this._mergedTextIndexBinaryDocumentDetectionMinLength = mergedTextIndexBinaryDocumentDetectionMinLength == null ? this._mergedTextIndexBinaryDocumentDetectionMinLength : mergedTextIndexBinaryDocumentDetectionMinLength;
        return this;
    }

    public Set<String> getMergedTextIndexPathToExclude() {
        return this._mergedTextIndexPathToExclude;
    }

    public List<String> getMergedTextIndexSuffixToExclude() {
        return this._mergedTextIndexSuffixToExclude;
    }

    public SchemaConformingTransformerV2Config setMergedTextIndexPathToExclude(Set<String> mergedTextIndexPathToExclude) {
        this._mergedTextIndexPathToExclude = mergedTextIndexPathToExclude == null ? this._mergedTextIndexPathToExclude : mergedTextIndexPathToExclude;
        return this;
    }

    public Set<String> getFieldsToDoubleIngest() {
        return this._fieldsToDoubleIngest;
    }

    public SchemaConformingTransformerV2Config setFieldsToDoubleIngest(Set<String> fieldsToDoubleIngest) {
        this._fieldsToDoubleIngest = fieldsToDoubleIngest == null ? this._fieldsToDoubleIngest : fieldsToDoubleIngest;
        return this;
    }
}

