/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.env;

import com.google.common.base.Preconditions;
import java.io.Reader;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.lang3.StringUtils;

class VersionedPropertyReader
extends PropertiesConfiguration.PropertiesReader {
    public VersionedPropertyReader(Reader reader) {
        super(reader);
    }

    protected void parseProperty(String line) {
        String separator = this.getPropertySeparator();
        Preconditions.checkArgument((boolean)" = ".equals(separator), (Object)String.format("Versioned property configuration separator '%s' should be equal to '%s'", separator, " = "));
        String[] keyValue = StringUtils.splitByWholeSeparator((String)line, (String)separator, (int)2);
        Preconditions.checkArgument((keyValue.length == 2 ? 1 : 0) != 0, (Object)"property content split should result in key and value");
        this.initPropertyName(keyValue[0]);
        this.initPropertyValue(keyValue[1]);
        this.initPropertySeparator(separator);
    }

    protected String unescapePropertyName(String name) {
        return name;
    }
}

