/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.eventlistener.query;

import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.eventlistener.query.BrokerQueryEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BrokerQueryEventListenerFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(BrokerQueryEventListenerFactory.class);
    private static BrokerQueryEventListener _brokerQueryEventListener;
    private static Set<String> _trackedHeaders;

    private BrokerQueryEventListenerFactory() {
    }

    public static void init(PinotConfiguration config) {
        BrokerQueryEventListenerFactory.initializeBrokerQueryEventListener(config);
        BrokerQueryEventListenerFactory.initializeTrackedHeaders(config);
    }

    private static void initializeBrokerQueryEventListener(PinotConfiguration config) {
        String brokerQueryEventListenerClassName = config.getProperty("factory.className", "org.apache.pinot.spi.eventlistener.query.NoOpBrokerQueryEventListener");
        LOGGER.info("Initializing BrokerQueryEventListener with class name: {}", (Object)brokerQueryEventListenerClassName);
        try {
            _brokerQueryEventListener = (BrokerQueryEventListener)Class.forName(brokerQueryEventListenerClassName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        LOGGER.info("Initialized BrokerQueryEventListener: {}", (Object)_brokerQueryEventListener.getClass().getName());
    }

    private static void initializeTrackedHeaders(PinotConfiguration config) {
        String trackedHeaders = config.getProperty("request.context.tracked.header.keys");
        if (StringUtils.isNotEmpty((CharSequence)trackedHeaders)) {
            LOGGER.info("Initializing tracked headers with config: {}", (Object)trackedHeaders);
            String[] split = StringUtils.split((String)trackedHeaders, (char)',');
            _trackedHeaders = Sets.newHashSetWithExpectedSize((int)split.length);
            for (String header : split) {
                _trackedHeaders.add(header.trim().toLowerCase());
            }
            LOGGER.info("Initialized tracked headers: {}", _trackedHeaders);
        } else {
            LOGGER.info("No tracked headers configured");
            _trackedHeaders = Set.of();
        }
    }

    public static BrokerQueryEventListener getBrokerQueryEventListener() {
        return (BrokerQueryEventListener)Preconditions.checkNotNull((Object)_brokerQueryEventListener, (Object)"BrokerQueryEventListenerFactory has not been initialized");
    }

    public static Set<String> getTrackedHeaders() {
        return (Set)Preconditions.checkNotNull(_trackedHeaders, (Object)"BrokerQueryEventListenerFactory has not been initialized");
    }
}

