/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.recordenricher;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.ingestion.EnrichmentConfig;
import org.apache.pinot.spi.config.table.ingestion.IngestionConfig;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.recordenricher.RecordEnricher;
import org.apache.pinot.spi.recordenricher.RecordEnricherRegistry;

public class RecordEnricherPipeline {
    private final List<RecordEnricher> _enrichers = new ArrayList<RecordEnricher>();
    private final Set<String> _columnsToExtract = new HashSet<String>();

    public static RecordEnricherPipeline getPassThroughPipeline() {
        return new RecordEnricherPipeline();
    }

    public static RecordEnricherPipeline fromIngestionConfig(IngestionConfig ingestionConfig) {
        RecordEnricherPipeline pipeline = new RecordEnricherPipeline();
        if (null == ingestionConfig || null == ingestionConfig.getEnrichmentConfigs()) {
            return pipeline;
        }
        List<EnrichmentConfig> enrichmentConfigs = ingestionConfig.getEnrichmentConfigs();
        for (EnrichmentConfig enrichmentConfig : enrichmentConfigs) {
            try {
                RecordEnricher enricher = RecordEnricherRegistry.createRecordEnricher(enrichmentConfig);
                pipeline.add(enricher);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to instantiate record enricher " + enrichmentConfig.getEnricherType(), e);
            }
        }
        return pipeline;
    }

    public static RecordEnricherPipeline fromTableConfig(TableConfig tableConfig) {
        return RecordEnricherPipeline.fromIngestionConfig(tableConfig.getIngestionConfig());
    }

    public Set<String> getColumnsToExtract() {
        return this._columnsToExtract;
    }

    public void add(RecordEnricher enricher) {
        this._enrichers.add(enricher);
        this._columnsToExtract.addAll(enricher.getInputColumns());
    }

    public void run(GenericRow record) {
        for (RecordEnricher enricher : this._enrichers) {
            enricher.enrich(record);
        }
    }
}

