/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.recordenricher;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.apache.pinot.spi.config.table.ingestion.EnrichmentConfig;
import org.apache.pinot.spi.recordenricher.RecordEnricher;
import org.apache.pinot.spi.recordenricher.RecordEnricherFactory;
import org.apache.pinot.spi.recordenricher.RecordEnricherValidationConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecordEnricherRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(RecordEnricherRegistry.class);
    private static final Map<String, RecordEnricherFactory> RECORD_ENRICHER_FACTORY_MAP = new HashMap<String, RecordEnricherFactory>();

    private RecordEnricherRegistry() {
    }

    public static void validateEnrichmentConfig(EnrichmentConfig enrichmentConfig, RecordEnricherValidationConfig config) {
        if (!RECORD_ENRICHER_FACTORY_MAP.containsKey(enrichmentConfig.getEnricherType())) {
            throw new IllegalArgumentException("No record enricher found for type: " + enrichmentConfig.getEnricherType());
        }
        RECORD_ENRICHER_FACTORY_MAP.get(enrichmentConfig.getEnricherType()).validateEnrichmentConfig(enrichmentConfig.getProperties(), config);
    }

    public static RecordEnricher createRecordEnricher(EnrichmentConfig enrichmentConfig) throws IOException {
        if (!RECORD_ENRICHER_FACTORY_MAP.containsKey(enrichmentConfig.getEnricherType())) {
            throw new IllegalArgumentException("No record enricher found for type: " + enrichmentConfig.getEnricherType());
        }
        return RECORD_ENRICHER_FACTORY_MAP.get(enrichmentConfig.getEnricherType()).createEnricher(enrichmentConfig.getProperties());
    }

    static {
        for (RecordEnricherFactory recordEnricherFactory : ServiceLoader.load(RecordEnricherFactory.class)) {
            LOGGER.info("Registered record enricher factory type: {}", (Object)recordEnricherFactory.getEnricherType());
            RECORD_ENRICHER_FACTORY_MAP.put(recordEnricherFactory.getEnricherType(), recordEnricherFactory);
        }
    }
}

