/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.apache.pinot.spi.utils.ByteArray;

public class BigDecimalUtils {
    private BigDecimalUtils() {
    }

    public static int byteSize(BigDecimal value) {
        BigInteger unscaledValue = value.unscaledValue();
        return (unscaledValue.bitLength() >>> 3) + 3;
    }

    public static int byteSizeForFixedPrecision(int precision) {
        BigDecimal bd = BigDecimalUtils.generateMaximumNumberWithPrecision(precision);
        return BigDecimalUtils.byteSize(bd);
    }

    public static byte[] serialize(BigDecimal value) {
        int scale = value.scale();
        BigInteger unscaledValue = value.unscaledValue();
        byte[] unscaledValueBytes = unscaledValue.toByteArray();
        byte[] valueBytes = new byte[unscaledValueBytes.length + 2];
        valueBytes[0] = (byte)(scale >> 8);
        valueBytes[1] = (byte)scale;
        System.arraycopy(unscaledValueBytes, 0, valueBytes, 2, unscaledValueBytes.length);
        return valueBytes;
    }

    public static byte[] serializeWithSize(BigDecimal value, int fixedSize) {
        int scale = value.scale();
        BigInteger unscaledValue = value.unscaledValue();
        byte[] unscaledValueBytes = unscaledValue.toByteArray();
        int unscaledBytesStartingIndex = fixedSize - unscaledValueBytes.length;
        if (unscaledValueBytes.length > fixedSize - 2) {
            throw new IllegalArgumentException("Big decimal of size " + (unscaledValueBytes.length + 2) + " is too big to serialize into a fixed size of " + fixedSize + " bytes");
        }
        byte[] valueBytes = new byte[fixedSize];
        valueBytes[0] = (byte)(scale >> 8);
        valueBytes[1] = (byte)scale;
        int paddingByte = 0;
        if (value.signum() < 0) {
            paddingByte = -1;
        }
        for (int i = 2; i < unscaledBytesStartingIndex; ++i) {
            valueBytes[i] = paddingByte;
        }
        System.arraycopy(unscaledValueBytes, 0, valueBytes, unscaledBytesStartingIndex, unscaledValueBytes.length);
        return valueBytes;
    }

    public static BigDecimal deserialize(byte[] bytes) {
        int scale = (short)((bytes[0] & 0xFF) << 8) | bytes[1] & 0xFF;
        byte[] unscaledValueBytes = new byte[bytes.length - 2];
        System.arraycopy(bytes, 2, unscaledValueBytes, 0, unscaledValueBytes.length);
        BigInteger unscaledValue = new BigInteger(unscaledValueBytes);
        return new BigDecimal(unscaledValue, scale);
    }

    public static BigDecimal deserialize(ByteArray byteArray) {
        return BigDecimalUtils.deserialize(byteArray.getBytes());
    }

    public static BigDecimal deserialize(ByteBuffer byteBuffer) {
        byte[] bytes = new byte[byteBuffer.remaining()];
        byteBuffer.get(bytes);
        return BigDecimalUtils.deserialize(bytes);
    }

    public static BigDecimal generateMaximumNumberWithPrecision(int precision) {
        return new BigDecimal("10").pow(precision).subtract(new BigDecimal("1"));
    }
}

