/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TableType;
import org.apache.pinot.spi.config.table.ingestion.AggregationConfig;
import org.apache.pinot.spi.config.table.ingestion.BatchIngestionConfig;
import org.apache.pinot.spi.env.PinotConfiguration;

public final class IngestionConfigUtils {
    public static final String DOT_SEPARATOR = ".";
    private static final String DEFAULT_SEGMENT_NAME_GENERATOR_TYPE = "simple";
    private static final String DEFAULT_SEGMENT_INGESTION_TYPE = "APPEND";
    private static final String DEFAULT_PUSH_MODE = "tar";
    private static final int DEFAULT_PUSH_ATTEMPTS = 5;
    private static final int DEFAULT_PUSH_PARALLELISM = 1;
    private static final long DEFAULT_PUSH_RETRY_INTERVAL_MILLIS = 1000L;

    private IngestionConfigUtils() {
    }

    public static Map<String, String> getStreamConfigMap(TableConfig tableConfig) {
        String tableNameWithType = tableConfig.getTableName();
        Preconditions.checkState((tableConfig.getTableType() == TableType.REALTIME ? 1 : 0) != 0, (String)"Cannot fetch streamConfigs for OFFLINE table: %s", (Object)tableNameWithType);
        Map<String, String> streamConfigMap = null;
        if (tableConfig.getIngestionConfig() != null && tableConfig.getIngestionConfig().getStreamIngestionConfig() != null) {
            List<Map<String, String>> streamConfigMaps = tableConfig.getIngestionConfig().getStreamIngestionConfig().getStreamConfigMaps();
            Preconditions.checkState((streamConfigMaps.size() == 1 ? 1 : 0) != 0, (Object)"Only 1 stream supported per table");
            streamConfigMap = streamConfigMaps.get(0);
        }
        if (streamConfigMap == null && tableConfig.getIndexingConfig() != null) {
            streamConfigMap = tableConfig.getIndexingConfig().getStreamConfigs();
        }
        if (streamConfigMap == null) {
            throw new IllegalStateException("Could not find streamConfigs for REALTIME table: " + tableNameWithType);
        }
        return streamConfigMap;
    }

    public static List<AggregationConfig> getAggregationConfigs(TableConfig tableConfig) {
        String tableNameWithType = tableConfig.getTableName();
        Preconditions.checkState((tableConfig.getTableType() == TableType.REALTIME ? 1 : 0) != 0, (String)"aggregationConfigs are only supported in REALTIME tables. Found a OFFLINE table: %s", (Object)tableNameWithType);
        if (tableConfig.getIngestionConfig() != null) {
            return tableConfig.getIngestionConfig().getAggregationConfigs();
        }
        return null;
    }

    public static boolean getBatchSegmentIngestionConsistentDataPushEnabled(TableConfig tableConfig) {
        BatchIngestionConfig batchIngestionConfig;
        boolean consistentDataPush = false;
        if (tableConfig.getIngestionConfig() != null && (batchIngestionConfig = tableConfig.getIngestionConfig().getBatchIngestionConfig()) != null) {
            consistentDataPush = batchIngestionConfig.getConsistentDataPush();
        }
        return consistentDataPush;
    }

    public static String getBatchSegmentIngestionType(TableConfig tableConfig) {
        BatchIngestionConfig batchIngestionConfig;
        String segmentIngestionType = null;
        if (tableConfig.getIngestionConfig() != null && (batchIngestionConfig = tableConfig.getIngestionConfig().getBatchIngestionConfig()) != null) {
            segmentIngestionType = batchIngestionConfig.getSegmentIngestionType();
        }
        if (segmentIngestionType == null) {
            segmentIngestionType = tableConfig.getValidationConfig().getSegmentPushType();
        }
        return segmentIngestionType == null ? DEFAULT_SEGMENT_INGESTION_TYPE : segmentIngestionType;
    }

    public static String getBatchSegmentIngestionFrequency(TableConfig tableConfig) {
        BatchIngestionConfig batchIngestionConfig;
        String segmentIngestionFrequency = null;
        if (tableConfig.getIngestionConfig() != null && (batchIngestionConfig = tableConfig.getIngestionConfig().getBatchIngestionConfig()) != null) {
            segmentIngestionFrequency = batchIngestionConfig.getSegmentIngestionFrequency();
        }
        if (segmentIngestionFrequency == null) {
            segmentIngestionFrequency = tableConfig.getValidationConfig().getSegmentPushFrequency();
        }
        return segmentIngestionFrequency;
    }

    public static Map<String, String> getRecordReaderProps(Map<String, String> batchConfigMap) {
        return IngestionConfigUtils.getConfigMapWithPrefix(batchConfigMap, "recordReader.prop");
    }

    public static Map<String, String> getSegmentNameGeneratorProps(Map<String, String> batchConfigMap) {
        return IngestionConfigUtils.getConfigMapWithPrefix(batchConfigMap, "segmentNameGenerator.configs");
    }

    public static PinotConfiguration getInputFsProps(Map<String, String> batchConfigMap) {
        return new PinotConfiguration(IngestionConfigUtils.getPropsWithPrefix(batchConfigMap, "input.fs.prop"));
    }

    public static PinotConfiguration getOutputFsProps(Map<String, String> batchConfigMap) {
        return new PinotConfiguration(IngestionConfigUtils.getPropsWithPrefix(batchConfigMap, "output.fs.prop"));
    }

    public static Map<String, String> extractPropsMatchingPrefix(Map<String, String> batchConfigMap, String prefix) {
        HashMap<String, String> propsMatchingPrefix = new HashMap<String, String>();
        for (Map.Entry<String, String> entry : batchConfigMap.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(prefix)) continue;
            propsMatchingPrefix.put(key, entry.getValue());
        }
        return propsMatchingPrefix;
    }

    public static Map<String, Object> getPropsWithPrefix(Map<String, String> batchConfigMap, String prefix) {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.putAll(IngestionConfigUtils.getConfigMapWithPrefix(batchConfigMap, prefix));
        return props;
    }

    public static Map<String, String> getConfigMapWithPrefix(Map<String, String> batchConfigMap, String prefix) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (!((String)prefix).endsWith(DOT_SEPARATOR)) {
            prefix = (String)prefix + DOT_SEPARATOR;
        }
        for (String configKey : batchConfigMap.keySet()) {
            String[] splits;
            if (!configKey.startsWith((String)prefix) || (splits = configKey.split((String)prefix, 2)).length <= 1) continue;
            props.put(splits[1], batchConfigMap.get(configKey));
        }
        return props;
    }

    public static String getSegmentNameGeneratorType(Map<String, String> batchConfigMap) {
        return batchConfigMap.getOrDefault("segmentNameGenerator.type", DEFAULT_SEGMENT_NAME_GENERATOR_TYPE);
    }

    public static String getPushMode(Map<String, String> batchConfigMap) {
        return batchConfigMap.getOrDefault("push.mode", DEFAULT_PUSH_MODE);
    }

    public static int getPushAttempts(Map<String, String> batchConfigMap) {
        String pushAttempts = batchConfigMap.get("push.attempts");
        if (StringUtils.isNumeric((CharSequence)pushAttempts)) {
            return Integer.parseInt(pushAttempts);
        }
        return 5;
    }

    public static int getPushParallelism(Map<String, String> batchConfigMap) {
        String pushParallelism = batchConfigMap.get("push.parallelism");
        if (StringUtils.isNumeric((CharSequence)pushParallelism)) {
            return Integer.parseInt(pushParallelism);
        }
        return 1;
    }

    public static long getPushRetryIntervalMillis(Map<String, String> batchConfigMap) {
        String pushRetryIntervalMillis = batchConfigMap.get("push.retry.interval.millis");
        if (StringUtils.isNumeric((CharSequence)pushRetryIntervalMillis)) {
            return Long.parseLong(pushRetryIntervalMillis);
        }
        return 1000L;
    }
}

