/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils.retry;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.pinot.spi.utils.retry.BaseRetryPolicy;

public class ExponentialBackoffRetryPolicy
extends BaseRetryPolicy {
    private final ThreadLocalRandom _random = ThreadLocalRandom.current();
    private final long _initialDelayMs;
    private final double _delayScaleFactor;

    public ExponentialBackoffRetryPolicy(int maxNumAttempts, long initialDelayMs, double delayScaleFactor) {
        super(maxNumAttempts);
        this._initialDelayMs = initialDelayMs;
        this._delayScaleFactor = delayScaleFactor;
    }

    @Override
    protected long getDelayMs(int currentAttempt) {
        long maxDelayMs;
        long minDelayMs = (long)((double)this._initialDelayMs * Math.pow(this._delayScaleFactor, currentAttempt));
        return minDelayMs < (maxDelayMs = (long)((double)minDelayMs * this._delayScaleFactor)) ? this._random.nextLong(minDelayMs, maxDelayMs) : minDelayMs;
    }
}

