/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.config.BaseJsonConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;

public class TableConfigs
extends BaseJsonConfig {
    private String _tableName;
    private final Schema _schema;
    private final TableConfig _offline;
    private final TableConfig _realtime;

    @JsonCreator
    public TableConfigs(@JsonProperty(value="tableName", required=true) String tableName, @JsonProperty(value="schema", required=true) Schema schema, @JsonProperty(value="offline") @Nullable TableConfig offline, @JsonProperty(value="realtime") @Nullable TableConfig realtime) {
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)tableName), (Object)"'tableName' cannot be null or empty in TableConfigs");
        Preconditions.checkNotNull((Object)schema, (Object)"'schema' cannot be null in TableConfigs");
        this._tableName = tableName;
        this._schema = schema;
        this._offline = offline;
        this._realtime = realtime;
    }

    public String getTableName() {
        return this._tableName;
    }

    public void setTableName(String rawTableName) {
        this._tableName = rawTableName;
        this._schema.setSchemaName(rawTableName);
        if (this._offline != null) {
            this._offline.setTableName(TableNameBuilder.OFFLINE.tableNameWithType(rawTableName));
        }
        if (this._realtime != null) {
            this._realtime.setTableName(TableNameBuilder.REALTIME.tableNameWithType(rawTableName));
        }
    }

    public Schema getSchema() {
        return this._schema;
    }

    @Nullable
    public TableConfig getOffline() {
        return this._offline;
    }

    @Nullable
    public TableConfig getRealtime() {
        return this._realtime;
    }

    private ObjectNode toJsonObject() {
        ObjectNode tableConfigsObjectNode = JsonUtils.newObjectNode();
        tableConfigsObjectNode.put("tableName", this._tableName);
        tableConfigsObjectNode.set("schema", (JsonNode)this._schema.toJsonObject());
        if (this._offline != null) {
            tableConfigsObjectNode.set("offline", this._offline.toJsonNode());
        }
        if (this._realtime != null) {
            tableConfigsObjectNode.set("realtime", this._realtime.toJsonNode());
        }
        return tableConfigsObjectNode;
    }

    @Override
    public String toJsonString() {
        try {
            return JsonUtils.objectToString(this.toJsonObject());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public String toPrettyJsonString() {
        try {
            return JsonUtils.objectToPrettyString(this.toJsonObject());
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

