/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.config.table;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.pinot.spi.config.table.IndexConfig;

public class MapIndexConfig
extends IndexConfig {
    public static final MapIndexConfig DEFAULT = new MapIndexConfig();
    public static final MapIndexConfig DISABLED = new MapIndexConfig(true);
    private final Map<String, Object> _configs;

    public MapIndexConfig() {
        this(false);
    }

    public MapIndexConfig(Boolean disabled) {
        super(disabled);
        this._configs = new HashMap<String, Object>();
    }

    @JsonCreator
    public MapIndexConfig(@JsonProperty(value="disabled") @Nullable Boolean disabled, @JsonProperty(value="configs") @Nullable Map<String, Object> configs) {
        super(disabled);
        this._configs = configs != null ? configs : new HashMap();
    }

    public Map<String, Object> getConfigs() {
        return this._configs;
    }

    public void putConfig(String key, Object value) {
        this._configs.put(key, value);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MapIndexConfig config = (MapIndexConfig)o;
        return this._configs.equals(config._configs);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this._configs);
    }
}

