/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.cursors;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import org.apache.pinot.spi.cursors.ResponseStore;

public class ResponseStoreService {
    private static volatile ResponseStoreService _instance = ResponseStoreService.fromServiceLoader();
    private final Set<ResponseStore> _allResponseStores;
    private final Map<String, ResponseStore> _responseStoreByType;

    private ResponseStoreService(Set<ResponseStore> storeSet) {
        this._allResponseStores = storeSet;
        this._responseStoreByType = new HashMap<String, ResponseStore>();
        for (ResponseStore responseStore : storeSet) {
            this._responseStoreByType.put(responseStore.getType(), responseStore);
        }
    }

    public static ResponseStoreService getInstance() {
        return _instance;
    }

    public static void setInstance(ResponseStoreService service) {
        _instance = service;
    }

    public static ResponseStoreService fromServiceLoader() {
        HashSet<ResponseStore> storeSet = new HashSet<ResponseStore>();
        for (ResponseStore responseStore : ServiceLoader.load(ResponseStore.class)) {
            storeSet.add(responseStore);
        }
        return new ResponseStoreService(storeSet);
    }

    public Set<ResponseStore> getAllResponseStores() {
        return this._allResponseStores;
    }

    public Map<String, ResponseStore> getResponseStoresByType() {
        return this._responseStoreByType;
    }

    public ResponseStore getResponseStore(String type) {
        ResponseStore responseStore = this._responseStoreByType.get(type);
        if (responseStore == null) {
            throw new IllegalArgumentException("Unknown ResponseStore type: " + type);
        }
        return responseStore;
    }
}

