/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Preconditions;
import java.util.HashMap;
import java.util.Map;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.StringUtil;

@JsonIgnoreProperties(ignoreUnknown=true)
public final class ComplexFieldSpec
extends FieldSpec {
    public static final String KEY_FIELD = "key";
    public static final String VALUE_FIELD = "value";
    private final Map<String, FieldSpec> _childFieldSpecs;

    public ComplexFieldSpec() {
        this._childFieldSpecs = new HashMap<String, FieldSpec>();
    }

    public ComplexFieldSpec(String name, FieldSpec.DataType dataType, boolean isSingleValueField, Map<String, FieldSpec> childFieldSpecs) {
        super(name, dataType, isSingleValueField);
        Preconditions.checkArgument((dataType == FieldSpec.DataType.STRUCT || dataType == FieldSpec.DataType.MAP || dataType == FieldSpec.DataType.LIST ? 1 : 0) != 0);
        this._childFieldSpecs = childFieldSpecs;
    }

    public static String[] getColumnPath(String column) {
        return column.split("\\$\\$");
    }

    public FieldSpec getChildFieldSpec(String child) {
        return this._childFieldSpecs.get(child);
    }

    public Map<String, FieldSpec> getChildFieldSpecs() {
        return this._childFieldSpecs;
    }

    @Override
    @JsonIgnore
    public FieldSpec.FieldType getFieldType() {
        return FieldSpec.FieldType.COMPLEX;
    }

    public String toString() {
        return "field type: COMPLEX, field name: " + this._name + ", root data type: " + this._dataType + ", child field specs: " + this._childFieldSpecs;
    }

    public static MapFieldSpec toMapFieldSpec(ComplexFieldSpec complexFieldSpec) {
        return new MapFieldSpec(complexFieldSpec);
    }

    public static ComplexFieldSpec fromMapFieldSpec(MapFieldSpec mapFieldSpec) {
        return new ComplexFieldSpec(mapFieldSpec.getFieldName(), FieldSpec.DataType.MAP, true, Map.of(KEY_FIELD, mapFieldSpec.getKeyFieldSpec(), VALUE_FIELD, mapFieldSpec.getValueFieldSpec()));
    }

    public static String getFullChildName(String ... columns) {
        return StringUtil.join("$$", columns);
    }

    @Override
    public ObjectNode toJsonObject() {
        ObjectNode jsonObject = super.toJsonObject();
        ObjectNode childFieldSpecsNode = JsonUtils.newObjectNode();
        for (Map.Entry<String, FieldSpec> entry : this._childFieldSpecs.entrySet()) {
            childFieldSpecsNode.put(entry.getKey(), (JsonNode)entry.getValue().toJsonObject());
        }
        jsonObject.put("childFieldSpecs", (JsonNode)childFieldSpecsNode);
        return jsonObject;
    }

    public static class MapFieldSpec {
        private final String _fieldName;
        private final FieldSpec _keyFieldSpec;
        private final FieldSpec _valueFieldSpec;

        private MapFieldSpec(ComplexFieldSpec complexFieldSpec) {
            Preconditions.checkState((boolean)complexFieldSpec.getChildFieldSpecs().containsKey(ComplexFieldSpec.KEY_FIELD), (Object)"Missing 'key' in the 'childFieldSpec'");
            Preconditions.checkState((boolean)complexFieldSpec.getChildFieldSpecs().containsKey(ComplexFieldSpec.VALUE_FIELD), (Object)"Missing 'value' in the 'childFieldSpec'");
            this._keyFieldSpec = complexFieldSpec.getChildFieldSpec(ComplexFieldSpec.KEY_FIELD);
            this._valueFieldSpec = complexFieldSpec.getChildFieldSpec(ComplexFieldSpec.VALUE_FIELD);
            this._fieldName = complexFieldSpec.getName();
        }

        public String getFieldName() {
            return this._fieldName;
        }

        public FieldSpec getKeyFieldSpec() {
            return this._keyFieldSpec;
        }

        public FieldSpec getValueFieldSpec() {
            return this._valueFieldSpec;
        }
    }
}

