/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.OptBoolean;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.pinot.spi.data.ComplexFieldSpec;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.DimensionFieldSpec;
import org.apache.pinot.spi.data.MetricFieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.TimeFieldSpec;
import org.apache.pinot.spi.utils.BooleanUtils;
import org.apache.pinot.spi.utils.ByteArray;
import org.apache.pinot.spi.utils.BytesUtils;
import org.apache.pinot.spi.utils.EqualityUtils;
import org.apache.pinot.spi.utils.JsonUtils;
import org.apache.pinot.spi.utils.TimestampUtils;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="fieldType", requireTypeIdForSubtypes=OptBoolean.FALSE)
@JsonSubTypes(value={@JsonSubTypes.Type(value=DimensionFieldSpec.class, name="DIMENSION"), @JsonSubTypes.Type(value=MetricFieldSpec.class, name="METRIC"), @JsonSubTypes.Type(value=TimeFieldSpec.class, name="TIME"), @JsonSubTypes.Type(value=DateTimeFieldSpec.class, name="DATE_TIME"), @JsonSubTypes.Type(value=ComplexFieldSpec.class, name="COMPLEX")})
public abstract class FieldSpec
implements Comparable<FieldSpec>,
Serializable {
    public static final int DEFAULT_MAX_LENGTH = 512;
    public static final Integer DEFAULT_DIMENSION_NULL_VALUE_OF_INT = Integer.MIN_VALUE;
    public static final Long DEFAULT_DIMENSION_NULL_VALUE_OF_LONG = Long.MIN_VALUE;
    public static final Float DEFAULT_DIMENSION_NULL_VALUE_OF_FLOAT = Float.valueOf(Float.NEGATIVE_INFINITY);
    public static final Double DEFAULT_DIMENSION_NULL_VALUE_OF_DOUBLE = Double.NEGATIVE_INFINITY;
    public static final Integer DEFAULT_DIMENSION_NULL_VALUE_OF_BOOLEAN = 0;
    public static final Long DEFAULT_DIMENSION_NULL_VALUE_OF_TIMESTAMP = 0L;
    public static final String DEFAULT_DIMENSION_NULL_VALUE_OF_STRING = "null";
    public static final String DEFAULT_DIMENSION_NULL_VALUE_OF_JSON = "null";
    public static final byte[] DEFAULT_DIMENSION_NULL_VALUE_OF_BYTES = new byte[0];
    public static final BigDecimal DEFAULT_DIMENSION_NULL_VALUE_OF_BIG_DECIMAL = BigDecimal.ZERO;
    public static final Integer DEFAULT_METRIC_NULL_VALUE_OF_INT = 0;
    public static final Long DEFAULT_METRIC_NULL_VALUE_OF_LONG = 0L;
    public static final Float DEFAULT_METRIC_NULL_VALUE_OF_FLOAT = Float.valueOf(0.0f);
    public static final Double DEFAULT_METRIC_NULL_VALUE_OF_DOUBLE = 0.0;
    public static final BigDecimal DEFAULT_METRIC_NULL_VALUE_OF_BIG_DECIMAL = BigDecimal.ZERO;
    public static final String DEFAULT_METRIC_NULL_VALUE_OF_STRING = "null";
    public static final byte[] DEFAULT_METRIC_NULL_VALUE_OF_BYTES = new byte[0];
    public static final FieldSpecMetadata FIELD_SPEC_METADATA;
    public static final Map DEFAULT_COMPLEX_NULL_VALUE_OF_MAP;
    public static final List DEFAULT_COMPLEX_NULL_VALUE_OF_LIST;
    protected String _name;
    protected DataType _dataType;
    protected boolean _isSingleValueField = true;
    protected boolean _notNull = false;
    private int _maxLength = 512;
    protected MaxLengthExceedStrategy _maxLengthExceedStrategy;
    protected Object _defaultNullValue;
    private transient String _stringDefaultNullValue;
    @Deprecated
    protected String _transformFunction;
    protected String _virtualColumnProvider;

    public FieldSpec() {
    }

    public FieldSpec(String name, DataType dataType, boolean isSingleValueField) {
        this(name, dataType, isSingleValueField, 512, null);
    }

    public FieldSpec(String name, DataType dataType, boolean isSingleValueField, @Nullable Object defaultNullValue) {
        this(name, dataType, isSingleValueField, 512, defaultNullValue);
    }

    public FieldSpec(String name, DataType dataType, boolean isSingleValueField, int maxLength, @Nullable Object defaultNullValue) {
        this(name, dataType, isSingleValueField, maxLength, defaultNullValue, null);
    }

    public FieldSpec(String name, DataType dataType, boolean isSingleValueField, int maxLength, @Nullable Object defaultNullValue, @Nullable MaxLengthExceedStrategy maxLengthExceedStrategy) {
        this._name = name;
        this._dataType = dataType;
        this._isSingleValueField = isSingleValueField;
        this._maxLength = maxLength;
        this.setDefaultNullValue(defaultNullValue);
        this._maxLengthExceedStrategy = maxLengthExceedStrategy;
    }

    public abstract FieldType getFieldType();

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public DataType getDataType() {
        return this._dataType;
    }

    public void setDataType(DataType dataType) {
        this._dataType = dataType;
        this._defaultNullValue = FieldSpec.getDefaultNullValue(this.getFieldType(), this._dataType, this._stringDefaultNullValue);
    }

    public boolean isSingleValueField() {
        return this._isSingleValueField;
    }

    public void setSingleValueField(boolean isSingleValueField) {
        this._isSingleValueField = isSingleValueField;
    }

    public int getMaxLength() {
        return this._maxLength;
    }

    public void setMaxLength(int maxLength) {
        this._maxLength = maxLength;
    }

    @Nullable
    public MaxLengthExceedStrategy getMaxLengthExceedStrategy() {
        return this._maxLengthExceedStrategy;
    }

    public void setMaxLengthExceedStrategy(@Nullable MaxLengthExceedStrategy maxLengthExceedStrategy) {
        this._maxLengthExceedStrategy = maxLengthExceedStrategy;
    }

    public String getVirtualColumnProvider() {
        return this._virtualColumnProvider;
    }

    public void setVirtualColumnProvider(String virtualColumnProvider) {
        this._virtualColumnProvider = virtualColumnProvider;
    }

    @JsonIgnore
    public boolean isVirtualColumn() {
        return this._virtualColumnProvider != null && !this._virtualColumnProvider.isEmpty();
    }

    public Object getDefaultNullValue() {
        return this._defaultNullValue;
    }

    public String getDefaultNullValueString() {
        return FieldSpec.getStringValue(this._defaultNullValue);
    }

    public static String getStringValue(Object value) {
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).toPlainString();
        }
        if (value instanceof byte[]) {
            return BytesUtils.toHexString((byte[])value);
        }
        return value.toString();
    }

    public void setDefaultNullValue(@Nullable Object defaultNullValue) {
        if (defaultNullValue != null) {
            this._stringDefaultNullValue = FieldSpec.getStringValue(defaultNullValue);
        }
        if (this._dataType != null) {
            this._defaultNullValue = FieldSpec.getDefaultNullValue(this.getFieldType(), this._dataType, this._stringDefaultNullValue);
        }
    }

    public static Object getDefaultNullValue(FieldType fieldType, DataType dataType, @Nullable String stringDefaultNullValue) {
        if (stringDefaultNullValue != null) {
            return dataType.convert(stringDefaultNullValue);
        }
        switch (fieldType) {
            case METRIC: {
                switch (dataType) {
                    case INT: {
                        return DEFAULT_METRIC_NULL_VALUE_OF_INT;
                    }
                    case LONG: {
                        return DEFAULT_METRIC_NULL_VALUE_OF_LONG;
                    }
                    case FLOAT: {
                        return DEFAULT_METRIC_NULL_VALUE_OF_FLOAT;
                    }
                    case DOUBLE: {
                        return DEFAULT_METRIC_NULL_VALUE_OF_DOUBLE;
                    }
                    case BIG_DECIMAL: {
                        return DEFAULT_METRIC_NULL_VALUE_OF_BIG_DECIMAL;
                    }
                    case STRING: {
                        return "null";
                    }
                    case BYTES: {
                        return DEFAULT_METRIC_NULL_VALUE_OF_BYTES;
                    }
                }
                throw new IllegalStateException("Unsupported metric data type: " + dataType);
            }
            case DIMENSION: 
            case TIME: 
            case DATE_TIME: {
                switch (dataType) {
                    case INT: {
                        return DEFAULT_DIMENSION_NULL_VALUE_OF_INT;
                    }
                    case LONG: {
                        return DEFAULT_DIMENSION_NULL_VALUE_OF_LONG;
                    }
                    case FLOAT: {
                        return DEFAULT_DIMENSION_NULL_VALUE_OF_FLOAT;
                    }
                    case DOUBLE: {
                        return DEFAULT_DIMENSION_NULL_VALUE_OF_DOUBLE;
                    }
                    case BOOLEAN: {
                        return DEFAULT_DIMENSION_NULL_VALUE_OF_BOOLEAN;
                    }
                    case TIMESTAMP: {
                        return DEFAULT_DIMENSION_NULL_VALUE_OF_TIMESTAMP;
                    }
                    case STRING: {
                        return "null";
                    }
                    case JSON: {
                        return "null";
                    }
                    case BYTES: {
                        return DEFAULT_DIMENSION_NULL_VALUE_OF_BYTES;
                    }
                    case BIG_DECIMAL: {
                        return DEFAULT_DIMENSION_NULL_VALUE_OF_BIG_DECIMAL;
                    }
                }
                throw new IllegalStateException("Unsupported dimension/time data type: " + dataType);
            }
            case COMPLEX: {
                switch (dataType) {
                    case MAP: {
                        return DEFAULT_COMPLEX_NULL_VALUE_OF_MAP;
                    }
                    case LIST: {
                        return DEFAULT_COMPLEX_NULL_VALUE_OF_LIST;
                    }
                }
                throw new IllegalStateException("Unsupported complex data type: " + dataType);
            }
        }
        throw new IllegalStateException("Unsupported field type: " + fieldType);
    }

    @Deprecated
    public String getTransformFunction() {
        return this._transformFunction;
    }

    @Deprecated
    public void setTransformFunction(@Nullable String transformFunction) {
        this._transformFunction = transformFunction;
    }

    @JsonIgnore
    public boolean isNullable() {
        return !this._notNull;
    }

    @JsonIgnore
    public void setNullable(Boolean nullable) {
        this._notNull = nullable == false;
    }

    public boolean isNotNull() {
        return this._notNull;
    }

    public void setNotNull(boolean notNull) {
        this._notNull = notNull;
    }

    public ObjectNode toJsonObject() {
        ObjectNode jsonObject = JsonUtils.newObjectNode();
        jsonObject.put("name", this._name);
        jsonObject.put("dataType", this._dataType.name());
        jsonObject.put("fieldType", this.getFieldType().toString());
        if (!this._isSingleValueField) {
            jsonObject.put("singleValueField", false);
        }
        if (this._maxLength != 512) {
            jsonObject.put("maxLength", this._maxLength);
        }
        this.appendDefaultNullValue(jsonObject);
        this.appendTransformFunction(jsonObject);
        jsonObject.put("notNull", this._notNull);
        return jsonObject;
    }

    protected void appendDefaultNullValue(ObjectNode jsonNode) {
        assert (this._defaultNullValue != null);
        String key = "defaultNullValue";
        if (!this._defaultNullValue.equals(FieldSpec.getDefaultNullValue(this.getFieldType(), this._dataType, null))) {
            switch (this._dataType) {
                case INT: {
                    jsonNode.put(key, (Integer)this._defaultNullValue);
                    break;
                }
                case LONG: {
                    jsonNode.put(key, (Long)this._defaultNullValue);
                    break;
                }
                case FLOAT: {
                    jsonNode.put(key, (Float)this._defaultNullValue);
                    break;
                }
                case DOUBLE: {
                    jsonNode.put(key, (Double)this._defaultNullValue);
                    break;
                }
                case BIG_DECIMAL: {
                    jsonNode.put(key, (BigDecimal)this._defaultNullValue);
                    break;
                }
                case BOOLEAN: {
                    jsonNode.put(key, (Integer)this._defaultNullValue == 1);
                    break;
                }
                case TIMESTAMP: {
                    jsonNode.put(key, new Timestamp((Long)this._defaultNullValue).toString());
                    break;
                }
                case STRING: 
                case JSON: {
                    jsonNode.put(key, (String)this._defaultNullValue);
                    break;
                }
                case BYTES: {
                    jsonNode.put(key, BytesUtils.toHexString((byte[])this._defaultNullValue));
                    break;
                }
                case MAP: {
                    jsonNode.put(key, JsonUtils.objectToJsonNode(this._defaultNullValue));
                    break;
                }
                case LIST: {
                    jsonNode.put(key, JsonUtils.objectToJsonNode(this._defaultNullValue));
                    break;
                }
                default: {
                    throw new IllegalStateException("Unsupported data type: " + this);
                }
            }
        }
    }

    protected void appendTransformFunction(ObjectNode jsonNode) {
        if (this._transformFunction != null) {
            jsonNode.put("transformFunction", this._transformFunction);
        }
    }

    public boolean equals(Object o) {
        if (EqualityUtils.isSameReference(this, o)) {
            return true;
        }
        if (EqualityUtils.isNullOrNotSameClass(this, o)) {
            return false;
        }
        FieldSpec that = (FieldSpec)o;
        return EqualityUtils.isEqual(this._name, that._name) && EqualityUtils.isEqual((Object)this._dataType, (Object)that._dataType) && EqualityUtils.isEqual(this._isSingleValueField, that._isSingleValueField) && EqualityUtils.isEqual(FieldSpec.getStringValue(this._defaultNullValue), FieldSpec.getStringValue(that._defaultNullValue)) && EqualityUtils.isEqual(this._maxLength, that._maxLength) && EqualityUtils.isEqual(this._transformFunction, that._transformFunction) && EqualityUtils.isEqual((Object)this._maxLengthExceedStrategy, (Object)that._maxLengthExceedStrategy) && EqualityUtils.isEqual(this._virtualColumnProvider, that._virtualColumnProvider) && EqualityUtils.isEqual(this._notNull, that._notNull);
    }

    public int hashCode() {
        int result = EqualityUtils.hashCodeOf(this._name);
        result = EqualityUtils.hashCodeOf(result, (Object)this._dataType);
        result = EqualityUtils.hashCodeOf(result, this._isSingleValueField);
        result = EqualityUtils.hashCodeOf(result, FieldSpec.getStringValue(this._defaultNullValue));
        result = EqualityUtils.hashCodeOf(result, this._maxLength);
        result = EqualityUtils.hashCodeOf(result, (Object)this._maxLengthExceedStrategy);
        result = EqualityUtils.hashCodeOf(result, this._transformFunction);
        result = EqualityUtils.hashCodeOf(result, this._virtualColumnProvider);
        result = EqualityUtils.hashCodeOf(result, this._notNull);
        return result;
    }

    @Override
    public int compareTo(FieldSpec otherSpec) {
        return this._name.compareTo(otherSpec._name);
    }

    public boolean isBackwardCompatibleWith(FieldSpec oldFieldSpec) {
        return EqualityUtils.isEqual(this._name, oldFieldSpec._name) && EqualityUtils.isEqual((Object)this._dataType, (Object)oldFieldSpec._dataType) && EqualityUtils.isEqual(this._isSingleValueField, oldFieldSpec._isSingleValueField);
    }

    static {
        DEFAULT_COMPLEX_NULL_VALUE_OF_MAP = Map.of();
        DEFAULT_COMPLEX_NULL_VALUE_OF_LIST = List.of();
        FIELD_SPEC_METADATA = new FieldSpecMetadata();
        for (FieldType fieldType : FieldType.values()) {
            FieldTypeMetadata fieldTypeMetadata = new FieldTypeMetadata();
            for (DataType dataType : DataType.values()) {
                try {
                    Schema.validate(fieldType, dataType);
                    try {
                        fieldTypeMetadata.put(dataType, new DataTypeMetadata(FieldSpec.getDefaultNullValue(fieldType, dataType, null)));
                    }
                    catch (IllegalStateException ignored) {
                        fieldTypeMetadata.put(dataType, new DataTypeMetadata(null));
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
            FIELD_SPEC_METADATA.put(fieldType, fieldTypeMetadata);
        }
        for (Enum enum_ : DataType.values()) {
            FIELD_SPEC_METADATA.put((DataType)enum_, new DataTypeProperties((DataType)enum_));
        }
    }

    public static class DataTypeProperties {
        @JsonProperty(value="storedType")
        public final DataType _storedType;
        @JsonProperty(value="size")
        public final int _size;
        @JsonProperty(value="sortable")
        public final boolean _sortable;
        @JsonProperty(value="numeric")
        public final boolean _numeric;

        public DataTypeProperties(DataType dataType) {
            this._storedType = dataType._storedType;
            this._sortable = dataType._sortable;
            this._numeric = dataType._numeric;
            this._size = dataType._size;
        }
    }

    public static class DataTypeMetadata {
        @JsonProperty(value="nullDefault")
        public Object _nullDefault;

        public DataTypeMetadata(Object nullDefault) {
            this._nullDefault = nullDefault;
        }
    }

    public static class FieldTypeMetadata {
        @JsonProperty(value="allowedDataTypes")
        public Map<DataType, DataTypeMetadata> _allowedDataTypes = new HashMap<DataType, DataTypeMetadata>();

        void put(DataType dataType, DataTypeMetadata metadata) {
            this._allowedDataTypes.put(dataType, metadata);
        }
    }

    public static class FieldSpecMetadata {
        @JsonProperty(value="fieldTypes")
        public Map<FieldType, FieldTypeMetadata> _fieldTypes = new HashMap<FieldType, FieldTypeMetadata>();
        @JsonProperty(value="dataTypes")
        public Map<DataType, DataTypeProperties> _dataTypes = new HashMap<DataType, DataTypeProperties>();

        void put(FieldType type, FieldTypeMetadata metadata) {
            this._fieldTypes.put(type, metadata);
        }

        void put(DataType type, DataTypeProperties metadata) {
            this._dataTypes.put(type, metadata);
        }
    }

    public static enum DataType {
        INT(4, true, true),
        LONG(8, true, true),
        FLOAT(4, true, true),
        DOUBLE(8, true, true),
        BIG_DECIMAL(true, true),
        BOOLEAN(INT, false, true),
        TIMESTAMP(LONG, false, true),
        STRING(false, true),
        JSON(STRING, false, false),
        BYTES(false, false),
        STRUCT(false, false),
        MAP(false, false),
        LIST(false, false),
        UNKNOWN(false, true);

        private final DataType _storedType;
        private final int _size;
        private final boolean _sortable;
        private final boolean _numeric;

        private DataType(boolean numeric, boolean sortable) {
            this._storedType = this;
            this._size = -1;
            this._sortable = sortable;
            this._numeric = numeric;
        }

        private DataType(DataType storedType, boolean numeric, boolean sortable) {
            this._storedType = storedType;
            this._size = storedType._size;
            this._sortable = sortable;
            this._numeric = numeric;
        }

        private DataType(int size, boolean numeric, boolean sortable) {
            this._storedType = this;
            this._size = size;
            this._sortable = sortable;
            this._numeric = numeric;
        }

        public DataType getStoredType() {
            return this._storedType;
        }

        public boolean isFixedWidth() {
            return this._size >= 0;
        }

        public int size() {
            if (this._size >= 0) {
                return this._size;
            }
            throw new IllegalStateException("Cannot get number of bytes for: " + this);
        }

        public boolean isNumeric() {
            return this._numeric;
        }

        public boolean isUnknown() {
            return this._storedType == UNKNOWN;
        }

        public Object convert(String value) {
            try {
                switch (this) {
                    case INT: {
                        return Integer.valueOf(value);
                    }
                    case LONG: {
                        return Long.valueOf(value);
                    }
                    case FLOAT: {
                        return Float.valueOf(value);
                    }
                    case DOUBLE: {
                        return Double.valueOf(value);
                    }
                    case BIG_DECIMAL: {
                        return new BigDecimal(value);
                    }
                    case BOOLEAN: {
                        return BooleanUtils.toInt(value);
                    }
                    case TIMESTAMP: {
                        return TimestampUtils.toMillisSinceEpoch(value);
                    }
                    case STRING: 
                    case JSON: {
                        return value;
                    }
                    case BYTES: {
                        return BytesUtils.toBytes(value);
                    }
                    case MAP: {
                        return JsonUtils.stringToObject(value, Map.class);
                    }
                    case LIST: {
                        return JsonUtils.stringToObject(value, List.class);
                    }
                }
                throw new IllegalStateException();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot convert value: '" + value + "' to type: " + this);
            }
        }

        public int compare(Object value1, Object value2) {
            switch (this) {
                case INT: {
                    return Integer.compare((Integer)value1, (Integer)value2);
                }
                case LONG: {
                    return Long.compare((Long)value1, (Long)value2);
                }
                case FLOAT: {
                    return Float.compare(((Float)value1).floatValue(), ((Float)value2).floatValue());
                }
                case DOUBLE: {
                    return Double.compare((Double)value1, (Double)value2);
                }
                case BIG_DECIMAL: {
                    return ((BigDecimal)value1).compareTo((BigDecimal)value2);
                }
                case BOOLEAN: {
                    return Boolean.compare((Boolean)value1, (Boolean)value2);
                }
                case TIMESTAMP: {
                    return Long.compare((Long)value1, (Long)value2);
                }
                case STRING: 
                case JSON: {
                    return ((String)value1).compareTo((String)value2);
                }
                case BYTES: {
                    return ByteArray.compare((byte[])value1, (byte[])value2);
                }
                case MAP: 
                case LIST: {
                    throw new UnsupportedOperationException("Cannot compare complex data types: " + this);
                }
            }
            throw new IllegalStateException();
        }

        public String toString(Object value) {
            if (this == BIG_DECIMAL) {
                return ((BigDecimal)value).toPlainString();
            }
            if (this == BYTES) {
                return BytesUtils.toHexString((byte[])value);
            }
            if (this == MAP || this == LIST) {
                try {
                    return JsonUtils.objectToString(value);
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
            }
            return value.toString();
        }

        public Comparable convertInternal(String value) {
            try {
                switch (this) {
                    case INT: {
                        return Integer.valueOf(value);
                    }
                    case LONG: {
                        return Long.valueOf(value);
                    }
                    case FLOAT: {
                        return Float.valueOf(value);
                    }
                    case DOUBLE: {
                        return Double.valueOf(value);
                    }
                    case BIG_DECIMAL: {
                        return new BigDecimal(value);
                    }
                    case BOOLEAN: {
                        return Integer.valueOf(BooleanUtils.toInt(value));
                    }
                    case TIMESTAMP: {
                        return Long.valueOf(TimestampUtils.toMillisSinceEpoch(value));
                    }
                    case STRING: 
                    case JSON: {
                        return value;
                    }
                    case BYTES: {
                        return BytesUtils.toByteArray(value);
                    }
                    case MAP: 
                    case LIST: {
                        throw new UnsupportedOperationException("Cannot convert complex data types: " + this);
                    }
                }
                throw new IllegalStateException();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot convert value: '" + value + "' to type: " + this);
            }
        }

        public boolean canBeASortedColumn() {
            return this._sortable;
        }
    }

    public static enum FieldType {
        DIMENSION,
        METRIC,
        TIME,
        DATE_TIME,
        COMPLEX;

    }

    public static enum MaxLengthExceedStrategy {
        TRIM_LENGTH,
        ERROR,
        SUBSTITUTE_DEFAULT_VALUE,
        NO_ACTION;

    }
}

