/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.data.readers;

import com.google.common.collect.Maps;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.pinot.spi.data.readers.RecordExtractor;

public abstract class BaseRecordExtractor<T>
implements RecordExtractor<T> {
    @Override
    public Object convert(Object value) {
        Object convertedValue = this.isMultiValue(value) ? this.convertMultiValue(value) : (this.isMap(value) ? this.convertMap(value) : (this.isRecord(value) ? this.convertRecord(value) : this.convertSingleValue(value)));
        return convertedValue;
    }

    protected boolean isRecord(Object value) {
        return false;
    }

    protected boolean isMultiValue(Object value) {
        return value instanceof Collection || value.getClass().isArray() && !(value instanceof byte[]);
    }

    protected boolean isMap(Object value) {
        return value instanceof Map;
    }

    protected Map<Object, Object> convertRecord(Object value) {
        throw new UnsupportedOperationException("Extractor cannot convert record type structures for this data format.");
    }

    protected Object[] convertMultiValue(Object value) {
        if (value instanceof Collection) {
            return this.convertCollection((Collection)value);
        }
        if (value instanceof Object[]) {
            return this.convertArray((Object[])value);
        }
        return this.convertPrimitiveArray(value);
    }

    protected Object[] convertCollection(Collection collection) {
        int numValues = collection.size();
        Object[] convertedValues = new Object[numValues];
        int index = 0;
        for (Object value : collection) {
            Object convertedValue = value != null ? this.convert(value) : null;
            convertedValues[index++] = convertedValue;
        }
        return convertedValues;
    }

    protected Object[] convertArray(Object[] array) {
        int numValues = array.length;
        Object[] convertedValues = new Object[numValues];
        for (int i = 0; i < numValues; ++i) {
            Object convertedValue;
            Object value = array[i];
            convertedValues[i] = convertedValue = value != null ? this.convert(value) : null;
        }
        return convertedValues;
    }

    protected Object[] convertPrimitiveArray(Object array) {
        if (array instanceof int[]) {
            return ArrayUtils.toObject((int[])((int[])array));
        }
        if (array instanceof long[]) {
            return ArrayUtils.toObject((long[])((long[])array));
        }
        if (array instanceof float[]) {
            return ArrayUtils.toObject((float[])((float[])array));
        }
        if (array instanceof double[]) {
            return ArrayUtils.toObject((double[])((double[])array));
        }
        throw new IllegalArgumentException("Unsupported primitive array type: " + array.getClass().getName());
    }

    protected Map<Object, Object> convertMap(Object value) {
        Map map = (Map)value;
        HashMap convertedMap = Maps.newHashMapWithExpectedSize((int)map.size());
        for (Map.Entry entry : map.entrySet()) {
            Object mapKey = entry.getKey();
            if (mapKey == null) continue;
            Object mapValue = entry.getValue();
            Object convertedMapValue = mapValue != null ? this.convert(mapValue) : null;
            convertedMap.put(this.convertSingleValue(entry.getKey()), convertedMapValue);
        }
        return convertedMap;
    }

    protected Object convertSingleValue(Object value) {
        if (value instanceof ByteBuffer) {
            ByteBuffer slice = ((ByteBuffer)value).slice();
            byte[] bytesValue = new byte[slice.limit()];
            slice.get(bytesValue);
            return bytesValue;
        }
        if (value instanceof Number || value instanceof byte[]) {
            if (value instanceof Short) {
                return Integer.valueOf(value.toString());
            }
            return value;
        }
        return value.toString();
    }
}

