/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.env;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import org.apache.commons.configuration2.Configuration;
import org.apache.commons.configuration2.PropertiesConfiguration;
import org.apache.commons.configuration2.convert.LegacyListDelimiterHandler;
import org.apache.commons.configuration2.convert.ListDelimiterHandler;
import org.apache.commons.configuration2.ex.ConfigurationException;
import org.apache.commons.configuration2.io.FileBased;
import org.apache.commons.configuration2.io.FileHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.env.PropertyIOFactoryKind;

public class CommonsConfigurationUtils {
    public static final String VERSIONED_CONFIG_SEPARATOR = " = ";
    private static final Character DEFAULT_LIST_DELIMITER = Character.valueOf(',');
    private static final ListDelimiterHandler DEFAULT_LIST_DELIMITER_HANDLER = new LegacyListDelimiterHandler(DEFAULT_LIST_DELIMITER.charValue());
    public static final String VERSION_HEADER_IDENTIFIER = "version";
    public static final String DEFAULT_PROPERTIES_CONFIGURATION_HEADER_VERSION = "1";
    public static final String PROPERTIES_CONFIGURATION_HEADER_VERSION_2 = "2";

    private CommonsConfigurationUtils() {
    }

    public static PropertiesConfiguration fromPath(String path) throws ConfigurationException {
        return CommonsConfigurationUtils.fromPath(path, true, null);
    }

    public static PropertiesConfiguration fromPath(@Nullable String path, boolean setDefaultDelimiter, @Nullable PropertyIOFactoryKind ioFactoryKind) throws ConfigurationException {
        PropertiesConfiguration config = CommonsConfigurationUtils.createPropertiesConfiguration(setDefaultDelimiter, ioFactoryKind);
        if (StringUtils.isNotEmpty((CharSequence)path)) {
            FileHandler fileHandler = new FileHandler((FileBased)config);
            fileHandler.load(path);
        }
        return config;
    }

    public static PropertiesConfiguration fromInputStream(InputStream stream) throws ConfigurationException {
        return CommonsConfigurationUtils.fromInputStream(stream, true, PropertyIOFactoryKind.DefaultIOFactory);
    }

    public static PropertiesConfiguration fromInputStream(@Nullable InputStream stream, boolean setDefaultDelimiter, @Nullable PropertyIOFactoryKind ioFactoryKind) throws ConfigurationException {
        PropertiesConfiguration config = CommonsConfigurationUtils.createPropertiesConfiguration(setDefaultDelimiter, ioFactoryKind);
        if (stream != null) {
            FileHandler fileHandler = new FileHandler((FileBased)config);
            fileHandler.load(stream);
        }
        return config;
    }

    public static PropertiesConfiguration getSegmentMetadataFromFile(File file, boolean setDefaultDelimiter) throws ConfigurationException {
        PropertyIOFactoryKind ioFactoryKind = PropertyIOFactoryKind.DefaultIOFactory;
        if (PROPERTIES_CONFIGURATION_HEADER_VERSION_2.equals(CommonsConfigurationUtils.getConfigurationHeaderVersion(file))) {
            ioFactoryKind = PropertyIOFactoryKind.VersionedIOFactory;
        }
        return CommonsConfigurationUtils.fromFile(file, setDefaultDelimiter, ioFactoryKind);
    }

    public static PropertiesConfiguration fromFile(File file) throws ConfigurationException {
        return CommonsConfigurationUtils.fromFile(file, true, PropertyIOFactoryKind.DefaultIOFactory);
    }

    public static PropertiesConfiguration fromFile(@Nullable File file, boolean setDefaultDelimiter, @Nullable PropertyIOFactoryKind ioFactoryKind) throws ConfigurationException {
        PropertiesConfiguration config = CommonsConfigurationUtils.createPropertiesConfiguration(setDefaultDelimiter, ioFactoryKind);
        if (file != null && file.exists()) {
            FileHandler fileHandler = new FileHandler((FileBased)config);
            fileHandler.load(file);
        }
        return config;
    }

    public static void saveSegmentMetadataToFile(PropertiesConfiguration propertiesConfiguration, File file, @Nullable String versionHeader) {
        if (StringUtils.isNotEmpty((CharSequence)versionHeader)) {
            String header = CommonsConfigurationUtils.getVersionHeaderString(versionHeader);
            propertiesConfiguration.setHeader(header);
            if (PROPERTIES_CONFIGURATION_HEADER_VERSION_2.equals(versionHeader)) {
                propertiesConfiguration.setIOFactory((PropertiesConfiguration.IOFactory)PropertyIOFactoryKind.VersionedIOFactory.getInstance());
                propertiesConfiguration.getLayout().setGlobalSeparator(VERSIONED_CONFIG_SEPARATOR);
            }
        }
        CommonsConfigurationUtils.saveToFile(propertiesConfiguration, file);
    }

    public static void saveToFile(PropertiesConfiguration propertiesConfiguration, File file) {
        FileHandler fileHandler = new FileHandler((FileBased)propertiesConfiguration);
        fileHandler.setFile(file);
        try {
            fileHandler.save();
        }
        catch (ConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private static Iterable<String> getIterable(Iterator<String> keys) {
        return () -> keys;
    }

    public static Stream<String> getKeysStream(Configuration configuration) {
        return StreamSupport.stream(CommonsConfigurationUtils.getIterable(configuration.getKeys()).spliterator(), false);
    }

    public static List<String> getKeys(Configuration configuration) {
        return CommonsConfigurationUtils.getKeysStream(configuration).collect(Collectors.toList());
    }

    public static Map<String, Object> toMap(Configuration configuration) {
        return CommonsConfigurationUtils.getKeysStream(configuration).collect(Collectors.toMap(key -> key, key -> CommonsConfigurationUtils.mapValue(key, configuration)));
    }

    private static Object mapValue(String key, Configuration configuration) {
        return Optional.of(configuration.getStringArray(key)).filter(values -> ((String[])values).length > 1).map(values -> Arrays.stream(values).collect(Collectors.joining(","))).orElseGet(() -> {
            Object rawProperty = configuration.getProperty(key);
            if (!CommonsConfigurationUtils.needInterpolate(rawProperty)) {
                return rawProperty;
            }
            return configuration.getString(key);
        });
    }

    public static boolean needInterpolate(Object rawProperty) {
        if (rawProperty instanceof String) {
            String strProperty = (String)rawProperty;
            return StringUtils.isNotEmpty((CharSequence)strProperty) && strProperty.startsWith("${") && strProperty.endsWith("}");
        }
        return false;
    }

    public static <T> T interpolate(Configuration configuration, String key, T defaultValue, Class<T> returnType) {
        if (Integer.class.equals(returnType)) {
            return (T)configuration.getInteger(key, (Integer)defaultValue);
        }
        if (Boolean.class.equals(returnType)) {
            return (T)configuration.getBoolean(key, (Boolean)defaultValue);
        }
        if (Long.class.equals(returnType)) {
            return (T)configuration.getLong(key, (Long)defaultValue);
        }
        if (Double.class.equals(returnType)) {
            return (T)configuration.getDouble(key, (Double)defaultValue);
        }
        throw new IllegalArgumentException(returnType + " is not a supported type for conversion.");
    }

    public static <T> T convert(Object value, Class<T> returnType) {
        if (Integer.class.equals(returnType)) {
            return (T)Integer.valueOf(value.toString());
        }
        if (Boolean.class.equals(returnType)) {
            return (T)Boolean.valueOf(value.toString());
        }
        if (Long.class.equals(returnType)) {
            return (T)Long.valueOf(value.toString());
        }
        if (Double.class.equals(returnType)) {
            return (T)Double.valueOf(value.toString());
        }
        throw new IllegalArgumentException(returnType + " is not a supported type for conversion.");
    }

    @Nullable
    public static String replaceSpecialCharacterInPropertyValue(String value) {
        int length = ((String)value).length();
        if (length == 0) {
            return value;
        }
        boolean containsDelimiter = false;
        for (int i = 0; i < length; ++i) {
            char c = ((String)value).charAt(i);
            if (Character.isSurrogate(c)) {
                return null;
            }
            if (c != DEFAULT_LIST_DELIMITER.charValue()) continue;
            containsDelimiter = true;
        }
        if (containsDelimiter) {
            value = ((String)value).replace(",", "\u0000\u0000");
        }
        if (((String)value).charAt(0) == ' ') {
            value = "\u0000" + (String)value;
        }
        if (((String)value).charAt(((String)value).length() - 1) == ' ') {
            value = (String)value + "\u0000";
        }
        return value;
    }

    public static String recoverSpecialCharacterInPropertyValue(String value) {
        if (value.isEmpty()) {
            return value;
        }
        if (value.startsWith("\u0000 ")) {
            value = value.substring(1);
        }
        if (value.endsWith(" \u0000")) {
            value = value.substring(0, value.length() - 1);
        }
        return value.replace("\u0000\u0000", ",");
    }

    private static PropertiesConfiguration createPropertiesConfiguration(boolean setDefaultDelimiter, @Nullable PropertyIOFactoryKind ioFactoryKind) {
        PropertiesConfiguration config = new PropertiesConfiguration();
        if (ioFactoryKind != null) {
            config.setIOFactory((PropertiesConfiguration.IOFactory)ioFactoryKind.getInstance());
        }
        if (setDefaultDelimiter) {
            config.setListDelimiterHandler((ListDelimiterHandler)new LegacyListDelimiterHandler(DEFAULT_LIST_DELIMITER.charValue()));
        }
        return config;
    }

    private static String getConfigurationHeaderVersion(File file) throws ConfigurationException {
        String versionValue = DEFAULT_PROPERTIES_CONFIGURATION_HEADER_VERSION;
        if (file.exists()) {
            try (BufferedReader reader = new BufferedReader(new FileReader(file));){
                String[] headerKeyValue;
                String fileFirstLine = reader.readLine();
                String versionHeaderCommentPrefix = "# version";
                if (StringUtils.startsWith((CharSequence)fileFirstLine, (CharSequence)versionHeaderCommentPrefix) && (headerKeyValue = StringUtils.splitByWholeSeparator((String)fileFirstLine, (String)VERSIONED_CONFIG_SEPARATOR, (int)2)).length == 2) {
                    versionValue = headerKeyValue[1];
                }
            }
            catch (IOException exception) {
                throw new ConfigurationException("Error occurred while reading configuration file " + file.getName(), (Throwable)exception);
            }
        }
        return versionValue;
    }

    static String getVersionHeaderString(String versionHeaderValue) {
        return "version = " + versionHeaderValue;
    }

    public static PropertiesConfiguration.PropertiesWriter getPropertiesWriterFromWriter(Writer writer) {
        PropertiesConfiguration.PropertiesWriter propertiesWriter = new PropertiesConfiguration.PropertiesWriter(writer, DEFAULT_LIST_DELIMITER_HANDLER);
        propertiesWriter.setGlobalSeparator(VERSIONED_CONFIG_SEPARATOR);
        return propertiesWriter;
    }
}

