/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.executor;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.executor.ExecutorServicePlugin;
import org.apache.pinot.spi.executor.ExecutorServiceProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecutorServiceUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(ExecutorServiceUtils.class);
    private static final long DEFAULT_TERMINATION_MILLIS = 30000L;
    private static final Map<String, ExecutorServiceProvider> PROVIDERS = new HashMap<String, ExecutorServiceProvider>();

    private static void forEachExecutorThatLoads(Consumer<ExecutorServicePlugin> consumer) {
        Iterator<ExecutorServicePlugin> iterator = ServiceLoader.load(ExecutorServicePlugin.class).iterator();
        while (ExecutorServiceUtils.hasNextOrSkip(iterator)) {
            ExecutorServicePlugin next;
            try {
                next = iterator.next();
            }
            catch (ServiceConfigurationError e) {
                LOGGER.warn("Skipping executor service plugin that doesn't load", (Throwable)e);
                continue;
            }
            consumer.accept(next);
        }
    }

    private static boolean hasNextOrSkip(Iterator<ExecutorServicePlugin> loader) {
        while (true) {
            try {
                return loader.hasNext();
            }
            catch (ServiceConfigurationError e) {
                LOGGER.warn("Skipping executor service plugin", (Throwable)e);
                continue;
            }
            break;
        }
    }

    private ExecutorServiceUtils() {
    }

    public static ExecutorService create(PinotConfiguration conf, String confPrefix, String baseName, String defType) {
        String type = conf.getProperty(confPrefix + ".type", defType);
        ExecutorServiceProvider provider = PROVIDERS.get(type);
        if (provider == null) {
            throw new IllegalArgumentException("Unknown executor service provider: " + type);
        }
        return provider.create(conf, confPrefix, baseName);
    }

    public static void close(ExecutorService executorService) {
        ExecutorServiceUtils.close(executorService, 30000L);
    }

    public static void close(ExecutorService executorService, long terminationMillis) {
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(terminationMillis, TimeUnit.SECONDS)) {
                List<Runnable> runnables = executorService.shutdownNow();
                LOGGER.warn("Around {} didn't finish in time after a shutdown", (Object)runnables.size());
            }
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        ExecutorServiceUtils.forEachExecutorThatLoads(plugin -> {
            ExecutorServiceProvider provider = plugin.provider();
            ExecutorServiceProvider old = PROVIDERS.put(plugin.id(), provider);
            if (old != null) {
                LOGGER.warn("Duplicate executor provider for id '{}': {} and {}", new Object[]{plugin.id(), old, provider});
            } else {
                LOGGER.info("Registered executor provider for id '{}': {}", (Object)plugin.id(), (Object)provider);
            }
        });
    }
}

