/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.plugin;

import com.google.common.annotations.VisibleForTesting;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.reflect.Constructor;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.pinot.spi.plugin.PinotPluginConfiguration;
import org.apache.pinot.spi.plugin.Plugin;
import org.apache.pinot.spi.plugin.PluginClassLoader;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PluginManager {
    public static final String PLUGINS_DIR_PROPERTY_NAME = "plugins.dir";
    public static final String PLUGINS_INCLUDE_PROPERTY_NAME = "plugins.include";
    public static final String DEFAULT_PLUGIN_NAME = "DEFAULT";
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginManager.class);
    private static final String JAR_FILE_EXTENSION = "jar";
    private static final PluginManager PLUGIN_MANAGER = new PluginManager();
    private static final String PINOT_REALMID = "pinot";
    private static final String PINOUT_PLUGIN_PROPERTIES_FILE_NAME = "pinot-plugin.properties";
    private static final Map<String, String> PLUGINS_BACKWARD_COMPATIBLE_CLASS_NAME_MAP = new HashMap<String, String>(){
        {
            this.put("org.apache.pinot.core.realtime.stream.SimpleAvroMessageDecoder", "org.apache.pinot.plugin.inputformat.avro.SimpleAvroMessageDecoder");
            this.put("org.apache.pinot.core.realtime.impl.kafka.KafkaAvroMessageDecoder", "org.apache.pinot.plugin.inputformat.avro.KafkaAvroMessageDecoder");
            this.put("org.apache.pinot.core.realtime.impl.kafka.KafkaJSONMessageDecoder", "org.apache.pinot.plugin.stream.kafka.KafkaJSONMessageDecoder");
            this.put("org.apache.pinot.core.data.readers.AvroRecordReader", "org.apache.pinot.plugin.inputformat.avro.AvroRecordReader");
            this.put("org.apache.pinot.core.data.readers.CSVRecordReader", "org.apache.pinot.plugin.inputformat.csv.CSVRecordReader");
            this.put("org.apache.pinot.core.data.readers.JSONRecordReader", "org.apache.pinot.plugin.inputformat.json.JSONRecordReader");
            this.put("org.apache.pinot.plugin.inputformat.json.JsonRecordReader", "org.apache.pinot.plugin.inputformat.json.JSONRecordReader");
            this.put("org.apache.pinot.orc.data.readers.ORCRecordReader", "org.apache.pinot.plugin.inputformat.orc.ORCRecordReader");
            this.put("org.apache.pinot.plugin.inputformat.orc.OrcRecordReader", "org.apache.pinot.plugin.inputformat.orc.ORCRecordReader");
            this.put("org.apache.pinot.parquet.data.readers.ParquetRecordReader", "org.apache.pinot.plugin.inputformat.parquet.ParquetRecordReader");
            this.put("org.apache.pinot.core.data.readers.ThriftRecordReader", "org.apache.pinot.plugin.inputformat.thrift.ThriftRecordReader");
            this.put("org.apache.pinot.filesystem.AzurePinotFS", "org.apache.pinot.plugin.filesystem.AzurePinotFS");
            this.put("org.apache.pinot.filesystem.HadoopPinotFS", "org.apache.pinot.plugin.filesystem.HadoopPinotFS");
            this.put("org.apache.pinot.filesystem.LocalPinotFS", "org.apache.pinot.spi.filesystem.LocalPinotFS");
            this.put("org.apache.pinot.core.realtime.impl.kafka2.KafkaConsumerFactory", "org.apache.pinot.plugin.stream.kafka20.KafkaConsumerFactory");
            this.put("org.apache.pinot.core.realtime.impl.kafka3.KafkaConsumerFactory", "org.apache.pinot.plugin.stream.kafka30.KafkaConsumerFactory");
        }
    };
    private static final Map<String, String> INPUT_FORMAT_TO_RECORD_READER_CLASS_NAME_MAP = new HashMap<String, String>(){
        {
            this.put("avro", "org.apache.pinot.plugin.inputformat.avro.AvroRecordReader");
            this.put("csv", "org.apache.pinot.plugin.inputformat.csv.CSVRecordReader");
            this.put("json", "org.apache.pinot.plugin.inputformat.json.JSONRecordReader");
            this.put("orc", "org.apache.pinot.plugin.inputformat.orc.ORCRecordReader");
            this.put("parquet", "org.apache.pinot.plugin.inputformat.parquet.ParquetRecordReader");
            this.put("protobuf", "org.apache.pinot.plugin.inputformat.protobuf.ProtoBufRecordReader");
            this.put("thrift", "org.apache.pinot.plugin.inputformat.thrift.ThriftRecordReader");
        }
    };
    private static final Map<String, String> INPUT_FORMAT_TO_RECORD_READER_CONFIG_CLASS_NAME_MAP = new HashMap<String, String>(){
        {
            this.put("avro", "org.apache.pinot.plugin.inputformat.avro.AvroRecordReaderConfig");
            this.put("csv", "org.apache.pinot.plugin.inputformat.csv.CSVRecordReaderConfig");
            this.put("protobuf", "org.apache.pinot.plugin.inputformat.protobuf.ProtoBufRecordReaderConfig");
            this.put("thrift", "org.apache.pinot.plugin.inputformat.thrift.ThriftRecordReaderConfig");
        }
    };
    private final ClassWorld _classWorld;
    private final Map<Plugin, PluginClassLoader> _registry = new HashMap<Plugin, PluginClassLoader>();
    private String _pluginsDirectories;
    private String _pluginsInclude;
    private boolean _initialized = false;

    PluginManager() {
        this._registry.put(new Plugin(DEFAULT_PLUGIN_NAME), this.createClassLoader(Collections.emptyList()));
        try {
            this._classWorld = new ClassWorld();
            this._classWorld.newRealm(DEFAULT_PLUGIN_NAME);
            this._classWorld.newRealm(PINOT_REALMID, ClassLoader.getSystemClassLoader());
        }
        catch (DuplicateRealmException e) {
            throw new RuntimeException(e);
        }
        this.init();
    }

    public synchronized void init() {
        if (this._initialized) {
            return;
        }
        try {
            this._pluginsDirectories = System.getProperty(PLUGINS_DIR_PROPERTY_NAME);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load system property {}", (Object)PLUGINS_DIR_PROPERTY_NAME, (Object)e);
            this._pluginsDirectories = null;
        }
        try {
            this._pluginsInclude = System.getProperty(PLUGINS_INCLUDE_PROPERTY_NAME);
        }
        catch (Exception e) {
            LOGGER.error("Failed to load system property {}", (Object)PLUGINS_INCLUDE_PROPERTY_NAME, (Object)e);
            this._pluginsInclude = null;
        }
        this.init(this._pluginsDirectories, this._pluginsInclude);
        this._initialized = true;
    }

    private void init(String pluginsDirectories, String pluginsInclude) {
        if (StringUtils.isEmpty((CharSequence)pluginsDirectories)) {
            LOGGER.info("System property '{}' is not specified. Set this system property via the JVM arguments to load additional plugins.", (Object)PLUGINS_DIR_PROPERTY_NAME);
        } else {
            try {
                HashMap<String, File> plugins = this.getPluginsToLoad(pluginsDirectories, pluginsInclude);
                LOGGER.info("#getPluginsToLoad has produced {} plugins to load", (Object)plugins.size());
                for (Map.Entry<String, File> entry : plugins.entrySet()) {
                    String pluginName = entry.getKey();
                    File pluginDir = entry.getValue();
                    try {
                        this.load(pluginName, pluginDir);
                        LOGGER.info("Successfully Loaded plugin [{}] from dir [{}]", (Object)pluginName, (Object)pluginDir);
                    }
                    catch (Exception e) {
                        LOGGER.error("Failed to load plugin [{}] from dir [{}]", new Object[]{pluginName, pluginDir, e});
                    }
                }
                this.initRecordReaderClassMap();
            }
            catch (IllegalArgumentException e) {
                LOGGER.warn(e.getMessage());
            }
        }
    }

    @VisibleForTesting
    public HashMap<String, File> getPluginsToLoad(String pluginsDirectories, String pluginsInclude) throws IllegalArgumentException {
        String[] directories = pluginsDirectories.split(";");
        LOGGER.info("Plugin directories: {}, parsed directories to load: '{}'", (Object)pluginsDirectories, (Object)directories);
        HashMap<String, File> finalPluginsToLoad = new HashMap<String, File>();
        for (String pluginsDirectory : directories) {
            if (!new File(pluginsDirectory).exists()) {
                throw new IllegalArgumentException("Plugins dir [" + pluginsDirectory + "] doesn't exist.");
            }
            Collection jarFiles = FileUtils.listFiles((File)new File(pluginsDirectory), (String[])new String[]{JAR_FILE_EXTENSION}, (boolean)true);
            List<String> pluginsToLoad = null;
            if (!StringUtils.isEmpty((CharSequence)pluginsInclude)) {
                pluginsToLoad = Arrays.asList(pluginsInclude.split(";"));
                LOGGER.info("Potential plugins to load: [{}]", (Object)Arrays.toString(pluginsToLoad.toArray()));
            } else {
                LOGGER.info("Please use system property '{}' to customize plugins to load. Loading all plugins: {}", (Object)PLUGINS_INCLUDE_PROPERTY_NAME, (Object)Arrays.toString(jarFiles.toArray()));
            }
            for (File jarFile : jarFiles) {
                File pluginDir = jarFile.getParentFile();
                String pluginName = pluginDir.getName();
                LOGGER.info("Found plugin, pluginDir: {}, pluginName: {}", (Object)pluginDir, (Object)pluginName);
                if (pluginsToLoad != null && !pluginsToLoad.contains(pluginName)) {
                    LOGGER.info("Skipping plugin: {} is not inside pluginsToLoad {}", (Object)pluginName, pluginsToLoad);
                    continue;
                }
                if (finalPluginsToLoad.containsKey(pluginName)) continue;
                finalPluginsToLoad.put(pluginName, pluginDir);
                LOGGER.info("Added [{}] from dir [{}] to final list of plugins to load", (Object)pluginName, (Object)pluginDir);
            }
        }
        return finalPluginsToLoad;
    }

    private void initRecordReaderClassMap() {
    }

    public void load(String pluginName, File directory) {
        Path pluginPropertiesPath = directory.toPath().resolve(PINOUT_PLUGIN_PROPERTIES_FILE_NAME);
        if (Files.isRegularFile(pluginPropertiesPath, new LinkOption[0])) {
            Collection urlList;
            PinotPluginConfiguration config;
            Properties pluginProperties = new Properties();
            try (BufferedReader reader = Files.newBufferedReader(pluginPropertiesPath);){
                pluginProperties.load(reader);
                config = new PinotPluginConfiguration(pluginProperties);
            }
            catch (IOException e) {
                LOGGER.warn("Failed to load plugin properties from {}", (Object)pluginPropertiesPath, (Object)e);
                throw new UncheckedIOException(e);
            }
            ClassLoader baseClassLoader = ClassLoader.getPlatformClassLoader();
            try (Stream<Path> pluginClasspathEntries = Files.list(directory.toPath());){
                urlList = pluginClasspathEntries.map(p -> {
                    try {
                        return p.toUri().toURL();
                    }
                    catch (MalformedURLException e) {
                        throw new RuntimeException(e);
                    }
                }).collect(Collectors.toList());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            try {
                ClassRealm pluginRealm = this._classWorld.newRealm(pluginName, baseClassLoader);
                urlList.forEach(arg_0 -> ((ClassRealm)pluginRealm).addURL(arg_0));
                ClassRealm pinotRealm = this._classWorld.getClassRealm(PINOT_REALMID);
                Stream<String> importedPinotPackages = Stream.of("org.apache.pinot.spi");
                importedPinotPackages.forEach(p -> pluginRealm.importFrom((ClassLoader)pinotRealm, p));
                config.getImportsFromPerRealm().forEach((r, ifs) -> {
                    try {
                        ClassRealm cr = this._classWorld.getRealm(r);
                        ifs.forEach(i -> pluginRealm.importFrom((ClassLoader)cr, i));
                    }
                    catch (NoSuchRealmException e) {
                        LOGGER.warn("{} realm does not exist", r);
                    }
                });
                config.getParentRealmId().map(arg_0 -> ((ClassWorld)this._classWorld).getClassRealm(arg_0)).ifPresent(arg_0 -> ((ClassRealm)pluginRealm).setParentRealm(arg_0));
            }
            catch (DuplicateRealmException e) {
                throw new RuntimeException(e);
            }
            LOGGER.info("Successfully loaded plugin [{}] from jar files: {}", (Object)pluginName, (Object)Arrays.toString(urlList.toArray()));
        } else {
            LOGGER.info("Trying to load plugin [{}] from location [{}]", (Object)pluginName, (Object)directory);
            Collection jarFiles = FileUtils.listFiles((File)directory, (String[])new String[]{JAR_FILE_EXTENSION}, (boolean)true);
            ArrayList<URL> urlList = new ArrayList<URL>();
            for (File jarFile : jarFiles) {
                try {
                    urlList.add(jarFile.toURI().toURL());
                }
                catch (MalformedURLException e) {
                    LOGGER.error("Unable to load plugin [{}] jar file [{}]", new Object[]{pluginName, jarFile, e});
                }
            }
            PluginClassLoader classLoader = this.createClassLoader(urlList);
            this._registry.put(new Plugin(pluginName), classLoader);
            LOGGER.info("Successfully loaded plugin [{}] from jar files: {}", (Object)pluginName, (Object)Arrays.toString(urlList.toArray()));
        }
    }

    private PluginClassLoader createClassLoader(Collection<URL> urlList) {
        URL[] urls = new URL[urlList.size()];
        urlList.toArray(urls);
        Arrays.sort(urls, Comparator.comparing(URL::toString));
        return new PluginClassLoader(urls, this.getClass().getClassLoader());
    }

    public Class<?> loadClass(String className) throws ClassNotFoundException {
        String pluginName = DEFAULT_PLUGIN_NAME;
        String realClassName = className;
        if (className.indexOf(":") > -1) {
            String[] split = className.split("\\:");
            pluginName = split[0];
            realClassName = split[1];
        }
        return this.loadClass(pluginName, realClassName);
    }

    public Class<?> loadClass(String pluginName, String className) throws ClassNotFoundException {
        String name = PluginManager.loadClassWithBackwardCompatibleCheck(className);
        Plugin plugin = new Plugin(pluginName);
        if (this._registry.containsKey(plugin)) {
            return this._registry.get(plugin).loadClass(name, true);
        }
        try {
            return this._classWorld.getRealm(pluginName).loadClass(className);
        }
        catch (NoSuchRealmException e) {
            throw new RuntimeException(e);
        }
    }

    public static String loadClassWithBackwardCompatibleCheck(String className) {
        return PLUGINS_BACKWARD_COMPATIBLE_CLASS_NAME_MAP.getOrDefault(className, className);
    }

    public <T> T createInstance(String className) throws Exception {
        return this.createInstance(className, new Class[0], new Object[0]);
    }

    public <T> T createInstance(String className, Class[] argTypes, Object[] argValues) throws Exception {
        String pluginName = DEFAULT_PLUGIN_NAME;
        String realClassName = className;
        if (className.indexOf(":") > -1) {
            String[] split = className.split("\\:");
            pluginName = split[0];
            realClassName = split[1];
        }
        return this.createInstance(pluginName, realClassName, argTypes, argValues);
    }

    public <T> T createInstance(String pluginName, String className) throws Exception {
        return this.createInstance(pluginName, className, new Class[0], new Object[0]);
    }

    public <T> T createInstance(String pluginName, String className, Class[] argTypes, Object[] argValues) throws Exception {
        Class<?> loadedClass;
        String name = PluginManager.loadClassWithBackwardCompatibleCheck(className);
        Plugin plugin = new Plugin(pluginName);
        if (this._registry.containsKey(plugin)) {
            PluginClassLoader pluginClassLoader = this._registry.get(plugin);
            loadedClass = pluginClassLoader.loadClass(name, true);
        } else {
            loadedClass = Class.forName(name, true, (ClassLoader)this._classWorld.getRealm(pluginName));
        }
        Constructor<?> constructor = loadedClass.getConstructor(argTypes);
        Object instance = constructor.newInstance(argValues);
        return (T)instance;
    }

    public String[] getPluginsDirectories() {
        if (this._pluginsDirectories != null) {
            return this._pluginsDirectories.split(";");
        }
        return null;
    }

    public static PluginManager get() {
        return PLUGIN_MANAGER;
    }

    public String getRecordReaderClassName(String inputFormat) {
        String inputFormatKey = inputFormat.toLowerCase();
        return INPUT_FORMAT_TO_RECORD_READER_CLASS_NAME_MAP.get(inputFormatKey);
    }

    public String getRecordReaderConfigClassName(String inputFormat) {
        String inputFormatKey = inputFormat.toLowerCase();
        return INPUT_FORMAT_TO_RECORD_READER_CONFIG_CLASS_NAME_MAP.get(inputFormatKey);
    }

    public void registerRecordReaderClass(String inputFormat, String recordReaderClass, String recordReaderConfigClass) {
        if (recordReaderClass != null) {
            INPUT_FORMAT_TO_RECORD_READER_CLASS_NAME_MAP.put(inputFormat.toLowerCase(), recordReaderClass);
        }
        if (recordReaderConfigClass != null) {
            INPUT_FORMAT_TO_RECORD_READER_CONFIG_CLASS_NAME_MAP.put(inputFormat.toLowerCase(), recordReaderConfigClass);
        }
    }
}

