/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.stream;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.stream.Collectors;
import org.apache.pinot.spi.stream.PartitionGroupConsumptionStatus;
import org.apache.pinot.spi.stream.PartitionGroupMetadata;
import org.apache.pinot.spi.stream.StreamConfig;
import org.apache.pinot.spi.stream.StreamConsumerFactory;
import org.apache.pinot.spi.stream.StreamConsumerFactoryProvider;
import org.apache.pinot.spi.stream.StreamMetadataProvider;
import org.apache.pinot.spi.stream.TransientConsumerException;
import org.apache.pinot.spi.utils.IngestionConfigUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionGroupMetadataFetcher
implements Callable<Boolean> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionGroupMetadataFetcher.class);
    private final List<PartitionGroupMetadata> _newPartitionGroupMetadataList;
    private final List<StreamConfig> _streamConfigs;
    private final List<PartitionGroupConsumptionStatus> _partitionGroupConsumptionStatusList;
    private Exception _exception;
    private final List<String> _topicNames;

    public PartitionGroupMetadataFetcher(List<StreamConfig> streamConfigs, List<PartitionGroupConsumptionStatus> partitionGroupConsumptionStatusList) {
        this._topicNames = streamConfigs.stream().map(StreamConfig::getTopicName).collect(Collectors.toList());
        this._streamConfigs = streamConfigs;
        this._partitionGroupConsumptionStatusList = partitionGroupConsumptionStatusList;
        this._newPartitionGroupMetadataList = new ArrayList<PartitionGroupMetadata>();
    }

    public List<PartitionGroupMetadata> getPartitionGroupMetadataList() {
        return this._newPartitionGroupMetadataList;
    }

    public Exception getException() {
        return this._exception;
    }

    @Override
    public Boolean call() throws Exception {
        this._newPartitionGroupMetadataList.clear();
        for (int i = 0; i < this._streamConfigs.size(); ++i) {
            String clientId = PartitionGroupMetadataFetcher.class.getSimpleName() + "-" + this._streamConfigs.get(i).getTableNameWithType() + "-" + this._topicNames.get(i);
            StreamConsumerFactory streamConsumerFactory = StreamConsumerFactoryProvider.create(this._streamConfigs.get(i));
            int index = i;
            List<PartitionGroupConsumptionStatus> topicPartitionGroupConsumptionStatusList = this._partitionGroupConsumptionStatusList.stream().filter(partitionGroupConsumptionStatus -> IngestionConfigUtils.getStreamConfigIndexFromPinotPartitionId(partitionGroupConsumptionStatus.getPartitionGroupId()) == index).collect(Collectors.toList());
            try (StreamMetadataProvider streamMetadataProvider = streamConsumerFactory.createStreamMetadataProvider(clientId);){
                this._newPartitionGroupMetadataList.addAll(streamMetadataProvider.computePartitionGroupMetadata(clientId, this._streamConfigs.get(i), topicPartitionGroupConsumptionStatusList, 15000).stream().map(metadata -> new PartitionGroupMetadata(IngestionConfigUtils.getPinotPartitionIdFromStreamPartitionId(metadata.getPartitionGroupId(), index), metadata.getStartOffset())).collect(Collectors.toList()));
                if (this._exception == null) continue;
                LOGGER.info("Successfully retrieved PartitionGroupMetadata for topic {}", (Object)this._topicNames.get(i));
                continue;
            }
            catch (TransientConsumerException e) {
                LOGGER.warn("Transient Exception: Could not get partition count for topic {}", (Object)this._topicNames.get(i), (Object)e);
                this._exception = e;
                return Boolean.FALSE;
            }
            catch (Exception e) {
                LOGGER.warn("Could not get partition count for topic {}", (Object)this._topicNames.get(i), (Object)e);
                this._exception = e;
                throw e;
            }
        }
        return Boolean.TRUE;
    }
}

