/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import javax.annotation.Nullable;

public class BooleanUtils {
    public static final int INTERNAL_TRUE = 1;
    public static final int INTERNAL_FALSE = 0;

    private BooleanUtils() {
    }

    public static boolean toBoolean(String booleanString) {
        return booleanString.equalsIgnoreCase("true") || booleanString.equals("1");
    }

    public static boolean toBoolean(Object booleanObject) {
        if (booleanObject == null) {
            return false;
        }
        if (booleanObject instanceof String) {
            return BooleanUtils.toBoolean((String)booleanObject);
        }
        if (booleanObject instanceof Number) {
            return ((Number)booleanObject).intValue() == 1;
        }
        if (booleanObject instanceof Boolean) {
            return (Boolean)booleanObject;
        }
        throw new IllegalArgumentException("Illegal type for boolean conversion: " + booleanObject.getClass());
    }

    public static int toInt(String booleanString) {
        return BooleanUtils.toBoolean(booleanString) ? 1 : 0;
    }

    public static int toInt(boolean booleanValue) {
        return booleanValue ? 1 : 0;
    }

    public static boolean fromNonNullInternalValue(Object value) {
        return (Integer)value == 1;
    }

    public static boolean isTrueInternalValue(@Nullable Object value) {
        return value != null && (Integer)value == 1;
    }

    public static boolean isFalseInternalValue(@Nullable Object value) {
        return value != null && (Integer)value == 0;
    }
}

