/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import com.google.common.collect.ImmutableList;
import java.io.File;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.spi.config.instance.InstanceType;
import org.apache.pinot.spi.utils.ByteArray;

public class CommonConstants {
    public static final String ENVIRONMENT_IDENTIFIER = "environment";
    public static final String INSTANCE_FAILURE_DOMAIN = "failureDomain";
    public static final String DEFAULT_FAILURE_DOMAIN = "No such domain";
    public static final String PREFIX_OF_SSL_SUBSET = "ssl";
    public static final String HTTP_PROTOCOL = "http";
    public static final String HTTPS_PROTOCOL = "https";
    public static final String KEY_OF_AUTH = "auth";
    public static final String TABLE_NAME = "tableName";
    public static final String UNKNOWN = "unknown";
    public static final String CONFIG_OF_METRICS_FACTORY_CLASS_NAME = "factory.className";
    public static final String CONFIG_OF_BROKER_EVENT_LISTENER_CLASS_NAME = "factory.className";
    public static final String CONFIG_OF_REQUEST_CONTEXT_TRACKED_HEADER_KEYS = "request.context.tracked.header.keys";
    public static final String DEFAULT_METRICS_FACTORY_CLASS_NAME = "org.apache.pinot.plugin.metrics.yammer.YammerMetricsFactory";
    public static final String DEFAULT_BROKER_EVENT_LISTENER_CLASS_NAME = "org.apache.pinot.spi.eventlistener.query.NoOpBrokerQueryEventListener";
    public static final String SWAGGER_AUTHORIZATION_KEY = "oauth";
    public static final String SWAGGER_POM_PROPERTIES_PATH = "META-INF/maven/org.webjars/swagger-ui/pom.properties";
    public static final String CONFIG_OF_SWAGGER_RESOURCES_PATH = "META-INF/resources/webjars/swagger-ui/";
    public static final String CONFIG_OF_TIMEZONE = "pinot.timezone";
    public static final String APPLICATION = "application";
    public static final String DATABASE = "database";
    public static final String DEFAULT_DATABASE = "default";
    public static final String CONFIG_OF_PINOT_INSECURE_MODE = "pinot.insecure.mode";
    public static final String DEFAULT_PINOT_INSECURE_MODE = "false";
    public static final String CONFIG_OF_EXECUTORS_FIXED_NUM_THREADS = "pinot.executors.fixed.default.numThreads";
    public static final String DEFAULT_EXECUTORS_FIXED_NUM_THREADS = "-1";
    public static final String CONFIG_OF_PINOT_TAR_COMPRESSION_CODEC_NAME = "pinot.tar.compression.codec.name";
    public static final String PINOT_QUERY_SCHEDULER_PREFIX = "pinot.query.scheduler";

    private CommonConstants() {
    }

    public static class ForwardIndexConfigs {
        public static final String CONFIG_OF_DEFAULT_RAW_INDEX_WRITER_VERSION = "pinot.forward.index.default.raw.index.writer.version";
        public static final String CONFIG_OF_DEFAULT_TARGET_MAX_CHUNK_SIZE = "pinot.forward.index.default.target.max.chunk.size";
        public static final String CONFIG_OF_DEFAULT_TARGET_DOCS_PER_CHUNK = "pinot.forward.index.default.target.docs.per.chunk";
    }

    public static class CursorConfigs {
        public static final String PREFIX_OF_CONFIG_OF_CURSOR = "pinot.broker.cursor";
        public static final String PREFIX_OF_CONFIG_OF_RESPONSE_STORE = "pinot.broker.cursor.response.store";
        public static final String DEFAULT_RESPONSE_STORE_TYPE = "file";
        public static final String RESPONSE_STORE_TYPE = "type";
        public static final int DEFAULT_CURSOR_FETCH_ROWS = 10000;
        public static final String CURSOR_FETCH_ROWS = "pinot.broker.cursor.fetch.rows";
        public static final String DEFAULT_RESULTS_EXPIRATION_INTERVAL = "1h";
        public static final String RESULTS_EXPIRATION_INTERVAL = "pinot.broker.cursor.response.store.expiration";
        public static final String RESPONSE_STORE_CLEANER_FREQUENCY_PERIOD = "controller.cluster.response.store.cleaner.frequencyPeriod";
        public static final String DEFAULT_RESPONSE_STORE_CLEANER_FREQUENCY_PERIOD = "1h";
        public static final String RESPONSE_STORE_CLEANER_INITIAL_DELAY = "controller.cluster.response.store.cleaner.initialDelay";
    }

    public static class NullValuePlaceHolder {
        public static final int INT = 0;
        public static final long LONG = 0L;
        public static final float FLOAT = 0.0f;
        public static final double DOUBLE = 0.0;
        public static final BigDecimal BIG_DECIMAL = BigDecimal.ZERO;
        public static final String STRING = "";
        public static final byte[] BYTES = new byte[0];
        public static final ByteArray INTERNAL_BYTES = new ByteArray(BYTES);
        public static final int[] INT_ARRAY = new int[0];
        public static final long[] LONG_ARRAY = new long[0];
        public static final float[] FLOAT_ARRAY = new float[0];
        public static final double[] DOUBLE_ARRAY = new double[0];
        public static final String[] STRING_ARRAY = new String[0];
        public static final byte[][] BYTES_ARRAY = new byte[0][];
        public static final Object MAP = Collections.emptyMap();
    }

    public static class MultiStageQueryRunner {
        public static final String KEY_OF_MAX_INBOUND_QUERY_DATA_BLOCK_SIZE_BYTES = "pinot.query.runner.max.msg.size.bytes";
        public static final int DEFAULT_MAX_INBOUND_QUERY_DATA_BLOCK_SIZE_BYTES = 0x1000000;
        public static final String KEY_OF_QUERY_SERVER_PORT = "pinot.query.server.port";
        public static final int DEFAULT_QUERY_SERVER_PORT = 0;
        public static final String KEY_OF_QUERY_RUNNER_HOSTNAME = "pinot.query.runner.hostname";
        public static final String KEY_OF_QUERY_RUNNER_PORT = "pinot.query.runner.port";
        public static final int DEFAULT_QUERY_RUNNER_PORT = 0;
        public static final String KEY_OF_MAX_ROWS_IN_JOIN = "pinot.query.join.max.rows";
        public static final String KEY_OF_JOIN_OVERFLOW_MODE = "pinot.query.join.overflow.mode";
        public static final String KEY_OF_MAX_ROWS_IN_WINDOW = "pinot.query.window.max.rows";
        public static final String KEY_OF_WINDOW_OVERFLOW_MODE = "pinot.query.window.overflow.mode";
        public static final String KEY_OF_MULTISTAGE_EXPLAIN_INCLUDE_SEGMENT_PLAN = "pinot.query.multistage.explain.include.segment.plan";
        public static final boolean DEFAULT_OF_MULTISTAGE_EXPLAIN_INCLUDE_SEGMENT_PLAN = false;

        public static class PlanVersions {
            public static final int V1 = 1;
        }

        public static enum WindowOverFlowMode {
            THROW,
            BREAK;

        }

        public static enum JoinOverFlowMode {
            THROW,
            BREAK;

        }
    }

    public static class RewriterConstants {
        public static final String PARENT_AGGREGATION_NAME_PREFIX = "pinotparentagg";
        public static final String CHILD_AGGREGATION_NAME_PREFIX = "pinotchildagg";
        public static final String CHILD_AGGREGATION_SEPERATOR = "@";
        public static final String CHILD_KEY_SEPERATOR = "_";
    }

    public static class IdealState {
        public static final String HYBRID_TABLE_TIME_BOUNDARY = "HYBRID_TABLE_TIME_BOUNDARY";
    }

    public static class Query {

        public static class Range {
            public static final char DELIMITER = '\u0000';
            public static final char LOWER_EXCLUSIVE = '(';
            public static final char LOWER_INCLUSIVE = '[';
            public static final char UPPER_EXCLUSIVE = ')';
            public static final char UPPER_INCLUSIVE = ']';
            public static final String UNBOUNDED = "*";
            public static final String LOWER_UNBOUNDED = "(*\u0000";
            public static final String UPPER_UNBOUNDED = "\u0000*)";
        }

        public static class OptimizationConstants {
            public static final int DEFAULT_AVG_MV_ENTRIES_DENOMINATOR = 2;
        }

        public static class Response {

            public static class ServerResponseStatus {
                public static final String STATUS_ERROR = "ERROR";
                public static final String STATUS_OK = "OK";
            }

            public static class ResponseType {
                public static final String DATA = "data";
                public static final String METADATA = "metadata";
                public static final String NON_STREAMING = "nonStreaming";
            }

            public static class MetadataKeys {
                public static final String RESPONSE_TYPE = "responseType";
            }
        }

        public static class Request {

            public static class PayloadType {
                public static final String SQL = "sql";
                public static final String BROKER_REQUEST = "brokerRequest";
            }

            public static class MetadataKeys {
                public static final String REQUEST_ID = "requestId";
                public static final String BROKER_ID = "brokerId";
                public static final String ENABLE_TRACE = "enableTrace";
                public static final String ENABLE_STREAMING = "enableStreaming";
                public static final String PAYLOAD_TYPE = "payloadType";
            }
        }
    }

    public static class Explain {

        public static class Response {

            public static class ServerResponseStatus {
                public static final String STATUS_ERROR = "ERROR";
                public static final String STATUS_OK = "OK";
            }
        }
    }

    public static class Tier {
        public static final String BACKEND_PROP_DATA_DIR = "dataDir";
    }

    public static class Segment {
        public static final String START_TIME = "segment.start.time";
        public static final String END_TIME = "segment.end.time";
        public static final String RAW_START_TIME = "segment.start.time.raw";
        public static final String RAW_END_TIME = "segment.end.time.raw";
        public static final String TIME_UNIT = "segment.time.unit";
        public static final String INDEX_VERSION = "segment.index.version";
        public static final String TOTAL_DOCS = "segment.total.docs";
        public static final String CRC = "segment.crc";
        public static final String TIER = "segment.tier";
        public static final String CREATION_TIME = "segment.creation.time";
        public static final String PUSH_TIME = "segment.push.time";
        public static final String REFRESH_TIME = "segment.refresh.time";
        public static final String DOWNLOAD_URL = "segment.download.url";
        public static final String CRYPTER_NAME = "segment.crypter";
        public static final String PARTITION_METADATA = "segment.partition.metadata";
        public static final String CUSTOM_MAP = "custom.map";
        public static final String SIZE_IN_BYTES = "segment.size.in.bytes";
        public static final String SEGMENT_UPLOAD_START_TIME = "segment.upload.start.time";
        public static final String SEGMENT_BACKUP_DIR_SUFFIX = ".segment.bak";
        public static final String SEGMENT_TEMP_DIR_SUFFIX = ".segment.tmp";
        public static final String LOCAL_SEGMENT_SCHEME = "file";
        public static final String PEER_SEGMENT_DOWNLOAD_SCHEME = "peer://";
        public static final String METADATA_URI_FOR_PEER_DOWNLOAD = "";

        public static class BuiltInVirtualColumn {
            public static final String DOCID = "$docId";
            public static final String HOSTNAME = "$hostName";
            public static final String SEGMENTNAME = "$segmentName";
        }

        public static class AssignmentStrategy {
            public static final String BALANCE_NUM_SEGMENT_ASSIGNMENT_STRATEGY = "balanced";
            public static final String REPLICA_GROUP_SEGMENT_ASSIGNMENT_STRATEGY = "replicagroup";
            public static final String DIM_TABLE_SEGMENT_ASSIGNMENT_STRATEGY = "allservers";
        }

        @Deprecated
        public static class Offline {
            public static final String DOWNLOAD_URL = "segment.offline.download.url";
            public static final String PUSH_TIME = "segment.offline.push.time";
            public static final String REFRESH_TIME = "segment.offline.refresh.time";
        }

        public static class Realtime {
            public static final String STATUS = "segment.realtime.status";
            public static final String START_OFFSET = "segment.realtime.startOffset";
            public static final String END_OFFSET = "segment.realtime.endOffset";
            public static final String NUM_REPLICAS = "segment.realtime.numReplicas";
            public static final String FLUSH_THRESHOLD_SIZE = "segment.flush.threshold.size";
            public static final String FLUSH_THRESHOLD_TIME = "segment.flush.threshold.time";
            @Deprecated
            public static final String DOWNLOAD_URL = "segment.realtime.download.url";

            public static enum CompletionMode {
                DEFAULT,
                DOWNLOAD;

            }

            public static enum Status {
                IN_PROGRESS,
                DONE,
                UPLOADED;


                public boolean isCompleted() {
                    return this != IN_PROGRESS;
                }
            }
        }
    }

    public static class ExecutorService {
        public static final String PINOT_QUERY_RUNNER_NAME_PREFIX = "pqr-";
        public static final String PINOT_QUERY_RUNNER_NAME_FORMAT = "pqr-%d";
        public static final String PINOT_QUERY_WORKER_NAME_PREFIX = "pqw-";
        public static final String PINOT_QUERY_WORKER_NAME_FORMAT = "pqw-%d";
    }

    public static class Accounting {
        public static final int ANCHOR_TASK_ID = -1;
        public static final String CONFIG_OF_FACTORY_NAME = "accounting.factory.name";
        public static final String CONFIG_OF_ENABLE_THREAD_CPU_SAMPLING = "accounting.enable.thread.cpu.sampling";
        public static final Boolean DEFAULT_ENABLE_THREAD_CPU_SAMPLING = false;
        public static final String CONFIG_OF_ENABLE_THREAD_MEMORY_SAMPLING = "accounting.enable.thread.memory.sampling";
        public static final Boolean DEFAULT_ENABLE_THREAD_MEMORY_SAMPLING = false;
        public static final String CONFIG_OF_OOM_PROTECTION_KILLING_QUERY = "accounting.oom.enable.killing.query";
        public static final boolean DEFAULT_ENABLE_OOM_PROTECTION_KILLING_QUERY = false;
        public static final String CONFIG_OF_PUBLISHING_JVM_USAGE = "accounting.publishing.jvm.heap.usage";
        public static final boolean DEFAULT_PUBLISHING_JVM_USAGE = false;
        public static final String CONFIG_OF_CPU_TIME_BASED_KILLING_ENABLED = "accounting.cpu.time.based.killing.enabled";
        public static final boolean DEFAULT_CPU_TIME_BASED_KILLING_ENABLED = false;
        public static final String CONFIG_OF_CPU_TIME_BASED_KILLING_THRESHOLD_MS = "accounting.cpu.time.based.killing.threshold.ms";
        public static final int DEFAULT_CPU_TIME_BASED_KILLING_THRESHOLD_MS = 30000;
        public static final String CONFIG_OF_PANIC_LEVEL_HEAP_USAGE_RATIO = "accounting.oom.panic.heap.usage.ratio";
        public static final float DFAULT_PANIC_LEVEL_HEAP_USAGE_RATIO = 0.99f;
        public static final String CONFIG_OF_CRITICAL_LEVEL_HEAP_USAGE_RATIO = "accounting.oom.critical.heap.usage.ratio";
        public static final float DEFAULT_CRITICAL_LEVEL_HEAP_USAGE_RATIO = 0.96f;
        public static final String CONFIG_OF_CRITICAL_LEVEL_HEAP_USAGE_RATIO_DELTA_AFTER_GC = "accounting.oom.critical.heap.usage.ratio.delta.after.gc";
        public static final float DEFAULT_CONFIG_OF_CRITICAL_LEVEL_HEAP_USAGE_RATIO_DELTA_AFTER_GC = 0.15f;
        public static final String CONFIG_OF_ALARMING_LEVEL_HEAP_USAGE_RATIO = "accounting.oom.alarming.usage.ratio";
        public static final float DEFAULT_ALARMING_LEVEL_HEAP_USAGE_RATIO = 0.75f;
        public static final String CONFIG_OF_HEAP_USAGE_PUBLISHING_PERIOD_MS = "accounting.heap.usage.publishing.period.ms";
        public static final int DEFAULT_HEAP_USAGE_PUBLISH_PERIOD = 5000;
        public static final String CONFIG_OF_SLEEP_TIME_MS = "accounting.sleep.ms";
        public static final int DEFAULT_SLEEP_TIME_MS = 30;
        public static final String CONFIG_OF_SLEEP_TIME_DENOMINATOR = "accounting.sleep.time.denominator";
        public static final int DEFAULT_SLEEP_TIME_DENOMINATOR = 3;
        public static final String CONFIG_OF_MIN_MEMORY_FOOTPRINT_TO_KILL_RATIO = "accounting.min.memory.footprint.to.kill.ratio";
        public static final double DEFAULT_MEMORY_FOOTPRINT_TO_KILL_RATIO = 0.025;
        public static final String CONFIG_OF_GC_BACKOFF_COUNT = "accounting.gc.backoff.count";
        public static final int DEFAULT_GC_BACKOFF_COUNT = 5;
        public static final String CONFIG_OF_INSTANCE_TYPE = "accounting.instance.type";
        public static final InstanceType DEFAULT_CONFIG_OF_INSTANCE_TYPE = InstanceType.SERVER;
        public static final String CONFIG_OF_GC_WAIT_TIME_MS = "accounting.gc.wait.time.ms";
        public static final int DEFAULT_CONFIG_OF_GC_WAIT_TIME_MS = 0;
        public static final String CONFIG_OF_QUERY_KILLED_METRIC_ENABLED = "accounting.query.killed.metric.enabled";
        public static final boolean DEFAULT_QUERY_KILLED_METRIC_ENABLED = false;
        public static final String CONFIG_OF_ENABLE_THREAD_SAMPLING_MSE = "accounting.enable.thread.sampling.mse.debug";
        public static final Boolean DEFAULT_ENABLE_THREAD_SAMPLING_MSE = true;
    }

    public static class ControllerJob {
        public static final String JOB_TYPE = "jobType";
        public static final String TABLE_NAME_WITH_TYPE = "tableName";
        public static final String TENANT_NAME = "tenantName";
        public static final String JOB_ID = "jobId";
        public static final String SUBMISSION_TIME_MS = "submissionTimeMs";
        public static final String MESSAGE_COUNT = "messageCount";
        public static final Integer MAXIMUM_CONTROLLER_JOBS_IN_ZK = 100;
        public static final String SEGMENT_RELOAD_JOB_SEGMENT_NAME = "segmentName";
        public static final String SEGMENT_RELOAD_JOB_INSTANCE_NAME = "instanceName";
        public static final String CONSUMING_SEGMENTS_FORCE_COMMITTED_LIST = "segmentsForceCommitted";
    }

    public static class Minion {
        public static final String CONFIG_OF_METRICS_PREFIX = "pinot.minion.";
        public static final String CONFIG_OF_MINION_ID = "pinot.minion.instance.id";
        public static final String METADATA_EVENT_OBSERVER_PREFIX = "metadata.event.notifier";
        public static final String CONFIG_OF_SWAGGER_USE_HTTPS = "pinot.minion.swagger.use.https";
        public static final String CONFIG_OF_METRICS_PREFIX_KEY = "pinot.minion.metrics.prefix";
        @Deprecated
        public static final String DEPRECATED_CONFIG_OF_METRICS_PREFIX_KEY = "metricsPrefix";
        public static final String METRICS_REGISTRY_REGISTRATION_LISTENERS_KEY = "metricsRegistryRegistrationListeners";
        public static final String METRICS_CONFIG_PREFIX = "pinot.minion.metrics";
        public static final int DEFAULT_HELIX_PORT = 9514;
        public static final String DEFAULT_INSTANCE_BASE_DIR = System.getProperty("java.io.tmpdir") + File.separator + "PinotMinion";
        public static final String DEFAULT_INSTANCE_DATA_DIR = DEFAULT_INSTANCE_BASE_DIR + File.separator + "data";
        public static final String PREFIX_OF_CONFIG_OF_PINOT_FS_FACTORY = "pinot.minion.storage.factory";
        public static final String PREFIX_OF_CONFIG_OF_SEGMENT_FETCHER_FACTORY = "pinot.minion.segment.fetcher";
        public static final String PREFIX_OF_CONFIG_OF_SEGMENT_UPLOADER = "pinot.minion.segment.uploader";
        public static final String PREFIX_OF_CONFIG_OF_PINOT_CRYPTER = "pinot.minion.crypter";
        @Deprecated
        public static final String DEPRECATED_PREFIX_OF_CONFIG_OF_PINOT_FS_FACTORY = "storage.factory";
        @Deprecated
        public static final String DEPRECATED_PREFIX_OF_CONFIG_OF_SEGMENT_FETCHER_FACTORY = "segment.fetcher";
        @Deprecated
        public static final String DEPRECATED_PREFIX_OF_CONFIG_OF_SEGMENT_UPLOADER = "segment.uploader";
        @Deprecated
        public static final String DEPRECATED_PREFIX_OF_CONFIG_OF_PINOT_CRYPTER = "crypter";
        public static final String CONFIG_TASK_AUTH_NAMESPACE = "task.auth";
        public static final String MINION_TLS_PREFIX = "pinot.minion.tls";
        public static final String CONFIG_OF_MINION_QUERY_REWRITER_CLASS_NAMES = "pinot.minion.query.rewriter.class.names";
        public static final String CONFIG_OF_LOGGER_ROOT_DIR = "pinot.minion.logger.root.dir";
        public static final String CONFIG_OF_EVENT_OBSERVER_CLEANUP_DELAY_IN_SEC = "pinot.minion.event.observer.cleanupDelayInSec";
        public static final char TASK_LIST_SEPARATOR = ',';
        public static final String CONFIG_OF_ALLOW_DOWNLOAD_FROM_SERVER = "pinot.minion.task.allow.download.from.server";
        public static final String DEFAULT_ALLOW_DOWNLOAD_FROM_SERVER = "false";
    }

    public static class Controller {
        public static final String PREFIX_OF_CONFIG_OF_SEGMENT_FETCHER_FACTORY = "pinot.controller.segment.fetcher";
        public static final String PREFIX_OF_CONFIG_OF_PINOT_FS_FACTORY = "pinot.controller.storage.factory";
        public static final String HOST_HTTP_HEADER = "Pinot-Controller-Host";
        public static final String VERSION_HTTP_HEADER = "Pinot-Controller-Version";
        public static final String SEGMENT_NAME_HTTP_HEADER = "Pinot-Segment-Name";
        public static final String TABLE_NAME_HTTP_HEADER = "Pinot-Table-Name";
        public static final String PINOT_QUERY_ERROR_CODE_HEADER = "X-Pinot-Error-Code";
        public static final String INGESTION_DESCRIPTOR = "Pinot-Ingestion-Descriptor";
        public static final String PREFIX_OF_CONFIG_OF_PINOT_CRYPTER = "pinot.controller.crypter";
        public static final String CONFIG_OF_CONTROLLER_METRICS_PREFIX = "controller.metrics.prefix";
        public static final String DEFAULT_METRICS_PREFIX = "pinot.controller.";
        public static final String CONFIG_OF_INSTANCE_ID = "pinot.controller.instance.id";
        public static final String CONFIG_OF_CONTROLLER_QUERY_REWRITER_CLASS_NAMES = "pinot.controller.query.rewriter.class.names";
        public static final String CONTROLLER_SERVICE_AUTO_DISCOVERY = "pinot.controller.service.auto.discovery";
        public static final String CONFIG_OF_LOGGER_ROOT_DIR = "pinot.controller.logger.root.dir";
        public static final String PREFIX_OF_PINOT_CONTROLLER_SEGMENT_COMPLETION = "pinot.controller.segment.completion";
    }

    public static class Server {
        public static final String INSTANCE_DATA_MANAGER_CONFIG_PREFIX = "pinot.server.instance";
        public static final String QUERY_EXECUTOR_CONFIG_PREFIX = "pinot.server.query.executor";
        public static final String METRICS_CONFIG_PREFIX = "pinot.server.metrics";
        public static final String CONFIG_OF_INSTANCE_DATA_MANAGER_CLASS = "pinot.server.instance.data.manager.class";
        public static final String DEFAULT_INSTANCE_DATA_MANAGER_CLASS = "org.apache.pinot.server.starter.helix.HelixInstanceDataManager";
        public static final String INSTANCE_ID = "id";
        public static final String CONFIG_OF_INSTANCE_ID = "pinot.server.instance.id";
        public static final String INSTANCE_DATA_DIR = "dataDir";
        public static final String CONFIG_OF_INSTANCE_DATA_DIR = "pinot.server.instance.dataDir";
        public static final String DEFAULT_INSTANCE_BASE_DIR = FileUtils.getTempDirectoryPath() + File.separator + "PinotServer";
        public static final String DEFAULT_INSTANCE_DATA_DIR = DEFAULT_INSTANCE_BASE_DIR + File.separator + "index";
        public static final String CONSUMER_DIR = "consumerDir";
        public static final String CONFIG_OF_CONSUMER_DIR = "pinot.server.instance.consumerDir";
        public static final String INSTANCE_SEGMENT_TAR_DIR = "segmentTarDir";
        public static final String CONFIG_OF_INSTANCE_SEGMENT_TAR_DIR = "pinot.server.instance.segmentTarDir";
        public static final String DEFAULT_INSTANCE_SEGMENT_TAR_DIR = DEFAULT_INSTANCE_BASE_DIR + File.separator + "segmentTar";
        public static final String CONSUMER_CLIENT_ID_SUFFIX = "consumer.client.id.suffix";
        public static final String CONFIG_OF_CONSUMER_CLIENT_ID_SUFFIX = "pinot.server.instance.consumer.client.id.suffix";
        public static final String SEGMENT_STORE_URI = "segment.store.uri";
        public static final String CONFIG_OF_SEGMENT_STORE_URI = "pinot.server.instance.segment.store.uri";
        public static final String TABLE_DATA_MANAGER_PROVIDER_CLASS = "table.data.manager.provider.class";
        public static final String CONFIG_OF_TABLE_DATA_MANAGER_PROVIDER_CLASS = "pinot.server.instance.table.data.manager.provider.class";
        public static final String DEFAULT_TABLE_DATA_MANAGER_PROVIDER_CLASS = "org.apache.pinot.core.data.manager.provider.DefaultTableDataManagerProvider";
        public static final String READ_MODE = "readMode";
        public static final String CONFIG_OF_READ_MODE = "pinot.server.instance.readMode";
        public static final String DEFAULT_READ_MODE = "mmap";
        public static final String SEGMENT_FORMAT_VERSION = "segment.format.version";
        public static final String CONFIG_OF_SEGMENT_FORMAT_VERSION = "pinot.server.instance.segment.format.version";
        public static final String REALTIME_OFFHEAP_ALLOCATION = "realtime.alloc.offheap";
        public static final String CONFIG_OF_REALTIME_OFFHEAP_ALLOCATION = "pinot.server.instance.realtime.alloc.offheap";
        public static final boolean DEFAULT_REALTIME_OFFHEAP_ALLOCATION = true;
        public static final String REALTIME_OFFHEAP_DIRECT_ALLOCATION = "realtime.alloc.offheap.direct";
        public static final String CONFIG_OF_REALTIME_OFFHEAP_DIRECT_ALLOCATION = "pinot.server.instance.realtime.alloc.offheap.direct";
        public static final boolean DEFAULT_REALTIME_OFFHEAP_DIRECT_ALLOCATION = false;
        public static final String RELOAD_CONSUMING_SEGMENT = "reload.consumingSegment";
        public static final String CONFIG_OF_RELOAD_CONSUMING_SEGMENT = "pinot.server.instance.reload.consumingSegment";
        public static final boolean DEFAULT_RELOAD_CONSUMING_SEGMENT = true;
        public static final String CONFIG_OF_QUERY_LOG_MAX_RATE = "pinot.server.query.log.maxRatePerSecond";
        @Deprecated
        public static final String DEPRECATED_CONFIG_OF_QUERY_LOG_MAX_RATE = "pinot.query.scheduler.query.log.maxRatePerSecond";
        public static final double DEFAULT_QUERY_LOG_MAX_RATE = 10000.0;
        public static final String CONFIG_OF_QUERY_LOG_DROPPED_REPORT_MAX_RATE = "pinot.server.query.log.droppedReportMaxRatePerSecond";
        public static final double DEFAULT_QUERY_LOG_DROPPED_REPORT_MAX_RATE = 1.0;
        public static final String CONFIG_OF_QUERY_EXECUTOR_CLASS = "pinot.server.query.executor.class";
        public static final String CONFIG_OF_QUERY_EXECUTOR_PRUNER_CLASS = "pinot.server.query.executor.pruner.class";
        public static final String CONFIG_OF_QUERY_EXECUTOR_PLAN_MAKER_CLASS = "pinot.server.query.executor.plan.maker.class";
        public static final String CONFIG_OF_QUERY_EXECUTOR_TIMEOUT = "pinot.server.query.executor.timeout";
        public static final String CONFIG_OF_QUERY_EXECUTOR_NUM_GROUPS_LIMIT = "pinot.server.query.executor.num.groups.limit";
        public static final String CONFIG_OF_QUERY_EXECUTOR_MAX_INITIAL_RESULT_HOLDER_CAPACITY = "pinot.server.query.executor.max.init.group.holder.capacity";
        public static final String CONFIG_OF_QUERY_EXECUTOR_MIN_INITIAL_INDEXED_TABLE_CAPACITY = "pinot.server.query.executor.min.init.indexed.table.capacity";
        public static final String CONFIG_OF_QUERY_EXECUTOR_OPCHAIN_EXECUTOR = "pinot.server.query.executor.multistage.executor";
        public static final String DEFAULT_QUERY_EXECUTOR_OPCHAIN_EXECUTOR = "cached";
        public static final String CONFIG_OF_TRANSFORM_FUNCTIONS = "pinot.server.transforms";
        public static final String CONFIG_OF_SERVER_QUERY_REWRITER_CLASS_NAMES = "pinot.server.query.rewriter.class.names";
        public static final String CONFIG_OF_SERVER_QUERY_REGEX_CLASS = "pinot.server.query.regex.class";
        public static final String DEFAULT_SERVER_QUERY_REGEX_CLASS = "JAVA_UTIL";
        public static final String CONFIG_OF_ENABLE_QUERY_CANCELLATION = "pinot.server.enable.query.cancellation";
        public static final String CONFIG_OF_NETTY_SERVER_ENABLED = "pinot.server.netty.enabled";
        public static final boolean DEFAULT_NETTY_SERVER_ENABLED = true;
        public static final String CONFIG_OF_ENABLE_GRPC_SERVER = "pinot.server.grpc.enable";
        public static final boolean DEFAULT_ENABLE_GRPC_SERVER = true;
        public static final String CONFIG_OF_GRPC_PORT = "pinot.server.grpc.port";
        public static final int DEFAULT_GRPC_PORT = 8090;
        public static final String CONFIG_OF_GRPCTLS_SERVER_ENABLED = "pinot.server.grpctls.enabled";
        public static final boolean DEFAULT_GRPCTLS_SERVER_ENABLED = false;
        public static final String CONFIG_OF_NETTYTLS_SERVER_ENABLED = "pinot.server.nettytls.enabled";
        public static final boolean DEFAULT_NETTYTLS_SERVER_ENABLED = false;
        public static final String CONFIG_OF_SWAGGER_SERVER_ENABLED = "pinot.server.swagger.enabled";
        public static final boolean DEFAULT_SWAGGER_SERVER_ENABLED = true;
        public static final String CONFIG_OF_SWAGGER_USE_HTTPS = "pinot.server.swagger.use.https";
        public static final String CONFIG_OF_ADMIN_API_PORT = "pinot.server.adminapi.port";
        public static final int DEFAULT_ADMIN_API_PORT = 8097;
        public static final String CONFIG_OF_SERVER_RESOURCE_PACKAGES = "server.restlet.api.resource.packages";
        public static final String DEFAULT_SERVER_RESOURCE_PACKAGES = "org.apache.pinot.server.api.resources";
        public static final String PREFIX_OF_CONFIG_OF_PINOT_FS_FACTORY = "pinot.server.storage.factory";
        public static final String PREFIX_OF_CONFIG_OF_PINOT_CRYPTER = "pinot.server.crypter";
        public static final String CONFIG_OF_VALUE_PRUNER_IN_PREDICATE_THRESHOLD = "pinot.server.query.executor.pruner.columnvaluesegmentpruner.inpredicate.threshold";
        public static final int DEFAULT_VALUE_PRUNER_IN_PREDICATE_THRESHOLD = 10;
        public static final String CONFIG_OF_AUTH = "auth";
        public static final String CONFIG_OF_SERVER_MIN_RESOURCE_PERCENT_FOR_START = "pinot.server.startup.minResourcePercent";
        public static final double DEFAULT_SERVER_MIN_RESOURCE_PERCENT_FOR_START = 100.0;
        public static final String CONFIG_OF_STARTUP_REALTIME_CONSUMPTION_CATCHUP_WAIT_MS = "pinot.server.starter.realtimeConsumptionCatchupWaitMs";
        public static final int DEFAULT_STARTUP_REALTIME_CONSUMPTION_CATCHUP_WAIT_MS = 0;
        public static final String CONFIG_OF_ENABLE_REALTIME_OFFSET_BASED_CONSUMPTION_STATUS_CHECKER = "pinot.server.starter.enableRealtimeOffsetBasedConsumptionStatusChecker";
        public static final boolean DEFAULT_ENABLE_REALTIME_OFFSET_BASED_CONSUMPTION_STATUS_CHECKER = false;
        public static final String CONFIG_OF_ENABLE_REALTIME_FRESHNESS_BASED_CONSUMPTION_STATUS_CHECKER = "pinot.server.starter.enableRealtimeFreshnessBasedConsumptionStatusChecker";
        public static final boolean DEFAULT_ENABLE_REALTIME_FRESHNESS_BASED_CONSUMPTION_STATUS_CHECKER = false;
        public static final String CONFIG_OF_REALTIME_FRESHNESS_IDLE_TIMEOUT_MS = "pinot.server.starter.realtimeFreshnessIdleTimeoutMs";
        public static final int DEFAULT_REALTIME_FRESHNESS_IDLE_TIMEOUT_MS = 0;
        public static final String CONFIG_OF_STARTUP_REALTIME_MIN_FRESHNESS_MS = "pinot.server.starter.realtimeMinFreshnessMs";
        public static final int DEFAULT_STARTUP_REALTIME_MIN_FRESHNESS_MS = 10000;
        public static final String CONFIG_OF_SERVER_CONSUMPTION_RATE_LIMIT = "pinot.server.consumption.rate.limit";
        public static final double DEFAULT_SERVER_CONSUMPTION_RATE_LIMIT = 0.0;
        public static final String CONFIG_OF_MMAP_DEFAULT_ADVICE = "pinot.server.mmap.advice.default";
        public static final String DEFAULT_QUERY_EXECUTOR_CLASS = "org.apache.pinot.core.query.executor.ServerQueryExecutorV1Impl";
        public static final List<String> DEFAULT_QUERY_EXECUTOR_PRUNER_CLASS = ImmutableList.of((Object)"ColumnValueSegmentPruner", (Object)"BloomFilterSegmentPruner", (Object)"SelectionQuerySegmentPruner");
        public static final String DEFAULT_QUERY_EXECUTOR_PLAN_MAKER_CLASS = "org.apache.pinot.core.plan.maker.InstancePlanMakerImplV2";
        public static final long DEFAULT_QUERY_EXECUTOR_TIMEOUT_MS = 15000L;
        public static final String PREFIX_OF_CONFIG_OF_SEGMENT_FETCHER_FACTORY = "pinot.server.segment.fetcher";
        public static final String CONFIG_OF_STARTUP_TIMEOUT_MS = "pinot.server.startup.timeoutMs";
        public static final long DEFAULT_STARTUP_TIMEOUT_MS = 600000L;
        public static final String CONFIG_OF_STARTUP_ENABLE_SERVICE_STATUS_CHECK = "pinot.server.startup.enableServiceStatusCheck";
        public static final boolean DEFAULT_STARTUP_ENABLE_SERVICE_STATUS_CHECK = true;
        public static final String CONFIG_OF_EXIT_ON_SERVICE_STATUS_CHECK_FAILURE = "pinot.server.startup.exitOnServiceStatusCheckFailure";
        public static final boolean DEFAULT_EXIT_ON_SERVICE_STATUS_CHECK_FAILURE = false;
        public static final String CONFIG_OF_STARTUP_SERVICE_STATUS_CHECK_INTERVAL_MS = "pinot.server.startup.serviceStatusCheckIntervalMs";
        public static final long DEFAULT_STARTUP_SERVICE_STATUS_CHECK_INTERVAL_MS = 10000L;
        public static final String CONFIG_OF_SHUTDOWN_TIMEOUT_MS = "pinot.server.shutdown.timeoutMs";
        public static final long DEFAULT_SHUTDOWN_TIMEOUT_MS = 600000L;
        public static final String CONFIG_OF_SHUTDOWN_ENABLE_QUERY_CHECK = "pinot.server.shutdown.enableQueryCheck";
        public static final boolean DEFAULT_SHUTDOWN_ENABLE_QUERY_CHECK = true;
        public static final String CONFIG_OF_SHUTDOWN_NO_QUERY_THRESHOLD_MS = "pinot.server.shutdown.noQueryThresholdMs";
        public static final String CONFIG_OF_SHUTDOWN_ENABLE_RESOURCE_CHECK = "pinot.server.shutdown.enableResourceCheck";
        public static final boolean DEFAULT_SHUTDOWN_ENABLE_RESOURCE_CHECK = false;
        public static final String CONFIG_OF_SHUTDOWN_RESOURCE_CHECK_INTERVAL_MS = "pinot.server.shutdown.resourceCheckIntervalMs";
        public static final long DEFAULT_SHUTDOWN_RESOURCE_CHECK_INTERVAL_MS = 10000L;
        public static final String DEFAULT_COLUMN_MIN_MAX_VALUE_GENERATOR_MODE = "ALL";
        public static final String PINOT_SERVER_METRICS_PREFIX = "pinot.server.metrics.prefix";
        public static final String SERVER_TLS_PREFIX = "pinot.server.tls";
        public static final String SERVER_NETTYTLS_PREFIX = "pinot.server.nettytls";
        public static final String SERVER_GRPCTLS_PREFIX = "pinot.server.grpctls";
        public static final String SERVER_NETTY_PREFIX = "pinot.server.netty";
        public static final String CONFIG_OF_LOGGER_ROOT_DIR = "pinot.server.logger.root.dir";
        public static final String LUCENE_MAX_REFRESH_THREADS = "pinot.server.lucene.max.refresh.threads";
        public static final int DEFAULT_LUCENE_MAX_REFRESH_THREADS = 1;
        public static final String LUCENE_MIN_REFRESH_INTERVAL_MS = "pinot.server.lucene.min.refresh.interval.ms";
        public static final int DEFAULT_LUCENE_MIN_REFRESH_INTERVAL_MS = 10;
        public static final String DEFAULT_METRICS_PREFIX = "pinot.server.";
        public static final String CONFIG_OF_ENABLE_TABLE_LEVEL_METRICS = "pinot.server.enableTableLevelMetrics";
        public static final boolean DEFAULT_ENABLE_TABLE_LEVEL_METRICS = true;
        public static final String CONFIG_OF_ALLOWED_TABLES_FOR_EMITTING_METRICS = "pinot.server.allowedTablesForEmittingMetrics";
        public static final String ACCESS_CONTROL_FACTORY_CLASS = "pinot.server.admin.access.control.factory.class";
        public static final String DEFAULT_ACCESS_CONTROL_FACTORY_CLASS = "org.apache.pinot.server.access.AllowAllAccessFactory";
        public static final String PREFIX_OF_CONFIG_OF_ACCESS_CONTROL = "pinot.server.admin.access.control";
        public static final String CONFIG_OF_ENABLE_THREAD_CPU_TIME_MEASUREMENT = "pinot.server.instance.enableThreadCpuTimeMeasurement";
        public static final String CONFIG_OF_ENABLE_THREAD_ALLOCATED_BYTES_MEASUREMENT = "pinot.server.instance.enableThreadAllocatedBytesMeasurement";
        public static final boolean DEFAULT_ENABLE_THREAD_CPU_TIME_MEASUREMENT = false;
        public static final boolean DEFAULT_THREAD_ALLOCATED_BYTES_MEASUREMENT = false;
        public static final String CONFIG_OF_CURRENT_DATA_TABLE_VERSION = "pinot.server.instance.currentDataTableVersion";
        public static final String PREFIX_OF_CONFIG_OF_ENVIRONMENT_PROVIDER_FACTORY = "pinot.server.environmentProvider.factory";
        public static final String ENVIRONMENT_PROVIDER_CLASS_NAME = "pinot.server.environmentProvider.className";

        public static class SegmentCompletionProtocol {
            public static final String PREFIX_OF_CONFIG_OF_SEGMENT_UPLOADER = "pinot.server.segment.uploader";
            @Deprecated
            public static final String CONFIG_OF_CONTROLLER_HTTPS_ENABLED = "enabled";
            @Deprecated
            public static final String CONFIG_OF_CONTROLLER_HTTPS_PORT = "controller.port";
            public static final String CONFIG_OF_SEGMENT_UPLOAD_REQUEST_TIMEOUT_MS = "upload.request.timeout.ms";
            public static final String CONFIG_OF_PROTOCOL = "protocol";
            public static final String CONFIG_OF_SEGMENT_UPLOADER_AUTH = "auth";
            public static final int DEFAULT_SEGMENT_UPLOAD_REQUEST_TIMEOUT_MS = 300000;
            public static final int DEFAULT_OTHER_REQUESTS_TIMEOUT = 10000;
        }
    }

    public static class Broker {
        public static final String ROUTING_TABLE_CONFIG_PREFIX = "pinot.broker.routing.table";
        public static final String ACCESS_CONTROL_CONFIG_PREFIX = "pinot.broker.access.control";
        public static final String METRICS_CONFIG_PREFIX = "pinot.broker.metrics";
        public static final String EVENT_LISTENER_CONFIG_PREFIX = "pinot.broker.event.listener";
        public static final String CONFIG_OF_METRICS_NAME_PREFIX = "pinot.broker.metrics.prefix";
        public static final String DEFAULT_METRICS_NAME_PREFIX = "pinot.broker.";
        public static final String CONFIG_OF_DELAY_SHUTDOWN_TIME_MS = "pinot.broker.delayShutdownTimeMs";
        public static final long DEFAULT_DELAY_SHUTDOWN_TIME_MS = 10000L;
        public static final String CONFIG_OF_ENABLE_TABLE_LEVEL_METRICS = "pinot.broker.enableTableLevelMetrics";
        public static final boolean DEFAULT_ENABLE_TABLE_LEVEL_METRICS = true;
        public static final String CONFIG_OF_ALLOWED_TABLES_FOR_EMITTING_METRICS = "pinot.broker.allowedTablesForEmittingMetrics";
        public static final String CONFIG_OF_BROKER_QUERY_REWRITER_CLASS_NAMES = "pinot.broker.query.rewriter.class.names";
        public static final String CONFIG_OF_BROKER_QUERY_RESPONSE_LIMIT = "pinot.broker.query.response.limit";
        public static final int DEFAULT_BROKER_QUERY_RESPONSE_LIMIT = Integer.MAX_VALUE;
        public static final String CONFIG_OF_BROKER_QUERY_LOG_LENGTH = "pinot.broker.query.log.length";
        public static final int DEFAULT_BROKER_QUERY_LOG_LENGTH = Integer.MAX_VALUE;
        public static final String CONFIG_OF_BROKER_QUERY_LOG_MAX_RATE_PER_SECOND = "pinot.broker.query.log.maxRatePerSecond";
        public static final String CONFIG_OF_BROKER_QUERY_ENABLE_NULL_HANDLING = "pinot.broker.query.enable.null.handling";
        public static final String CONFIG_OF_BROKER_ENABLE_QUERY_CANCELLATION = "pinot.broker.enable.query.cancellation";
        public static final double DEFAULT_BROKER_QUERY_LOG_MAX_RATE_PER_SECOND = 10000.0;
        public static final String CONFIG_OF_BROKER_TIMEOUT_MS = "pinot.broker.timeoutMs";
        public static final long DEFAULT_BROKER_TIMEOUT_MS = 10000L;
        public static final String CONFIG_OF_BROKER_ID = "pinot.broker.instance.id";
        public static final String CONFIG_OF_BROKER_INSTANCE_TAGS = "pinot.broker.instance.tags";
        public static final String CONFIG_OF_BROKER_HOSTNAME = "pinot.broker.hostname";
        public static final String CONFIG_OF_SWAGGER_USE_HTTPS = "pinot.broker.swagger.use.https";
        public static final String BROKER_RESOURCE_PACKAGES = "broker.restlet.api.resource.packages";
        public static final String DEFAULT_BROKER_RESOURCE_PACKAGES = "org.apache.pinot.broker.api.resources";
        public static final String CONFIG_OF_BROKER_MIN_RESOURCE_PERCENT_FOR_START = "pinot.broker.startup.minResourcePercent";
        public static final double DEFAULT_BROKER_MIN_RESOURCE_PERCENT_FOR_START = 100.0;
        public static final String CONFIG_OF_ENABLE_QUERY_LIMIT_OVERRIDE = "pinot.broker.enable.query.limit.override";
        public static final String CONFIG_OF_MAX_REDUCE_THREADS_PER_QUERY = "pinot.broker.max.reduce.threads.per.query";
        public static final int DEFAULT_MAX_REDUCE_THREADS_PER_QUERY = Math.max(1, Math.min(10, Runtime.getRuntime().availableProcessors() / 2));
        public static final String CONFIG_OF_ENABLE_BOUNDED_JERSEY_THREADPOOL_EXECUTOR = "pinot.broker.enable.bounded.jersey.threadpool.executor";
        public static final boolean DEFAULT_ENABLE_BOUNDED_JERSEY_THREADPOOL_EXECUTOR = false;
        public static final String CONFIG_OF_JERSEY_THREADPOOL_EXECUTOR_MAX_POOL_SIZE = "pinot.broker.jersey.threadpool.executor.max.pool.size";
        public static final int DEFAULT_JERSEY_THREADPOOL_EXECUTOR_MAX_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 2;
        public static final String CONFIG_OF_JERSEY_THREADPOOL_EXECUTOR_CORE_POOL_SIZE = "pinot.broker.jersey.threadpool.executor.core.pool.size";
        public static final int DEFAULT_JERSEY_THREADPOOL_EXECUTOR_CORE_POOL_SIZE = Runtime.getRuntime().availableProcessors() * 2;
        public static final String CONFIG_OF_JERSEY_THREADPOOL_EXECUTOR_QUEUE_SIZE = "pinot.broker.jersey.threadpool.executor.queue.size";
        public static final int DEFAULT_JERSEY_THREADPOOL_EXECUTOR_QUEUE_SIZE = Integer.MAX_VALUE;
        public static final String CONFIG_OF_BROKER_GROUPBY_TRIM_THRESHOLD = "pinot.broker.groupby.trim.threshold";
        public static final int DEFAULT_BROKER_GROUPBY_TRIM_THRESHOLD = 1000000;
        public static final String CONFIG_OF_BROKER_MIN_GROUP_TRIM_SIZE = "pinot.broker.min.group.trim.size";
        public static final int DEFAULT_BROKER_MIN_GROUP_TRIM_SIZE = 5000;
        public static final String CONFIG_OF_BROKER_MIN_INITIAL_INDEXED_TABLE_CAPACITY = "pinot.broker.min.init.indexed.table.capacity";
        public static final int DEFAULT_BROKER_MIN_INITIAL_INDEXED_TABLE_CAPACITY = 128;
        public static final String BROKER_REQUEST_HANDLER_TYPE = "pinot.broker.request.handler.type";
        public static final String NETTY_BROKER_REQUEST_HANDLER_TYPE = "netty";
        public static final String GRPC_BROKER_REQUEST_HANDLER_TYPE = "grpc";
        public static final String MULTI_STAGE_BROKER_REQUEST_HANDLER_TYPE = "multistage";
        public static final String DEFAULT_BROKER_REQUEST_HANDLER_TYPE = "netty";
        public static final String BROKER_TLS_PREFIX = "pinot.broker.tls";
        public static final String BROKER_NETTY_PREFIX = "pinot.broker.netty";
        public static final String BROKER_NETTYTLS_ENABLED = "pinot.broker.nettytls.enabled";
        public static final String BROKER_SERVICE_AUTO_DISCOVERY = "pinot.broker.service.auto.discovery";
        public static final String DISABLE_GROOVY = "pinot.broker.disable.query.groovy";
        public static final boolean DEFAULT_DISABLE_GROOVY = true;
        public static final String USE_APPROXIMATE_FUNCTION = "pinot.broker.use.approximate.function";
        public static final String CONTROLLER_URL = "pinot.broker.controller.url";
        public static final String CONFIG_OF_BROKER_REQUEST_CLIENT_IP_LOGGING = "pinot.broker.request.client.ip.logging";
        public static final boolean DEFAULT_BROKER_REQUEST_CLIENT_IP_LOGGING = false;
        public static final String CONFIG_OF_LOGGER_ROOT_DIR = "pinot.broker.logger.root.dir";
        public static final String CONFIG_OF_SWAGGER_BROKER_ENABLED = "pinot.broker.swagger.enabled";
        public static final boolean DEFAULT_SWAGGER_BROKER_ENABLED = true;
        public static final String CONFIG_OF_ENABLE_THREAD_CPU_TIME_MEASUREMENT = "pinot.broker.instance.enableThreadCpuTimeMeasurement";
        public static final String CONFIG_OF_ENABLE_THREAD_ALLOCATED_BYTES_MEASUREMENT = "pinot.broker.instance.enableThreadAllocatedBytesMeasurement";
        public static final boolean DEFAULT_ENABLE_THREAD_CPU_TIME_MEASUREMENT = false;
        public static final boolean DEFAULT_THREAD_ALLOCATED_BYTES_MEASUREMENT = false;
        public static final String CONFIG_OF_BROKER_RESULT_REWRITER_CLASS_NAMES = "pinot.broker.result.rewriter.class.names";
        public static final String CONFIG_OF_ENABLE_PARTITION_METADATA_MANAGER = "pinot.broker.enable.partition.metadata.manager";
        public static final boolean DEFAULT_ENABLE_PARTITION_METADATA_MANAGER = true;
        public static final String CONFIG_OF_INFER_PARTITION_HINT = "pinot.broker.multistage.infer.partition.hint";
        public static final boolean DEFAULT_INFER_PARTITION_HINT = false;
        public static final String CONFIG_OF_SPOOLS = "pinot.broker.multistage.spools";
        public static final boolean DEFAULT_OF_SPOOLS = false;
        public static final String CONFIG_OF_USE_FIXED_REPLICA = "pinot.broker.use.fixed.replica";
        public static final boolean DEFAULT_USE_FIXED_REPLICA = false;
        public static final String CONFIG_OF_MAX_QUERY_RESPONSE_SIZE_BYTES = "pinot.broker.max.query.response.size.bytes";
        public static final String CONFIG_OF_MAX_SERVER_RESPONSE_SIZE_BYTES = "pinot.broker.max.server.response.size.bytes";
        public static final String CONFIG_OF_NEW_SEGMENT_EXPIRATION_SECONDS = "pinot.broker.new.segment.expiration.seconds";
        public static final long DEFAULT_VALUE_OF_NEW_SEGMENT_EXPIRATION_SECONDS = TimeUnit.MINUTES.toSeconds(5L);
        public static final String CONFIG_OF_BROKER_ENABLE_MULTISTAGE_MIGRATION_METRIC = "pinot.broker.enable.multistage.migration.metric";
        public static final boolean DEFAULT_ENABLE_MULTISTAGE_MIGRATION_METRIC = false;
        public static final String PREFIX_OF_CONFIG_OF_PINOT_FS_FACTORY = "pinot.broker.storage.factory";

        public static class AdaptiveServerSelector {
            private static final String CONFIG_PREFIX = "pinot.broker.adaptive.server.selector";
            public static final String CONFIG_OF_TYPE = "pinot.broker.adaptive.server.selector.type";
            public static final String DEFAULT_TYPE = Type.NO_OP.name();
            public static final String CONFIG_OF_ENABLE_STATS_COLLECTION = "pinot.broker.adaptive.server.selector.enable.stats.collection";
            public static final boolean DEFAULT_ENABLE_STATS_COLLECTION = false;
            public static final String CONFIG_OF_EWMA_ALPHA = "pinot.broker.adaptive.server.selector.ewma.alpha";
            public static final double DEFAULT_EWMA_ALPHA = 0.666;
            public static final String CONFIG_OF_AUTODECAY_WINDOW_MS = "pinot.broker.adaptive.server.selector.autodecay.window.ms";
            public static final long DEFAULT_AUTODECAY_WINDOW_MS = 10000L;
            public static final String CONFIG_OF_WARMUP_DURATION_MS = "pinot.broker.adaptive.server.selector.warmup.duration";
            public static final long DEFAULT_WARMUP_DURATION_MS = 0L;
            public static final String CONFIG_OF_AVG_INITIALIZATION_VAL = "pinot.broker.adaptive.server.selector.avg.initialization.val";
            public static final double DEFAULT_AVG_INITIALIZATION_VAL = 1.0;
            public static final String CONFIG_OF_HYBRID_SCORE_EXPONENT = "pinot.broker.adaptive.server.selector.hybrid.score.exponent";
            public static final int DEFAULT_HYBRID_SCORE_EXPONENT = 3;
            public static final String CONFIG_OF_STATS_MANAGER_THREADPOOL_SIZE = "pinot.broker.adaptive.server.selector.stats.manager.threadpool.size";
            public static final int DEFAULT_STATS_MANAGER_THREADPOOL_SIZE = 2;

            public static enum Type {
                NO_OP,
                NUM_INFLIGHT_REQ,
                LATENCY,
                HYBRID;

            }
        }

        public static class FailureDetector {
            public static final String CONFIG_OF_TYPE = "pinot.broker.failure.detector.type";
            public static final String DEFAULT_TYPE = Type.NO_OP.name();
            public static final String CONFIG_OF_CLASS_NAME = "pinot.broker.failure.detector.class";
            public static final String CONFIG_OF_RETRY_INITIAL_DELAY_MS = "pinot.broker.failure.detector.retry.initial.delay.ms";
            public static final long DEFAULT_RETRY_INITIAL_DELAY_MS = 5000L;
            public static final String CONFIG_OF_RETRY_DELAY_FACTOR = "pinot.broker.failure.detector.retry.delay.factor";
            public static final double DEFAULT_RETRY_DELAY_FACTOR = 2.0;
            public static final String CONFIG_OF_MAX_RETRIES = "pinot.broker.failure.detector.max.retries";
            public static final int DEFAULT_MAX_RETIRES = 10;

            public static enum Type {
                NO_OP,
                CONNECTION,
                CUSTOM;

            }
        }

        public static class Request {
            public static final String SQL = "sql";
            public static final String SQL_V1 = "sqlV1";
            public static final String SQL_V2 = "sqlV2";
            public static final String TRACE = "trace";
            public static final String QUERY_OPTIONS = "queryOptions";

            public static class QueryOptionValue {
                public static final int DEFAULT_MAX_STREAMING_PENDING_BLOCKS = 100;
            }

            public static class QueryOptionKey {
                public static final String TIMEOUT_MS = "timeoutMs";
                public static final String SKIP_UPSERT = "skipUpsert";
                public static final String SKIP_UPSERT_VIEW = "skipUpsertView";
                public static final String UPSERT_VIEW_FRESHNESS_MS = "upsertViewFreshnessMs";
                public static final String USE_STAR_TREE = "useStarTree";
                public static final String SCAN_STAR_TREE_NODES = "scanStarTreeNodes";
                public static final String ROUTING_OPTIONS = "routingOptions";
                public static final String USE_SCAN_REORDER_OPTIMIZATION = "useScanReorderOpt";
                public static final String MAX_EXECUTION_THREADS = "maxExecutionThreads";
                public static final String MIN_SEGMENT_GROUP_TRIM_SIZE = "minSegmentGroupTrimSize";
                public static final String MIN_SERVER_GROUP_TRIM_SIZE = "minServerGroupTrimSize";
                public static final String MIN_BROKER_GROUP_TRIM_SIZE = "minBrokerGroupTrimSize";
                public static final String NUM_REPLICA_GROUPS_TO_QUERY = "numReplicaGroupsToQuery";
                public static final String USE_FIXED_REPLICA = "useFixedReplica";
                public static final String EXPLAIN_PLAN_VERBOSE = "explainPlanVerbose";
                public static final String USE_MULTISTAGE_ENGINE = "useMultistageEngine";
                public static final String INFER_PARTITION_HINT = "inferPartitionHint";
                public static final String ENABLE_NULL_HANDLING = "enableNullHandling";
                public static final String APPLICATION_NAME = "applicationName";
                public static final String USE_SPOOLS = "useSpools";
                public static final String EXPLAIN_ASKING_SERVERS = "explainAskingServers";
                public static final String SERVER_RETURN_FINAL_RESULT = "serverReturnFinalResult";
                public static final String SERVER_RETURN_FINAL_RESULT_KEY_UNPARTITIONED = "serverReturnFinalResultKeyUnpartitioned";
                public static final String AND_SCAN_REORDERING = "AndScanReordering";
                public static final String SKIP_INDEXES = "skipIndexes";
                public static final String ORDER_BY_ALGORITHM = "orderByAlgorithm";
                public static final String MULTI_STAGE_LEAF_LIMIT = "multiStageLeafLimit";
                public static final String NUM_GROUPS_LIMIT = "numGroupsLimit";
                public static final String MAX_INITIAL_RESULT_HOLDER_CAPACITY = "maxInitialResultHolderCapacity";
                public static final String MIN_INITIAL_INDEXED_TABLE_CAPACITY = "minInitialIndexedTableCapacity";
                public static final String GROUP_TRIM_THRESHOLD = "groupTrimThreshold";
                public static final String STAGE_PARALLELISM = "stageParallelism";
                public static final String IN_PREDICATE_PRE_SORTED = "inPredicatePreSorted";
                public static final String IN_PREDICATE_LOOKUP_ALGORITHM = "inPredicateLookupAlgorithm";
                public static final String DROP_RESULTS = "dropResults";
                public static final String MAX_STREAMING_PENDING_BLOCKS = "maxStreamingPendingBlocks";
                public static final String MAX_ROWS_IN_JOIN = "maxRowsInJoin";
                public static final String JOIN_OVERFLOW_MODE = "joinOverflowMode";
                public static final String MAX_ROWS_IN_WINDOW = "maxRowsInWindow";
                public static final String WINDOW_OVERFLOW_MODE = "windowOverflowMode";
                public static final String MAX_SERVER_RESPONSE_SIZE_BYTES = "maxServerResponseSizeBytes";
                public static final String MAX_QUERY_RESPONSE_SIZE_BYTES = "maxQueryResponseSizeBytes";
                public static final String SKIP_UNAVAILABLE_SERVERS = "skipUnavailableServers";
                public static final String IS_SECONDARY_WORKLOAD = "isSecondaryWorkload";
                public static final String FILTERED_AGGREGATIONS_SKIP_EMPTY_GROUPS = "filteredAggregationsSkipEmptyGroups";
                public static final String OPTIMIZE_MAX_INITIAL_RESULT_HOLDER_CAPACITY = "optimizeMaxInitialResultHolderCapacity";
                public static final String GET_CURSOR = "getCursor";
                public static final String CURSOR_NUM_ROWS = "cursorNumRows";
            }
        }
    }

    public static class Helix {
        public static final String IS_SHUTDOWN_IN_PROGRESS = "shutdownInProgress";
        public static final String QUERIES_DISABLED = "queriesDisabled";
        public static final String QUERY_RATE_LIMIT_DISABLED = "queryRateLimitDisabled";
        public static final String DATABASE_MAX_QUERIES_PER_SECOND = "databaseMaxQueriesPerSecond";
        public static final String APPLICATION_MAX_QUERIES_PER_SECOND = "applicationMaxQueriesPerSecond";
        public static final String INSTANCE_CONNECTED_METRIC_NAME = "helix.connected";
        public static final String PREFIX_OF_CONTROLLER_INSTANCE = "Controller_";
        public static final String PREFIX_OF_BROKER_INSTANCE = "Broker_";
        public static final String PREFIX_OF_SERVER_INSTANCE = "Server_";
        public static final String PREFIX_OF_MINION_INSTANCE = "Minion_";
        public static final int CONTROLLER_INSTANCE_PREFIX_LENGTH = "Controller_".length();
        public static final int BROKER_INSTANCE_PREFIX_LENGTH = "Broker_".length();
        public static final int SERVER_INSTANCE_PREFIX_LENGTH = "Server_".length();
        public static final int MINION_INSTANCE_PREFIX_LENGTH = "Minion_".length();
        public static final String BROKER_RESOURCE_INSTANCE = "brokerResource";
        public static final String LEAD_CONTROLLER_RESOURCE_NAME = "leadControllerResource";
        public static final String LEAD_CONTROLLER_RESOURCE_ENABLED_KEY = "RESOURCE_ENABLED";
        public static final String ENABLE_CASE_INSENSITIVE_KEY = "enable.case.insensitive";
        public static final boolean DEFAULT_ENABLE_CASE_INSENSITIVE = true;
        public static final String DEFAULT_HYPERLOGLOG_LOG2M_KEY = "default.hyperloglog.log2m";
        public static final int DEFAULT_HYPERLOGLOG_LOG2M = 8;
        public static final int DEFAULT_HYPERLOGLOG_PLUS_P = 14;
        public static final int DEFAULT_HYPERLOGLOG_PLUS_SP = 0;
        public static final int DEFAULT_THETA_SKETCH_NOMINAL_ENTRIES = 16384;
        public static final int DEFAULT_TUPLE_SKETCH_LGK = 14;
        public static final int DEFAULT_CPC_SKETCH_LGK = 12;
        public static final int DEFAULT_ULTRALOGLOG_P = 12;
        public static final String ENABLE_DISTINCT_COUNT_BITMAP_OVERRIDE_KEY = "enable.distinct.count.bitmap.override";
        public static final int NUMBER_OF_PARTITIONS_IN_LEAD_CONTROLLER_RESOURCE = 24;
        public static final int LEAD_CONTROLLER_RESOURCE_REPLICA_COUNT = 1;
        public static final int MIN_ACTIVE_REPLICAS = 0;
        public static final String CONTROLLER_INSTANCE = "controller";
        public static final String UNTAGGED_BROKER_INSTANCE = "broker_untagged";
        public static final String UNTAGGED_SERVER_INSTANCE = "server_untagged";
        public static final String UNTAGGED_MINION_INSTANCE = "minion_untagged";
        public static final String SET_INSTANCE_ID_TO_HOSTNAME_KEY = "pinot.set.instance.id.to.hostname";
        public static final String KEY_OF_SERVER_NETTY_PORT = "pinot.server.netty.port";
        public static final int DEFAULT_SERVER_NETTY_PORT = 8098;
        public static final String KEY_OF_SERVER_NETTYTLS_PORT = "pinot.server.nettytls.port";
        public static final int DEFAULT_SERVER_NETTYTLS_PORT = 8091;
        public static final String KEY_OF_BROKER_QUERY_PORT = "pinot.broker.client.queryPort";
        public static final int DEFAULT_BROKER_QUERY_PORT = 8099;
        public static final String KEY_OF_SERVER_NETTY_HOST = "pinot.server.netty.host";
        public static final String KEY_OF_MINION_HOST = "pinot.minion.host";
        public static final String KEY_OF_MINION_PORT = "pinot.minion.port";
        public static final String CONFIG_OF_CONTROLLER_FLAPPING_TIME_WINDOW_MS = "pinot.controller.flapping.timeWindowMs";
        public static final String CONFIG_OF_BROKER_FLAPPING_TIME_WINDOW_MS = "pinot.broker.flapping.timeWindowMs";
        public static final String CONFIG_OF_SERVER_FLAPPING_TIME_WINDOW_MS = "pinot.server.flapping.timeWindowMs";
        public static final String CONFIG_OF_MINION_FLAPPING_TIME_WINDOW_MS = "pinot.minion.flapping.timeWindowMs";
        public static final String CONFIG_OF_HELIX_INSTANCE_MAX_STATE_TRANSITIONS = "pinot.helix.instance.state.maxStateTransitions";
        public static final String DEFAULT_HELIX_INSTANCE_MAX_STATE_TRANSITIONS = "100000";
        public static final String DEFAULT_FLAPPING_TIME_WINDOW_MS = "1";
        public static final String PINOT_SERVICE_ROLE = "pinot.service.role";
        public static final String CONFIG_OF_CLUSTER_NAME = "pinot.cluster.name";
        public static final String CONFIG_OF_ZOOKEEPR_SERVER = "pinot.zk.server";
        public static final String CONFIG_OF_PINOT_CONTROLLER_STARTABLE_CLASS = "pinot.controller.startable.class";
        public static final String CONFIG_OF_PINOT_BROKER_STARTABLE_CLASS = "pinot.broker.startable.class";
        public static final String CONFIG_OF_PINOT_SERVER_STARTABLE_CLASS = "pinot.server.startable.class";
        public static final String CONFIG_OF_PINOT_MINION_STARTABLE_CLASS = "pinot.minion.startable.class";
        public static final String CONFIG_OF_MULTI_STAGE_ENGINE_ENABLED = "pinot.multistage.engine.enabled";
        public static final boolean DEFAULT_MULTI_STAGE_ENGINE_ENABLED = true;
        public static final String CONFIG_OF_MULTI_STAGE_ENGINE_TLS_ENABLED = "pinot.multistage.engine.tls.enabled";
        public static final boolean DEFAULT_MULTI_STAGE_ENGINE_TLS_ENABLED = false;
        public static final String CONFIG_OF_MAX_CONCURRENT_MULTI_STAGE_QUERIES = "pinot.beta.multistage.engine.max.server.concurrent.queries";
        public static final String DEFAULT_MAX_CONCURRENT_MULTI_STAGE_QUERIES = "-1";

        public static class Instance {
            @Deprecated
            public static final String INSTANCE_ID_KEY = "instanceId";
            public static final String DATA_DIR_KEY = "dataDir";
            public static final String ADMIN_PORT_KEY = "adminPort";
            public static final String ADMIN_HTTPS_PORT_KEY = "adminHttpsPort";
            public static final String GRPC_PORT_KEY = "grpcPort";
            public static final String NETTY_TLS_PORT_KEY = "nettyTlsPort";
            public static final String MULTI_STAGE_QUERY_ENGINE_SERVICE_PORT_KEY = "queryServerPort";
            public static final String MULTI_STAGE_QUERY_ENGINE_MAILBOX_PORT_KEY = "queryMailboxPort";
            public static final String SYSTEM_RESOURCE_INFO_KEY = "SYSTEM_RESOURCE_INFO";
        }

        public static class DataSource {

            public static enum SegmentAssignmentStrategyType {
                RandomAssignmentStrategy,
                BalanceNumSegmentAssignmentStrategy,
                BucketizedSegmentAssignmentStrategy,
                ReplicaGroupSegmentAssignmentStrategy;

            }
        }

        public static class ZkClient {
            public static final int DEFAULT_CONNECT_TIMEOUT_MS = 60000;
            public static final int DEFAULT_SESSION_TIMEOUT_MS = 30000;
            public static final int RETRY_INTERVAL_MS = 50;
            public static final int RETRY_COUNT = 2;
            public static final String ZK_CLIENT_CONNECTION_TIMEOUT_MS_CONFIG = "zk.client.connection.timeout.ms";
            public static final String ZK_CLIENT_SESSION_TIMEOUT_MS_CONFIG = "zk.client.session.timeout.ms";
        }

        public static class StateModel {

            public static class BrokerResourceStateModel {
                public static final String ONLINE = "ONLINE";
                public static final String OFFLINE = "OFFLINE";
                public static final String ERROR = "ERROR";
            }

            public static class DisplaySegmentStatus {
                public static final String BAD = "BAD";
                public static final String GOOD = "GOOD";
                public static final String UPDATING = "UPDATING";
            }

            public static class SegmentStateModel {
                public static final String ONLINE = "ONLINE";
                public static final String OFFLINE = "OFFLINE";
                public static final String ERROR = "ERROR";
                public static final String CONSUMING = "CONSUMING";
            }
        }
    }

    public static class Table {
        public static final String PUSH_FREQUENCY_HOURLY = "hourly";
        public static final String PUSH_FREQUENCY_DAILY = "daily";
        public static final String PUSH_FREQUENCY_WEEKLY = "weekly";
        public static final String PUSH_FREQUENCY_MONTHLY = "monthly";
    }

    public static enum ConsumerState {
        CONSUMING,
        NOT_CONSUMING;

    }
}

