/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class EqualityUtils {
    private EqualityUtils() {
    }

    public static boolean isEqual(int left, int right) {
        return left == right;
    }

    public static boolean isEqual(long left, long right) {
        return left == right;
    }

    public static boolean isEqual(float left, float right) {
        return Float.floatToIntBits(left) == Float.floatToIntBits(right);
    }

    public static boolean isEqual(double left, double right) {
        return Double.doubleToLongBits(left) == Double.doubleToLongBits(right);
    }

    public static boolean isEqual(short left, short right) {
        return left == right;
    }

    public static boolean isEqual(char left, char right) {
        return left == right;
    }

    public static boolean isEqual(byte left, byte right) {
        return left == right;
    }

    public static boolean isEqual(@Nullable Object left, @Nullable Object right) {
        if (left != null && right != null) {
            if (left instanceof Set && right instanceof Set) {
                return EqualityUtils.isEqualSet((Set)left, (Set)right);
            }
            if (left instanceof Map && right instanceof Map) {
                return EqualityUtils.isEqualMap((Map)left, (Map)right);
            }
            if (left instanceof byte[] && right instanceof byte[]) {
                return Arrays.equals((byte[])left, (byte[])right);
            }
            if (left.getClass().isArray() && right.getClass().isArray()) {
                return EqualityUtils.isEqual((Object[])left, (Object[])right);
            }
            return left.equals(right);
        }
        return left == right;
    }

    public static boolean isEqual(@Nullable Object[] left, @Nullable Object[] right) {
        if (left == right) {
            return true;
        }
        if (left == null || right == null) {
            return false;
        }
        int length = left.length;
        if (right.length != length) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            Object e1 = left[i];
            Object e2 = right[i];
            if (e1 == e2) continue;
            if (e1 == null) {
                return false;
            }
            boolean eq = EqualityUtils.isEqual(e1, e2);
            if (eq) continue;
            return false;
        }
        return true;
    }

    public static boolean isEqualMap(@Nullable Map left, @Nullable Map right) {
        if (left != null && right != null) {
            if (left.size() != right.size()) {
                return false;
            }
            for (Object key : left.keySet()) {
                if (right.containsKey(key) && EqualityUtils.isEqual(left.get(key), right.get(key))) continue;
                return false;
            }
            return true;
        }
        return left == right;
    }

    public static boolean isEqualIgnoreOrder(@Nullable List left, @Nullable List right) {
        if (left != null && right != null) {
            ArrayList sortedLeft = new ArrayList(left);
            ArrayList sortedRight = new ArrayList(right);
            Collections.sort(sortedLeft);
            Collections.sort(sortedRight);
            return sortedLeft.equals(sortedRight);
        }
        return left == right;
    }

    public static boolean isEqualSet(@Nullable Set left, @Nullable Set right) {
        if (left != null && right != null) {
            if (left.size() != right.size()) {
                return false;
            }
            return right.containsAll(left);
        }
        return false;
    }

    public static boolean isNullOrNotSameClass(@Nonnull Object left, @Nullable Object right) {
        return right == null || left.getClass() != right.getClass();
    }

    public static boolean isSameReference(@Nullable Object left, @Nullable Object right) {
        return left == right;
    }

    public static int hashCodeOf(@Nullable Object o) {
        if (o != null) {
            return o.hashCode();
        }
        return 0;
    }

    public static int hashCodeOf(int previousHashCode, @Nullable Object o) {
        return 37 * previousHashCode + EqualityUtils.hashCodeOf(o);
    }

    public static int hashCodeOf(int previousHashCode, int value) {
        return 37 * previousHashCode + value;
    }

    public static int hashCodeOf(int previousHashCode, long value) {
        return 37 * previousHashCode + (int)(value ^ value >>> 32);
    }

    public static int hashCodeOf(int previousHashCode, boolean value) {
        return 37 * previousHashCode + (value ? 1 : 0);
    }
}

