/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import groovy.lang.GroovyShell;
import groovy.text.SimpleTemplateEngine;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class GroovyTemplateUtils {
    private static final GroovyShell GROOVY_SHELL = new GroovyShell();
    private static final SimpleTemplateEngine GROOVY_TEMPLATE_ENGINE = new SimpleTemplateEngine(GROOVY_SHELL);
    private static final DateTimeFormatter DATE_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd").withZone(ZoneOffset.UTC);

    private GroovyTemplateUtils() {
    }

    public static String renderTemplate(String template, Map<String, Object> newContext) throws IOException, ClassNotFoundException {
        Map<String, Object> contextMap = GroovyTemplateUtils.getDefaultContextMap();
        contextMap.putAll(newContext);
        String templateRendered = GROOVY_TEMPLATE_ENGINE.createTemplate(template).make(contextMap).toString();
        GROOVY_SHELL.resetLoadedClasses();
        return templateRendered;
    }

    public static Map<String, Object> getDefaultContextMap() {
        HashMap<String, Object> defaultContextMap = new HashMap<String, Object>();
        Instant now = Instant.now();
        defaultContextMap.put("today", DATE_FORMAT.format(now));
        defaultContextMap.put("yesterday", DATE_FORMAT.format(now.minus(1L, ChronoUnit.DAYS)));
        return defaultContextMap;
    }

    public static Map<String, Object> getTemplateContext(List<String> values) {
        if (values == null) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> context = new HashMap<String, Object>();
        for (String value : values) {
            String[] splits = value.split("=", 2);
            if (splits.length <= 1) continue;
            context.put(splits[0], splits[1]);
        }
        return context;
    }

    public static String renderTemplate(String template) throws IOException, ClassNotFoundException {
        return GroovyTemplateUtils.renderTemplate(template, Collections.emptyMap());
    }

    static {
        GROOVY_TEMPLATE_ENGINE.setEscapeBackslash(true);
    }
}

