/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapUtils.class);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private MapUtils() {
    }

    public static byte[] serializeMap(Map<String, Object> map) {
        int size = map.size();
        if (size == 0) {
            return new byte[4];
        }
        long bufferSize = (1L + 2L * (long)size) * 4L;
        byte[][] keyBytesArray = new byte[size][];
        byte[][] valueBytesArray = new byte[size][];
        int index = 0;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            byte[] keyBytes = entry.getKey().getBytes(StandardCharsets.UTF_8);
            bufferSize += (long)keyBytes.length;
            keyBytesArray[index] = keyBytes;
            byte[] valueBytes = null;
            try {
                valueBytes = OBJECT_MAPPER.writeValueAsBytes(entry.getValue());
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            bufferSize += (long)valueBytes.length;
            valueBytesArray[index++] = valueBytes;
        }
        Preconditions.checkState((bufferSize <= Integer.MAX_VALUE ? 1 : 0) != 0, (Object)"Buffer size exceeds 2GB");
        byte[] bytes = new byte[(int)bufferSize];
        ByteBuffer byteBuffer = ByteBuffer.wrap(bytes);
        byteBuffer.putInt(size);
        for (int i = 0; i < index; ++i) {
            byte[] keyBytes = keyBytesArray[i];
            byteBuffer.putInt(keyBytes.length);
            byteBuffer.put(keyBytes);
            byte[] valueBytes = valueBytesArray[i];
            byteBuffer.putInt(valueBytes.length);
            byteBuffer.put(valueBytes);
        }
        return bytes;
    }

    public static Map<String, Object> deserializeMap(byte[] bytes) {
        return MapUtils.deserializeMap(ByteBuffer.wrap(bytes));
    }

    public static Map<String, Object> deserializeMap(ByteBuffer byteBuffer) {
        Preconditions.checkNotNull((Object)byteBuffer, (Object)"ByteBuffer cannot be null");
        int size = byteBuffer.getInt();
        Preconditions.checkState((size >= 0 ? 1 : 0) != 0, (Object)"Size of the map cannot be negative");
        if (size == 0) {
            return Map.of();
        }
        Preconditions.checkState((byteBuffer.remaining() >= size * 2 * 4 ? 1 : 0) != 0, (Object)"Insufficient bytes in buffer to read all keys and values");
        HashMap<String, Object> map = new HashMap<String, Object>(size);
        for (int i = 0; i < size; ++i) {
            Preconditions.checkState((byteBuffer.remaining() >= 4 ? 1 : 0) != 0, (Object)"Insufficient bytes in buffer to read key length");
            int keyLength = byteBuffer.getInt();
            Preconditions.checkState((keyLength >= 0 ? 1 : 0) != 0, (Object)"Key length cannot be negative");
            Preconditions.checkState((byteBuffer.remaining() >= keyLength ? 1 : 0) != 0, (Object)"Insufficient bytes in buffer to read key");
            byte[] keyBytes = new byte[keyLength];
            byteBuffer.get(keyBytes);
            String key = new String(keyBytes, StandardCharsets.UTF_8);
            Preconditions.checkState((byteBuffer.remaining() >= 4 ? 1 : 0) != 0, (Object)"Insufficient bytes in buffer to read value length");
            int valueLength = byteBuffer.getInt();
            Preconditions.checkState((valueLength >= 0 ? 1 : 0) != 0, (Object)"Value length cannot be negative");
            Preconditions.checkState((byteBuffer.remaining() >= valueLength ? 1 : 0) != 0, (Object)"Insufficient bytes in buffer to read value");
            byte[] valueBytes = new byte[valueLength];
            byteBuffer.get(valueBytes);
            Object value = null;
            try {
                value = OBJECT_MAPPER.readValue(valueBytes, Object.class);
            }
            catch (IOException e) {
                LOGGER.error("Caught exception while deserializing value for key: {}", (Object)key, (Object)e);
            }
            map.put(key, value);
        }
        return map;
    }

    public static String toString(Map<String, Object> map) {
        try {
            return OBJECT_MAPPER.writeValueAsString(map);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }
}

