/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;

public class StringUtil {
    private static final String NULL_CHARACTER = "\u0000";

    private StringUtil() {
    }

    public static String join(String separator, String ... keys) {
        return StringUtils.join((Object[])keys, (String)separator);
    }

    public static String[] split(String str, char separator, int max) {
        int length = str.length();
        if (length == 0) {
            return ArrayUtils.EMPTY_STRING_ARRAY;
        }
        if (max == 1) {
            return new String[]{str};
        }
        ArrayList<String> list = new ArrayList<String>(max);
        int start = 0;
        for (int end = 0; end < length; ++end) {
            if (str.charAt(end) != separator) continue;
            list.add(str.substring(start, end));
            start = end + 1;
            if (list.size() == max - 1) break;
        }
        list.add(str.substring(start, length));
        return list.toArray(new String[0]);
    }

    public static String sanitizeStringValue(String value, int maxLength) {
        int index = value.indexOf(NULL_CHARACTER);
        if (index < 0) {
            return value.length() <= maxLength ? value : value.substring(0, maxLength);
        }
        return value.substring(0, Math.min(index, maxLength));
    }
}

