/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.pinot.spi.config.table.FieldConfig;
import org.apache.pinot.spi.config.table.IndexingConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.config.table.TimestampConfig;
import org.apache.pinot.spi.config.table.TimestampIndexGranularity;
import org.apache.pinot.spi.config.table.ingestion.IngestionConfig;
import org.apache.pinot.spi.config.table.ingestion.TransformConfig;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;

public class TimestampIndexUtils {
    private static final Set<String> VALID_GRANULARITIES = Arrays.stream(TimestampIndexGranularity.values()).map(Enum::name).collect(Collectors.toSet());
    private static final EnumMap<TimestampIndexGranularity, String> FIELD_SPEC_GRANULARITY_MAP = new EnumMap(TimestampIndexGranularity.class);

    private TimestampIndexUtils() {
    }

    public static String getColumnWithGranularity(String timestampColumn, TimestampIndexGranularity granularity) {
        return TimestampIndexUtils.getColumnWithGranularity(timestampColumn, granularity.name());
    }

    public static String getColumnWithGranularity(String timestampColumn, String granularity) {
        return "$" + timestampColumn + "$" + granularity;
    }

    public static boolean isValidGranularity(String granularity) {
        return VALID_GRANULARITIES.contains(granularity);
    }

    public static boolean isValidColumnWithGranularity(String column) {
        if (column.charAt(0) != '$') {
            return false;
        }
        int secondDollarPos = column.indexOf(36, 1);
        if (secondDollarPos < 0) {
            return false;
        }
        return VALID_GRANULARITIES.contains(column.substring(secondDollarPos + 1));
    }

    public static Set<String> extractColumnsWithGranularity(TableConfig tableConfig) {
        if (tableConfig.getFieldConfigList() == null) {
            return Collections.emptySet();
        }
        HashSet columnsWithGranularity = new HashSet();
        for (FieldConfig fieldConfig : tableConfig.getFieldConfigList()) {
            TimestampConfig timestampConfig = fieldConfig.getTimestampConfig();
            if (timestampConfig == null || CollectionUtils.isEmpty(timestampConfig.getGranularities())) continue;
            String timestampColumn = fieldConfig.getName();
            for (TimestampIndexGranularity granularity : timestampConfig.getGranularities()) {
                columnsWithGranularity.add(TimestampIndexUtils.getColumnWithGranularity(timestampColumn, granularity));
            }
        }
        return columnsWithGranularity.isEmpty() ? Collections.emptySet() : columnsWithGranularity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void applyTimestampIndex(TableConfig tableConfig, Schema schema) {
        if (tableConfig.getFieldConfigList() == null) {
            return;
        }
        HashMap<String, List<TimestampIndexGranularity>> timestampIndexConfigs = new HashMap<String, List<TimestampIndexGranularity>>();
        for (FieldConfig fieldConfig : tableConfig.getFieldConfigList()) {
            TimestampConfig timestampConfig = fieldConfig.getTimestampConfig();
            if (timestampConfig == null || CollectionUtils.isEmpty(timestampConfig.getGranularities())) continue;
            timestampIndexConfigs.put(fieldConfig.getName(), timestampConfig.getGranularities());
        }
        if (timestampIndexConfigs.isEmpty()) {
            return;
        }
        TableConfig tableConfig2 = tableConfig;
        synchronized (tableConfig2) {
            boolean tableConfigApplied;
            Map.Entry sampleEntry = timestampIndexConfigs.entrySet().iterator().next();
            String sampleTimestampColumnWithGranularity = TimestampIndexUtils.getColumnWithGranularity((String)sampleEntry.getKey(), (TimestampIndexGranularity)((Object)((List)sampleEntry.getValue()).get(0)));
            boolean schemaApplied = schema.hasColumn(sampleTimestampColumnWithGranularity);
            IndexingConfig indexingConfig = tableConfig.getIndexingConfig();
            List<String> rangeIndexColumns = indexingConfig.getRangeIndexColumns();
            boolean bl = tableConfigApplied = rangeIndexColumns != null && rangeIndexColumns.contains(sampleTimestampColumnWithGranularity);
            if (schemaApplied && tableConfigApplied) {
                return;
            }
            List<TransformConfig> transformConfigs = null;
            if (!tableConfigApplied) {
                IngestionConfig ingestionConfig;
                if (rangeIndexColumns == null) {
                    rangeIndexColumns = new ArrayList<String>();
                    indexingConfig.setRangeIndexColumns(rangeIndexColumns);
                }
                if ((ingestionConfig = tableConfig.getIngestionConfig()) == null) {
                    ingestionConfig = new IngestionConfig();
                    tableConfig.setIngestionConfig(ingestionConfig);
                }
                if ((transformConfigs = ingestionConfig.getTransformConfigs()) == null) {
                    transformConfigs = new ArrayList<TransformConfig>();
                    ingestionConfig.setTransformConfigs(transformConfigs);
                }
            }
            for (Map.Entry entry : timestampIndexConfigs.entrySet()) {
                String timestampColumn = (String)entry.getKey();
                for (TimestampIndexGranularity granularity : (List)entry.getValue()) {
                    String columnWithGranularity = TimestampIndexUtils.getColumnWithGranularity(timestampColumn, granularity);
                    if (!schemaApplied) {
                        schema.addField(TimestampIndexUtils.getFieldSpecWithGranularity(columnWithGranularity, granularity));
                    }
                    if (tableConfigApplied) continue;
                    transformConfigs.add(new TransformConfig(columnWithGranularity, TimestampIndexUtils.getTransformExpression(timestampColumn, granularity)));
                    rangeIndexColumns.add(columnWithGranularity);
                }
            }
        }
    }

    private static DateTimeFieldSpec getFieldSpecWithGranularity(String columnWithGranularity, TimestampIndexGranularity granularity) {
        return new DateTimeFieldSpec(columnWithGranularity, FieldSpec.DataType.TIMESTAMP, DateTimeFieldSpec.TimeFormat.TIMESTAMP.name(), FIELD_SPEC_GRANULARITY_MAP.get((Object)granularity));
    }

    private static String getTransformExpression(String timestampColumn, TimestampIndexGranularity granularity) {
        return "dateTrunc('" + granularity + "',\"" + timestampColumn + "\")";
    }

    static {
        FIELD_SPEC_GRANULARITY_MAP.put(TimestampIndexGranularity.MILLISECOND, "1:MILLISECONDS");
        FIELD_SPEC_GRANULARITY_MAP.put(TimestampIndexGranularity.SECOND, "1:SECONDS");
        FIELD_SPEC_GRANULARITY_MAP.put(TimestampIndexGranularity.MINUTE, "1:MINUTES");
        FIELD_SPEC_GRANULARITY_MAP.put(TimestampIndexGranularity.HOUR, "1:HOURS");
        FIELD_SPEC_GRANULARITY_MAP.put(TimestampIndexGranularity.DAY, "1:DAYS");
        FIELD_SPEC_GRANULARITY_MAP.put(TimestampIndexGranularity.WEEK, "7:DAYS");
        FIELD_SPEC_GRANULARITY_MAP.put(TimestampIndexGranularity.MONTH, "30:DAYS");
        FIELD_SPEC_GRANULARITY_MAP.put(TimestampIndexGranularity.QUARTER, "90:DAYS");
        FIELD_SPEC_GRANULARITY_MAP.put(TimestampIndexGranularity.YEAR, "365:DAYS");
    }
}

