/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.spi.utils;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;

public class TimestampUtils {
    private static final DateTimeFormatter UNIVERSAL_DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd").optionalStart().appendLiteral('T').appendPattern("HH:mm").optionalStart().appendLiteral(':').appendPattern("ss").optionalEnd().optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, true).optionalEnd().optionalEnd().optionalStart().appendLiteral(' ').appendPattern("HH:mm").optionalStart().appendLiteral(':').appendPattern("ss").optionalEnd().optionalStart().appendFraction(ChronoField.NANO_OF_SECOND, 1, 9, true).optionalEnd().optionalEnd().appendOptional(DateTimeFormatter.ofPattern("XXX")).parseDefaulting(ChronoField.HOUR_OF_DAY, 0L).parseDefaulting(ChronoField.MINUTE_OF_HOUR, 0L).parseDefaulting(ChronoField.SECOND_OF_MINUTE, 0L).toFormatter();

    private TimestampUtils() {
    }

    public static Timestamp toTimestamp(String timestampString) {
        try {
            return Timestamp.valueOf(timestampString);
        }
        catch (Exception exception) {
            try {
                return new Timestamp(Long.parseLong(timestampString));
            }
            catch (Exception exception2) {
                try {
                    return Timestamp.from(ZonedDateTime.parse(timestampString, UNIVERSAL_DATE_TIME_FORMATTER).toInstant());
                }
                catch (Exception exception3) {
                    try {
                        LocalDateTime dateTime = LocalDateTime.parse(timestampString, UNIVERSAL_DATE_TIME_FORMATTER);
                        return Timestamp.valueOf(dateTime);
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Invalid timestamp: '" + timestampString + "'");
                    }
                }
            }
        }
    }

    public static long toMillisSinceEpoch(String timestampString) {
        try {
            return Timestamp.valueOf(timestampString).getTime();
        }
        catch (Exception exception) {
            try {
                return Long.parseLong(timestampString);
            }
            catch (Exception exception2) {
                try {
                    return ZonedDateTime.parse(timestampString, UNIVERSAL_DATE_TIME_FORMATTER).toInstant().toEpochMilli();
                }
                catch (Exception exception3) {
                    try {
                        LocalDateTime dateTime = LocalDateTime.parse(timestampString, UNIVERSAL_DATE_TIME_FORMATTER);
                        return dateTime.atZone(ZoneId.systemDefault()).toInstant().toEpochMilli();
                    }
                    catch (Exception e) {
                        throw new IllegalArgumentException("Invalid timestamp: '" + timestampString + "'");
                    }
                }
            }
        }
    }
}

