/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.tsdb.spi;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.Map;

public class AggInfo {
    private final String _aggFunction;
    private final boolean _isPartial;
    private final Map<String, String> _params;

    @JsonCreator
    public AggInfo(@JsonProperty(value="aggFunction") String aggFunction, @JsonProperty(value="isPartial") boolean isPartial, @JsonProperty(value="params") Map<String, String> params) {
        Preconditions.checkNotNull((Object)aggFunction, (Object)"Received null aggFunction in AggInfo");
        this._aggFunction = aggFunction;
        this._isPartial = isPartial;
        this._params = params != null ? params : Collections.emptyMap();
    }

    public AggInfo withPartialAggregation() {
        return new AggInfo(this._aggFunction, true, this._params);
    }

    public AggInfo withFullAggregation() {
        return new AggInfo(this._aggFunction, false, this._params);
    }

    public String getAggFunction() {
        return this._aggFunction;
    }

    public boolean getIsPartial() {
        return this._isPartial;
    }

    public Map<String, String> getParams() {
        return Collections.unmodifiableMap(this._params);
    }

    public String getParam(String key) {
        return this._params.get(key);
    }
}

