/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.tsdb.spi.plan.serde;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.pinot.spi.annotations.InterfaceStability;
import org.apache.pinot.tsdb.spi.plan.BaseTimeSeriesPlanNode;

@InterfaceStability.Evolving
public class TimeSeriesPlanSerde {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();

    private TimeSeriesPlanSerde() {
    }

    public static String serialize(BaseTimeSeriesPlanNode planNode) {
        try {
            return OBJECT_MAPPER.writeValueAsString((Object)planNode);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while serializing plan", e);
        }
    }

    public static BaseTimeSeriesPlanNode deserialize(String planString) {
        try {
            JsonNode jsonNode = OBJECT_MAPPER.readTree(planString);
            return TimeSeriesPlanSerde.create(jsonNode);
        }
        catch (Exception e) {
            throw new RuntimeException("Caught exception while deserializing plan", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BaseTimeSeriesPlanNode create(JsonNode jsonNode) throws JsonProcessingException, ClassNotFoundException {
        JsonNode inputs = null;
        if (jsonNode instanceof ObjectNode) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            if (objectNode.has("inputs")) {
                inputs = objectNode.get("inputs");
                objectNode.remove("inputs");
            }
            objectNode.putIfAbsent("inputs", (JsonNode)OBJECT_MAPPER.createArrayNode());
        }
        BaseTimeSeriesPlanNode planNode = null;
        try {
            String klassName = jsonNode.get("klass").asText();
            Class<?> klass = Class.forName(klassName);
            planNode = (BaseTimeSeriesPlanNode)OBJECT_MAPPER.readValue(jsonNode.toString(), klass);
        }
        finally {
            if (planNode != null && inputs instanceof ArrayNode) {
                ArrayNode childArray = (ArrayNode)inputs;
                for (JsonNode childJsonNode : childArray) {
                    planNode.addInputNode(TimeSeriesPlanSerde.create(childJsonNode));
                }
            }
        }
        return planNode;
    }

    static {
        OBJECT_MAPPER.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
    }
}

