/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.tsdb.spi.series;

import java.util.List;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.tsdb.spi.AggInfo;
import org.apache.pinot.tsdb.spi.TimeBuckets;
import org.apache.pinot.tsdb.spi.series.BaseTimeSeriesBuilder;
import org.apache.pinot.tsdb.spi.series.TimeSeriesBuilderFactory;
import org.apache.pinot.tsdb.spi.series.builders.MaxTimeSeriesBuilder;
import org.apache.pinot.tsdb.spi.series.builders.MinTimeSeriesBuilder;
import org.apache.pinot.tsdb.spi.series.builders.SummingTimeSeriesBuilder;

public class SimpleTimeSeriesBuilderFactory
extends TimeSeriesBuilderFactory {
    private final int _maxSeriesLimit;
    private final long _maxDataPointsLimit;

    public SimpleTimeSeriesBuilderFactory() {
        this(100000, 100000000L);
    }

    public SimpleTimeSeriesBuilderFactory(int maxSeriesLimit, long maxDataPointsLimit) {
        this._maxSeriesLimit = maxSeriesLimit;
        this._maxDataPointsLimit = maxDataPointsLimit;
    }

    @Override
    public BaseTimeSeriesBuilder newTimeSeriesBuilder(AggInfo aggInfo, String id, TimeBuckets timeBuckets, List<String> tagNames, Object[] tagValues) {
        switch (aggInfo.getAggFunction().toUpperCase()) {
            case "SUM": {
                return new SummingTimeSeriesBuilder(id, timeBuckets, tagNames, tagValues);
            }
            case "MIN": {
                return new MinTimeSeriesBuilder(id, timeBuckets, tagNames, tagValues);
            }
            case "MAX": {
                return new MaxTimeSeriesBuilder(id, timeBuckets, tagNames, tagValues);
            }
        }
        throw new UnsupportedOperationException("Unsupported aggregation: " + aggInfo.getAggFunction());
    }

    @Override
    public void init(PinotConfiguration pinotConfiguration) {
    }

    @Override
    public int getMaxUniqueSeriesPerServerLimit() {
        return this._maxSeriesLimit;
    }

    @Override
    public long getMaxDataPointsPerServerLimit() {
        return this._maxDataPointsLimit;
    }
}

