/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.tsdb.spi.series;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.pinot.tsdb.spi.TimeBuckets;

public class TimeSeries {
    private final String _id;
    private final Long[] _timeValues;
    private final TimeBuckets _timeBuckets;
    private final Object[] _values;
    private final List<String> _tagNames;
    private final Object[] _tagValues;

    public TimeSeries(String id, @Nullable Long[] timeValues, @Nullable TimeBuckets timeBuckets, Object[] values, List<String> tagNames, Object[] tagValues) {
        Preconditions.checkArgument((values instanceof Double[] || values instanceof byte[][] ? 1 : 0) != 0, (Object)"Time Series can only take Double[] or byte[][] values");
        this._id = id;
        this._timeValues = timeValues;
        this._timeBuckets = timeBuckets;
        this._values = values;
        this._tagNames = Collections.unmodifiableList(tagNames);
        this._tagValues = tagValues;
    }

    public String getId() {
        return this._id;
    }

    @Nullable
    public Long[] getTimeValues() {
        return this._timeValues;
    }

    @Nullable
    public TimeBuckets getTimeBuckets() {
        return this._timeBuckets;
    }

    public Object[] getValues() {
        return this._values;
    }

    public Double[] getDoubleValues() {
        return (Double[])this._values;
    }

    public byte[][] getBytesValues() {
        return (byte[][])this._values;
    }

    public List<String> getTagNames() {
        return this._tagNames;
    }

    public Object[] getTagValues() {
        return this._tagValues;
    }

    public Map<String, String> getTagKeyValuesAsMap() {
        HashMap<String, String> result = new HashMap<String, String>();
        for (int index = 0; index < this._tagNames.size(); ++index) {
            String tagValue = this._tagValues[index] == null ? "null" : this._tagValues[index].toString();
            result.put(this._tagNames.get(index), tagValue);
        }
        return result;
    }

    public String getTagsSerialized() {
        if (this._tagNames.isEmpty()) {
            return "*";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this._tagNames.size(); ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(String.format("%s=%s", this._tagNames.get(i), this._tagValues[i]));
        }
        return sb.toString();
    }

    public static long hash(Object[] tagNamesAndValues) {
        return Objects.hash(tagNamesAndValues);
    }
}

