/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.tsdb.spi.series;

import com.google.common.annotations.VisibleForTesting;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.tsdb.spi.PinotTimeSeriesConfiguration;
import org.apache.pinot.tsdb.spi.series.TimeSeriesBuilderFactory;

public class TimeSeriesBuilderFactoryProvider {
    private static final Map<String, TimeSeriesBuilderFactory> FACTORY_MAP = new HashMap<String, TimeSeriesBuilderFactory>();

    private TimeSeriesBuilderFactoryProvider() {
    }

    public static void init(PinotConfiguration pinotConfiguration) {
        String[] languages;
        for (String language : languages = pinotConfiguration.getProperty(PinotTimeSeriesConfiguration.getEnabledLanguagesConfigKey(), "").split(",")) {
            String seriesBuilderClass = pinotConfiguration.getProperty(PinotTimeSeriesConfiguration.getSeriesBuilderFactoryConfigKey(language));
            try {
                Class<?> klass = TimeSeriesBuilderFactoryProvider.class.getClassLoader().loadClass(seriesBuilderClass);
                Object untypedSeriesBuilderFactory = klass.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (!(untypedSeriesBuilderFactory instanceof TimeSeriesBuilderFactory)) {
                    throw new RuntimeException("Series builder factory class " + seriesBuilderClass + " does not implement SeriesBuilderFactory");
                }
                TimeSeriesBuilderFactory seriesBuilderFactory = (TimeSeriesBuilderFactory)untypedSeriesBuilderFactory;
                seriesBuilderFactory.init(pinotConfiguration.subset("pinot.timeseries." + language));
                FACTORY_MAP.putIfAbsent(language, seriesBuilderFactory);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static TimeSeriesBuilderFactory getSeriesBuilderFactory(String engine) {
        return Objects.requireNonNull(FACTORY_MAP.get(engine), "No series builder factory found for engine: " + engine);
    }

    @VisibleForTesting
    public static void registerSeriesBuilderFactory(String engine, TimeSeriesBuilderFactory factory) {
        if (FACTORY_MAP.put(engine, factory) != null) {
            throw new IllegalStateException(String.format("Entry for engine=%s already exists in series builder", engine));
        }
    }
}

