/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.Accordion;
import org.apache.pivot.wtk.AccordionAttributeListener;
import org.apache.pivot.wtk.AccordionListener;
import org.apache.pivot.wtk.AccordionSelectionListener;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonGroup;
import org.apache.pivot.wtk.ButtonGroupListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentStateListener;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.effects.ClipDecorator;
import org.apache.pivot.wtk.effects.Decorator;
import org.apache.pivot.wtk.effects.Transition;
import org.apache.pivot.wtk.effects.TransitionListener;
import org.apache.pivot.wtk.effects.easing.Easing;
import org.apache.pivot.wtk.effects.easing.Quartic;
import org.apache.pivot.wtk.skin.ButtonSkin;
import org.apache.pivot.wtk.skin.ContainerSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraAccordionSkin
extends ContainerSkin
implements AccordionListener,
AccordionSelectionListener,
AccordionAttributeListener {
    private ButtonGroup panelHeaderGroup = new ButtonGroup();
    private ArrayList<PanelHeader> panelHeaders = new ArrayList();
    private Color borderColor;
    private Insets padding;
    private Font buttonFont;
    private Color buttonColor;
    private Color disabledButtonColor;
    private Color buttonBackgroundColor;
    private Insets buttonPadding;
    private int selectionChangeDuration = 250;
    private int selectionChangeRate = 30;
    private Color buttonBevelColor;
    private SelectionChangeTransition selectionChangeTransition = null;
    private ClipDecorator previousSelectedPanelClipDecorator = new ClipDecorator();
    private ClipDecorator selectedPanelClipDecorator = new ClipDecorator();
    private ComponentStateListener panelStateListener = new ComponentStateListener.Adapter(){

        public void enabledChanged(Component component) {
            Accordion accordion = (Accordion)TerraAccordionSkin.this.getComponent();
            int i = accordion.getPanels().indexOf(component);
            ((PanelHeader)((Object)TerraAccordionSkin.this.panelHeaders.get(i))).setEnabled(component.isEnabled());
        }
    };
    public static final int GRADIENT_BEVEL_THICKNESS = 4;
    private static final int DEFAULT_SELECTION_CHANGE_DURATION = 250;
    private static final int DEFAULT_SELECTION_CHANGE_RATE = 30;

    public TerraAccordionSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(theme.getColor(4));
        this.borderColor = theme.getColor(7);
        this.padding = new Insets(4);
        this.buttonFont = theme.getFont().deriveFont(1);
        this.buttonColor = theme.getColor(12);
        this.disabledButtonColor = theme.getColor(7);
        this.buttonBackgroundColor = theme.getColor(10);
        this.buttonPadding = new Insets(3, 4, 3, 4);
        this.buttonBevelColor = TerraTheme.brighten(this.buttonBackgroundColor);
        this.panelHeaderGroup.getButtonGroupListeners().add((Object)new ButtonGroupListener.Adapter(){

            public void selectionChanged(ButtonGroup buttonGroup, Button previousSelection) {
                Button button = TerraAccordionSkin.this.panelHeaderGroup.getSelection();
                int index = button == null ? -1 : TerraAccordionSkin.this.panelHeaders.indexOf((Object)((PanelHeader)button));
                Accordion accordion = (Accordion)TerraAccordionSkin.this.getComponent();
                accordion.setSelectedIndex(index);
            }
        });
    }

    public void setSize(int width, int height) {
        if (this.selectionChangeTransition != null) {
            this.selectionChangeTransition.end();
        }
        super.setSize(width, height);
    }

    public void install(Component component) {
        super.install(component);
        Accordion accordion = (Accordion)component;
        accordion.getAccordionListeners().add((Object)this);
        accordion.getAccordionSelectionListeners().add((Object)this);
        accordion.getAccordionAttributeListeners().add((Object)this);
    }

    public int getPreferredWidth(int height) {
        Accordion accordion = (Accordion)this.getComponent();
        int maxPanelHeaderWidth = 0;
        for (PanelHeader panelHeader : this.panelHeaders) {
            maxPanelHeaderWidth = Math.max(panelHeader.getPreferredWidth(), maxPanelHeaderWidth);
        }
        int maxPanelWidth = 0;
        for (Component panel : accordion.getPanels()) {
            maxPanelWidth = Math.max(panel.getPreferredWidth(), maxPanelWidth);
        }
        int preferredWidth = Math.max(maxPanelHeaderWidth, maxPanelWidth + (this.padding.left + this.padding.right + 2));
        return preferredWidth;
    }

    public int getPreferredHeight(int width) {
        Accordion accordion = (Accordion)this.getComponent();
        int preferredHeight = 0;
        for (PanelHeader panelHeader : this.panelHeaders) {
            preferredHeight += panelHeader.getPreferredHeight(width) - 1;
        }
        if (width != -1) {
            width = Math.max(0, width - (this.padding.left + this.padding.right + 2));
        }
        int maxPanelHeight = 0;
        for (Component panel : accordion.getPanels()) {
            maxPanelHeight = Math.max(maxPanelHeight, panel.getPreferredHeight(width));
        }
        return preferredHeight += maxPanelHeight + this.padding.top + this.padding.bottom + 2;
    }

    public Dimensions getPreferredSize() {
        Accordion accordion = (Accordion)this.getComponent();
        int preferredHeight = 0;
        int maxPanelHeaderWidth = 0;
        for (PanelHeader panelHeader : this.panelHeaders) {
            Dimensions preferredSize = panelHeader.getPreferredSize();
            maxPanelHeaderWidth = Math.max(preferredSize.width, maxPanelHeaderWidth);
            preferredHeight += preferredSize.height - 1;
        }
        int maxPanelWidth = 0;
        int maxPanelHeight = 0;
        for (Component panel : accordion.getPanels()) {
            Dimensions preferredSize = panel.getPreferredSize();
            maxPanelWidth = Math.max(preferredSize.width, maxPanelWidth);
            maxPanelHeight = Math.max(maxPanelHeight, preferredSize.height);
        }
        int preferredWidth = Math.max(maxPanelHeaderWidth, maxPanelWidth + (this.padding.left + this.padding.right + 2));
        return new Dimensions(preferredWidth, preferredHeight += maxPanelHeight + this.padding.top + this.padding.bottom + 2);
    }

    public int getBaseline(int width, int height) {
        int baseline = -1;
        if (this.panelHeaders.getLength() > 0) {
            PanelHeader firstPanelHeader = (PanelHeader)((Object)this.panelHeaders.get(0));
            baseline = firstPanelHeader.getBaseline(width, firstPanelHeader.getPreferredHeight(width));
        }
        return baseline;
    }

    public void layout() {
        Accordion accordion = (Accordion)this.getComponent();
        int width = this.getWidth();
        int height = this.getHeight();
        int contentWidth = Math.max(width - (this.padding.left + this.padding.right + 2), 0);
        int panelHeight = 0;
        int contentHeight = 0;
        if (this.selectionChangeTransition == null) {
            panelHeight = height;
            for (PanelHeader panelHeader : this.panelHeaders) {
                panelHeader.setSize(width, panelHeader.getPreferredHeight(width));
                panelHeight -= panelHeader.getHeight() - 1;
            }
            panelHeight = Math.max(panelHeight - 2, 0);
            contentHeight = Math.max(panelHeight - (this.padding.top + this.padding.bottom), 0);
        } else {
            panelHeight = this.selectionChangeTransition.toPanel.getHeight() + (this.padding.top + this.padding.bottom);
        }
        Accordion.PanelSequence panels = accordion.getPanels();
        int panelY = 0;
        int n = panels.getLength();
        for (int i = 0; i < n; ++i) {
            Component panel = panels.get(i);
            PanelHeader panelHeader = (PanelHeader)((Object)this.panelHeaders.get(i));
            panelHeader.setLocation(0, panelY);
            panelY += panelHeader.getHeight() - 1;
            if (this.selectionChangeTransition == null) {
                Component toPanel = accordion.getSelectedPanel();
                if (panel == toPanel) {
                    panel.setVisible(true);
                    panel.setSize(contentWidth, contentHeight);
                    panel.setLocation(this.padding.left + 1, panelY + this.padding.top + 1);
                    panelY += panelHeight + 1;
                    continue;
                }
                panel.setVisible(false);
                continue;
            }
            if (this.selectionChangeTransition.isRunning()) {
                if (panel == this.selectionChangeTransition.fromPanel) {
                    panel.setLocation(this.padding.left + 1, panelY + this.padding.top + 1);
                    int previousSelectedPanelHeight = Math.round((float)panelHeight * (1.0f - this.selectionChangeTransition.getEasedPercentComplete()));
                    this.previousSelectedPanelClipDecorator.setWidth(contentWidth);
                    this.previousSelectedPanelClipDecorator.setHeight(previousSelectedPanelHeight);
                    panelY += previousSelectedPanelHeight + 1;
                }
                if (panel != this.selectionChangeTransition.toPanel) continue;
                panel.setLocation(this.padding.left + 1, panelY + this.padding.top + 1);
                int selectedPanelHeight = Math.round((float)panelHeight * this.selectionChangeTransition.getEasedPercentComplete());
                this.selectedPanelClipDecorator.setWidth(contentWidth);
                this.selectedPanelClipDecorator.setHeight(selectedPanelHeight);
                panelY += selectedPanelHeight;
                continue;
            }
            this.selectionChangeTransition.toPanel.setSize(this.selectionChangeTransition.fromPanel.getSize());
            this.selectionChangeTransition.toPanel.setVisible(true);
        }
    }

    public void paint(Graphics2D graphics) {
        super.paint(graphics);
        int width = this.getWidth();
        int height = this.getHeight();
        graphics.setPaint(this.borderColor);
        GraphicsUtilities.drawRect((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height);
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.borderColor = borderColor;
        this.repaintComponent();
    }

    public final void setBorderColor(String borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.setBorderColor(GraphicsUtilities.decodeColor((String)borderColor));
    }

    public Insets getPadding() {
        return this.padding;
    }

    public void setPadding(Insets padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.padding = padding;
        this.invalidateComponent();
    }

    public final void setPadding(Dictionary<String, ?> padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(int padding) {
        this.setPadding(new Insets(padding));
    }

    public final void setPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(padding.intValue());
    }

    public final void setPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("padding is null.");
        }
        this.setPadding(Insets.decode((String)padding));
    }

    public Font getButtonFont() {
        return this.buttonFont;
    }

    public void setButtonFont(Font buttonFont) {
        if (buttonFont == null) {
            throw new IllegalArgumentException("buttonFont is null.");
        }
        this.buttonFont = buttonFont;
        this.invalidateComponent();
    }

    public final void setButtonFont(String buttonFont) {
        if (buttonFont == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setButtonFont(TerraAccordionSkin.decodeFont((String)buttonFont));
    }

    public final void setButtonFont(Dictionary<String, ?> buttonFont) {
        if (buttonFont == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setButtonFont(Theme.deriveFont(buttonFont));
    }

    public Color getButtonColor() {
        return this.buttonColor;
    }

    public void setButtonColor(Color buttonColor) {
        if (buttonColor == null) {
            throw new IllegalArgumentException("buttonColor is null.");
        }
        this.buttonColor = buttonColor;
        this.repaintComponent();
    }

    public final void setButtonColor(String buttonColor) {
        if (buttonColor == null) {
            throw new IllegalArgumentException("buttonColor is null.");
        }
        this.setButtonColor(GraphicsUtilities.decodeColor((String)buttonColor));
    }

    public final void setButtonColor(int buttonColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setButtonColor(theme.getColor(buttonColor));
    }

    public Color getDisabledButtonColor() {
        return this.disabledButtonColor;
    }

    public void setDisabledButtonColor(Color disabledButtonColor) {
        if (disabledButtonColor == null) {
            throw new IllegalArgumentException("disabledButtonColor is null.");
        }
        this.disabledButtonColor = disabledButtonColor;
        this.repaintComponent();
    }

    public final void setDisabledButtonColor(String disabledButtonColor) {
        if (disabledButtonColor == null) {
            throw new IllegalArgumentException("disabledButtonColor is null.");
        }
        this.setDisabledButtonColor(GraphicsUtilities.decodeColor((String)disabledButtonColor));
    }

    public final void setDisabledButtonColor(int disabledButtonColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setDisabledButtonColor(theme.getColor(disabledButtonColor));
    }

    public Color getButtonBackgroundColor() {
        return this.buttonBackgroundColor;
    }

    public void setButtonBackgroundColor(Color buttonBackgroundColor) {
        if (buttonBackgroundColor == null) {
            throw new IllegalArgumentException("buttonBackgroundColor is null.");
        }
        this.buttonBackgroundColor = buttonBackgroundColor;
        this.buttonBevelColor = TerraTheme.brighten(buttonBackgroundColor);
        this.repaintComponent();
    }

    public final void setButtonBackgroundColor(String buttonBackgroundColor) {
        if (buttonBackgroundColor == null) {
            throw new IllegalArgumentException("buttonBackgroundColor is null.");
        }
        this.setButtonBackgroundColor(GraphicsUtilities.decodeColor((String)buttonBackgroundColor));
    }

    public final void setButtonBackgroundColor(int buttonBackgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setButtonBackgroundColor(theme.getColor(buttonBackgroundColor));
    }

    public Insets getButtonPadding() {
        return this.buttonPadding;
    }

    public void setButtonPadding(Insets buttonPadding) {
        if (buttonPadding == null) {
            throw new IllegalArgumentException("buttonPadding is null.");
        }
        this.buttonPadding = buttonPadding;
        this.invalidateComponent();
    }

    public final void setButtonPadding(Dictionary<String, ?> buttonPadding) {
        if (buttonPadding == null) {
            throw new IllegalArgumentException("buttonPadding is null.");
        }
        this.setButtonPadding(new Insets(buttonPadding));
    }

    public final void setButtonPadding(int buttonPadding) {
        this.setButtonPadding(new Insets(buttonPadding));
    }

    public final void setButtonPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("buttonPadding is null.");
        }
        this.setButtonPadding(padding.intValue());
    }

    public final void setButtonPadding(String padding) {
        if (padding == null) {
            throw new IllegalArgumentException("buttonPadding is null.");
        }
        this.setButtonPadding(Insets.decode((String)padding));
    }

    public int getSelectionChangeDuration() {
        return this.selectionChangeDuration;
    }

    public void setSelectionChangeDuration(int selectionChangeDuration) {
        this.selectionChangeDuration = selectionChangeDuration;
    }

    public int getSelectionChangeRate() {
        return this.selectionChangeRate;
    }

    public void setSelectionChangeRate(int selectionChangeRate) {
        this.selectionChangeRate = selectionChangeRate;
    }

    public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = super.keyPressed(component, keyCode, keyLocation);
        if (!consumed) {
            Accordion accordion = (Accordion)this.getComponent();
            Accordion.PanelSequence panels = accordion.getPanels();
            Keyboard.Modifier commandModifier = Platform.getCommandModifier();
            if (Keyboard.isPressed((Keyboard.Modifier)commandModifier)) {
                int selectedIndex = -1;
                switch (keyCode) {
                    case 49: 
                    case 97: {
                        selectedIndex = 0;
                        break;
                    }
                    case 50: 
                    case 98: {
                        selectedIndex = 1;
                        break;
                    }
                    case 51: 
                    case 99: {
                        selectedIndex = 2;
                        break;
                    }
                    case 52: 
                    case 100: {
                        selectedIndex = 3;
                        break;
                    }
                    case 53: 
                    case 101: {
                        selectedIndex = 4;
                        break;
                    }
                    case 54: 
                    case 102: {
                        selectedIndex = 5;
                        break;
                    }
                    case 55: 
                    case 103: {
                        selectedIndex = 6;
                        break;
                    }
                    case 56: 
                    case 104: {
                        selectedIndex = 7;
                        break;
                    }
                    case 57: 
                    case 105: {
                        selectedIndex = 8;
                        break;
                    }
                }
                if (selectedIndex >= 0 && selectedIndex < panels.getLength() && panels.get(selectedIndex).isEnabled()) {
                    accordion.setSelectedIndex(selectedIndex);
                    consumed = true;
                }
            } else if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.ALT)) {
                int n = panels.getLength();
                int selectedIndex = accordion.getSelectedIndex();
                switch (keyCode) {
                    case 38: {
                        while (--selectedIndex >= 0 && !panels.get(selectedIndex).isEnabled()) {
                        }
                        break;
                    }
                    case 40: {
                        while (++selectedIndex < n && !panels.get(selectedIndex).isEnabled()) {
                        }
                        break;
                    }
                }
                if (selectedIndex >= 0 && selectedIndex < n && panels.get(selectedIndex).isEnabled()) {
                    accordion.setSelectedIndex(selectedIndex);
                    consumed = true;
                }
            }
        }
        return consumed;
    }

    public void panelInserted(Accordion accordion, int index) {
        if (this.selectionChangeTransition != null) {
            this.selectionChangeTransition.end();
        }
        Component panel = accordion.getPanels().get(index);
        PanelHeader panelHeader = new PanelHeader(panel);
        panelHeader.setButtonGroup(this.panelHeaderGroup);
        this.panelHeaders.insert((Object)panelHeader, index);
        accordion.add((Component)panelHeader);
        panelHeader.setEnabled(panel.isEnabled());
        panel.getComponentStateListeners().add((Object)this.panelStateListener);
        if (accordion.getPanels().getLength() == 1) {
            accordion.setSelectedIndex(0);
        }
        this.invalidateComponent();
    }

    public void panelsRemoved(Accordion accordion, int index, Sequence<Component> removed) {
        if (this.selectionChangeTransition != null) {
            this.selectionChangeTransition.end();
        }
        Sequence removedHeaders = this.panelHeaders.remove(index, removed.getLength());
        int n = removedHeaders.getLength();
        for (int i = 0; i < n; ++i) {
            PanelHeader panelHeader = (PanelHeader)((Object)removedHeaders.get(i));
            panelHeader.setButtonGroup(null);
            panelHeader.panel.getComponentStateListeners().remove((Object)this.panelStateListener);
            accordion.remove((Component)panelHeader);
        }
        this.invalidateComponent();
    }

    public void headerDataRendererChanged(Accordion accordion, Button.DataRenderer previousHeaderDataRenderer) {
        for (PanelHeader panelHeader : this.panelHeaders) {
            panelHeader.invalidate();
        }
    }

    public Vote previewSelectedIndexChange(final Accordion accordion, final int selectedIndex) {
        Vote vote = Vote.APPROVE;
        if (accordion.isShowing() && accordion.isValid()) {
            if (this.selectionChangeTransition == null) {
                int previousSelectedIndex = accordion.getSelectedIndex();
                if (selectedIndex != -1 && previousSelectedIndex != -1) {
                    Component fromPanel = accordion.getPanels().get(previousSelectedIndex);
                    Component toPanel = accordion.getPanels().get(selectedIndex);
                    this.selectionChangeTransition = new SelectionChangeTransition(fromPanel, toPanel);
                    this.layout();
                    this.selectionChangeTransition.start(new TransitionListener(){

                        public void transitionCompleted(Transition transition) {
                            accordion.setSelectedIndex(selectedIndex);
                            TerraAccordionSkin.this.selectionChangeTransition = null;
                            TerraAccordionSkin.this.invalidateComponent();
                        }
                    });
                    vote = Vote.DEFER;
                }
            } else if (this.selectionChangeTransition.isRunning()) {
                vote = Vote.DEFER;
            }
        }
        return vote;
    }

    public void selectedIndexChangeVetoed(Accordion accordion, Vote reason) {
        if (reason == Vote.DENY && this.selectionChangeTransition != null) {
            this.selectionChangeTransition.stop();
            this.selectionChangeTransition = null;
            this.invalidateComponent();
        }
    }

    public void selectedIndexChanged(Accordion accordion, int previousSelectedIndex) {
        int selectedIndex = accordion.getSelectedIndex();
        if (selectedIndex != previousSelectedIndex) {
            if (selectedIndex == -1) {
                Button button = this.panelHeaderGroup.getSelection();
                if (button != null) {
                    button.setSelected(false);
                }
            } else {
                Button button = (Button)this.panelHeaders.get(selectedIndex);
                button.setSelected(true);
                Component selectedPanel = accordion.getPanels().get(selectedIndex);
                selectedPanel.requestFocus();
            }
            this.invalidateComponent();
        }
    }

    public void headerDataChanged(Accordion accordion, Component component, Object previousHeaderData) {
        int i = accordion.getPanels().indexOf(component);
        ((PanelHeader)((Object)this.panelHeaders.get(i))).invalidate();
    }

    public void tooltipTextChanged(Accordion accordion, Component component, String previousTooltipText) {
    }

    public class SelectionChangeTransition
    extends Transition {
        public final Component fromPanel;
        public final Component toPanel;
        private Easing easing;

        public SelectionChangeTransition(Component fromPanel, Component toPanel) {
            super(TerraAccordionSkin.this.selectionChangeDuration, TerraAccordionSkin.this.selectionChangeRate, false);
            this.easing = new Quartic();
            this.fromPanel = fromPanel;
            this.toPanel = toPanel;
        }

        public float getEasedPercentComplete() {
            return this.easing.easeOut((float)this.getElapsedTime(), 0.0f, 1.0f, (float)this.getDuration());
        }

        public void start(TransitionListener transitionListener) {
            this.fromPanel.getDecorators().add((Decorator)TerraAccordionSkin.this.previousSelectedPanelClipDecorator);
            this.toPanel.getDecorators().add((Decorator)TerraAccordionSkin.this.selectedPanelClipDecorator);
            TerraAccordionSkin.this.getComponent().setEnabled(false);
            super.start(transitionListener);
        }

        public void stop() {
            this.fromPanel.getDecorators().remove((Decorator)TerraAccordionSkin.this.previousSelectedPanelClipDecorator);
            this.toPanel.getDecorators().remove((Decorator)TerraAccordionSkin.this.selectedPanelClipDecorator);
            TerraAccordionSkin.this.getComponent().setEnabled(true);
            super.stop();
        }

        protected void update() {
            TerraAccordionSkin.this.invalidateComponent();
        }
    }

    protected class PanelHeaderSkin
    extends ButtonSkin {
        protected PanelHeaderSkin() {
        }

        public int getPreferredWidth(int height) {
            PanelHeader panelHeader = (PanelHeader)this.getComponent();
            Button.DataRenderer dataRenderer = panelHeader.getDataRenderer();
            dataRenderer.render(panelHeader.getButtonData(), (Button)panelHeader, false);
            int preferredWidth = dataRenderer.getPreferredWidth(-1) + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.left + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.right + 2;
            return preferredWidth;
        }

        public int getPreferredHeight(int width) {
            PanelHeader panelHeader = (PanelHeader)this.getComponent();
            Button.DataRenderer dataRenderer = panelHeader.getDataRenderer();
            dataRenderer.render(panelHeader.getButtonData(), (Button)panelHeader, false);
            int contentWidth = width;
            if (contentWidth != -1) {
                contentWidth = Math.max(contentWidth - (((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.left + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.right + 2), 0);
            }
            int preferredHeight = dataRenderer.getPreferredHeight(contentWidth) + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.top + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.bottom + 2;
            return preferredHeight;
        }

        public Dimensions getPreferredSize() {
            PanelHeader panelHeader = (PanelHeader)this.getComponent();
            Button.DataRenderer dataRenderer = panelHeader.getDataRenderer();
            dataRenderer.render(panelHeader.getButtonData(), (Button)panelHeader, false);
            Dimensions preferredContentSize = dataRenderer.getPreferredSize();
            int preferredWidth = preferredContentSize.width + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.left + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.right + 2;
            int preferredHeight = preferredContentSize.height + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.top + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.bottom + 2;
            return new Dimensions(preferredWidth, preferredHeight);
        }

        public int getBaseline(int width, int height) {
            PanelHeader panelHeader = (PanelHeader)this.getComponent();
            Button.DataRenderer dataRenderer = panelHeader.getDataRenderer();
            dataRenderer.render(panelHeader.getButtonData(), (Button)panelHeader, false);
            int clientWidth = Math.max(width - (((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.left + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.right + 2), 0);
            int clientHeight = Math.max(height - (((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.top + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.bottom + 2), 0);
            int baseline = dataRenderer.getBaseline(clientWidth, clientHeight);
            if (baseline != -1) {
                baseline += ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.top + 1;
            }
            return baseline;
        }

        public void paint(Graphics2D graphics) {
            PanelHeader panelHeader = (PanelHeader)this.getComponent();
            int width = this.getWidth();
            int height = this.getHeight();
            graphics.setPaint(new GradientPaint((float)width / 2.0f, 0.0f, TerraAccordionSkin.this.buttonBevelColor, (float)width / 2.0f, height, TerraAccordionSkin.this.buttonBackgroundColor));
            graphics.fillRect(0, 0, width, height);
            graphics.setPaint(TerraAccordionSkin.this.borderColor);
            GraphicsUtilities.drawRect((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height);
            Button.DataRenderer dataRenderer = panelHeader.getDataRenderer();
            dataRenderer.render(panelHeader.getButtonData(), (Button)panelHeader, false);
            dataRenderer.setSize(Math.max(width - (((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.left + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.right + 2), 0), Math.max(this.getHeight() - (((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.top + ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.bottom + 2), 0));
            Graphics2D contentGraphics = (Graphics2D)graphics.create();
            contentGraphics.translate(((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.left + 1, ((TerraAccordionSkin)TerraAccordionSkin.this).buttonPadding.top + 1);
            contentGraphics.clipRect(0, 0, dataRenderer.getWidth(), dataRenderer.getHeight());
            dataRenderer.paint(contentGraphics);
            contentGraphics.dispose();
        }

        public boolean isFocusable() {
            return false;
        }

        public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
            PanelHeader panelHeader = (PanelHeader)this.getComponent();
            panelHeader.press();
            return true;
        }

        public Font getFont() {
            return TerraAccordionSkin.this.buttonFont;
        }

        public Color getColor() {
            return TerraAccordionSkin.this.buttonColor;
        }

        public Color getDisabledColor() {
            return TerraAccordionSkin.this.disabledButtonColor;
        }
    }

    protected class PanelHeader
    extends Button {
        private final Component panel;

        public PanelHeader(Component panel) {
            this.panel = panel;
            super.setToggleButton(true);
            this.setSkin((Skin)new PanelHeaderSkin());
        }

        public Object getButtonData() {
            return Accordion.getHeaderData((Component)this.panel);
        }

        public void setButtonData(Object buttonData) {
            throw new UnsupportedOperationException();
        }

        public Button.DataRenderer getDataRenderer() {
            Accordion accordion = (Accordion)TerraAccordionSkin.this.getComponent();
            return accordion.getHeaderDataRenderer();
        }

        public void setDataRenderer(Button.DataRenderer dataRenderer) {
            throw new UnsupportedOperationException();
        }

        public String getTooltipText() {
            return Accordion.getTooltipText((Component)this.panel);
        }

        public void setTooltipText(String tooltipText) {
            throw new UnsupportedOperationException();
        }

        public void setToggleButton(boolean toggleButton) {
            throw new UnsupportedOperationException();
        }

        public void setTriState(boolean triState) {
            throw new UnsupportedOperationException();
        }

        public void press() {
            this.setSelected(true);
            super.press();
        }
    }
}

