/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Font;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.net.URL;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.apache.pivot.beans.BXML;
import org.apache.pivot.beans.BXMLSerializer;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.collections.immutable.ImmutableList;
import org.apache.pivot.serialization.SerializationException;
import org.apache.pivot.text.FileSizeFormat;
import org.apache.pivot.util.Filter;
import org.apache.pivot.util.concurrent.AbortException;
import org.apache.pivot.util.concurrent.Task;
import org.apache.pivot.util.concurrent.TaskExecutionException;
import org.apache.pivot.util.concurrent.TaskListener;
import org.apache.pivot.wtk.ActivityIndicator;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ComponentKeyListener;
import org.apache.pivot.wtk.ComponentMouseButtonListener;
import org.apache.pivot.wtk.ComponentTooltipListener;
import org.apache.pivot.wtk.Container;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.Display;
import org.apache.pivot.wtk.FileBrowser;
import org.apache.pivot.wtk.FocusTraversalDirection;
import org.apache.pivot.wtk.FocusTraversalPolicy;
import org.apache.pivot.wtk.GridPane;
import org.apache.pivot.wtk.HorizontalAlignment;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.ListButton;
import org.apache.pivot.wtk.ListButtonSelectionListener;
import org.apache.pivot.wtk.ListView;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.Point;
import org.apache.pivot.wtk.PushButton;
import org.apache.pivot.wtk.ScrollPane;
import org.apache.pivot.wtk.SortDirection;
import org.apache.pivot.wtk.Span;
import org.apache.pivot.wtk.TableView;
import org.apache.pivot.wtk.TableViewSelectionListener;
import org.apache.pivot.wtk.TableViewSortListener;
import org.apache.pivot.wtk.TaskAdapter;
import org.apache.pivot.wtk.TextArea;
import org.apache.pivot.wtk.TextInput;
import org.apache.pivot.wtk.TextInputContentListener;
import org.apache.pivot.wtk.Tooltip;
import org.apache.pivot.wtk.VerticalAlignment;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.ContainerSkin;
import org.apache.pivot.wtk.skin.FileBrowserSkin;

public class TerraFileBrowserSkin
extends FileBrowserSkin {
    public static final File HOME_DIRECTORY = new File(System.getProperty("user.home"));
    private Component content = null;
    @BXML
    private ListButton driveListButton = null;
    @BXML
    private ListButton pathListButton = null;
    @BXML
    private PushButton goUpButton = null;
    @BXML
    private PushButton newFolderButton = null;
    @BXML
    private PushButton goHomeButton = null;
    @BXML
    private TextInput searchTextInput = null;
    @BXML
    private ScrollPane fileScrollPane = null;
    @BXML
    private TableView fileTableView = null;
    @BXML
    private ActivityIndicator indicator = null;
    @BXML
    private GridPane activityGrid = null;
    private boolean keyboardFolderTraversalEnabled = true;
    private boolean hideDisabledFiles = false;
    private boolean showHiddenFiles = false;
    private boolean updatingSelection = false;
    private boolean refreshRoots = true;
    private boolean selectingDriveFromRootDirectory = false;
    private RefreshFileListTask refreshFileListTask = null;
    private static final FileFilter HIDDEN_FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return !file.isHidden();
        }
    };
    private static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(3, 3);

    public static FileComparator getFileComparator(String columnName, SortDirection sortDirection) {
        if (columnName.equals("name")) {
            return sortDirection == SortDirection.ASCENDING ? new FileNameAscendingComparator() : new FileNameDescendingComparator();
        }
        if (columnName.equals("size")) {
            return sortDirection == SortDirection.ASCENDING ? new FileSizeAscendingComparator() : new FileSizeDescendingComparator();
        }
        if (columnName.equals("lastModified")) {
            return sortDirection == SortDirection.ASCENDING ? new FileDateAscendingComparator() : new FileDateDescendingComparator();
        }
        throw new IllegalArgumentException();
    }

    public void install(Component component) {
        super.install(component);
        final FileBrowser fileBrowser = (FileBrowser)component;
        BXMLSerializer bxmlSerializer = new BXMLSerializer();
        try {
            this.content = (Component)bxmlSerializer.readObject(TerraFileBrowserSkin.class, "terra_file_browser_skin.bxml", true);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
        catch (SerializationException exception) {
            throw new RuntimeException(exception);
        }
        fileBrowser.add(this.content);
        bxmlSerializer.bind((Object)this, TerraFileBrowserSkin.class);
        this.driveListButton.getListButtonSelectionListeners().add((Object)new ListButtonSelectionListener.Adapter(){

            public void selectedItemChanged(ListButton listButton, Object previousSelectedItem) {
                if (previousSelectedItem != null) {
                    File drive = (File)listButton.getSelectedItem();
                    if (drive != null && drive.canRead()) {
                        if (!TerraFileBrowserSkin.this.selectingDriveFromRootDirectory) {
                            fileBrowser.setRootDirectory(drive);
                        }
                    } else {
                        TerraFileBrowserSkin.this.refreshRoots = true;
                        listButton.setSelectedItem(previousSelectedItem);
                    }
                }
            }
        });
        this.pathListButton.getListButtonSelectionListeners().add((Object)new ListButtonSelectionListener.Adapter(){

            public void selectedItemChanged(ListButton listButton, Object previousSelectedItem) {
                File ancestorDirectory = (File)listButton.getSelectedItem();
                if (ancestorDirectory != null) {
                    fileBrowser.setRootDirectory(ancestorDirectory);
                }
            }
        });
        this.goUpButton.getButtonPressListeners().add((Object)new ButtonPressListener(){

            public void buttonPressed(Button button) {
                File rootDirectory = fileBrowser.getRootDirectory();
                File parentDirectory = rootDirectory.getParentFile();
                fileBrowser.setRootDirectory(parentDirectory);
            }
        });
        this.newFolderButton.getButtonPressListeners().add((Object)new ButtonPressListener(){

            public void buttonPressed(Button button) {
            }
        });
        this.goHomeButton.getButtonPressListeners().add((Object)new ButtonPressListener(){

            public void buttonPressed(Button button) {
                fileBrowser.setRootDirectory(HOME_DIRECTORY);
            }
        });
        this.searchTextInput.getComponentKeyListeners().add((Object)new ComponentKeyListener.Adapter(){

            public boolean keyPressed(Component componentArgument, int keyCode, Keyboard.KeyLocation keyLocation) {
                boolean consumed = super.keyPressed(componentArgument, keyCode, keyLocation);
                if (keyCode == 27) {
                    TerraFileBrowserSkin.this.searchTextInput.setText("");
                    consumed = true;
                } else if (keyCode == 40 && TerraFileBrowserSkin.this.fileTableView.getTableData().getLength() > 0) {
                    TerraFileBrowserSkin.this.fileTableView.setSelectedIndex(0);
                    TerraFileBrowserSkin.this.fileTableView.requestFocus();
                }
                return consumed;
            }
        });
        this.searchTextInput.getTextInputContentListeners().add((Object)new TextInputContentListener.Adapter(){

            public void textChanged(TextInput textInput) {
                TerraFileBrowserSkin.this.refreshFileList();
            }
        });
        this.fileTableView.getTableViewSelectionListeners().add((Object)new TableViewSelectionListener(){

            public void selectedRangeAdded(TableView tableView, int rangeStart, int rangeEnd) {
                if (!TerraFileBrowserSkin.this.updatingSelection) {
                    TerraFileBrowserSkin.this.updatingSelection = true;
                    for (int i = rangeStart; i <= rangeEnd; ++i) {
                        List files = TerraFileBrowserSkin.this.fileTableView.getTableData();
                        File file = (File)files.get(i);
                        fileBrowser.addSelectedFile(file);
                    }
                    TerraFileBrowserSkin.this.updatingSelection = false;
                }
            }

            public void selectedRangeRemoved(TableView tableView, int rangeStart, int rangeEnd) {
                if (!TerraFileBrowserSkin.this.updatingSelection) {
                    TerraFileBrowserSkin.this.updatingSelection = true;
                    for (int i = rangeStart; i <= rangeEnd; ++i) {
                        List files = TerraFileBrowserSkin.this.fileTableView.getTableData();
                        File file = (File)files.get(i);
                        fileBrowser.removeSelectedFile(file);
                    }
                    TerraFileBrowserSkin.this.updatingSelection = false;
                }
            }

            public void selectedRangesChanged(TableView tableView, Sequence<Span> previousSelectedRanges) {
                if (!TerraFileBrowserSkin.this.updatingSelection && previousSelectedRanges != null) {
                    TerraFileBrowserSkin.this.updatingSelection = true;
                    Sequence files = tableView.getSelectedRows();
                    int n = files.getLength();
                    for (int i = 0; i < n; ++i) {
                        File file = (File)files.get(i);
                        files.update(i, (Object)file);
                    }
                    fileBrowser.setSelectedFiles(files);
                    TerraFileBrowserSkin.this.updatingSelection = false;
                }
            }

            public void selectedRowChanged(TableView tableView, Object previousSelectedRow) {
            }
        });
        this.fileTableView.getTableViewSortListeners().add((Object)new TableViewSortListener.Adapter(){

            public void sortChanged(TableView tableView) {
                TableView.SortDictionary sort = TerraFileBrowserSkin.this.fileTableView.getSort();
                if (!sort.isEmpty()) {
                    Dictionary.Pair pair = TerraFileBrowserSkin.this.fileTableView.getSort().get(0);
                    List files = TerraFileBrowserSkin.this.fileTableView.getTableData();
                    files.setComparator((Comparator)TerraFileBrowserSkin.getFileComparator((String)pair.key, (SortDirection)pair.value));
                }
            }
        });
        this.fileTableView.getComponentMouseButtonListeners().add((Object)new ComponentMouseButtonListener.Adapter(){
            private int index = -1;

            public boolean mouseClick(Component componentArgument, Mouse.Button button, int x, int y, int count) {
                File file;
                int indexLocal;
                boolean consumed = super.mouseClick(componentArgument, button, x, y, count);
                if (count == 1) {
                    this.index = TerraFileBrowserSkin.this.fileTableView.getRowAt(y);
                } else if (count == 2 && (indexLocal = TerraFileBrowserSkin.this.fileTableView.getRowAt(y)) != -1 && indexLocal == this.index && TerraFileBrowserSkin.this.fileTableView.isRowSelected(indexLocal) && (file = (File)TerraFileBrowserSkin.this.fileTableView.getTableData().get(indexLocal)).isDirectory()) {
                    fileBrowser.setRootDirectory(file);
                    consumed = true;
                }
                return consumed;
            }
        });
        fileBrowser.setFocusTraversalPolicy((FocusTraversalPolicy)new ContainerSkin.IndexFocusTraversalPolicy(){

            public Component getNextComponent(Container container, Component componentArgument, FocusTraversalDirection direction) {
                Object nextComponent = componentArgument == null ? TerraFileBrowserSkin.this.fileTableView : super.getNextComponent(container, componentArgument, direction);
                return nextComponent;
            }
        });
        this.fileTableView.setSort("name", SortDirection.ASCENDING);
        this.fileTableView.getComponentTooltipListeners().add((Object)new ComponentTooltipListener(){

            public void tooltipTriggered(Component comp, int x, int y) {
                if (TerraFileBrowserSkin.this.fileTableView.getColumnAt(x) != 0) {
                    return;
                }
                int row = TerraFileBrowserSkin.this.fileTableView.getRowAt(y);
                if (row < 0) {
                    return;
                }
                File file = (File)TerraFileBrowserSkin.this.fileTableView.getTableData().get(row);
                Tooltip tooltip = new Tooltip();
                String text = null;
                if (file != null) {
                    text = file.getName();
                }
                if (text == null || text.isEmpty()) {
                    return;
                }
                TextArea toolTipTextArea = new TextArea();
                toolTipTextArea.setText(text);
                toolTipTextArea.getStyles().put("wrapText", (Object)true);
                tooltip.setContent((Component)toolTipTextArea);
                Point location = comp.getDisplay().getMouseLocation();
                x = location.x;
                y = location.y;
                Display display = comp.getDisplay();
                int tooltipHeight = tooltip.getPreferredHeight();
                if (y + tooltipHeight > display.getHeight()) {
                    y -= tooltipHeight;
                }
                int tooltipXOffset = 16;
                int padding = 15;
                toolTipTextArea.setMaximumWidth(display.getWidth() - (x + tooltipXOffset + padding));
                tooltip.setLocation(x + tooltipXOffset, y);
                tooltip.open(comp.getWindow());
            }
        });
        this.rootDirectoryChanged(fileBrowser, null);
        this.selectedFilesChanged(fileBrowser, null);
    }

    public int getPreferredWidth(int height) {
        return this.content.getPreferredWidth(height);
    }

    public int getPreferredHeight(int width) {
        return this.content.getPreferredHeight(width);
    }

    public Dimensions getPreferredSize() {
        return this.content.getPreferredSize();
    }

    public void layout() {
        int width = this.getWidth();
        int height = this.getHeight();
        this.content.setLocation(0, 0);
        this.content.setSize(width, height);
    }

    public File getFileAt(int x, int y) {
        File file = null;
        FileBrowser fileBrowser = (FileBrowser)this.getComponent();
        Component component = fileBrowser.getDescendantAt(x, y);
        if (component == this.fileTableView) {
            Point location = this.fileTableView.mapPointFromAncestor((Container)fileBrowser, x, y);
            int index = this.fileTableView.getRowAt(location.y);
            if (index != -1) {
                file = (File)this.fileTableView.getTableData().get(index);
            }
        }
        return file;
    }

    public boolean isKeyboardFolderTraversalEnabled() {
        return this.keyboardFolderTraversalEnabled;
    }

    public void setKeyboardFolderTraversalEnabled(boolean keyboardFolderTraversalEnabled) {
        this.keyboardFolderTraversalEnabled = keyboardFolderTraversalEnabled;
    }

    public boolean isHideDisabledFiles() {
        return this.hideDisabledFiles;
    }

    public void setHideDisabledFiles(boolean hideDisabledFiles) {
        this.hideDisabledFiles = hideDisabledFiles;
        this.refreshFileList();
    }

    public boolean isShowHiddenFiles() {
        return this.showHiddenFiles;
    }

    public void setShowHiddenFiles(boolean showHiddenFiles) {
        this.showHiddenFiles = showHiddenFiles;
        this.refreshFileList();
    }

    public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = super.keyPressed(component, keyCode, keyLocation);
        FileBrowser fileBrowser = (FileBrowser)this.getComponent();
        if (keyCode == 10 && this.keyboardFolderTraversalEnabled) {
            File selectedFile;
            ImmutableList selectedFiles = fileBrowser.getSelectedFiles();
            if (selectedFiles.getLength() == 1 && (selectedFile = (File)selectedFiles.get(0)).isDirectory()) {
                fileBrowser.setRootDirectory(selectedFile);
                consumed = true;
            }
        } else if (keyCode == 127 || keyCode == 8) {
            File rootDirectory = fileBrowser.getRootDirectory();
            File parentDirectory = rootDirectory.getParentFile();
            if (parentDirectory != null) {
                fileBrowser.setRootDirectory(parentDirectory);
                consumed = true;
            }
        } else if (keyCode == 116) {
            this.refreshFileList();
            consumed = true;
        }
        return consumed;
    }

    public boolean keyReleased(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = super.keyReleased(component, keyCode, keyLocation);
        Keyboard.Modifier commandModifier = Platform.getCommandModifier();
        if (keyCode == 70 && Keyboard.isPressed((Keyboard.Modifier)commandModifier)) {
            this.searchTextInput.requestFocus();
            consumed = true;
        }
        return consumed;
    }

    public void rootDirectoryChanged(FileBrowser fileBrowser, File previousRootDirectory) {
        ArrayList path = new ArrayList();
        File rootDirectory = fileBrowser.getRootDirectory();
        for (File ancestorDirectory = rootDirectory.getParentFile(); ancestorDirectory != null; ancestorDirectory = ancestorDirectory.getParentFile()) {
            path.add((Object)ancestorDirectory);
        }
        ArrayList drives = (ArrayList)this.driveListButton.getListData();
        if (this.refreshRoots) {
            File[] roots = File.listRoots();
            drives = new ArrayList();
            for (int i = 0; i < roots.length; ++i) {
                File root = roots[i];
                if (!root.exists()) continue;
                drives.add((Object)root);
            }
            this.driveListButton.setListData((List)drives);
            this.refreshRoots = false;
        }
        this.driveListButton.setVisible(drives.getLength() > 1);
        File drive = path.getLength() == 0 ? rootDirectory : (File)path.get(path.getLength() - 1);
        this.selectingDriveFromRootDirectory = true;
        this.driveListButton.setSelectedItem((Object)drive);
        this.selectingDriveFromRootDirectory = false;
        this.pathListButton.setListData((List)path);
        this.pathListButton.setButtonData((Object)rootDirectory);
        this.pathListButton.setEnabled(rootDirectory.getParentFile() != null);
        this.goUpButton.setEnabled(this.pathListButton.isEnabled());
        this.goHomeButton.setEnabled(!rootDirectory.equals(HOME_DIRECTORY));
        this.fileScrollPane.setScrollTop(0);
        this.fileScrollPane.setScrollLeft(0);
        this.searchTextInput.setText("");
        this.fileTableView.requestFocus();
    }

    public void selectedFileAdded(FileBrowser fileBrowser, File file) {
        List files;
        int index;
        if (!this.updatingSelection && (index = (files = this.fileTableView.getTableData()).indexOf((Object)file)) != -1) {
            this.updatingSelection = true;
            this.fileTableView.addSelectedIndex(index);
            this.updatingSelection = false;
        }
    }

    public void selectedFileRemoved(FileBrowser fileBrowser, File file) {
        List files;
        int index;
        if (!this.updatingSelection && (index = (files = this.fileTableView.getTableData()).indexOf((Object)file)) != -1) {
            this.updatingSelection = true;
            this.fileTableView.removeSelectedIndex(index);
            this.updatingSelection = false;
        }
    }

    public void selectedFilesChanged(FileBrowser fileBrowser, Sequence<File> previousSelectedFiles) {
        this.updateSelectedFiles(fileBrowser);
    }

    private void updateSelectedFiles(FileBrowser fileBrowser) {
        if (!this.updatingSelection) {
            ImmutableList selectedFiles = fileBrowser.getSelectedFiles();
            ArrayList selectedRanges = new ArrayList();
            int n = selectedFiles.getLength();
            for (int i = 0; i < n; ++i) {
                File selectedFile = (File)selectedFiles.get(i);
                List files = this.fileTableView.getTableData();
                int index = files.indexOf((Object)selectedFile);
                if (index == -1) continue;
                selectedRanges.add((Object)new Span(index, index));
            }
            this.updatingSelection = true;
            this.fileTableView.setSelectedRanges((Sequence)selectedRanges);
            this.updatingSelection = false;
        }
    }

    public void multiSelectChanged(FileBrowser fileBrowser) {
        this.fileTableView.setSelectMode(fileBrowser.isMultiSelect() ? TableView.SelectMode.MULTI : TableView.SelectMode.SINGLE);
    }

    public void disabledFileFilterChanged(FileBrowser fileBrowser, Filter<File> previousDisabledFileFilter) {
        this.fileTableView.setDisabledRowFilter(fileBrowser.getDisabledFileFilter());
        this.refreshFileList();
    }

    private void refreshFileList() {
        FileComparator fileComparator;
        if (this.refreshFileListTask != null) {
            this.refreshFileListTask.abort();
            if (this.indicator.isActive()) {
                this.indicator.setActive(false);
                this.activityGrid.setVisible(false);
            }
        }
        this.activityGrid.setVisible(true);
        this.indicator.setActive(true);
        this.fileTableView.setTableData((List)new ArrayList());
        String text = this.searchTextInput.getText().trim();
        Filter disabledFileFilter = this.hideDisabledFiles ? ((FileBrowser)this.getComponent()).getDisabledFileFilter() : null;
        IncludeFileFilter includeFileFilter = text.length() != 0 ? new IncludeFileFilter(text) : null;
        TableView.SortDictionary sort = this.fileTableView.getSort();
        if (sort.isEmpty()) {
            fileComparator = null;
        } else {
            Dictionary.Pair pair = this.fileTableView.getSort().get(0);
            fileComparator = TerraFileBrowserSkin.getFileComparator((String)pair.key, (SortDirection)pair.value);
        }
        this.refreshFileListTask = new RefreshFileListTask(includeFileFilter, (Filter<File>)disabledFileFilter, fileComparator);
        this.refreshFileListTask.execute((TaskListener)new TaskAdapter((TaskListener)new TaskListener<ArrayList<File>>(){

            public void taskExecuted(Task<ArrayList<File>> task) {
                if (task == TerraFileBrowserSkin.this.refreshFileListTask) {
                    TerraFileBrowserSkin.this.indicator.setActive(false);
                    TerraFileBrowserSkin.this.activityGrid.setVisible(false);
                    ArrayList fileList = (ArrayList)task.getResult();
                    TerraFileBrowserSkin.this.fileTableView.setTableData((List)fileList);
                    TerraFileBrowserSkin.this.updateSelectedFiles((FileBrowser)TerraFileBrowserSkin.this.getComponent());
                    TerraFileBrowserSkin.this.refreshFileListTask = null;
                }
            }

            public void executeFailed(Task<ArrayList<File>> task) {
                if (task == TerraFileBrowserSkin.this.refreshFileListTask) {
                    TerraFileBrowserSkin.this.indicator.setActive(false);
                    TerraFileBrowserSkin.this.activityGrid.setVisible(false);
                    TerraFileBrowserSkin.this.refreshFileListTask = null;
                }
            }
        }));
    }

    private class RefreshFileListTask
    extends Task<ArrayList<File>> {
        private Filter<File> includeFileFilter;
        private Filter<File> excludeFileFilter;
        private FileComparator fileComparator;

        public RefreshFileListTask(Filter<File> includeFileFilter, Filter<File> excludeFileFilter, FileComparator fileComparator) {
            this.includeFileFilter = includeFileFilter;
            this.excludeFileFilter = excludeFileFilter;
            this.fileComparator = fileComparator;
        }

        public ArrayList<File> execute() {
            FileBrowser fileBrowser = (FileBrowser)TerraFileBrowserSkin.this.getComponent();
            File rootDirectory = fileBrowser.getRootDirectory();
            if (this.abort) {
                throw new AbortException();
            }
            Object[] files = rootDirectory.listFiles(new FullFileFilter(TerraFileBrowserSkin.this.showHiddenFiles, this.includeFileFilter, this.excludeFileFilter));
            if (this.abort) {
                throw new AbortException();
            }
            Arrays.sort(files, this.fileComparator);
            return new ArrayList(files, 0, files.length);
        }
    }

    public static class FullFileFilter
    implements FileFilter {
        private FileFilter hiddenFileFilter;
        private Filter<File> includeFileFilter;
        private Filter<File> excludeFileFilter;

        public FullFileFilter(boolean showHiddenFiles, Filter<File> includeFileFilter, Filter<File> excludeFileFilter) {
            this.hiddenFileFilter = showHiddenFiles ? null : HIDDEN_FILE_FILTER;
            this.includeFileFilter = includeFileFilter;
            this.excludeFileFilter = excludeFileFilter;
        }

        @Override
        public boolean accept(File file) {
            boolean include;
            boolean bl = include = this.hiddenFileFilter == null ? true : this.hiddenFileFilter.accept(file);
            if (include && this.includeFileFilter != null) {
                include = this.includeFileFilter.include((Object)file);
            }
            if (include && this.excludeFileFilter != null) {
                include = !this.excludeFileFilter.include((Object)file);
            }
            return include;
        }
    }

    public static class IncludeFileFilter
    implements Filter<File> {
        private String match;

        public IncludeFileFilter() {
            this(null);
        }

        public IncludeFileFilter(String match) {
            this.match = match == null ? null : match.toLowerCase();
        }

        public boolean include(File file) {
            boolean include = true;
            if (this.match != null) {
                String name = file.getName();
                name = name.toLowerCase();
                include = this.match.startsWith("*") ? (this.match.length() == 1 ? true : name.contains(this.match.substring(1))) : name.startsWith(this.match);
            }
            return include;
        }
    }

    public static class FileDateDescendingComparator
    extends FileComparator {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(File f1, File f2) {
            return Long.signum(f2.lastModified() - f1.lastModified());
        }
    }

    public static class FileDateAscendingComparator
    extends FileComparator {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(File f1, File f2) {
            return Long.signum(f1.lastModified() - f2.lastModified());
        }
    }

    public static class FileSizeDescendingComparator
    extends FileComparator {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(File f1, File f2) {
            return Long.signum(f2.length() - f1.length());
        }
    }

    public static class FileSizeAscendingComparator
    extends FileComparator {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(File f1, File f2) {
            return Long.signum(f1.length() - f2.length());
        }
    }

    public static class FileNameDescendingComparator
    extends FileComparator {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(File f1, File f2) {
            boolean file1IsDirectory = f1.isDirectory();
            boolean file2IsDirectory = f2.isDirectory();
            int result = file1IsDirectory && !file2IsDirectory ? -1 : (!file1IsDirectory && file2IsDirectory ? 1 : f2.compareTo(f1));
            return result;
        }
    }

    public static class FileNameAscendingComparator
    extends FileComparator {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(File f1, File f2) {
            boolean file1IsDirectory = f1.isDirectory();
            boolean file2IsDirectory = f2.isDirectory();
            int result = file1IsDirectory && !file2IsDirectory ? -1 : (!file1IsDirectory && file2IsDirectory ? 1 : f1.compareTo(f2));
            return result;
        }
    }

    public static abstract class FileComparator
    implements Comparator<File>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public abstract int compare(File var1, File var2);
    }

    public static class ListViewDriveRenderer
    extends DriveRenderer
    implements ListView.ItemRenderer {
        public ListViewDriveRenderer() {
            this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.LEFT);
            this.getStyles().put("padding", (Object)new Insets(2, 3, 2, 3));
        }

        public void render(Object item, int index, ListView listView, boolean selected, boolean checked, boolean highlighted, boolean disabled) {
            this.label.getStyles().put("font", listView.getStyles().get("font"));
            Object color = null;
            color = listView.isEnabled() && !disabled ? (selected ? (listView.isFocused() ? listView.getStyles().get("selectionColor") : listView.getStyles().get("inactiveSelectionColor")) : listView.getStyles().get("color")) : listView.getStyles().get("disabledColor");
            this.label.getStyles().put("color", color);
            if (item != null) {
                File file = (File)item;
                this.imageView.setImage(DRIVE_IMAGE);
                this.imageView.getStyles().put("opacity", (Object)Float.valueOf(listView.isEnabled() && !disabled ? 1.0f : 0.5f));
                this.label.setText(file.toString());
            }
        }

        public String toString(Object item) {
            return null;
        }
    }

    public static class ListButtonDriveRenderer
    extends DriveRenderer
    implements Button.DataRenderer {
        public ListButtonDriveRenderer() {
            this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.LEFT);
        }

        public void render(Object data, Button button, boolean highlight) {
            if (data != null) {
                File file = (File)data;
                this.imageView.setImage(DRIVE_IMAGE);
                this.imageView.getStyles().put("opacity", (Object)Float.valueOf(button.isEnabled() ? 1.0f : 0.5f));
                this.label.setText(file.toString());
            }
        }

        public String toString(Object data) {
            return null;
        }
    }

    public static abstract class DriveRenderer
    extends BoxPane {
        protected ImageView imageView = new ImageView();
        protected Label label = new Label();
        public static final int ICON_WIDTH = 16;
        public static final int ICON_HEIGHT = 16;
        public static final Image DRIVE_IMAGE;

        public DriveRenderer() {
            this.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
            this.add((Component)this.imageView);
            this.add((Component)this.label);
            this.imageView.setPreferredSize(16, 16);
            this.imageView.getStyles().put("backgroundColor", null);
        }

        public void setSize(int width, int height) {
            super.setSize(width, height);
            this.validate();
        }

        static {
            try {
                DRIVE_IMAGE = Image.load((URL)FileRenderer.class.getResource("drive.png"));
            }
            catch (TaskExecutionException exception) {
                throw new RuntimeException(exception);
            }
        }
    }

    public static class TableViewFileRenderer
    extends FileRenderer
    implements TableView.CellRenderer {
        public static final String NAME_KEY = "name";
        public static final String SIZE_KEY = "size";
        public static final String LAST_MODIFIED_KEY = "lastModified";

        public TableViewFileRenderer() {
            this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.CENTER);
            this.getStyles().put("padding", (Object)new Insets(2));
        }

        public void render(Object row, int rowIndex, int columnIndex, TableView tableView, String columnName, boolean selected, boolean highlighted, boolean disabled) {
            boolean hidden = false;
            if (row != null) {
                File file = (File)row;
                hidden = file.getName().length() != 0 && file.isHidden();
                String text = null;
                Image icon = null;
                if (columnName.equals(NAME_KEY)) {
                    text = file.getName();
                    icon = TableViewFileRenderer.getIcon(file);
                    this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.LEFT);
                } else if (columnName.equals(SIZE_KEY)) {
                    long length = file.length();
                    text = FileSizeFormat.getInstance().format((Object)length);
                    this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.RIGHT);
                } else if (columnName.equals(LAST_MODIFIED_KEY)) {
                    long lastModified = file.lastModified();
                    Date lastModifiedDate = new Date(lastModified);
                    text = DATE_FORMAT.format(lastModifiedDate);
                    this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.RIGHT);
                } else {
                    System.err.println("Unexpected column name in " + ((Object)((Object)this)).getClass().getName() + ": " + columnName);
                    text = "";
                }
                this.label.setText(text);
                this.imageView.setImage(icon);
                this.imageView.getStyles().put("opacity", (Object)Float.valueOf(tableView.isEnabled() && !disabled && !hidden ? 1.0f : 0.5f));
            }
            Font font = (Font)tableView.getStyles().get("font");
            this.label.getStyles().put("font", (Object)font);
            Color color = tableView.isEnabled() && !disabled && !hidden ? (selected ? (tableView.isFocused() ? (Color)tableView.getStyles().get("selectionColor") : (Color)tableView.getStyles().get("inactiveSelectionColor")) : (Color)tableView.getStyles().get("color")) : (Color)tableView.getStyles().get("disabledColor");
            this.label.getStyles().put("color", (Object)color);
        }

        public String toString(Object row, String columnName) {
            String string;
            File file = (File)row;
            if (columnName.equals(NAME_KEY)) {
                string = file.getName();
            } else if (columnName.equals(SIZE_KEY)) {
                long length = file.length();
                string = FileSizeFormat.getInstance().format((Object)length);
            } else if (columnName.equals(LAST_MODIFIED_KEY)) {
                long lastModified = file.lastModified();
                Date lastModifiedDate = new Date(lastModified);
                string = DATE_FORMAT.format(lastModifiedDate);
            } else {
                System.err.println("Unexpected column name in " + ((Object)((Object)this)).getClass().getName() + ": " + columnName);
                string = null;
            }
            return string;
        }
    }

    public static class ListViewFileRenderer
    extends FileRenderer
    implements ListView.ItemRenderer {
        public ListViewFileRenderer() {
            this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.LEFT);
            this.getStyles().put("padding", (Object)new Insets(2, 3, 2, 3));
        }

        public void render(Object item, int index, ListView listView, boolean selected, boolean checked, boolean highlighted, boolean disabled) {
            boolean hidden = false;
            this.label.getStyles().put("font", listView.getStyles().get("font"));
            if (item != null) {
                File file = (File)item;
                hidden = file.getName().length() != 0 && file.isHidden();
                this.imageView.setImage(ListViewFileRenderer.getIcon(file));
                this.imageView.getStyles().put("opacity", (Object)Float.valueOf(listView.isEnabled() && !disabled && !hidden ? 1.0f : 0.5f));
                String text = file.getName();
                if (text.length() == 0) {
                    text = System.getProperty("file.separator");
                }
                this.label.setText(text);
            }
            Object color = null;
            color = listView.isEnabled() && !disabled && !hidden ? (selected ? (listView.isFocused() ? listView.getStyles().get("selectionColor") : listView.getStyles().get("inactiveSelectionColor")) : listView.getStyles().get("color")) : listView.getStyles().get("disabledColor");
            this.label.getStyles().put("color", color);
        }

        public String toString(Object item) {
            File file = (File)item;
            String text = file.getName();
            if (text.length() == 0) {
                text = System.getProperty("file.separator");
            }
            return text;
        }
    }

    public static class ListButtonFileRenderer
    extends FileRenderer
    implements Button.DataRenderer {
        public ListButtonFileRenderer() {
            this.getStyles().put("horizontalAlignment", (Object)HorizontalAlignment.LEFT);
        }

        public void render(Object data, Button button, boolean highlight) {
            if (data != null) {
                File file = (File)data;
                boolean hidden = file.getName().length() != 0 && file.isHidden();
                this.imageView.setImage(ListButtonFileRenderer.getIcon(file));
                this.imageView.getStyles().put("opacity", (Object)Float.valueOf(button.isEnabled() && !hidden ? 1.0f : 0.5f));
                String text = file.getName();
                if (text.length() == 0) {
                    text = System.getProperty("file.separator");
                }
                this.label.setText(text);
                Object color = null;
                color = button.isEnabled() && !hidden ? button.getStyles().get("color") : button.getStyles().get("disabledColor");
                this.label.getStyles().put("color", color);
            }
        }

        public String toString(Object item) {
            File file = (File)item;
            String text = file.getName();
            if (text.length() == 0) {
                text = System.getProperty("file.separator");
            }
            return text;
        }
    }

    public static abstract class FileRenderer
    extends BoxPane {
        protected ImageView imageView = new ImageView();
        protected Label label = new Label();
        public static final int ICON_WIDTH = 16;
        public static final int ICON_HEIGHT = 16;
        public static final Image FOLDER_IMAGE;
        public static final Image HOME_FOLDER_IMAGE;
        public static final Image FILE_IMAGE;

        public FileRenderer() {
            this.getStyles().put("verticalAlignment", (Object)VerticalAlignment.CENTER);
            this.add((Component)this.imageView);
            this.add((Component)this.label);
            this.imageView.setPreferredSize(16, 16);
            this.imageView.getStyles().put("backgroundColor", null);
        }

        public void setSize(int width, int height) {
            super.setSize(width, height);
            this.validate();
        }

        public static Image getIcon(File file) {
            Image icon = file.isDirectory() ? (file.equals(HOME_DIRECTORY) ? HOME_FOLDER_IMAGE : FOLDER_IMAGE) : FILE_IMAGE;
            return icon;
        }

        static {
            try {
                FOLDER_IMAGE = Image.load((URL)FileRenderer.class.getResource("folder.png"));
                HOME_FOLDER_IMAGE = Image.load((URL)FileRenderer.class.getResource("folder_home.png"));
                FILE_IMAGE = Image.load((URL)FileRenderer.class.getResource("page_white.png"));
            }
            catch (TaskExecutionException exception) {
                throw new RuntimeException(exception);
            }
        }
    }
}

