/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.collections.immutable.ImmutableList;
import org.apache.pivot.util.Filter;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Checkbox;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Insets;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.ListView;
import org.apache.pivot.wtk.ListViewItemListener;
import org.apache.pivot.wtk.ListViewItemStateListener;
import org.apache.pivot.wtk.ListViewListener;
import org.apache.pivot.wtk.ListViewSelectionListener;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.Span;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraListViewSkin
extends ComponentSkin
implements ListView.Skin,
ListViewListener,
ListViewItemListener,
ListViewItemStateListener,
ListViewSelectionListener {
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color backgroundColor;
    private Color selectionColor;
    private Color selectionBackgroundColor;
    private Color inactiveSelectionColor;
    private Color inactiveSelectionBackgroundColor;
    private Color highlightBackgroundColor;
    private Color alternateItemBackgroundColor;
    private boolean showHighlight;
    private boolean wrapSelectNext;
    private boolean variableItemHeight;
    private Insets checkboxPadding = new Insets(2, 2, 2, 0);
    private int highlightIndex = -1;
    private int selectIndex = -1;
    private ArrayList<Integer> itemBoundaries = null;
    private int fixedItemHeight;
    private boolean validateSelection = false;
    private static final Checkbox CHECKBOX = new Checkbox();

    public TerraListViewSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.font = theme.getFont();
        this.color = theme.getColor(1);
        this.disabledColor = theme.getColor(7);
        this.backgroundColor = theme.getColor(4);
        this.selectionColor = theme.getColor(4);
        this.selectionBackgroundColor = theme.getColor(14);
        this.inactiveSelectionColor = theme.getColor(1);
        this.inactiveSelectionBackgroundColor = theme.getColor(9);
        this.highlightBackgroundColor = theme.getColor(10);
        this.alternateItemBackgroundColor = null;
        this.showHighlight = true;
        this.wrapSelectNext = true;
    }

    public void install(Component component) {
        super.install(component);
        ListView listView = (ListView)component;
        listView.getListViewListeners().add((Object)this);
        listView.getListViewItemListeners().add((Object)this);
        listView.getListViewItemStateListeners().add((Object)this);
        listView.getListViewSelectionListeners().add((Object)this);
    }

    public int getPreferredWidth(int height) {
        int preferredWidth = 0;
        ListView listView = (ListView)this.getComponent();
        List listData = listView.getListData();
        ListView.ItemRenderer itemRenderer = listView.getItemRenderer();
        int index = 0;
        for (Object item : listData) {
            itemRenderer.render(item, index++, listView, false, false, false, false);
            preferredWidth = Math.max(preferredWidth, itemRenderer.getPreferredWidth(-1));
        }
        if (listView.getCheckmarksEnabled()) {
            preferredWidth += CHECKBOX.getWidth() + (this.checkboxPadding.left + this.checkboxPadding.right);
        }
        return preferredWidth;
    }

    public int getPreferredHeight(int width) {
        int preferredHeight = 0;
        ListView listView = (ListView)this.getComponent();
        List listData = listView.getListData();
        ListView.ItemRenderer itemRenderer = listView.getItemRenderer();
        if (this.variableItemHeight) {
            int clientWidth = width;
            if (listView.getCheckmarksEnabled()) {
                clientWidth = Math.max(clientWidth - (CHECKBOX.getWidth() + (this.checkboxPadding.left + this.checkboxPadding.right)), 0);
            }
            int index = 0;
            for (Object item : listData) {
                itemRenderer.render(item, index++, listView, false, false, false, false);
                preferredHeight += itemRenderer.getPreferredHeight(clientWidth);
            }
        } else {
            itemRenderer.render(null, -1, listView, false, false, false, false);
            int fixedItemHeightLocal = itemRenderer.getPreferredHeight(-1);
            if (listView.getCheckmarksEnabled()) {
                fixedItemHeightLocal = Math.max(CHECKBOX.getHeight() + (this.checkboxPadding.top + this.checkboxPadding.bottom), fixedItemHeightLocal);
            }
            preferredHeight = listData.getLength() * fixedItemHeightLocal;
        }
        return preferredHeight;
    }

    public int getBaseline(int width, int height) {
        ListView listView = (ListView)this.getComponent();
        int baseline = -1;
        int clientWidth = width;
        if (listView.getCheckmarksEnabled()) {
            clientWidth = Math.max(clientWidth - (CHECKBOX.getWidth() + (this.checkboxPadding.left + this.checkboxPadding.right)), 0);
        }
        ListView.ItemRenderer itemRenderer = listView.getItemRenderer();
        List listData = listView.getListData();
        if (this.variableItemHeight && listData.getLength() > 0) {
            itemRenderer.render(listData.get(0), 0, listView, false, false, false, false);
            int itemHeight = itemRenderer.getPreferredHeight(clientWidth);
            if (listView.getCheckmarksEnabled()) {
                itemHeight = Math.max(CHECKBOX.getHeight() + (this.checkboxPadding.top + this.checkboxPadding.bottom), itemHeight);
            }
            baseline = itemRenderer.getBaseline(clientWidth, itemHeight);
        } else {
            itemRenderer.render(null, -1, listView, false, false, false, false);
            int fixedItemHeightLocal = itemRenderer.getPreferredHeight(-1);
            if (listView.getCheckmarksEnabled()) {
                fixedItemHeightLocal = Math.max(CHECKBOX.getHeight() + (this.checkboxPadding.top + this.checkboxPadding.bottom), fixedItemHeightLocal);
            }
            baseline = itemRenderer.getBaseline(clientWidth, fixedItemHeightLocal);
        }
        return baseline;
    }

    public void layout() {
        ImmutableList selectedRanges;
        ListView listView = (ListView)this.getComponent();
        List listData = listView.getListData();
        ListView.ItemRenderer itemRenderer = listView.getItemRenderer();
        if (this.variableItemHeight) {
            int width = this.getWidth();
            int checkboxHeight = 0;
            if (listView.getCheckmarksEnabled()) {
                checkboxHeight = CHECKBOX.getHeight() + (this.checkboxPadding.top + this.checkboxPadding.bottom);
            }
            int n = listData.getLength();
            this.itemBoundaries = new ArrayList(n);
            int itemY = 0;
            for (int i = 0; i < n; ++i) {
                Object item = listData.get(i);
                int itemWidth = width;
                int itemX = 0;
                boolean checked = false;
                if (listView.getCheckmarksEnabled()) {
                    checked = listView.isItemChecked(i);
                    itemX = CHECKBOX.getWidth() + (this.checkboxPadding.left + this.checkboxPadding.right);
                    itemWidth -= itemX;
                }
                itemRenderer.render(item, i, listView, false, checked, false, false);
                int itemHeight = itemRenderer.getPreferredHeight(itemWidth);
                if (listView.getCheckmarksEnabled()) {
                    itemHeight = Math.max(itemHeight, checkboxHeight);
                }
                this.itemBoundaries.add((Object)(itemY += itemHeight));
            }
        } else {
            itemRenderer.render(null, -1, listView, false, false, false, false);
            this.fixedItemHeight = itemRenderer.getPreferredHeight(-1);
            if (listView.getCheckmarksEnabled()) {
                this.fixedItemHeight = Math.max(CHECKBOX.getHeight() + (this.checkboxPadding.top + this.checkboxPadding.bottom), this.fixedItemHeight);
            }
        }
        if (this.validateSelection && (selectedRanges = listView.getSelectedRanges()).getLength() > 0) {
            int rangeStart = ((Span)selectedRanges.get((int)0)).start;
            int rangeEnd = ((Span)selectedRanges.get((int)(selectedRanges.getLength() - 1))).end;
            Bounds selectionBounds = this.getItemBounds(rangeStart);
            Bounds visibleSelectionBounds = listView.getVisibleArea(selectionBounds = selectionBounds.union(this.getItemBounds(rangeEnd)));
            if (visibleSelectionBounds != null && visibleSelectionBounds.height < selectionBounds.height) {
                listView.scrollAreaToVisible(selectionBounds);
            }
        }
        this.validateSelection = false;
    }

    public void paint(Graphics2D graphics) {
        int itemIndex;
        ListView listView = (ListView)this.getComponent();
        List listData = listView.getListData();
        ListView.ItemRenderer itemRenderer = listView.getItemRenderer();
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.backgroundColor != null) {
            graphics.setPaint(this.backgroundColor);
            graphics.fillRect(0, 0, width, height);
        }
        int itemStart = 0;
        int itemEnd = listData.getLength() - 1;
        Rectangle clipBounds = graphics.getClipBounds();
        if (clipBounds != null) {
            if (this.variableItemHeight) {
                itemStart = this.getItemAt(clipBounds.y);
                if (itemStart == -1) {
                    itemStart = listData.getLength();
                }
                if (itemEnd != -1) {
                    int clipBottom = clipBounds.y + clipBounds.height - 1;
                    clipBottom = Math.min(clipBottom, (Integer)this.itemBoundaries.get(itemEnd) - 1);
                    itemEnd = this.getItemAt(clipBottom);
                }
            } else {
                itemStart = Math.max(itemStart, (int)Math.floor((double)clipBounds.y / (double)this.fixedItemHeight));
                itemEnd = Math.min(itemEnd, (int)Math.ceil((double)(clipBounds.y + clipBounds.height) / (double)this.fixedItemHeight) - 1);
            }
        }
        if (this.alternateItemBackgroundColor != null) {
            for (itemIndex = itemStart; itemIndex <= itemEnd; ++itemIndex) {
                int itemY = this.getItemY(itemIndex);
                int rowHeight = this.getItemHeight(itemIndex);
                if (itemIndex % 2 <= 0) continue;
                graphics.setPaint(this.alternateItemBackgroundColor);
                graphics.fillRect(0, itemY, width, rowHeight + 1);
            }
        }
        for (itemIndex = itemStart; itemIndex <= itemEnd; ++itemIndex) {
            Object item = listData.get(itemIndex);
            boolean highlighted = itemIndex == this.highlightIndex && listView.getSelectMode() != ListView.SelectMode.NONE;
            boolean selected = listView.isItemSelected(itemIndex);
            boolean disabled = listView.isItemDisabled(itemIndex);
            int itemY = this.getItemY(itemIndex);
            int itemHeight = this.getItemHeight(itemIndex);
            Color itemBackgroundColor = null;
            if (selected) {
                itemBackgroundColor = listView.isFocused() ? this.selectionBackgroundColor : this.inactiveSelectionBackgroundColor;
            } else if (highlighted && this.showHighlight && !disabled) {
                itemBackgroundColor = this.highlightBackgroundColor;
            }
            if (itemBackgroundColor != null) {
                graphics.setPaint(itemBackgroundColor);
                graphics.fillRect(0, itemY, width, itemHeight);
            }
            int itemX = 0;
            int itemWidth = width;
            boolean checked = false;
            if (listView.getCheckmarksEnabled()) {
                checked = listView.isItemChecked(itemIndex);
                int checkboxY = (itemHeight - CHECKBOX.getHeight()) / 2;
                Graphics2D checkboxGraphics = (Graphics2D)graphics.create(this.checkboxPadding.left, itemY + checkboxY, CHECKBOX.getWidth(), CHECKBOX.getHeight());
                CHECKBOX.setSelected(checked);
                CHECKBOX.setEnabled(!disabled && !listView.isCheckmarkDisabled(itemIndex));
                CHECKBOX.paint(checkboxGraphics);
                checkboxGraphics.dispose();
                itemX = CHECKBOX.getWidth() + (this.checkboxPadding.left + this.checkboxPadding.right);
                itemWidth -= itemX;
            }
            Graphics2D rendererGraphics = (Graphics2D)graphics.create(itemX, itemY, itemWidth, itemHeight);
            itemRenderer.render(item, itemIndex, listView, selected, checked, highlighted, disabled);
            itemRenderer.setSize(itemWidth, itemHeight);
            itemRenderer.paint(rendererGraphics);
            rendererGraphics.dispose();
            itemY += itemHeight;
        }
    }

    public int getItemAt(int y) {
        int index;
        if (y < 0) {
            throw new IllegalArgumentException("y is negative");
        }
        ListView listView = (ListView)this.getComponent();
        if (this.variableItemHeight) {
            if (y == 0) {
                index = 0;
            } else {
                index = ArrayList.binarySearch(this.itemBoundaries, (Comparable)Integer.valueOf(y));
                if (index < 0) {
                    index = -(index + 1);
                }
            }
        } else {
            index = y / this.fixedItemHeight;
            List listData = listView.getListData();
            if (index >= listData.getLength()) {
                index = -1;
            }
        }
        return index;
    }

    public Bounds getItemBounds(int index) {
        return new Bounds(0, this.getItemY(index), this.getWidth(), this.getItemHeight(index));
    }

    public int getItemIndent() {
        int itemIndent = 0;
        ListView listView = (ListView)this.getComponent();
        if (listView.getCheckmarksEnabled()) {
            itemIndent = CHECKBOX.getWidth() + this.checkboxPadding.left + this.checkboxPadding.right;
        }
        return itemIndent;
    }

    private int getItemY(int index) {
        int itemY = this.variableItemHeight ? (index == 0 ? 0 : (Integer)this.itemBoundaries.get(index - 1)) : index * this.fixedItemHeight;
        return itemY;
    }

    private int getItemHeight(int index) {
        int itemHeight;
        if (this.variableItemHeight) {
            itemHeight = (Integer)this.itemBoundaries.get(index);
            if (index > 0) {
                itemHeight -= ((Integer)this.itemBoundaries.get(index - 1)).intValue();
            }
        } else {
            itemHeight = this.fixedItemHeight;
        }
        return itemHeight;
    }

    public boolean isFocusable() {
        ListView listView = (ListView)this.getComponent();
        return listView.getSelectMode() != ListView.SelectMode.NONE;
    }

    public boolean isOpaque() {
        return this.backgroundColor != null && this.backgroundColor.getTransparency() == 1;
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraListViewSkin.decodeFont((String)font));
    }

    public final void setFont(Dictionary<String, ?> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(font));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)color));
    }

    public final void setColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setColor(theme.getColor(color));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = disabledColor;
        this.repaintComponent();
    }

    public final void setDisabledColor(String disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)disabledColor));
    }

    public final void setDisabledColor(int disabledColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setDisabledColor(theme.getColor(disabledColor));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.repaintComponent();
    }

    public final void setBackgroundColor(String backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor((String)backgroundColor));
    }

    public final void setBackgroundColor(int backgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(theme.getColor(backgroundColor));
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color selectionColor) {
        if (selectionColor == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.selectionColor = selectionColor;
        this.repaintComponent();
    }

    public final void setSelectionColor(String selectionColor) {
        if (selectionColor == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.setSelectionColor(GraphicsUtilities.decodeColor((String)selectionColor));
    }

    public final void setSelectionColor(int selectionColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setSelectionColor(theme.getColor(selectionColor));
    }

    public Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    public void setSelectionBackgroundColor(Color selectionBackgroundColor) {
        if (selectionBackgroundColor == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.selectionBackgroundColor = selectionBackgroundColor;
        this.repaintComponent();
    }

    public final void setSelectionBackgroundColor(String selectionBackgroundColor) {
        if (selectionBackgroundColor == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.setSelectionBackgroundColor(GraphicsUtilities.decodeColor((String)selectionBackgroundColor));
    }

    public final void setSelectionBackgroundColor(int selectionBackgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setSelectionBackgroundColor(theme.getColor(selectionBackgroundColor));
    }

    public Color getInactiveSelectionColor() {
        return this.inactiveSelectionColor;
    }

    public void setInactiveSelectionColor(Color inactiveSelectionColor) {
        if (inactiveSelectionColor == null) {
            throw new IllegalArgumentException("inactiveSelectionColor is null.");
        }
        this.inactiveSelectionColor = inactiveSelectionColor;
        this.repaintComponent();
    }

    public final void setInactiveSelectionColor(String inactiveSelectionColor) {
        if (inactiveSelectionColor == null) {
            throw new IllegalArgumentException("inactiveSelectionColor is null.");
        }
        this.setInactiveSelectionColor(GraphicsUtilities.decodeColor((String)inactiveSelectionColor));
    }

    public final void setInactiveSelectionColor(int inactiveSelectionColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setInactiveSelectionColor(theme.getColor(inactiveSelectionColor));
    }

    public Color getInactiveSelectionBackgroundColor() {
        return this.inactiveSelectionBackgroundColor;
    }

    public void setInactiveSelectionBackgroundColor(Color inactiveSelectionBackgroundColor) {
        if (inactiveSelectionBackgroundColor == null) {
            throw new IllegalArgumentException("inactiveSelectionBackgroundColor is null.");
        }
        this.inactiveSelectionBackgroundColor = inactiveSelectionBackgroundColor;
        this.repaintComponent();
    }

    public final void setInactiveSelectionBackgroundColor(String inactiveSelectionBackgroundColor) {
        if (inactiveSelectionBackgroundColor == null) {
            throw new IllegalArgumentException("inactiveSelectionBackgroundColor is null.");
        }
        this.setInactiveSelectionBackgroundColor(GraphicsUtilities.decodeColor((String)inactiveSelectionBackgroundColor));
    }

    public final void setInactiveSelectionBackgroundColor(int inactiveSelectionBackgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setInactiveSelectionBackgroundColor(theme.getColor(inactiveSelectionBackgroundColor));
    }

    public Color getHighlightBackgroundColor() {
        return this.highlightBackgroundColor;
    }

    public void setHighlightBackgroundColor(Color highlightBackgroundColor) {
        if (highlightBackgroundColor == null) {
            throw new IllegalArgumentException("highlightBackgroundColor is null.");
        }
        this.highlightBackgroundColor = highlightBackgroundColor;
        this.repaintComponent();
    }

    public final void setHighlightBackgroundColor(String highlightBackgroundColor) {
        if (highlightBackgroundColor == null) {
            throw new IllegalArgumentException("highlightBackgroundColor is null.");
        }
        this.setHighlightBackgroundColor(GraphicsUtilities.decodeColor((String)highlightBackgroundColor));
    }

    public final void setHighlightBackgroundColor(int highlightBackgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setHighlightBackgroundColor(theme.getColor(highlightBackgroundColor));
    }

    public Color getAlternateItemBackgroundColor() {
        return this.alternateItemBackgroundColor;
    }

    public void setAlternateItemBackgroundColor(Color alternateItemBackgroundColor) {
        this.alternateItemBackgroundColor = alternateItemBackgroundColor;
        this.repaintComponent();
    }

    public final void setAlternateItemBackgroundColor(String alternateItemBackgroundColor) {
        if (alternateItemBackgroundColor == null) {
            throw new IllegalArgumentException("alternateItemBackgroundColor is null.");
        }
        this.setAlternateItemBackgroundColor(GraphicsUtilities.decodeColor((String)alternateItemBackgroundColor));
    }

    public final void setAlternateItemColor(int alternateItemBackgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setAlternateItemBackgroundColor(theme.getColor(alternateItemBackgroundColor));
    }

    public boolean getShowHighlight() {
        return this.showHighlight;
    }

    public void setShowHighlight(boolean showHighlight) {
        this.showHighlight = showHighlight;
        this.repaintComponent();
    }

    public boolean getWrapSelectNext() {
        return this.wrapSelectNext;
    }

    public void setWrapSelectNext(boolean wrapSelectNext) {
        this.wrapSelectNext = wrapSelectNext;
    }

    public Insets getCheckboxPadding() {
        return this.checkboxPadding;
    }

    public void setCheckboxPadding(Insets checkboxPadding) {
        if (checkboxPadding == null) {
            throw new IllegalArgumentException("checkboxPadding is null.");
        }
        this.checkboxPadding = checkboxPadding;
        this.invalidateComponent();
    }

    public final void setCheckboxPadding(Dictionary<String, ?> checkboxPadding) {
        if (checkboxPadding == null) {
            throw new IllegalArgumentException("checkboxPadding is null.");
        }
        this.setCheckboxPadding(new Insets(checkboxPadding));
    }

    public final void setCheckboxPadding(int checkboxPadding) {
        this.setCheckboxPadding(new Insets(checkboxPadding));
    }

    public final void setCheckboxPadding(Number padding) {
        if (padding == null) {
            throw new IllegalArgumentException("checkboxPadding is null.");
        }
        this.setCheckboxPadding(padding.intValue());
    }

    public final void setCheckboxPadding(String checkboxPadding) {
        if (checkboxPadding == null) {
            throw new IllegalArgumentException("checkboxPadding is null.");
        }
        this.setCheckboxPadding(Insets.decode((String)checkboxPadding));
    }

    public boolean isVariableItemHeight() {
        return this.variableItemHeight;
    }

    public void setVariableItemHeight(boolean variableItemHeight) {
        this.variableItemHeight = variableItemHeight;
        this.invalidateComponent();
    }

    public boolean mouseMove(Component component, int x, int y) {
        boolean consumed = super.mouseMove(component, x, y);
        ListView listView = (ListView)this.getComponent();
        int previousHighlightIndex = this.highlightIndex;
        this.highlightIndex = this.getItemAt(y);
        if (previousHighlightIndex != this.highlightIndex && listView.getSelectMode() != ListView.SelectMode.NONE && this.showHighlight) {
            if (previousHighlightIndex != -1) {
                this.repaintComponent(this.getItemBounds(previousHighlightIndex));
            }
            if (this.highlightIndex != -1) {
                this.repaintComponent(this.getItemBounds(this.highlightIndex));
            }
        }
        return consumed;
    }

    public void mouseOut(Component component) {
        super.mouseOut(component);
        ListView listView = (ListView)this.getComponent();
        if (this.highlightIndex != -1 && listView.getSelectMode() != ListView.SelectMode.NONE && this.showHighlight) {
            Bounds itemBounds = this.getItemBounds(this.highlightIndex);
            this.repaintComponent(itemBounds.x, itemBounds.y, itemBounds.width, itemBounds.height);
        }
        this.highlightIndex = -1;
        this.selectIndex = -1;
    }

    public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseDown(component, button, x, y);
        ListView listView = (ListView)this.getComponent();
        int itemIndex = this.getItemAt(y);
        if (!(itemIndex == -1 || listView.isItemDisabled(itemIndex) || listView.getCheckmarksEnabled() && !listView.isCheckmarkDisabled(itemIndex) && this.getCheckboxBounds(itemIndex).contains(x, y))) {
            ListView.SelectMode selectMode = listView.getSelectMode();
            if (button == Mouse.Button.LEFT) {
                Keyboard.Modifier commandModifier = Platform.getCommandModifier();
                if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT) && selectMode == ListView.SelectMode.MULTI) {
                    Filter disabledItemFilter = listView.getDisabledItemFilter();
                    if (disabledItemFilter == null) {
                        ArrayList selectedRanges = new ArrayList();
                        int startIndex = listView.getFirstSelectedIndex();
                        int endIndex = listView.getLastSelectedIndex();
                        Span selectedRange = itemIndex > startIndex ? new Span(startIndex, itemIndex) : new Span(itemIndex, endIndex);
                        selectedRanges.add((Object)selectedRange);
                        listView.setSelectedRanges((Sequence)selectedRanges);
                    }
                } else if (Keyboard.isPressed((Keyboard.Modifier)commandModifier) && selectMode == ListView.SelectMode.MULTI) {
                    if (listView.isItemSelected(itemIndex)) {
                        listView.removeSelectedIndex(itemIndex);
                    } else {
                        listView.addSelectedIndex(itemIndex);
                    }
                } else if (Keyboard.isPressed((Keyboard.Modifier)commandModifier) && selectMode == ListView.SelectMode.SINGLE) {
                    if (listView.isItemSelected(itemIndex)) {
                        listView.setSelectedIndex(-1);
                    } else {
                        listView.setSelectedIndex(itemIndex);
                    }
                } else if (selectMode != ListView.SelectMode.NONE) {
                    if (listView.isItemSelected(itemIndex)) {
                        this.selectIndex = itemIndex;
                    } else {
                        listView.setSelectedIndex(itemIndex);
                    }
                }
            }
        }
        listView.requestFocus();
        return consumed;
    }

    public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseUp(component, button, x, y);
        ListView listView = (ListView)this.getComponent();
        if (this.selectIndex != -1 && listView.getFirstSelectedIndex() != listView.getLastSelectedIndex()) {
            listView.setSelectedIndex(this.selectIndex);
            this.selectIndex = -1;
        }
        return consumed;
    }

    public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
        boolean consumed = super.mouseClick(component, button, x, y, count);
        ListView listView = (ListView)this.getComponent();
        int itemIndex = this.getItemAt(y);
        if (itemIndex != -1 && !listView.isItemDisabled(itemIndex)) {
            ListView.ItemEditor itemEditor;
            if (listView.getCheckmarksEnabled() && !listView.isCheckmarkDisabled(itemIndex) && this.getCheckboxBounds(itemIndex).contains(x, y)) {
                listView.setItemChecked(itemIndex, !listView.isItemChecked(itemIndex));
            } else if (this.selectIndex != -1 && count == 1 && button == Mouse.Button.LEFT && (itemEditor = listView.getItemEditor()) != null) {
                if (itemEditor.isEditing()) {
                    itemEditor.endEdit(true);
                }
                itemEditor.beginEdit(listView, this.selectIndex);
            }
        }
        this.selectIndex = -1;
        return consumed;
    }

    private Bounds getCheckboxBounds(int itemIndex) {
        Bounds itemBounds = this.getItemBounds(itemIndex);
        int checkboxHeight = CHECKBOX.getHeight();
        return new Bounds(this.checkboxPadding.left, itemBounds.y + (itemBounds.height - checkboxHeight) / 2, CHECKBOX.getWidth(), checkboxHeight);
    }

    public boolean mouseWheel(Component component, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
        ListView listView = (ListView)this.getComponent();
        if (this.highlightIndex != -1) {
            Bounds itemBounds = this.getItemBounds(this.highlightIndex);
            this.highlightIndex = -1;
            if (listView.getSelectMode() != ListView.SelectMode.NONE && this.showHighlight) {
                this.repaintComponent(itemBounds.x, itemBounds.y, itemBounds.width, itemBounds.height, true);
            }
        }
        return super.mouseWheel(component, scrollType, scrollAmount, wheelRotation, x, y);
    }

    public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = super.keyPressed(component, keyCode, keyLocation);
        ListView listView = (ListView)this.getComponent();
        ListView.SelectMode selectMode = listView.getSelectMode();
        switch (keyCode) {
            case 38: {
                if (selectMode == ListView.SelectMode.NONE) break;
                int index = listView.getFirstSelectedIndex();
                int count = listView.getListData().getLength();
                while (--index >= 0 && listView.isItemDisabled(index)) {
                }
                if (index >= 0) {
                    if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT) && listView.getSelectMode() == ListView.SelectMode.MULTI) {
                        listView.addSelectedIndex(index);
                    } else {
                        listView.setSelectedIndex(index);
                    }
                } else if (!Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT) && listView.getSelectMode() == ListView.SelectMode.MULTI && count == listView.getSelectedItems().getLength()) {
                    index = listView.getLastSelectedIndex();
                    while (--index >= 0 && listView.isItemDisabled(index)) {
                    }
                    listView.setSelectedIndex(Math.max(0, index));
                }
                consumed = true;
                break;
            }
            case 40: {
                if (selectMode == ListView.SelectMode.NONE) break;
                int index = listView.getLastSelectedIndex();
                int count = listView.getListData().getLength();
                while (++index < count && listView.isItemDisabled(index)) {
                }
                if (index < count) {
                    if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT) && listView.getSelectMode() == ListView.SelectMode.MULTI) {
                        listView.addSelectedIndex(index);
                    } else {
                        listView.setSelectedIndex(index);
                    }
                } else if (!Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT) && listView.getSelectMode() == ListView.SelectMode.MULTI && count == listView.getSelectedItems().getLength()) {
                    index = 0;
                    while (++index < count && listView.isItemDisabled(index)) {
                    }
                    listView.setSelectedIndex(Math.min(count - 1, index));
                }
                consumed = true;
                break;
            }
        }
        if (this.highlightIndex != -1 && listView.getSelectMode() != ListView.SelectMode.NONE && this.showHighlight && consumed) {
            this.repaintComponent(this.getItemBounds(this.highlightIndex));
        }
        this.highlightIndex = -1;
        return consumed;
    }

    public boolean keyReleased(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = super.keyReleased(component, keyCode, keyLocation);
        ListView listView = (ListView)this.getComponent();
        switch (keyCode) {
            case 32: {
                int selectedIndex;
                if (!listView.getCheckmarksEnabled() || listView.getSelectMode() != ListView.SelectMode.SINGLE || listView.isCheckmarkDisabled(selectedIndex = listView.getSelectedIndex())) break;
                listView.setItemChecked(selectedIndex, !listView.isItemChecked(selectedIndex));
                consumed = true;
                break;
            }
        }
        return consumed;
    }

    public boolean keyTyped(Component component, char character) {
        char first;
        String string;
        int i;
        boolean consumed = super.keyTyped(component, character);
        ListView listView = (ListView)this.getComponent();
        List listData = listView.getListData();
        ListView.ItemRenderer itemRenderer = listView.getItemRenderer();
        char characterUpper = Character.toUpperCase(character);
        int n = listData.getLength();
        for (i = listView.getLastSelectedIndex() + 1; i < n; ++i) {
            if (listView.isItemDisabled(i) || (string = itemRenderer.toString(listData.get(i))) == null || string.length() <= 0 || (first = Character.toUpperCase(string.charAt(0))) != characterUpper) continue;
            listView.setSelectedIndex(i);
            consumed = true;
            break;
        }
        if (!consumed && this.wrapSelectNext) {
            n = listData.getLength();
            for (i = 0; i < n; ++i) {
                if (listView.isItemDisabled(i) || (string = itemRenderer.toString(listData.get(i))) == null || string.length() <= 0 || (first = Character.toUpperCase(string.charAt(0))) != characterUpper) continue;
                listView.setSelectedIndex(i);
                consumed = true;
                break;
            }
        }
        return consumed;
    }

    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.repaintComponent();
    }

    public void focusedChanged(Component component, Component obverseComponent) {
        super.focusedChanged(component, obverseComponent);
        this.repaintComponent();
    }

    public void listDataChanged(ListView listView, List<?> previousListData) {
        this.highlightIndex = -1;
        this.invalidateComponent();
    }

    public void itemRendererChanged(ListView listView, ListView.ItemRenderer previousItemRenderer) {
        this.invalidateComponent();
    }

    public void itemEditorChanged(ListView listView, ListView.ItemEditor previousItemEditor) {
    }

    public void selectModeChanged(ListView listView, ListView.SelectMode previousSelectMode) {
        this.repaintComponent();
    }

    public void checkmarksEnabledChanged(ListView listView) {
        this.invalidateComponent();
    }

    public void disabledItemFilterChanged(ListView listView, Filter<?> previousDisabledItemFilter) {
        this.repaintComponent();
    }

    public void disabledCheckmarkFilterChanged(ListView listView, Filter<?> previousDisabledCheckmarkFilter) {
        this.repaintComponent();
    }

    public void itemInserted(ListView listView, int index) {
        this.invalidateComponent();
    }

    public void itemsRemoved(ListView listView, int index, int count) {
        this.invalidateComponent();
    }

    public void itemUpdated(ListView listView, int index) {
        this.invalidateComponent();
    }

    public void itemsCleared(ListView listView) {
        this.invalidateComponent();
    }

    public void itemsSorted(ListView listView) {
        if (this.variableItemHeight) {
            this.invalidateComponent();
        } else {
            this.repaintComponent();
        }
    }

    public void itemCheckedChanged(ListView listView, int index) {
        this.repaintComponent(this.getItemBounds(index));
    }

    public void selectedRangeAdded(ListView listView, int rangeStart, int rangeEnd) {
        if (listView.isValid()) {
            Bounds selectionBounds = this.getItemBounds(rangeStart);
            selectionBounds = selectionBounds.union(this.getItemBounds(rangeEnd));
            this.repaintComponent(selectionBounds);
            Bounds visibleSelectionBounds = listView.getVisibleArea(selectionBounds);
            if (visibleSelectionBounds.height < selectionBounds.height) {
                listView.scrollAreaToVisible(selectionBounds);
            }
        } else {
            this.validateSelection = true;
        }
    }

    public void selectedRangeRemoved(ListView listView, int rangeStart, int rangeEnd) {
        if (listView.isValid()) {
            Bounds selectionBounds = this.getItemBounds(rangeStart);
            selectionBounds = selectionBounds.union(this.getItemBounds(rangeEnd));
            this.repaintComponent(selectionBounds);
        }
    }

    public void selectedRangesChanged(ListView listView, Sequence<Span> previousSelectedRanges) {
        if (previousSelectedRanges != null && previousSelectedRanges != listView.getSelectedRanges()) {
            if (listView.isValid()) {
                ImmutableList selectedRanges;
                if (previousSelectedRanges.getLength() > 0) {
                    int rangeStart = ((Span)previousSelectedRanges.get((int)0)).start;
                    int rangeEnd = ((Span)previousSelectedRanges.get((int)(previousSelectedRanges.getLength() - 1))).end;
                    Bounds previousSelectionBounds = this.getItemBounds(rangeStart);
                    previousSelectionBounds = previousSelectionBounds.union(this.getItemBounds(rangeEnd));
                    this.repaintComponent(previousSelectionBounds);
                }
                if ((selectedRanges = listView.getSelectedRanges()).getLength() > 0) {
                    int rangeStart = ((Span)selectedRanges.get((int)0)).start;
                    int rangeEnd = ((Span)selectedRanges.get((int)(selectedRanges.getLength() - 1))).end;
                    Bounds selectionBounds = this.getItemBounds(rangeStart);
                    selectionBounds = selectionBounds.union(this.getItemBounds(rangeEnd));
                    this.repaintComponent(selectionBounds);
                    Bounds visibleSelectionBounds = listView.getVisibleArea(selectionBounds);
                    if (visibleSelectionBounds != null && visibleSelectionBounds.height < selectionBounds.height) {
                        this.repaintComponent();
                        listView.scrollAreaToVisible(selectionBounds);
                    }
                }
            } else {
                this.validateSelection = true;
            }
        }
    }

    public void selectedItemChanged(ListView listView, Object previousSelectedItem) {
    }

    static {
        CHECKBOX.setSize(CHECKBOX.getPreferredSize());
    }
}

