/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.FocusTraversalPolicy;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Menu;
import org.apache.pivot.wtk.MenuListener;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.skin.ContainerSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraMenuSkin
extends ContainerSkin
implements MenuListener,
Menu.SectionListener {
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color activeColor;
    private Color activeBackgroundColor;
    private Color marginColor;
    private int margin;
    private Color separatorColor;
    private int sectionSpacing;
    private boolean showKeyboardShortcuts;

    public TerraMenuSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        Color backgroundColor = theme.getColor(4);
        backgroundColor = new Color(backgroundColor.getRed(), backgroundColor.getGreen(), backgroundColor.getBlue(), 228);
        this.setBackgroundColor(backgroundColor);
        this.font = theme.getFont();
        this.color = theme.getColor(1);
        this.disabledColor = theme.getColor(7);
        this.activeColor = theme.getColor(4);
        this.activeBackgroundColor = theme.getColor(14);
        this.marginColor = theme.getColor(11);
        this.marginColor = new Color(this.marginColor.getRed(), this.marginColor.getGreen(), this.marginColor.getBlue(), 228);
        this.margin = 20;
        this.separatorColor = theme.getColor(7);
        this.sectionSpacing = 7;
        this.showKeyboardShortcuts = true;
    }

    public void install(Component component) {
        super.install(component);
        Menu menu = (Menu)component;
        menu.getMenuListeners().add((Object)this);
        for (Menu.Section section : menu.getSections()) {
            section.getSectionListeners().add((Object)this);
        }
        menu.setFocusTraversalPolicy((FocusTraversalPolicy)new ContainerSkin.IndexFocusTraversalPolicy(true));
    }

    public boolean isFocusable() {
        return true;
    }

    public int getPreferredWidth(int height) {
        int preferredWidth = 0;
        Menu menu = (Menu)this.getComponent();
        Menu.SectionSequence sections = menu.getSections();
        int n = sections.getLength();
        for (int i = 0; i < n; ++i) {
            Menu.Section section = sections.get(i);
            for (Menu.Item item : section) {
                if (!item.isVisible()) continue;
                preferredWidth = Math.max(item.getPreferredWidth(-1), preferredWidth);
            }
        }
        return preferredWidth;
    }

    public int getPreferredHeight(int width) {
        int preferredHeight = 0;
        Menu menu = (Menu)this.getComponent();
        Menu.SectionSequence sections = menu.getSections();
        int n = sections.getLength();
        for (int i = 0; i < n; ++i) {
            Menu.Section section = sections.get(i);
            for (Menu.Item item : section) {
                if (!item.isVisible()) continue;
                preferredHeight += item.getPreferredHeight(width);
            }
            if (i <= 0) continue;
            preferredHeight += this.sectionSpacing;
        }
        return preferredHeight;
    }

    public Dimensions getPreferredSize() {
        int preferredWidth = 0;
        int preferredHeight = 0;
        Menu menu = (Menu)this.getComponent();
        Menu.SectionSequence sections = menu.getSections();
        int n = sections.getLength();
        for (int i = 0; i < n; ++i) {
            Menu.Section section = sections.get(i);
            for (Menu.Item item : section) {
                if (!item.isVisible()) continue;
                preferredWidth = Math.max(item.getPreferredWidth(), preferredWidth);
                preferredHeight += item.getPreferredHeight();
            }
            if (i <= 0) continue;
            preferredHeight += this.sectionSpacing;
        }
        return new Dimensions(preferredWidth, preferredHeight);
    }

    public void layout() {
        Menu menu = (Menu)this.getComponent();
        Menu.SectionSequence sections = menu.getSections();
        int width = this.getWidth();
        int itemY = 0;
        int n = sections.getLength();
        for (int i = 0; i < n; ++i) {
            Menu.Section section = sections.get(i);
            for (Menu.Item item : section) {
                if (!item.isVisible()) continue;
                item.setSize(width, item.getPreferredHeight(width));
                item.setLocation(0, itemY);
                itemY += item.getHeight();
            }
            itemY += this.sectionSpacing;
        }
    }

    public void paint(Graphics2D graphics) {
        super.paint(graphics);
        Menu menu = (Menu)this.getComponent();
        int width = this.getWidth();
        int height = this.getHeight();
        if (this.marginColor != null) {
            graphics.setColor(this.marginColor);
            graphics.fillRect(0, 0, this.margin, height);
        }
        Menu.SectionSequence sections = menu.getSections();
        int n = sections.getLength();
        for (int i = 0; i < n; ++i) {
            Menu.Section section = sections.get(i);
            if (section.getLength() <= 0) continue;
            Menu.Item item = section.get(section.getLength() - 1);
            int separatorY = item.getY() + item.getHeight() + this.sectionSpacing / 2;
            graphics.setColor(this.separatorColor);
            graphics.drawLine(1, separatorY, width - 2, separatorY);
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraMenuSkin.decodeFont((String)font));
    }

    public final void setFont(Dictionary<String, ?> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(font));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)color));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = disabledColor;
        this.repaintComponent();
    }

    public final void setDisabledColor(String disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)disabledColor));
    }

    public Color getActiveColor() {
        return this.activeColor;
    }

    public void setActiveColor(Color activeColor) {
        if (activeColor == null) {
            throw new IllegalArgumentException("activeColor is null.");
        }
        this.activeColor = activeColor;
        this.repaintComponent();
    }

    public final void setActiveColor(String activeColor) {
        if (activeColor == null) {
            throw new IllegalArgumentException("activeColor is null.");
        }
        this.setActiveColor(GraphicsUtilities.decodeColor((String)activeColor));
    }

    public Color getActiveBackgroundColor() {
        return this.activeBackgroundColor;
    }

    public void setActiveBackgroundColor(Color activeBackgroundColor) {
        if (activeBackgroundColor == null) {
            throw new IllegalArgumentException("activeBackgroundColor is null.");
        }
        this.activeBackgroundColor = activeBackgroundColor;
        this.repaintComponent();
    }

    public final void setActiveBackgroundColor(String activeBackgroundColor) {
        if (activeBackgroundColor == null) {
            throw new IllegalArgumentException("activeBackgroundColor is null.");
        }
        this.setActiveBackgroundColor(GraphicsUtilities.decodeColor((String)activeBackgroundColor));
    }

    public Color getMarginColor() {
        return this.marginColor;
    }

    public void setMarginColor(Color marginColor) {
        this.marginColor = marginColor;
        this.repaintComponent();
    }

    public int getMargin() {
        return this.margin;
    }

    public void setMargin(int margin) {
        if (margin < 0) {
            throw new IllegalArgumentException("margin is negative.");
        }
        this.margin = margin;
        this.invalidateComponent();
    }

    public Color getSeparatorColor() {
        return this.separatorColor;
    }

    public void setSeparatorColor(Color separatorColor) {
        if (separatorColor == null) {
            throw new IllegalArgumentException("separatorColor is null.");
        }
        this.separatorColor = separatorColor;
        this.repaintComponent();
    }

    public int getSectionSpacing() {
        return this.sectionSpacing;
    }

    public void setSectionSpacing(int sectionSpacing) {
        if (sectionSpacing < 0) {
            throw new IllegalArgumentException("sectionSpacing is negative.");
        }
        this.sectionSpacing = sectionSpacing;
        this.invalidateComponent();
    }

    public boolean getShowKeyboardShortcuts() {
        return this.showKeyboardShortcuts;
    }

    public void setShowKeyboardShortcuts(boolean showKeyboardShortcuts) {
        this.showKeyboardShortcuts = showKeyboardShortcuts;
        this.invalidateComponent();
    }

    public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = super.keyPressed(component, keyCode, keyLocation);
        Menu menu = (Menu)component;
        if (keyCode == 38) {
            Menu.Section section;
            int itemIndex;
            int sectionIndex;
            Menu.SectionSequence sections = menu.getSections();
            int sectionCount = sections.getLength();
            Menu.Item activeItem = menu.getActiveItem();
            if (activeItem == null) {
                sectionIndex = sectionCount - 1;
                itemIndex = -1;
            } else {
                section = activeItem.getSection();
                sectionIndex = sections.indexOf(section);
                itemIndex = section.indexOf(activeItem) - 1;
                if (itemIndex == -1) {
                    --sectionIndex;
                }
            }
            while (sectionIndex >= 0) {
                section = sections.get(sectionIndex);
                if (itemIndex == -1) {
                    int sectionLength = section.getLength();
                    itemIndex = sectionLength - 1;
                }
                while (itemIndex >= 0) {
                    Menu.Item item = section.get(itemIndex);
                    if (item.isEnabled()) {
                        item.setActive(true);
                        break;
                    }
                    --itemIndex;
                }
                if (itemIndex >= 0) break;
                --sectionIndex;
            }
            consumed = true;
        } else if (keyCode == 40) {
            Menu.Section section;
            int itemIndex;
            int sectionIndex;
            Menu.SectionSequence sections = menu.getSections();
            int sectionCount = sections.getLength();
            Menu.Item activeItem = menu.getActiveItem();
            if (activeItem == null) {
                sectionIndex = 0;
                itemIndex = 0;
            } else {
                section = activeItem.getSection();
                sectionIndex = sections.indexOf(section);
                itemIndex = section.indexOf(activeItem) + 1;
            }
            while (sectionIndex < sectionCount) {
                section = sections.get(sectionIndex);
                int sectionLength = section.getLength();
                while (itemIndex < sectionLength) {
                    Menu.Item item = section.get(itemIndex);
                    if (item.isEnabled()) {
                        item.setActive(true);
                        break;
                    }
                    ++itemIndex;
                }
                if (itemIndex < sectionLength) break;
                ++sectionIndex;
                itemIndex = 0;
            }
            consumed = true;
        } else if (keyCode == 37) {
            if (menu.getItem() != null) {
                Window window = menu.getWindow();
                window.close();
                consumed = true;
            }
        } else if (keyCode == 39) {
            Menu.Item activeItem = menu.getActiveItem();
            if (activeItem != null && activeItem.getMenu() != null) {
                activeItem.press();
                consumed = true;
            }
        } else if (keyCode == 10) {
            Menu.Item activeItem = menu.getActiveItem();
            if (activeItem != null && activeItem.getMenu() == null) {
                activeItem.press();
                consumed = true;
            }
        } else if (keyCode == 9) {
            consumed = false;
        }
        return consumed;
    }

    public boolean keyReleased(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        Menu.Item activeItem;
        boolean consumed = super.keyReleased(component, keyCode, keyLocation);
        Menu menu = (Menu)component;
        if (keyCode == 32 && (activeItem = menu.getActiveItem()) != null && activeItem.getMenu() == null) {
            activeItem.press();
            consumed = true;
        }
        return consumed;
    }

    public boolean keyTyped(Component component, char character) {
        int itemIndex;
        int sectionIndex;
        boolean consumed = super.keyTyped(component, character);
        Menu menu = (Menu)component;
        Menu.SectionSequence sections = menu.getSections();
        int sectionCount = sections.getLength();
        Menu.Item activeItem = menu.getActiveItem();
        if (activeItem == null) {
            sectionIndex = 0;
            itemIndex = 0;
        } else {
            Menu.Section section = activeItem.getSection();
            sectionIndex = sections.indexOf(section);
            itemIndex = section.indexOf(activeItem) + 1;
        }
        char characterUpper = Character.toUpperCase(character);
        while (sectionIndex < sectionCount) {
            Menu.Section section = sections.get(sectionIndex);
            int sectionLength = section.getLength();
            while (itemIndex < sectionLength) {
                char first;
                Button.DataRenderer itemDataRenderer;
                String string;
                Menu.Item item = section.get(itemIndex);
                if (item.isEnabled() && (string = (itemDataRenderer = item.getDataRenderer()).toString(item.getButtonData())) != null && string.length() > 0 && (first = Character.toUpperCase(string.charAt(0))) == characterUpper) {
                    item.setActive(true);
                    consumed = true;
                    break;
                }
                ++itemIndex;
            }
            if (itemIndex < sectionLength) break;
            ++sectionIndex;
            itemIndex = 0;
        }
        return consumed;
    }

    public void sectionInserted(Menu menu, int index) {
        Menu.Section section = menu.getSections().get(index);
        section.getSectionListeners().add((Object)this);
        this.invalidateComponent();
    }

    public void sectionsRemoved(Menu menu, int index, Sequence<Menu.Section> removed) {
        int n = removed.getLength();
        for (int i = 0; i < n; ++i) {
            Menu.Section section = (Menu.Section)removed.get(i);
            section.getSectionListeners().remove((Object)this);
        }
        this.invalidateComponent();
    }

    public void itemInserted(Menu.Section section, int index) {
        this.invalidateComponent();
    }

    public void itemsRemoved(Menu.Section section, int index, Sequence<Menu.Item> removed) {
        this.invalidateComponent();
    }

    public void nameChanged(Menu.Section section, String previousName) {
    }

    public void activeItemChanged(Menu menu, Menu.Item previousActiveItem) {
    }
}

