/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import org.apache.pivot.beans.BXMLSerializer;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.util.Vote;
import org.apache.pivot.wtk.BoxPane;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.ButtonPressListener;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.ImageView;
import org.apache.pivot.wtk.Label;
import org.apache.pivot.wtk.MessageType;
import org.apache.pivot.wtk.Prompt;
import org.apache.pivot.wtk.PromptListener;
import org.apache.pivot.wtk.PushButton;
import org.apache.pivot.wtk.Sheet;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.Window;
import org.apache.pivot.wtk.skin.terra.TerraSheetSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraPromptSkin
extends TerraSheetSkin
implements PromptListener {
    private ImageView typeImageView = null;
    private Label messageLabel = null;
    private BoxPane messageBoxPane = null;
    private BoxPane optionButtonBoxPane = null;
    private ButtonPressListener optionButtonPressListener = new ButtonPressListener(){

        public void buttonPressed(Button button) {
            int optionIndex = TerraPromptSkin.this.optionButtonBoxPane.indexOf((Component)button);
            if (optionIndex >= 0) {
                Prompt prompt = (Prompt)TerraPromptSkin.this.getComponent();
                prompt.setSelectedOptionIndex(optionIndex);
                prompt.close(true);
            }
        }
    };

    public TerraPromptSkin() {
        this.setResizable(true);
    }

    @Override
    public void install(Component component) {
        Component content;
        super.install(component);
        Prompt prompt = (Prompt)component;
        prompt.setPreferredWidth(320);
        prompt.setMinimumWidth(160);
        prompt.getPromptListeners().add((Object)this);
        BXMLSerializer bxmlSerializer = new BXMLSerializer();
        try {
            content = (Component)bxmlSerializer.readObject(TerraPromptSkin.class, "terra_prompt_skin.bxml");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception);
        }
        prompt.setContent(content);
        this.typeImageView = (ImageView)bxmlSerializer.getNamespace().get((Object)"typeImageView");
        this.messageLabel = (Label)bxmlSerializer.getNamespace().get((Object)"messageLabel");
        this.messageBoxPane = (BoxPane)bxmlSerializer.getNamespace().get((Object)"messageBoxPane");
        this.optionButtonBoxPane = (BoxPane)bxmlSerializer.getNamespace().get((Object)"optionButtonBoxPane");
        for (Object option : prompt.getOptions()) {
            PushButton optionButton = new PushButton(option);
            optionButton.setStyleName(TerraPromptSkin.class.getPackage().getName() + "." + "commandButton");
            optionButton.getButtonPressListeners().add((Object)this.optionButtonPressListener);
            this.optionButtonBoxPane.add((Component)optionButton);
        }
        this.messageTypeChanged(prompt, null);
        this.messageChanged(prompt, null);
        this.bodyChanged(prompt, null);
    }

    @Override
    public void windowOpened(Window window) {
        super.windowOpened(window);
        Prompt prompt = (Prompt)window;
        int index = prompt.getSelectedOptionIndex();
        if (index >= 0) {
            this.optionButtonBoxPane.get(index).requestFocus();
        } else {
            window.requestFocus();
        }
    }

    public void messageTypeChanged(Prompt prompt, MessageType previousMessageType) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.typeImageView.setImage(theme.getMessageIcon(prompt.getMessageType()));
    }

    public void messageChanged(Prompt prompt, String previousMessage) {
        String message = prompt.getMessage();
        this.messageLabel.setText(message != null ? message : "");
    }

    public void bodyChanged(Prompt prompt, Component previousBody) {
        Component body;
        if (previousBody != null) {
            this.messageBoxPane.remove(previousBody);
        }
        if ((body = prompt.getBody()) != null) {
            this.messageBoxPane.add(body);
        }
    }

    public void optionInserted(Prompt prompt, int index) {
        Object option = prompt.getOptions().get(index);
        PushButton optionButton = new PushButton(option);
        optionButton.setStyleName(TerraPromptSkin.class.getPackage().getName() + "." + "commandButton");
        optionButton.getButtonPressListeners().add((Object)this.optionButtonPressListener);
        this.optionButtonBoxPane.insert((Component)optionButton, index);
    }

    public void optionsRemoved(Prompt prompt, int index, Sequence<?> removed) {
        this.optionButtonBoxPane.remove(index, removed.getLength());
    }

    public void selectedOptionChanged(Prompt prompt, int previousSelectedOption) {
        int index = prompt.getSelectedOptionIndex();
        if (prompt.isOpen() && index >= 0) {
            this.optionButtonBoxPane.get(index).requestFocus();
        }
    }

    public Vote previewWindowOpen(Window window) {
        Vote vote = super.previewWindowOpen(window);
        switch (vote) {
            case APPROVE: {
                this.messageTypeChanged((Prompt)window, null);
            }
        }
        return vote;
    }

    @Override
    public void sheetClosed(Sheet sheet) {
        super.sheetClosed(sheet);
        this.typeImageView.clearImage();
    }
}

