/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.RadioButton;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.skin.RadioButtonSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraRadioButtonSkin
extends RadioButtonSkin {
    private Font font;
    private Color color;
    private Color disabledColor;
    private int spacing;
    private Color buttonColor;
    private Color buttonBorderColor;
    private Color buttonSelectionColor;
    private Color disabledButtonColor;
    private Color disabledButtonBorderColor;
    private Color disabledButtonSelectionColor;
    private static final int BUTTON_DIAMETER = 14;
    private static final int BUTTON_SELECTION_DIAMETER = 6;

    public TerraRadioButtonSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.font = theme.getFont();
        this.color = theme.getColor(1);
        this.disabledColor = theme.getColor(7);
        this.spacing = 3;
        this.buttonColor = theme.getColor(4);
        this.buttonBorderColor = theme.getColor(7);
        this.buttonSelectionColor = theme.getColor(15);
        this.disabledButtonColor = theme.getColor(3);
        this.disabledButtonBorderColor = theme.getColor(7);
        this.disabledButtonSelectionColor = theme.getColor(7);
    }

    public int getPreferredWidth(int height) {
        RadioButton radioButton = (RadioButton)this.getComponent();
        Button.DataRenderer dataRenderer = radioButton.getDataRenderer();
        int preferredWidth = 14;
        Object buttonData = radioButton.getButtonData();
        if (buttonData != null) {
            dataRenderer.render(buttonData, (Button)radioButton, false);
            preferredWidth += dataRenderer.getPreferredWidth(height) + this.spacing * 2;
        }
        return preferredWidth;
    }

    public int getPreferredHeight(int width) {
        RadioButton radioButton = (RadioButton)this.getComponent();
        Button.DataRenderer dataRenderer = radioButton.getDataRenderer();
        int preferredHeight = 14;
        Object buttonData = radioButton.getButtonData();
        if (buttonData != null) {
            if (width != -1) {
                width = Math.max(width - (14 + this.spacing), 0);
            }
            dataRenderer.render(buttonData, (Button)radioButton, false);
            preferredHeight = Math.max(preferredHeight, dataRenderer.getPreferredHeight(width));
        }
        return preferredHeight;
    }

    public Dimensions getPreferredSize() {
        RadioButton radioButton = (RadioButton)this.getComponent();
        Button.DataRenderer dataRenderer = radioButton.getDataRenderer();
        int preferredWidth = 14;
        int preferredHeight = 14;
        Object buttonData = radioButton.getButtonData();
        if (buttonData != null) {
            dataRenderer.render(buttonData, (Button)radioButton, false);
            preferredWidth += dataRenderer.getPreferredWidth(-1) + this.spacing * 2;
            preferredHeight = Math.max(preferredHeight, dataRenderer.getPreferredHeight(-1));
        }
        return new Dimensions(preferredWidth, preferredHeight);
    }

    public int getBaseline(int width, int height) {
        RadioButton radioButton = (RadioButton)this.getComponent();
        int baseline = -1;
        Button.DataRenderer dataRenderer = radioButton.getDataRenderer();
        dataRenderer.render(radioButton.getButtonData(), (Button)radioButton, false);
        int clientWidth = Math.max(width - (14 + this.spacing), 0);
        baseline = dataRenderer.getBaseline(clientWidth, height);
        return baseline;
    }

    public void paint(Graphics2D graphics) {
        RadioButton radioButton = (RadioButton)this.getComponent();
        int width = this.getWidth();
        int height = this.getHeight();
        int offset = (height - 14) / 2;
        graphics.translate(0, offset);
        this.paintButton(graphics, radioButton.isEnabled(), radioButton.isSelected());
        graphics.translate(0, -offset);
        Button.DataRenderer dataRenderer = radioButton.getDataRenderer();
        Object buttonData = radioButton.getButtonData();
        dataRenderer.render(buttonData, (Button)radioButton, false);
        dataRenderer.setSize(Math.max(width - (14 + this.spacing * 2), 0), height);
        Graphics2D contentGraphics = (Graphics2D)graphics.create();
        contentGraphics.translate(14 + this.spacing, 0);
        contentGraphics.clipRect(0, 0, dataRenderer.getWidth(), dataRenderer.getHeight());
        dataRenderer.paint(contentGraphics);
        contentGraphics.dispose();
        if (radioButton.isFocused()) {
            if (buttonData == null) {
                Color focusColor = new Color(this.buttonSelectionColor.getRed(), this.buttonSelectionColor.getGreen(), this.buttonSelectionColor.getBlue(), 68);
                graphics.setColor(focusColor);
                graphics.fillOval(0, 0, 13, 13);
            } else {
                BasicStroke dashStroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{0.0f, 2.0f}, 0.0f);
                graphics.setStroke(dashStroke);
                graphics.setColor(this.buttonBorderColor);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                Rectangle2D.Double focusRectangle = new Rectangle2D.Double(15.0, 0.5, dataRenderer.getWidth() + this.spacing * 2 - 2, dataRenderer.getHeight() - 1);
                graphics.draw(focusRectangle);
            }
        }
    }

    private void paintButton(Graphics2D graphics, boolean enabled, boolean selected) {
        Paint buttonPaint;
        Color buttonBorderColorLocal = null;
        Color buttonSelectionColorLocal = null;
        Ellipse2D.Double buttonBackgroundCircle = new Ellipse2D.Double(1.0, 1.0, 11.0, 11.0);
        if (enabled) {
            buttonPaint = new RadialGradientPaint((float)buttonBackgroundCircle.getCenterX(), (float)buttonBackgroundCircle.getCenterY(), (float)((RectangularShape)buttonBackgroundCircle).getWidth() * 2.0f / 3.0f, new float[]{0.0f, 1.0f}, new Color[]{TerraTheme.darken(this.buttonColor), this.buttonColor});
            buttonBorderColorLocal = this.buttonBorderColor;
            buttonSelectionColorLocal = this.buttonSelectionColor;
        } else {
            buttonPaint = this.disabledButtonColor;
            buttonBorderColorLocal = this.disabledButtonBorderColor;
            buttonSelectionColorLocal = this.disabledButtonSelectionColor;
        }
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics.setColor(buttonBorderColorLocal);
        graphics.fillOval(0, 0, 13, 13);
        graphics.setPaint(buttonPaint);
        graphics.fill(buttonBackgroundCircle);
        if (selected) {
            Ellipse2D.Double buttonSelectionCircle = new Ellipse2D.Double(4.0, 4.0, 5.0, 5.0);
            graphics.setColor(buttonSelectionColorLocal);
            graphics.fill(buttonSelectionCircle);
        }
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraRadioButtonSkin.decodeFont((String)font));
    }

    public final void setFont(Dictionary<String, ?> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(font));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)color));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = disabledColor;
        this.repaintComponent();
    }

    public final void setDisabledColor(String disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)disabledColor));
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        if (spacing < 0) {
            throw new IllegalArgumentException("spacing is negative.");
        }
        this.spacing = spacing;
        this.invalidateComponent();
    }

    public final void setSpacing(Number spacing) {
        if (spacing == null) {
            throw new IllegalArgumentException("spacing is null.");
        }
        this.setSpacing(spacing.intValue());
    }
}

