/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.List;
import org.apache.pivot.wtk.ApplicationContext;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.Dimensions;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Skin;
import org.apache.pivot.wtk.Spinner;
import org.apache.pivot.wtk.SpinnerListener;
import org.apache.pivot.wtk.SpinnerSelectionListener;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.media.Image;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.skin.ContainerSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraSpinnerSkin
extends ContainerSkin
implements Spinner.Skin,
SpinnerListener,
SpinnerSelectionListener {
    private SpinnerContent spinnerContent = new SpinnerContent();
    private SpinButton upButton = new SpinButton(1, new SpinUpImage());
    private SpinButton downButton = new SpinButton(-1, new SpinDownImage());
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color borderColor;
    private Color buttonColor;
    private Color buttonBackgroundColor;
    private boolean sizeToContent = false;
    private Color buttonBevelColor;
    private static AutomaticSpinner automaticSpinner = new AutomaticSpinner();
    public static final int BUTTON_IMAGE_SIZE = 5;

    public TerraSpinnerSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(theme.getColor(4));
        this.font = theme.getFont();
        this.color = theme.getColor(1);
        this.disabledColor = theme.getColor(7);
        this.borderColor = theme.getColor(7);
        this.buttonColor = theme.getColor(1);
        this.buttonBackgroundColor = theme.getColor(10);
        this.buttonBevelColor = TerraTheme.brighten(this.buttonBackgroundColor);
    }

    public void setSize(int width, int height) {
        int previousWidth = this.getWidth();
        int previousHeight = this.getHeight();
        super.setSize(width, height);
        if (previousWidth != width || previousHeight != height) {
            automaticSpinner.stop();
        }
    }

    public void install(Component component) {
        super.install(component);
        Spinner spinner = (Spinner)component;
        spinner.getSpinnerListeners().add((Object)this);
        spinner.getSpinnerSelectionListeners().add((Object)this);
        spinner.add((Component)this.spinnerContent);
        spinner.add((Component)this.upButton);
        spinner.add((Component)this.downButton);
    }

    public int getPreferredWidth(int height) {
        int preferredWidth = 2;
        int buttonHeight = height < 0 ? -1 : height / 2;
        preferredWidth += Math.max(this.upButton.getPreferredWidth(buttonHeight), this.downButton.getPreferredWidth(buttonHeight));
        if (height >= 0) {
            height = Math.max(height - 2, 0);
        }
        return preferredWidth += this.spinnerContent.getPreferredWidth(height);
    }

    public int getPreferredHeight(int width) {
        Dimensions upButtonPreferredSize = this.upButton.getPreferredSize();
        Dimensions downButtonPreferredSize = this.downButton.getPreferredSize();
        int preferredHeight = Math.max(upButtonPreferredSize.height, downButtonPreferredSize.height) * 2;
        if (width >= 0) {
            int buttonWidth = Math.max(upButtonPreferredSize.width, downButtonPreferredSize.width);
            width = Math.max(width - buttonWidth - 2, 0);
        }
        preferredHeight = Math.max(preferredHeight, this.spinnerContent.getPreferredHeight(width)) + 1;
        return preferredHeight;
    }

    public int getBaseline(int width, int height) {
        int clientHeight;
        Dimensions upButtonPreferredSize = this.upButton.getPreferredSize();
        Dimensions downButtonPreferredSize = this.downButton.getPreferredSize();
        int buttonWidth = Math.max(upButtonPreferredSize.width, downButtonPreferredSize.width);
        int clientWidth = Math.max(width - buttonWidth - 2, 0);
        int baseline = this.spinnerContent.getBaseline(clientWidth, clientHeight = Math.max(height - 2, 0));
        if (baseline != -1) {
            ++baseline;
        }
        return baseline;
    }

    public void layout() {
        int width = this.getWidth();
        int height = this.getHeight();
        int buttonHeight = Math.max((height - 3) / 2, 0);
        int buttonWidth = Math.max(this.upButton.getPreferredWidth(buttonHeight), this.downButton.getPreferredWidth(buttonHeight));
        this.spinnerContent.setSize(Math.max(width - buttonWidth - 3, 0), Math.max(height - 2, 0));
        this.spinnerContent.setLocation(1, 1);
        this.upButton.setSize(buttonWidth, buttonHeight);
        this.upButton.setLocation(width - buttonWidth - 1, 1);
        this.downButton.setSize(buttonWidth, Math.max(height - buttonHeight - 3, 0));
        this.downButton.setLocation(width - buttonWidth - 1, buttonHeight + 2);
    }

    public void paint(Graphics2D graphics) {
        super.paint(graphics);
        int width = this.getWidth();
        int height = this.getHeight();
        int buttonX = this.upButton.getX();
        int buttonWidth = this.upButton.getWidth();
        int buttonHeight = this.upButton.getHeight();
        graphics.setPaint(new GradientPaint(buttonX + buttonWidth / 2, 0.0f, this.buttonBevelColor, buttonX + buttonWidth / 2, buttonHeight, this.buttonBackgroundColor));
        graphics.fillRect(buttonX, 0, buttonWidth, height);
        graphics.setPaint(this.borderColor);
        GraphicsUtilities.drawRect((Graphics2D)graphics, (int)0, (int)0, (int)width, (int)height);
        GraphicsUtilities.drawLine((Graphics2D)graphics, (int)(width - buttonWidth - 2), (int)0, (int)height, (Orientation)Orientation.VERTICAL);
        GraphicsUtilities.drawLine((Graphics2D)graphics, (int)(width - buttonWidth - 2), (int)(buttonHeight + 1), (int)(buttonWidth + 1), (Orientation)Orientation.HORIZONTAL);
    }

    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.repaintComponent();
    }

    public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
        this.spinnerContent.requestFocus();
        return false;
    }

    protected void invalidateContent() {
        this.spinnerContent.invalidate();
        this.spinnerContent.repaint();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public final void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)color));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = disabledColor;
        this.repaintComponent();
    }

    public final void setDisabledColor(String disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)disabledColor));
    }

    public Color getBorderColor() {
        return this.borderColor;
    }

    public void setBorderColor(Color borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.borderColor = borderColor;
        this.repaintComponent();
    }

    public final void setBorderColor(String borderColor) {
        if (borderColor == null) {
            throw new IllegalArgumentException("borderColor is null.");
        }
        this.setBorderColor(GraphicsUtilities.decodeColor((String)borderColor));
    }

    public Color getButtonColor() {
        return this.buttonColor;
    }

    public void setButtonImageColor(Color buttonColor) {
        this.buttonColor = buttonColor;
        this.repaintComponent();
    }

    public final void setButtonColor(String buttonColor) {
        if (buttonColor == null) {
            throw new IllegalArgumentException("buttonColor is null");
        }
        this.setButtonImageColor(GraphicsUtilities.decodeColor((String)buttonColor));
    }

    public Color getButtonBackgroundColor() {
        return this.buttonBackgroundColor;
    }

    public void setButtonBackgroundColor(Color buttonBackgroundColor) {
        this.buttonBackgroundColor = buttonBackgroundColor;
        this.repaintComponent();
    }

    public final void setButtonBackgroundColor(String buttonBackgroundColor) {
        if (buttonBackgroundColor == null) {
            throw new IllegalArgumentException("buttonBackgroundColor is null");
        }
        this.setButtonBackgroundColor(GraphicsUtilities.decodeColor((String)buttonBackgroundColor));
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateContent();
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraSpinnerSkin.decodeFont((String)font));
    }

    public final void setFont(Dictionary<String, ?> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(font));
    }

    public boolean isSizeToContent() {
        return this.sizeToContent;
    }

    public void setSizeToContent(boolean sizeToContent) {
        this.sizeToContent = sizeToContent;
        this.invalidateContent();
    }

    public Bounds getContentBounds() {
        return this.spinnerContent.getBounds();
    }

    public void spinnerDataChanged(Spinner spinner, List<?> previousSpinnerData) {
        this.invalidateContent();
    }

    public void itemRendererChanged(Spinner spinner, Spinner.ItemRenderer previousItemRenderer) {
        this.invalidateContent();
    }

    public void circularChanged(Spinner spinner) {
    }

    public void selectedIndexChanged(Spinner spinner, int previousSelectedIndex) {
    }

    public void selectedItemChanged(Spinner spinner, Object previousSelectedItem) {
        this.invalidateContent();
    }

    protected class SpinDownImage
    extends SpinButtonImage {
        protected SpinDownImage() {
        }

        @Override
        public void paint(Graphics2D graphics) {
            super.paint(graphics);
            int[] xPoints = new int[]{0, 2, 4};
            int[] yPoints = new int[]{1, 3, 1};
            graphics.fillPolygon(xPoints, yPoints, 3);
            graphics.drawPolygon(xPoints, yPoints, 3);
        }
    }

    protected class SpinUpImage
    extends SpinButtonImage {
        protected SpinUpImage() {
        }

        @Override
        public void paint(Graphics2D graphics) {
            super.paint(graphics);
            int[] xPoints = new int[]{0, 2, 4};
            int[] yPoints = new int[]{3, 1, 3};
            graphics.fillPolygon(xPoints, yPoints, 3);
            graphics.drawPolygon(xPoints, yPoints, 3);
        }
    }

    protected abstract class SpinButtonImage
    extends Image {
        protected SpinButtonImage() {
        }

        public int getWidth() {
            return 5;
        }

        public int getHeight() {
            return 5;
        }

        public void paint(Graphics2D graphics) {
            graphics.setStroke(new BasicStroke(0.0f));
            graphics.setPaint(TerraSpinnerSkin.this.buttonColor);
        }
    }

    protected class SpinButtonSkin
    extends ComponentSkin {
        private boolean highlighted = false;
        private boolean pressed = false;

        protected SpinButtonSkin() {
        }

        public int getPreferredWidth(int height) {
            return 11;
        }

        public int getPreferredHeight(int width) {
            return 7;
        }

        public void layout() {
        }

        public void paint(Graphics2D graphics) {
            SpinButton spinButton = (SpinButton)this.getComponent();
            int width = this.getWidth();
            int height = this.getHeight();
            float alpha = this.pressed ? 0.5f : (this.highlighted ? 0.25f : 0.0f);
            graphics.setPaint(new Color(0.0f, 0.0f, 0.0f, alpha));
            graphics.fillRect(0, 0, width, height);
            SpinButtonImage buttonImage = (SpinButtonImage)spinButton.getButtonImage();
            graphics.translate((width - 5) / 2, (height - 5) / 2);
            buttonImage.paint(graphics);
        }

        public boolean isFocusable() {
            return false;
        }

        public boolean isOpaque() {
            return false;
        }

        public void enabledChanged(Component component) {
            super.enabledChanged(component);
            automaticSpinner.stop();
            this.pressed = false;
            this.highlighted = false;
            this.repaintComponent();
        }

        public void mouseOver(Component component) {
            super.mouseOver(component);
            this.highlighted = true;
            this.repaintComponent();
        }

        public void mouseOut(Component component) {
            super.mouseOut(component);
            automaticSpinner.stop();
            this.pressed = false;
            this.highlighted = false;
            this.repaintComponent();
        }

        public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
            boolean consumed = super.mouseDown(component, button, x, y);
            if (button == Mouse.Button.LEFT) {
                SpinButton spinButton = (SpinButton)this.getComponent();
                Spinner spinner = (Spinner)TerraSpinnerSkin.this.getComponent();
                automaticSpinner.start(spinner, spinButton.getDirection());
                this.pressed = true;
                this.repaintComponent();
            }
            return consumed;
        }

        public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
            boolean consumed = super.mouseUp(component, button, x, y);
            if (button == Mouse.Button.LEFT) {
                automaticSpinner.stop();
                this.pressed = false;
                this.repaintComponent();
            }
            return consumed;
        }
    }

    protected class SpinButton
    extends Component {
        private int direction;
        private Image buttonImage;

        public SpinButton(int direction, Image buttonImage) {
            this.direction = direction;
            this.buttonImage = buttonImage;
            this.setSkin((Skin)new SpinButtonSkin());
        }

        public int getDirection() {
            return this.direction;
        }

        public Image getButtonImage() {
            return this.buttonImage;
        }
    }

    protected class SpinnerContentSkin
    extends ComponentSkin {
        protected SpinnerContentSkin() {
        }

        public int getPreferredWidth(int height) {
            int preferredWidth = 0;
            Spinner spinner = (Spinner)TerraSpinnerSkin.this.getComponent();
            Spinner.ItemRenderer itemRenderer = spinner.getItemRenderer();
            if (TerraSpinnerSkin.this.sizeToContent) {
                List spinnerData = spinner.getSpinnerData();
                for (Object item : spinnerData) {
                    itemRenderer.render(item, spinner);
                    preferredWidth = Math.max(preferredWidth, itemRenderer.getPreferredWidth(height));
                }
            } else {
                itemRenderer.render(spinner.getSelectedItem(), spinner);
                preferredWidth = itemRenderer.getPreferredWidth(height);
            }
            return preferredWidth;
        }

        public int getPreferredHeight(int width) {
            int preferredHeight = 0;
            Spinner spinner = (Spinner)TerraSpinnerSkin.this.getComponent();
            Spinner.ItemRenderer itemRenderer = spinner.getItemRenderer();
            itemRenderer.render(spinner.getSelectedItem(), spinner);
            preferredHeight = itemRenderer.getPreferredHeight(width);
            return preferredHeight;
        }

        public int getBaseline(int width, int height) {
            Spinner spinner = (Spinner)TerraSpinnerSkin.this.getComponent();
            int baseline = -1;
            Spinner.ItemRenderer itemRenderer = spinner.getItemRenderer();
            itemRenderer.render(spinner.getSelectedItem(), spinner);
            baseline = itemRenderer.getBaseline(width, height);
            return baseline;
        }

        public Dimensions getPreferredSize() {
            Dimensions preferredSize;
            Spinner spinner = (Spinner)TerraSpinnerSkin.this.getComponent();
            Spinner.ItemRenderer itemRenderer = spinner.getItemRenderer();
            if (TerraSpinnerSkin.this.sizeToContent) {
                preferredSize = new Dimensions(this.getPreferredWidth(-1), this.getPreferredHeight(-1));
            } else {
                itemRenderer.render(spinner.getSelectedItem(), spinner);
                preferredSize = itemRenderer.getPreferredSize();
            }
            return preferredSize;
        }

        public void layout() {
        }

        public void paint(Graphics2D graphics) {
            SpinnerContent spinnerContentLocal = (SpinnerContent)this.getComponent();
            Spinner spinner = (Spinner)TerraSpinnerSkin.this.getComponent();
            int width = this.getWidth();
            int height = this.getHeight();
            Spinner.ItemRenderer itemRenderer = spinner.getItemRenderer();
            itemRenderer.render(spinner.getSelectedItem(), spinner);
            Graphics2D contentGraphics = (Graphics2D)graphics.create();
            itemRenderer.setSize(width, height);
            itemRenderer.paint(contentGraphics);
            contentGraphics.dispose();
            if (spinnerContentLocal.isFocused()) {
                BasicStroke dashStroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{0.0f, 2.0f}, 0.0f);
                graphics.setStroke(dashStroke);
                graphics.setColor(TerraSpinnerSkin.this.borderColor);
                graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                graphics.draw(new Rectangle2D.Double(1.0, 1.5, Math.max((double)width - 2.5, 0.0), Math.max(height - 3, 0)));
            }
        }

        public boolean isOpaque() {
            return false;
        }

        public void focusedChanged(Component component, Component obverseComponent) {
            super.focusedChanged(component, obverseComponent);
            this.repaintComponent();
        }

        public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
            int selectedIndex;
            boolean consumed = false;
            Spinner spinner = (Spinner)TerraSpinnerSkin.this.getComponent();
            boolean circular = spinner.isCircular();
            int count = spinner.getSpinnerData().getLength();
            int newSelectedIndex = selectedIndex = spinner.getSelectedIndex();
            if (keyCode == 38) {
                if (selectedIndex < count - 1) {
                    ++newSelectedIndex;
                } else if (circular) {
                    newSelectedIndex = 0;
                }
            } else if (keyCode == 40) {
                if (selectedIndex > 0) {
                    --newSelectedIndex;
                } else if (circular) {
                    newSelectedIndex = count - 1;
                }
            } else {
                consumed = super.keyPressed(component, keyCode, keyLocation);
            }
            if (newSelectedIndex != selectedIndex) {
                spinner.setSelectedIndex(newSelectedIndex);
                consumed = true;
            }
            return consumed;
        }

        public boolean keyTyped(Component component, char character) {
            boolean consumed = super.keyTyped(component, character);
            Spinner spinner = (Spinner)TerraSpinnerSkin.this.getComponent();
            List spinnerData = spinner.getSpinnerData();
            Spinner.ItemRenderer itemRenderer = spinner.getItemRenderer();
            char characterUpper = Character.toUpperCase(character);
            int n = spinnerData.getLength();
            for (int i = spinner.getSelectedIndex() + 1; i < n; ++i) {
                char first;
                String string = itemRenderer.toString(spinnerData.get(i));
                if (string == null || string.length() <= 0 || (first = Character.toUpperCase(string.charAt(0))) != characterUpper) continue;
                spinner.setSelectedIndex(i);
                consumed = true;
                break;
            }
            return consumed;
        }
    }

    protected class SpinnerContent
    extends Component {
        public SpinnerContent() {
            this.setSkin((Skin)new SpinnerContentSkin());
        }
    }

    private static class AutomaticSpinner {
        public Spinner spinner;
        public int direction;
        private ApplicationContext.ScheduledCallback scheduledSpinnerCallback = null;

        private AutomaticSpinner() {
        }

        public void start(Spinner spinnerArgument, int directionArgument) {
            assert (directionArgument != 0) : "Direction must be positive or negative";
            if (this.scheduledSpinnerCallback != null) {
                throw new IllegalStateException("Already running");
            }
            this.spinner = spinnerArgument;
            this.direction = directionArgument;
            this.scheduledSpinnerCallback = ApplicationContext.scheduleRecurringCallback((Runnable)new Runnable(){

                @Override
                public void run() {
                    AutomaticSpinner.this.spin();
                }
            }, (long)400L, (long)30L);
            this.spin();
        }

        private void spin() {
            boolean circular = this.spinner.isCircular();
            int selectedIndex = this.spinner.getSelectedIndex();
            int count = this.spinner.getSpinnerData().getLength();
            if (count < 1) {
                this.stop();
                return;
            }
            if (this.direction > 0) {
                if (selectedIndex < count - 1) {
                    this.spinner.setSelectedIndex(selectedIndex + 1);
                } else if (circular) {
                    this.spinner.setSelectedIndex(0);
                } else {
                    this.stop();
                }
            } else if (selectedIndex > 0) {
                this.spinner.setSelectedIndex(selectedIndex - 1);
            } else if (circular) {
                this.spinner.setSelectedIndex(count - 1);
            } else {
                this.stop();
            }
        }

        public void stop() {
            if (this.scheduledSpinnerCallback != null) {
                this.scheduledSpinnerCallback.cancel();
                this.scheduledSpinnerCallback = null;
            }
        }
    }
}

