/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pivot.wtk.skin.terra;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.pivot.collections.ArrayList;
import org.apache.pivot.collections.Dictionary;
import org.apache.pivot.collections.List;
import org.apache.pivot.collections.Sequence;
import org.apache.pivot.collections.immutable.ImmutableList;
import org.apache.pivot.util.Filter;
import org.apache.pivot.wtk.Bounds;
import org.apache.pivot.wtk.Button;
import org.apache.pivot.wtk.Checkbox;
import org.apache.pivot.wtk.Component;
import org.apache.pivot.wtk.GraphicsUtilities;
import org.apache.pivot.wtk.Keyboard;
import org.apache.pivot.wtk.Mouse;
import org.apache.pivot.wtk.Orientation;
import org.apache.pivot.wtk.Platform;
import org.apache.pivot.wtk.Theme;
import org.apache.pivot.wtk.TreeView;
import org.apache.pivot.wtk.TreeViewBranchListener;
import org.apache.pivot.wtk.TreeViewListener;
import org.apache.pivot.wtk.TreeViewNodeListener;
import org.apache.pivot.wtk.TreeViewNodeStateListener;
import org.apache.pivot.wtk.TreeViewSelectionListener;
import org.apache.pivot.wtk.skin.ComponentSkin;
import org.apache.pivot.wtk.skin.terra.TerraTheme;

public class TerraTreeViewSkin
extends ComponentSkin
implements TreeView.Skin,
TreeViewListener,
TreeViewBranchListener,
TreeViewNodeListener,
TreeViewNodeStateListener,
TreeViewSelectionListener {
    private BranchInfo rootBranchInfo = null;
    private List<NodeInfo> visibleNodes = new ArrayList();
    private NodeInfo highlightedNode = null;
    private Sequence.Tree.Path selectPath = null;
    private Font font;
    private Color color;
    private Color disabledColor;
    private Color backgroundColor;
    private Color selectionColor;
    private Color selectionBackgroundColor;
    private Color inactiveSelectionColor;
    private Color inactiveSelectionBackgroundColor;
    private Color highlightColor;
    private Color highlightBackgroundColor;
    private int spacing;
    private int indent;
    private boolean showHighlight;
    private boolean showBranchControls;
    private boolean showEmptyBranchControls;
    private Color branchControlColor;
    private Color branchControlSelectionColor;
    private Color branchControlInactiveSelectionColor;
    private Color gridColor;
    private boolean showGridLines;
    private boolean validateSelection = false;
    private static final int BRANCH_CONTROL_IMAGE_WIDTH = 8;
    private static final int BRANCH_CONTROL_IMAGE_HEIGHT = 8;
    private static final int VERTICAL_SPACING = 1;
    private static final Checkbox CHECKBOX = new Checkbox();
    private static final int CHECKBOX_VERTICAL_PADDING = 2;

    public TerraTreeViewSkin() {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.font = theme.getFont();
        this.color = theme.getColor(1);
        this.disabledColor = theme.getColor(7);
        this.backgroundColor = theme.getColor(4);
        this.selectionColor = theme.getColor(4);
        this.selectionBackgroundColor = theme.getColor(14);
        this.inactiveSelectionColor = theme.getColor(1);
        this.inactiveSelectionBackgroundColor = theme.getColor(10);
        this.highlightColor = theme.getColor(1);
        this.highlightBackgroundColor = theme.getColor(10);
        this.spacing = 6;
        this.indent = 16;
        this.showHighlight = true;
        this.showBranchControls = true;
        this.showEmptyBranchControls = true;
        this.branchControlColor = theme.getColor(12);
        this.branchControlSelectionColor = theme.getColor(4);
        this.branchControlInactiveSelectionColor = theme.getColor(14);
        this.gridColor = theme.getColor(11);
        this.showGridLines = false;
    }

    public void install(Component component) {
        super.install(component);
        TreeView treeView = (TreeView)component;
        treeView.getTreeViewListeners().add((Object)this);
        treeView.getTreeViewBranchListeners().add((Object)this);
        treeView.getTreeViewNodeListeners().add((Object)this);
        treeView.getTreeViewNodeStateListeners().add((Object)this);
        treeView.getTreeViewSelectionListeners().add((Object)this);
        this.treeDataChanged(treeView, null);
    }

    public int getPreferredWidth(int height) {
        TreeView treeView = (TreeView)this.getComponent();
        TreeView.NodeRenderer nodeRenderer = treeView.getNodeRenderer();
        int preferredWidth = 0;
        VisibleNodeIterator visibleNodeIterator = new VisibleNodeIterator();
        while (visibleNodeIterator.hasNext()) {
            NodeInfo nodeInfo = visibleNodeIterator.next();
            int nodeWidth = (nodeInfo.depth - 1) * (this.indent + this.spacing);
            nodeRenderer.render(nodeInfo.data, visibleNodeIterator.getPath(), visibleNodeIterator.getRowIndex(), treeView, false, false, TreeView.NodeCheckState.UNCHECKED, false, false);
            preferredWidth = Math.max(preferredWidth, nodeWidth += nodeRenderer.getPreferredWidth(-1));
        }
        if (this.showBranchControls) {
            preferredWidth += this.indent + this.spacing;
        }
        if (treeView.getCheckmarksEnabled()) {
            preferredWidth += Math.max(CHECKBOX.getWidth(), this.indent) + this.spacing;
        }
        return preferredWidth;
    }

    public int getPreferredHeight(int width) {
        int nodeHeight = this.getNodeHeight();
        int visibleNodeCount = this.visibleNodes.getLength();
        int preferredHeight = nodeHeight * visibleNodeCount;
        if (visibleNodeCount > 1) {
            preferredHeight += 1 * (visibleNodeCount - 1);
        }
        return preferredHeight;
    }

    public int getBaseline(int width, int height) {
        int baseline = -1;
        if (this.visibleNodes.getLength() > 0) {
            TreeView treeView = (TreeView)this.getComponent();
            TreeView.NodeRenderer nodeRenderer = treeView.getNodeRenderer();
            NodeInfo nodeInfo = (NodeInfo)this.visibleNodes.get(0);
            int nodeWidth = width - (nodeInfo.depth - 1) * (this.indent + this.spacing);
            int nodeHeight = this.getNodeHeight();
            boolean expanded = false;
            boolean selected = nodeInfo.isSelected();
            boolean highlighted = nodeInfo.isHighlighted();
            boolean disabled = nodeInfo.isDisabled();
            if (this.showBranchControls) {
                if (nodeInfo instanceof BranchInfo) {
                    BranchInfo branchInfo = (BranchInfo)nodeInfo;
                    expanded = branchInfo.isExpanded();
                }
                nodeWidth -= this.indent + this.spacing;
            }
            TreeView.NodeCheckState checkState = TreeView.NodeCheckState.UNCHECKED;
            if (treeView.getCheckmarksEnabled()) {
                checkState = nodeInfo.getCheckState();
                nodeWidth -= Math.max(this.indent, CHECKBOX.getWidth()) + this.spacing;
            }
            nodeRenderer.render(nodeInfo.data, nodeInfo.getPath(), 0, treeView, expanded, selected, checkState, highlighted, disabled);
            baseline = nodeRenderer.getBaseline(nodeWidth, nodeHeight);
        }
        return baseline;
    }

    public void layout() {
        if (this.validateSelection) {
            this.scrollSelectionToVisible();
        }
        this.validateSelection = false;
    }

    public void paint(Graphics2D graphics) {
        TreeView treeView = (TreeView)this.getComponent();
        TreeView.NodeRenderer nodeRenderer = treeView.getNodeRenderer();
        int width = this.getWidth();
        int height = this.getHeight();
        int nodeHeight = this.getNodeHeight();
        if (this.backgroundColor != null) {
            graphics.setPaint(this.backgroundColor);
            graphics.fillRect(0, 0, width, height);
        }
        int nodeStart = 0;
        int nodeEnd = this.visibleNodes.getLength() - 1;
        Rectangle clipBounds = graphics.getClipBounds();
        if (clipBounds != null) {
            nodeStart = Math.max(nodeStart, (int)((double)clipBounds.y / (double)(nodeHeight + 1)));
            nodeEnd = Math.min(nodeEnd, (int)((double)(clipBounds.y + clipBounds.height) / (double)(nodeHeight + 1)));
        }
        int nodeY = nodeStart * (nodeHeight + 1);
        VisibleNodeIterator visibleNodeIterator = new VisibleNodeIterator(nodeStart, nodeEnd);
        while (visibleNodeIterator.hasNext()) {
            NodeInfo nodeInfo = visibleNodeIterator.next();
            boolean expanded = false;
            boolean highlighted = nodeInfo.isHighlighted();
            boolean selected = nodeInfo.isSelected();
            boolean disabled = nodeInfo.isDisabled();
            int nodeX = (nodeInfo.depth - 1) * (this.indent + this.spacing);
            if (treeView.isEnabled()) {
                if (selected) {
                    Color selectionBackgroundColorLocal = treeView.isFocused() ? this.selectionBackgroundColor : this.inactiveSelectionBackgroundColor;
                    graphics.setPaint(selectionBackgroundColorLocal);
                    graphics.fillRect(0, nodeY, width, nodeHeight);
                } else if (highlighted && !disabled) {
                    graphics.setPaint(this.highlightBackgroundColor);
                    graphics.fillRect(0, nodeY, width, nodeHeight);
                }
            }
            if (this.showBranchControls) {
                if (nodeInfo instanceof BranchInfo) {
                    BranchInfo branchInfo = (BranchInfo)nodeInfo;
                    boolean showBranchControl = true;
                    if (!this.showEmptyBranchControls) {
                        branchInfo.loadChildren();
                        boolean bl = showBranchControl = !branchInfo.children.isEmpty();
                    }
                    if (showBranchControl) {
                        expanded = branchInfo.isExpanded();
                        Color branchControlColorLocal = selected ? (treeView.isFocused() ? this.branchControlSelectionColor : this.branchControlInactiveSelectionColor) : this.branchControlColor;
                        GeneralPath shape = new GeneralPath();
                        int imageX = nodeX + (this.indent - 8) / 2;
                        int imageY = nodeY + (nodeHeight - 8) / 2;
                        if (expanded) {
                            shape.moveTo(imageX, imageY + 1);
                            shape.lineTo(imageX + 8, imageY + 1);
                            shape.lineTo(imageX + 4, imageY + 7);
                        } else {
                            shape.moveTo(imageX + 1, imageY);
                            shape.lineTo(imageX + 7, imageY + 4);
                            shape.lineTo(imageX + 1, imageY + 8);
                        }
                        shape.closePath();
                        Graphics2D branchControlGraphics = (Graphics2D)graphics.create();
                        branchControlGraphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
                        if (!treeView.isEnabled() || disabled) {
                            branchControlGraphics.setComposite(AlphaComposite.getInstance(3, 0.5f));
                        }
                        branchControlGraphics.setPaint(branchControlColorLocal);
                        branchControlGraphics.fill(shape);
                        branchControlGraphics.dispose();
                    }
                }
                nodeX += this.indent + this.spacing;
            }
            TreeView.NodeCheckState checkState = TreeView.NodeCheckState.UNCHECKED;
            if (treeView.getCheckmarksEnabled()) {
                Button.State state;
                checkState = nodeInfo.getCheckState();
                int checkboxWidth = CHECKBOX.getWidth();
                int checkboxHeight = CHECKBOX.getHeight();
                int checkboxX = Math.max(this.indent - checkboxWidth, 0) / 2;
                int checkboxY = (nodeHeight - checkboxHeight) / 2;
                Graphics2D checkboxGraphics = (Graphics2D)graphics.create(nodeX + checkboxX, nodeY + checkboxY, checkboxWidth, checkboxHeight);
                switch (checkState) {
                    case CHECKED: {
                        state = Button.State.SELECTED;
                        break;
                    }
                    case MIXED: {
                        state = Button.State.MIXED;
                        break;
                    }
                    default: {
                        state = Button.State.UNSELECTED;
                    }
                }
                CHECKBOX.setState(state);
                CHECKBOX.setEnabled(treeView.isEnabled() && !disabled && !nodeInfo.isCheckmarkDisabled());
                CHECKBOX.paint(checkboxGraphics);
                checkboxGraphics.dispose();
                nodeX += Math.max(this.indent, checkboxWidth) + this.spacing;
            }
            int nodeWidth = Math.max(width - nodeX, 0);
            Graphics2D rendererGraphics = (Graphics2D)graphics.create(nodeX, nodeY, nodeWidth, nodeHeight);
            nodeRenderer.render(nodeInfo.data, visibleNodeIterator.getPath(), visibleNodeIterator.getRowIndex(), treeView, expanded, selected, checkState, highlighted, disabled);
            nodeRenderer.setSize(nodeWidth, nodeHeight);
            nodeRenderer.paint(rendererGraphics);
            rendererGraphics.dispose();
            if (this.showGridLines) {
                graphics.setPaint(this.gridColor);
                GraphicsUtilities.drawLine((Graphics2D)graphics, (int)0, (int)(nodeY + nodeHeight), (int)width, (Orientation)Orientation.HORIZONTAL);
            }
            nodeY += nodeHeight + 1;
        }
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.font = font;
        this.invalidateComponent();
    }

    public final void setFont(String font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(TerraTreeViewSkin.decodeFont((String)font));
    }

    public final void setFont(Dictionary<String, ?> font) {
        if (font == null) {
            throw new IllegalArgumentException("font is null.");
        }
        this.setFont(Theme.deriveFont(font));
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.color = color;
        this.repaintComponent();
    }

    public void setColor(String color) {
        if (color == null) {
            throw new IllegalArgumentException("color is null.");
        }
        this.setColor(GraphicsUtilities.decodeColor((String)color));
    }

    public final void setColor(int color) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setColor(theme.getColor(color));
    }

    public Color getDisabledColor() {
        return this.disabledColor;
    }

    public void setDisabledColor(Color disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.disabledColor = disabledColor;
        this.repaintComponent();
    }

    public void setDisabledColor(String disabledColor) {
        if (disabledColor == null) {
            throw new IllegalArgumentException("disabledColor is null.");
        }
        this.setDisabledColor(GraphicsUtilities.decodeColor((String)disabledColor));
    }

    public final void setDisabledColor(int disabledColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setDisabledColor(theme.getColor(disabledColor));
    }

    public Color getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setBackgroundColor(Color backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.repaintComponent();
    }

    public void setBackgroundColor(String backgroundColor) {
        if (backgroundColor == null) {
            throw new IllegalArgumentException("backgroundColor is null.");
        }
        this.setBackgroundColor(GraphicsUtilities.decodeColor((String)backgroundColor));
    }

    public final void setBackgroundColor(int backgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBackgroundColor(theme.getColor(backgroundColor));
    }

    public Color getSelectionColor() {
        return this.selectionColor;
    }

    public void setSelectionColor(Color selectionColor) {
        if (selectionColor == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.selectionColor = selectionColor;
        this.repaintComponent();
    }

    public void setSelectionColor(String selectionColor) {
        if (selectionColor == null) {
            throw new IllegalArgumentException("selectionColor is null.");
        }
        this.setSelectionColor(GraphicsUtilities.decodeColor((String)selectionColor));
    }

    public final void setSelectionColor(int selectionColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setSelectionColor(theme.getColor(selectionColor));
    }

    public Color getSelectionBackgroundColor() {
        return this.selectionBackgroundColor;
    }

    public void setSelectionBackgroundColor(Color selectionBackgroundColor) {
        if (selectionBackgroundColor == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.selectionBackgroundColor = selectionBackgroundColor;
        this.repaintComponent();
    }

    public void setSelectionBackgroundColor(String selectionBackgroundColor) {
        if (selectionBackgroundColor == null) {
            throw new IllegalArgumentException("selectionBackgroundColor is null.");
        }
        this.setSelectionBackgroundColor(GraphicsUtilities.decodeColor((String)selectionBackgroundColor));
    }

    public final void setSelectionBackgroundColor(int selectionBackgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setSelectionBackgroundColor(theme.getColor(selectionBackgroundColor));
    }

    public Color getInactiveSelectionColor() {
        return this.inactiveSelectionColor;
    }

    public void setInactiveSelectionColor(Color inactiveSelectionColor) {
        if (inactiveSelectionColor == null) {
            throw new IllegalArgumentException("inactiveSelectionColor is null.");
        }
        this.inactiveSelectionColor = inactiveSelectionColor;
        this.repaintComponent();
    }

    public void setInactiveSelectionColor(String inactiveSelectionColor) {
        if (inactiveSelectionColor == null) {
            throw new IllegalArgumentException("inactiveSelectionColor is null.");
        }
        this.setInactiveSelectionColor(GraphicsUtilities.decodeColor((String)inactiveSelectionColor));
    }

    public final void setInactiveSelectionColor(int inactiveSelectionColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setInactiveSelectionColor(theme.getColor(inactiveSelectionColor));
    }

    public Color getInactiveSelectionBackgroundColor() {
        return this.inactiveSelectionBackgroundColor;
    }

    public void setInactiveSelectionBackgroundColor(Color inactiveSelectionBackgroundColor) {
        if (inactiveSelectionBackgroundColor == null) {
            throw new IllegalArgumentException("inactiveSelectionBackgroundColor is null.");
        }
        this.inactiveSelectionBackgroundColor = inactiveSelectionBackgroundColor;
        this.repaintComponent();
    }

    public void setInactiveSelectionBackgroundColor(String inactiveSelectionBackgroundColor) {
        if (inactiveSelectionBackgroundColor == null) {
            throw new IllegalArgumentException("inactiveSelectionBackgroundColor is null.");
        }
        this.setInactiveSelectionBackgroundColor(GraphicsUtilities.decodeColor((String)inactiveSelectionBackgroundColor));
    }

    public final void setInactiveSelectionBackgroundColor(int inactiveSelectionBackgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setInactiveSelectionBackgroundColor(theme.getColor(inactiveSelectionBackgroundColor));
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color highlightColor) {
        if (highlightColor == null) {
            throw new IllegalArgumentException("highlightColor is null.");
        }
        this.highlightColor = highlightColor;
        this.repaintComponent();
    }

    public void setHighlightColor(String highlightColor) {
        if (highlightColor == null) {
            throw new IllegalArgumentException("highlightColor is null.");
        }
        this.setHighlightColor(GraphicsUtilities.decodeColor((String)highlightColor));
    }

    public final void setHighlightColor(int highlightColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setHighlightColor(theme.getColor(highlightColor));
    }

    public Color getHighlightBackgroundColor() {
        return this.highlightBackgroundColor;
    }

    public void setHighlightBackgroundColor(Color highlightBackgroundColor) {
        if (highlightBackgroundColor == null) {
            throw new IllegalArgumentException("highlightBackgroundColor is null.");
        }
        this.highlightBackgroundColor = highlightBackgroundColor;
        this.repaintComponent();
    }

    public void setHighlightBackgroundColor(String highlightBackgroundColor) {
        if (highlightBackgroundColor == null) {
            throw new IllegalArgumentException("highlightBackgroundColor is null.");
        }
        this.setHighlightBackgroundColor(GraphicsUtilities.decodeColor((String)highlightBackgroundColor));
    }

    public final void setHighlightBackgroundColor(int highlightBackgroundColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setHighlightBackgroundColor(theme.getColor(highlightBackgroundColor));
    }

    public int getSpacing() {
        return this.spacing;
    }

    public void setSpacing(int spacing) {
        if (spacing < 0) {
            throw new IllegalArgumentException("spacing is negative.");
        }
        this.spacing = spacing;
        this.invalidateComponent();
    }

    public void setSpacing(Number spacing) {
        if (spacing == null) {
            throw new IllegalArgumentException("spacing is null.");
        }
        this.setSpacing(spacing.intValue());
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int indent) {
        if (indent < 0) {
            throw new IllegalArgumentException("indent is negative.");
        }
        this.indent = indent;
        this.invalidateComponent();
    }

    public void setIndent(Number indent) {
        if (indent == null) {
            throw new IllegalArgumentException("indent is null.");
        }
        this.setIndent(indent.intValue());
    }

    public boolean getShowHighlight() {
        return this.showHighlight;
    }

    public void setShowHighlight(boolean showHighlight) {
        this.showHighlight = showHighlight;
        this.repaintComponent();
    }

    public boolean getShowBranchControls() {
        return this.showBranchControls;
    }

    public void setShowBranchControls(boolean showBranchControls) {
        this.showBranchControls = showBranchControls;
        this.invalidateComponent();
    }

    public boolean getShowEmptyBranchControls() {
        return this.showEmptyBranchControls;
    }

    public void setShowEmptyBranchControls(boolean showEmptyBranchControls) {
        this.showEmptyBranchControls = showEmptyBranchControls;
        this.repaintComponent();
    }

    public Color getBranchControlColor() {
        return this.branchControlColor;
    }

    public void setBranchControlColor(Color branchControlColor) {
        if (branchControlColor == null) {
            throw new IllegalArgumentException("branchControlColor is null.");
        }
        this.branchControlColor = branchControlColor;
        this.repaintComponent();
    }

    public void setBranchControlColor(String branchControlColor) {
        if (branchControlColor == null) {
            throw new IllegalArgumentException("branchControlColor is null.");
        }
        this.setBranchControlColor(GraphicsUtilities.decodeColor((String)branchControlColor));
    }

    public final void setBranchControlColor(int branchControlColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBranchControlColor(theme.getColor(branchControlColor));
    }

    public Color getBranchControlSelectionColor() {
        return this.branchControlSelectionColor;
    }

    public void setBranchControlSelectionColor(Color branchControlSelectionColor) {
        if (branchControlSelectionColor == null) {
            throw new IllegalArgumentException("branchControlSelectionColor is null.");
        }
        this.branchControlSelectionColor = branchControlSelectionColor;
        this.repaintComponent();
    }

    public void setBranchControlSelectionColor(String branchControlSelectionColor) {
        if (branchControlSelectionColor == null) {
            throw new IllegalArgumentException("branchControlSelectionColor is null.");
        }
        this.setBranchControlSelectionColor(GraphicsUtilities.decodeColor((String)branchControlSelectionColor));
    }

    public final void setBranchControlSelectionColor(int branchControlSelectionColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBranchControlSelectionColor(theme.getColor(branchControlSelectionColor));
    }

    public Color getBranchControlInactiveSelectionColor() {
        return this.branchControlInactiveSelectionColor;
    }

    public void setBranchControlInactiveSelectionColor(Color branchControlInactiveSelectionColor) {
        if (branchControlInactiveSelectionColor == null) {
            throw new IllegalArgumentException("branchControlInactiveSelectionColor is null.");
        }
        this.branchControlInactiveSelectionColor = branchControlInactiveSelectionColor;
        this.repaintComponent();
    }

    public void setBranchControlInactiveSelectionColor(String branchControlInactiveSelectionColor) {
        if (branchControlInactiveSelectionColor == null) {
            throw new IllegalArgumentException("branchControlInactiveSelectionColor is null.");
        }
        this.setBranchControlInactiveSelectionColor(GraphicsUtilities.decodeColor((String)branchControlInactiveSelectionColor));
    }

    public final void setBranchControlInactiveSelectionColor(int branchControlInactiveSelectionColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setBranchControlInactiveSelectionColor(theme.getColor(branchControlInactiveSelectionColor));
    }

    public Color getGridColor() {
        return this.gridColor;
    }

    public void setGridColor(Color gridColor) {
        if (gridColor == null) {
            throw new IllegalArgumentException("gridColor is null.");
        }
        this.gridColor = gridColor;
        this.repaintComponent();
    }

    public void setGridColor(String gridColor) {
        if (gridColor == null) {
            throw new IllegalArgumentException("gridColor is null.");
        }
        this.setGridColor(GraphicsUtilities.decodeColor((String)gridColor));
    }

    public final void setGridColor(int gridColor) {
        TerraTheme theme = (TerraTheme)Theme.getTheme();
        this.setGridColor(theme.getColor(gridColor));
    }

    public boolean getShowGridLines() {
        return this.showGridLines;
    }

    public void setShowGridLines(boolean showGridLines) {
        this.showGridLines = showGridLines;
        this.repaintComponent();
    }

    protected int getNodeHeight() {
        TreeView treeView = (TreeView)this.getComponent();
        TreeView.NodeRenderer nodeRenderer = treeView.getNodeRenderer();
        nodeRenderer.render(null, null, -1, treeView, false, false, TreeView.NodeCheckState.UNCHECKED, false, false);
        int nodeHeight = nodeRenderer.getPreferredHeight(-1);
        if (treeView.getCheckmarksEnabled()) {
            nodeHeight = Math.max(CHECKBOX.getHeight() + 4, nodeHeight);
        }
        return nodeHeight;
    }

    protected final NodeInfo getNodeInfoAt(int y) {
        NodeInfo nodeInfo = null;
        int nodeHeight = this.getNodeHeight();
        int index = y / (nodeHeight + 1);
        if (index >= 0 && index < this.visibleNodes.getLength()) {
            nodeInfo = (NodeInfo)this.visibleNodes.get(index);
        }
        return nodeInfo;
    }

    protected final NodeInfo getNodeInfoAt(Sequence.Tree.Path path) {
        assert (path != null) : "Path is null";
        NodeInfo result = null;
        int n = path.getLength();
        if (n == 0) {
            result = this.rootBranchInfo;
        } else {
            BranchInfo branchInfo = this.rootBranchInfo;
            for (int i = 0; i < n - 1; ++i) {
                branchInfo.loadChildren();
                NodeInfo nodeInfo = (NodeInfo)branchInfo.children.get(path.get(i).intValue());
                assert (nodeInfo instanceof BranchInfo) : "Invalid path";
                branchInfo = (BranchInfo)nodeInfo;
            }
            branchInfo.loadChildren();
            result = (NodeInfo)branchInfo.children.get(path.get(n - 1).intValue());
        }
        return result;
    }

    protected final Bounds getNodeBounds(NodeInfo nodeInfo) {
        Bounds bounds = null;
        int index = this.visibleNodes.indexOf((Object)nodeInfo);
        if (index >= 0) {
            int nodeHeight = this.getNodeHeight();
            int nodeY = index * (nodeHeight + 1);
            bounds = new Bounds(0, nodeY, this.getWidth(), nodeHeight);
        }
        return bounds;
    }

    protected final void accept(NodeInfoVisitor visitor) {
        ArrayList nodes = new ArrayList();
        nodes.add((Object)this.rootBranchInfo);
        while (nodes.getLength() > 0) {
            BranchInfo branchInfo;
            NodeInfo nodeInfo = (NodeInfo)nodes.get(0);
            nodes.remove(0, 1);
            visitor.visit(nodeInfo);
            if (!(nodeInfo instanceof BranchInfo) || (branchInfo = (BranchInfo)nodeInfo).children == null) continue;
            int n = branchInfo.children.getLength();
            for (int i = 0; i < n; ++i) {
                nodes.insert(branchInfo.children.get(i), i);
            }
        }
    }

    private void addVisibleNodes(BranchInfo parentBranchInfo) {
        int insertIndex = -1;
        if (parentBranchInfo == this.rootBranchInfo) {
            insertIndex = 0;
        } else {
            int branchIndex = this.visibleNodes.indexOf((Object)parentBranchInfo);
            if (branchIndex >= 0) {
                insertIndex = branchIndex + 1;
            }
        }
        if (insertIndex >= 0) {
            ArrayList nodes = new ArrayList();
            parentBranchInfo.loadChildren();
            int n = parentBranchInfo.children.getLength();
            for (int i = 0; i < n; ++i) {
                nodes.add(parentBranchInfo.children.get(i));
            }
            while (nodes.getLength() > 0) {
                BranchInfo branchInfo;
                NodeInfo nodeInfo = (NodeInfo)nodes.get(0);
                nodes.remove(0, 1);
                this.visibleNodes.insert((Object)nodeInfo, insertIndex++);
                if (!(nodeInfo instanceof BranchInfo) || !(branchInfo = (BranchInfo)nodeInfo).isExpanded()) continue;
                branchInfo.loadChildren();
                int n2 = branchInfo.children.getLength();
                for (int i = 0; i < n2; ++i) {
                    nodes.insert(branchInfo.children.get(i), i);
                }
            }
            this.invalidateComponent();
        }
    }

    private void addVisibleNode(BranchInfo parentBranchInfo, int index) {
        parentBranchInfo.loadChildren();
        assert (index >= 0) : "Index is too small";
        assert (index < parentBranchInfo.children.getLength()) : "Index is too large";
        int branchIndex = this.visibleNodes.indexOf((Object)parentBranchInfo);
        if (parentBranchInfo == this.rootBranchInfo || branchIndex >= 0 && parentBranchInfo.isExpanded()) {
            NodeInfo nodeInfo = (NodeInfo)parentBranchInfo.children.get(index);
            int insertIndex = branchIndex + index + 1;
            if (index > 0) {
                NodeInfo youngerSibling = (NodeInfo)parentBranchInfo.children.get(index - 1);
                int n = this.visibleNodes.getLength();
                int nodeDepth = youngerSibling.depth;
                for (insertIndex = this.visibleNodes.indexOf((Object)youngerSibling) + 1; insertIndex < n && ((NodeInfo)this.visibleNodes.get((int)insertIndex)).depth > nodeDepth; ++insertIndex) {
                }
            }
            this.visibleNodes.insert((Object)nodeInfo, insertIndex);
            this.invalidateComponent();
        }
    }

    private void removeVisibleNodes(BranchInfo parentBranchInfo, int index, int count) {
        parentBranchInfo.loadChildren();
        int countUpdated = count;
        if (countUpdated == -1) {
            assert (index == 0) : "Non-zero index with 'remove all' count";
            countUpdated = parentBranchInfo.children.getLength();
        }
        assert (index + countUpdated <= parentBranchInfo.children.getLength()) : "Value too big";
        if (countUpdated > 0) {
            NodeInfo first = (NodeInfo)parentBranchInfo.children.get(index);
            NodeInfo last = (NodeInfo)parentBranchInfo.children.get(index + countUpdated - 1);
            int rangeStart = this.visibleNodes.indexOf((Object)first);
            if (rangeStart >= 0) {
                int rangeEnd;
                assert (rangeEnd > rangeStart) : "Invalid visible node structure";
                int n = this.visibleNodes.getLength();
                int nodeDepth = last.depth;
                for (rangeEnd = this.visibleNodes.indexOf((Object)last) + 1; rangeEnd < n && ((NodeInfo)this.visibleNodes.get((int)rangeEnd)).depth > nodeDepth; ++rangeEnd) {
                }
                this.visibleNodes.remove(rangeStart, rangeEnd - rangeStart);
                this.invalidateComponent();
            }
        }
    }

    protected void repaintNode(NodeInfo nodeInfo) {
        Bounds bounds = this.getNodeBounds(nodeInfo);
        if (bounds != null) {
            this.repaintComponent(bounds);
        }
    }

    protected void clearHighlightedNode() {
        if (this.highlightedNode != null) {
            this.highlightedNode.setHighlighted(false);
            this.repaintNode(this.highlightedNode);
            this.highlightedNode = null;
        }
    }

    private void clearFields(final byte mask) {
        this.accept(new NodeInfoVisitor(){

            @Override
            public void visit(NodeInfo nodeInfo) {
                nodeInfo.clearField(mask);
            }
        });
    }

    private void scrollSelectionToVisible() {
        TreeView treeView = (TreeView)this.getComponent();
        ImmutableList selectedPaths = treeView.getSelectedPaths();
        int n = selectedPaths.getLength();
        if (n > 0) {
            Bounds visibleSelectionBounds;
            Bounds nodeBounds = null;
            for (int i = n - 1; i >= 0 && nodeBounds == null; --i) {
                NodeInfo nodeInfo = this.getNodeInfoAt((Sequence.Tree.Path)selectedPaths.get(i));
                nodeBounds = this.getNodeBounds(nodeInfo);
            }
            if (nodeBounds != null && (visibleSelectionBounds = treeView.getVisibleArea(nodeBounds)) != null && visibleSelectionBounds.height < nodeBounds.height) {
                treeView.scrollAreaToVisible(nodeBounds);
            }
        }
    }

    public boolean mouseMove(Component component, int x, int y) {
        boolean consumed = super.mouseMove(component, x, y);
        TreeView treeView = (TreeView)this.getComponent();
        if (this.showHighlight && treeView.getSelectMode() != TreeView.SelectMode.NONE) {
            NodeInfo previousHighlightedNode = this.highlightedNode;
            this.highlightedNode = this.getNodeInfoAt(y);
            if (this.highlightedNode != previousHighlightedNode) {
                if (previousHighlightedNode != null) {
                    previousHighlightedNode.setHighlighted(false);
                    this.repaintNode(previousHighlightedNode);
                }
                if (this.highlightedNode != null) {
                    this.highlightedNode.setHighlighted(true);
                    this.repaintNode(this.highlightedNode);
                }
            }
        }
        return consumed;
    }

    public void mouseOut(Component component) {
        super.mouseOut(component);
        this.clearHighlightedNode();
        this.selectPath = null;
    }

    public boolean mouseDown(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseDown(component, button, x, y);
        if (!consumed) {
            TreeView treeView = (TreeView)this.getComponent();
            NodeInfo nodeInfo = this.getNodeInfoAt(y);
            if (nodeInfo != null && !nodeInfo.isDisabled()) {
                int nodeHeight = this.getNodeHeight();
                int baseNodeX = (nodeInfo.depth - 1) * (this.indent + this.spacing);
                int nodeX = baseNodeX + (this.showBranchControls ? this.indent + this.spacing : 0);
                int nodeY = y / (nodeHeight + 1) * (nodeHeight + 1);
                int checkboxWidth = CHECKBOX.getWidth();
                int checkboxHeight = CHECKBOX.getHeight();
                int checkboxX = Math.max(this.indent - checkboxWidth, 0) / 2;
                int checkboxY = (nodeHeight - checkboxHeight) / 2;
                if (!treeView.getCheckmarksEnabled() || nodeInfo.isCheckmarkDisabled() || x < nodeX + checkboxX || x >= nodeX + checkboxX + checkboxWidth || y < nodeY + checkboxY || y >= nodeY + checkboxY + checkboxHeight) {
                    Sequence.Tree.Path path = nodeInfo.getPath();
                    if (this.showBranchControls && nodeInfo instanceof BranchInfo && x >= baseNodeX && x < baseNodeX + this.indent) {
                        BranchInfo branchInfo = (BranchInfo)nodeInfo;
                        treeView.setBranchExpanded(path, !branchInfo.isExpanded());
                        consumed = true;
                    }
                    if (!consumed) {
                        TreeView.SelectMode selectMode = treeView.getSelectMode();
                        if (button == Mouse.Button.LEFT) {
                            Keyboard.Modifier commandModifier = Platform.getCommandModifier();
                            if (Keyboard.isPressed((Keyboard.Modifier)commandModifier) && selectMode == TreeView.SelectMode.MULTI) {
                                if (nodeInfo.isSelected()) {
                                    treeView.removeSelectedPath(path);
                                } else {
                                    treeView.addSelectedPath(path);
                                }
                            } else if (Keyboard.isPressed((Keyboard.Modifier)commandModifier) && selectMode == TreeView.SelectMode.SINGLE) {
                                if (nodeInfo.isSelected()) {
                                    treeView.clearSelection();
                                } else {
                                    treeView.setSelectedPath(path);
                                }
                            } else if (selectMode != TreeView.SelectMode.NONE) {
                                if (nodeInfo.isSelected()) {
                                    this.selectPath = path;
                                } else {
                                    treeView.setSelectedPath(path);
                                }
                            }
                        }
                    }
                }
            }
            treeView.requestFocus();
        }
        return consumed;
    }

    public boolean mouseUp(Component component, Mouse.Button button, int x, int y) {
        boolean consumed = super.mouseUp(component, button, x, y);
        TreeView treeView = (TreeView)this.getComponent();
        if (this.selectPath != null && !treeView.getFirstSelectedPath().equals(treeView.getLastSelectedPath())) {
            treeView.setSelectedPath(this.selectPath);
            this.selectPath = null;
        }
        return consumed;
    }

    public boolean mouseClick(Component component, Mouse.Button button, int x, int y, int count) {
        boolean consumed = super.mouseClick(component, button, x, y, count);
        if (!consumed) {
            TreeView treeView = (TreeView)this.getComponent();
            NodeInfo nodeInfo = this.getNodeInfoAt(y);
            if (nodeInfo != null && !nodeInfo.isDisabled()) {
                int nodeHeight = this.getNodeHeight();
                int baseNodeX = (nodeInfo.depth - 1) * (this.indent + this.spacing);
                int nodeX = baseNodeX + (this.showBranchControls ? this.indent + this.spacing : 0);
                int nodeY = y / (nodeHeight + 1) * (nodeHeight + 1);
                int checkboxWidth = CHECKBOX.getWidth();
                int checkboxHeight = CHECKBOX.getHeight();
                int checkboxX = Math.max(this.indent - checkboxWidth, 0) / 2;
                int checkboxY = (nodeHeight - checkboxHeight) / 2;
                if (treeView.getCheckmarksEnabled() && !nodeInfo.isCheckmarkDisabled() && x >= nodeX + checkboxX && x < nodeX + checkboxX + checkboxWidth && y >= nodeY + checkboxY && y < nodeY + checkboxY + checkboxHeight) {
                    Sequence.Tree.Path path = nodeInfo.getPath();
                    treeView.setNodeChecked(path, !nodeInfo.isChecked());
                } else {
                    TreeView.NodeEditor nodeEditor;
                    if (this.selectPath != null && count == 1 && button == Mouse.Button.LEFT && (nodeEditor = treeView.getNodeEditor()) != null) {
                        if (nodeEditor.isEditing()) {
                            nodeEditor.endEdit(true);
                        }
                        nodeEditor.beginEdit(treeView, this.selectPath);
                    }
                    this.selectPath = null;
                }
            }
        }
        return consumed;
    }

    public boolean mouseWheel(Component component, Mouse.ScrollType scrollType, int scrollAmount, int wheelRotation, int x, int y) {
        if (this.highlightedNode != null) {
            Bounds nodeBounds = this.getNodeBounds(this.highlightedNode);
            this.highlightedNode.setHighlighted(false);
            this.highlightedNode = null;
            if (nodeBounds != null) {
                this.repaintComponent(nodeBounds.x, nodeBounds.y, nodeBounds.width, nodeBounds.height, true);
            }
        }
        return super.mouseWheel(component, scrollType, scrollAmount, wheelRotation, x, y);
    }

    public boolean keyPressed(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = false;
        TreeView treeView = (TreeView)this.getComponent();
        TreeView.SelectMode selectMode = treeView.getSelectMode();
        switch (keyCode) {
            case 38: {
                int index;
                if (selectMode == TreeView.SelectMode.NONE) break;
                Sequence.Tree.Path firstSelectedPath = treeView.getFirstSelectedPath();
                if (firstSelectedPath != null) {
                    NodeInfo previousSelectedNode = this.getNodeInfoAt(firstSelectedPath);
                    index = this.visibleNodes.indexOf((Object)previousSelectedNode);
                } else {
                    index = this.visibleNodes.getLength();
                }
                NodeInfo newSelectedNode = null;
                do {
                    NodeInfo nodeInfo = newSelectedNode = --index >= 0 ? (NodeInfo)this.visibleNodes.get(index) : null;
                } while (newSelectedNode != null && newSelectedNode.isDisabled());
                if (newSelectedNode != null) {
                    if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT) && treeView.getSelectMode() == TreeView.SelectMode.MULTI) {
                        treeView.addSelectedPath(newSelectedNode.getPath());
                    } else {
                        treeView.setSelectedPath(newSelectedNode.getPath());
                    }
                    treeView.scrollAreaToVisible(this.getNodeBounds(newSelectedNode));
                }
                consumed = true;
                break;
            }
            case 40: {
                int index;
                if (selectMode == TreeView.SelectMode.NONE) break;
                Sequence.Tree.Path lastSelectedPath = treeView.getLastSelectedPath();
                if (lastSelectedPath != null) {
                    NodeInfo previousSelectedNode = this.getNodeInfoAt(lastSelectedPath);
                    index = this.visibleNodes.indexOf((Object)previousSelectedNode);
                } else {
                    index = -1;
                }
                NodeInfo newSelectedNode = null;
                int n = this.visibleNodes.getLength();
                do {
                    NodeInfo nodeInfo = newSelectedNode = ++index <= n - 1 ? (NodeInfo)this.visibleNodes.get(index) : null;
                } while (newSelectedNode != null && newSelectedNode.isDisabled());
                if (newSelectedNode != null) {
                    if (Keyboard.isPressed((Keyboard.Modifier)Keyboard.Modifier.SHIFT) && treeView.getSelectMode() == TreeView.SelectMode.MULTI) {
                        treeView.addSelectedPath(newSelectedNode.getPath());
                    } else {
                        treeView.setSelectedPath(newSelectedNode.getPath());
                    }
                    treeView.scrollAreaToVisible(this.getNodeBounds(newSelectedNode));
                }
                consumed = true;
                break;
            }
            case 37: {
                BranchInfo branchInfo;
                ImmutableList paths;
                if (!this.showBranchControls || (paths = treeView.getSelectedPaths()) == null || paths.getLength() <= 0) break;
                Sequence.Tree.Path path = (Sequence.Tree.Path)paths.get(paths.getLength() - 1);
                NodeInfo nodeInfo = this.getNodeInfoAt(path);
                if (nodeInfo instanceof BranchInfo && (branchInfo = (BranchInfo)nodeInfo).isExpanded()) {
                    treeView.collapseBranch(branchInfo.getPath());
                }
                consumed = true;
                break;
            }
            case 39: {
                BranchInfo branchInfo;
                ImmutableList paths;
                if (!this.showBranchControls || (paths = treeView.getSelectedPaths()) == null || paths.getLength() <= 0) break;
                Sequence.Tree.Path path = (Sequence.Tree.Path)paths.get(paths.getLength() - 1);
                NodeInfo nodeInfo = this.getNodeInfoAt(path);
                if (nodeInfo instanceof BranchInfo && !(branchInfo = (BranchInfo)nodeInfo).isExpanded()) {
                    treeView.expandBranch(branchInfo.getPath());
                }
                consumed = true;
                break;
            }
            default: {
                consumed = super.keyPressed(component, keyCode, keyLocation);
            }
        }
        if (consumed) {
            this.clearHighlightedNode();
        }
        return consumed;
    }

    public boolean keyReleased(Component component, int keyCode, Keyboard.KeyLocation keyLocation) {
        boolean consumed = false;
        TreeView treeView = (TreeView)this.getComponent();
        if (keyCode == 32) {
            NodeInfo nodeInfo;
            Sequence.Tree.Path selectedPath;
            if (treeView.getCheckmarksEnabled() && treeView.getSelectMode() == TreeView.SelectMode.SINGLE && (selectedPath = treeView.getSelectedPath()) != null && !(nodeInfo = this.getNodeInfoAt(selectedPath)).isCheckmarkDisabled()) {
                treeView.setNodeChecked(selectedPath, !treeView.isNodeChecked(selectedPath));
            }
        } else {
            consumed = super.keyReleased(component, keyCode, keyLocation);
        }
        return consumed;
    }

    public boolean isFocusable() {
        TreeView treeView = (TreeView)this.getComponent();
        return treeView.getSelectMode() != TreeView.SelectMode.NONE;
    }

    public boolean isOpaque() {
        return this.backgroundColor != null && this.backgroundColor.getTransparency() == 1;
    }

    public void enabledChanged(Component component) {
        super.enabledChanged(component);
        this.repaintComponent();
    }

    public void focusedChanged(Component component, Component obverseComponent) {
        super.focusedChanged(component, obverseComponent);
        this.repaintComponent();
    }

    public Sequence.Tree.Path getNodeAt(int y) {
        Sequence.Tree.Path path = null;
        NodeInfo nodeInfo = this.getNodeInfoAt(y);
        if (nodeInfo != null) {
            path = nodeInfo.getPath();
        }
        return path;
    }

    public Bounds getNodeBounds(Sequence.Tree.Path path) {
        Bounds nodeBounds = null;
        NodeInfo nodeInfo = this.getNodeInfoAt(path);
        if (nodeInfo != null) {
            nodeBounds = this.getNodeBounds(nodeInfo);
        }
        return nodeBounds;
    }

    public int getNodeIndent(int depth) {
        TreeView treeView = (TreeView)this.getComponent();
        int nodeIndent = (depth - 1) * (this.indent + this.spacing);
        if (this.showBranchControls) {
            nodeIndent += this.indent + this.spacing;
        }
        if (treeView.getCheckmarksEnabled()) {
            nodeIndent += Math.max(CHECKBOX.getWidth(), this.indent) + this.spacing;
        }
        return nodeIndent;
    }

    public int getRowIndex(Sequence.Tree.Path path) {
        int rowIndex = -1;
        NodeInfo nodeInfo = this.getNodeInfoAt(path);
        if (nodeInfo != null) {
            rowIndex = this.visibleNodes.indexOf((Object)nodeInfo);
        }
        return rowIndex;
    }

    public void treeDataChanged(TreeView treeView, List<?> previousTreeData) {
        List treeData = treeView.getTreeData();
        this.visibleNodes.clear();
        if (treeData == null) {
            this.rootBranchInfo = null;
        } else {
            this.rootBranchInfo = new BranchInfo(treeView, null, treeData);
            this.addVisibleNodes(this.rootBranchInfo);
        }
        this.invalidateComponent();
    }

    public void nodeRendererChanged(TreeView treeView, TreeView.NodeRenderer previousNodeRenderer) {
        this.invalidateComponent();
    }

    public void nodeEditorChanged(TreeView treeView, TreeView.NodeEditor previousNodeEditor) {
    }

    public void selectModeChanged(TreeView treeView, TreeView.SelectMode previousSelectMode) {
        this.clearFields((byte)2);
        this.repaintComponent();
    }

    public void checkmarksEnabledChanged(TreeView treeView) {
        this.clearFields((byte)48);
        this.invalidateComponent();
    }

    public void showMixedCheckmarkStateChanged(TreeView treeView) {
        if (treeView.getCheckmarksEnabled()) {
            ArrayList nodes = new ArrayList();
            nodes.add((Object)this.rootBranchInfo);
            while (nodes.getLength() > 0) {
                NodeInfo nodeInfo = (NodeInfo)nodes.get(0);
                nodes.remove(0, 1);
                if (!(nodeInfo instanceof BranchInfo)) continue;
                BranchInfo branchInfo = (BranchInfo)nodeInfo;
                Sequence.Tree.Path path = branchInfo.getPath();
                branchInfo.setCheckState(treeView.getNodeCheckState(path));
                if (branchInfo.children == null) continue;
                int n = branchInfo.children.getLength();
                for (int i = 0; i < n; ++i) {
                    nodes.insert(branchInfo.children.get(i), i);
                }
            }
            this.repaintComponent();
        }
    }

    public void disabledNodeFilterChanged(TreeView treeView, Filter<?> previousDisabledNodeFilter) {
        final Filter disabledNodeFilter = treeView.getDisabledNodeFilter();
        this.accept(new NodeInfoVisitor(){

            @Override
            public void visit(NodeInfo nodeInfo) {
                if (nodeInfo != TerraTreeViewSkin.this.rootBranchInfo) {
                    nodeInfo.setDisabled(disabledNodeFilter != null && disabledNodeFilter.include(nodeInfo.data));
                }
            }
        });
        this.repaintComponent();
    }

    public void disabledCheckmarkFilterChanged(TreeView treeView, Filter<?> previousDisabledCheckmarkFilter) {
        final Filter disabledCheckmarkFilter = treeView.getDisabledCheckmarkFilter();
        this.accept(new NodeInfoVisitor(){

            @Override
            public void visit(NodeInfo nodeInfo) {
                if (nodeInfo != TerraTreeViewSkin.this.rootBranchInfo) {
                    nodeInfo.setCheckmarkDisabled(disabledCheckmarkFilter != null && disabledCheckmarkFilter.include(nodeInfo.data));
                }
            }
        });
        this.repaintComponent();
    }

    public void branchExpanded(TreeView treeView, Sequence.Tree.Path path) {
        BranchInfo branchInfo = (BranchInfo)this.getNodeInfoAt(path);
        branchInfo.setExpanded(true);
        this.addVisibleNodes(branchInfo);
        this.repaintNode(branchInfo);
    }

    public void branchCollapsed(TreeView treeView, Sequence.Tree.Path path) {
        BranchInfo branchInfo = (BranchInfo)this.getNodeInfoAt(path);
        branchInfo.setExpanded(false);
        this.removeVisibleNodes(branchInfo, 0, -1);
        this.repaintNode(branchInfo);
    }

    public void nodeInserted(TreeView treeView, Sequence.Tree.Path path, int index) {
        BranchInfo branchInfo = (BranchInfo)this.getNodeInfoAt(path);
        List branchData = (List)branchInfo.data;
        if (branchInfo.children != null) {
            NodeInfo nodeInfo = NodeInfo.newInstance(treeView, branchInfo, branchData.get(index));
            branchInfo.children.insert((Object)nodeInfo, index);
        }
        this.addVisibleNode(branchInfo, index);
    }

    public void nodesRemoved(TreeView treeView, Sequence.Tree.Path path, int index, int count) {
        BranchInfo branchInfo = (BranchInfo)this.getNodeInfoAt(path);
        this.removeVisibleNodes(branchInfo, index, count);
        if (branchInfo.children != null) {
            branchInfo.children.remove(index, count);
        }
    }

    public void nodeUpdated(TreeView treeView, Sequence.Tree.Path path, int index) {
        BranchInfo branchInfo = (BranchInfo)this.getNodeInfoAt(path);
        List branchData = (List)branchInfo.data;
        branchInfo.loadChildren();
        NodeInfo nodeInfo = (NodeInfo)branchInfo.children.get(index);
        Object previousNodeData = nodeInfo.data;
        Object nodeData = branchData.get(index);
        if (previousNodeData != nodeData) {
            this.removeVisibleNodes(branchInfo, index, 1);
            nodeInfo = NodeInfo.newInstance(treeView, branchInfo, nodeData);
            branchInfo.children.update(index, (Object)nodeInfo);
            this.addVisibleNode(branchInfo, index);
        } else {
            Filter disabledNodeFilter = treeView.getDisabledNodeFilter();
            nodeInfo.setDisabled(disabledNodeFilter != null && disabledNodeFilter.include(nodeData));
            if (this.visibleNodes.indexOf((Object)nodeInfo) >= 0) {
                this.invalidateComponent();
            }
        }
    }

    public void nodesCleared(TreeView treeView, Sequence.Tree.Path path) {
        BranchInfo branchInfo = (BranchInfo)this.getNodeInfoAt(path);
        this.removeVisibleNodes(branchInfo, 0, -1);
        if (branchInfo.children != null) {
            branchInfo.children.clear();
        }
    }

    public void nodesSorted(TreeView treeView, Sequence.Tree.Path path) {
        BranchInfo branchInfo = (BranchInfo)this.getNodeInfoAt(path);
        this.removeVisibleNodes(branchInfo, 0, -1);
        branchInfo.children = null;
        branchInfo.loadChildren();
        this.addVisibleNodes(branchInfo);
    }

    public void nodeCheckStateChanged(TreeView treeView, Sequence.Tree.Path path, TreeView.NodeCheckState previousCheckState) {
        NodeInfo nodeInfo = this.getNodeInfoAt(path);
        nodeInfo.setCheckState(treeView.getNodeCheckState(path));
        this.repaintNode(nodeInfo);
    }

    public void selectedPathAdded(TreeView treeView, Sequence.Tree.Path path) {
        NodeInfo nodeInfo = this.getNodeInfoAt(path);
        nodeInfo.setSelected(true);
        if (treeView.isValid()) {
            Bounds nodeBounds = this.getNodeBounds(nodeInfo);
            if (nodeBounds != null) {
                Bounds visibleSelectionBounds = treeView.getVisibleArea(nodeBounds);
                if (visibleSelectionBounds.height < nodeBounds.height) {
                    treeView.scrollAreaToVisible(nodeBounds);
                }
            }
        } else {
            this.validateSelection = true;
        }
        this.repaintNode(nodeInfo);
    }

    public void selectedPathRemoved(TreeView treeView, Sequence.Tree.Path path) {
        NodeInfo nodeInfo = this.getNodeInfoAt(path);
        nodeInfo.setSelected(false);
        this.repaintNode(nodeInfo);
    }

    public void selectedPathsChanged(TreeView treeView, Sequence<Sequence.Tree.Path> previousSelectedPaths) {
        if (previousSelectedPaths != null && previousSelectedPaths != treeView.getSelectedPaths()) {
            if (treeView.isValid()) {
                this.scrollSelectionToVisible();
            } else {
                this.validateSelection = true;
            }
            int n = previousSelectedPaths.getLength();
            for (int i = 0; i < n; ++i) {
                NodeInfo previousSelectedNode = this.getNodeInfoAt((Sequence.Tree.Path)previousSelectedPaths.get(i));
                previousSelectedNode.setSelected(false);
                this.repaintNode(previousSelectedNode);
            }
            ImmutableList selectedPaths = treeView.getSelectedPaths();
            int n2 = selectedPaths.getLength();
            for (int i = 0; i < n2; ++i) {
                NodeInfo selectedNode = this.getNodeInfoAt((Sequence.Tree.Path)selectedPaths.get(i));
                selectedNode.setSelected(true);
                this.repaintNode(selectedNode);
            }
        }
    }

    public void selectedNodeChanged(TreeView treeView, Object previousSelectedNode) {
    }

    static {
        CHECKBOX.setSize(CHECKBOX.getPreferredSize());
        CHECKBOX.setTriState(true);
    }

    protected static final class BranchInfo
    extends NodeInfo {
        private List<NodeInfo> children = null;
        public static final byte EXPANDED_MASK = 64;

        private BranchInfo(TreeView treeView, BranchInfo parent, List<Object> data) {
            super(treeView, parent, data);
        }

        public void loadChildren() {
            if (this.children == null) {
                List dataLocal = (List)this.data;
                int count = dataLocal.getLength();
                this.children = new ArrayList(count);
                for (int i = 0; i < count; ++i) {
                    Object nodeData = dataLocal.get(i);
                    NodeInfo childNodeInfo = NodeInfo.newInstance(this.treeView, this, nodeData);
                    this.children.add((Object)childNodeInfo);
                }
            }
        }

        public boolean isExpanded() {
            return (this.fields & 0x40) != 0;
        }

        public void setExpanded(boolean expanded) {
            this.fields = expanded ? (byte)(this.fields | 0x40) : (byte)(this.fields & 0xFFFFFFBF);
        }
    }

    protected static class NodeInfo {
        final TreeView treeView;
        final BranchInfo parent;
        final Object data;
        final int depth;
        byte fields = 0;
        public static final byte HIGHLIGHTED_MASK = 1;
        public static final byte SELECTED_MASK = 2;
        public static final byte DISABLED_MASK = 4;
        public static final byte CHECKMARK_DISABLED_MASK = 8;
        public static final byte CHECK_STATE_CHECKED_MASK = 16;
        public static final byte CHECK_STATE_MIXED_MASK = 32;
        public static final byte CHECK_STATE_MASK = 48;

        private NodeInfo(TreeView treeView, BranchInfo parent, Object data) {
            Filter disabledCheckmarkFilter;
            this.treeView = treeView;
            this.parent = parent;
            this.data = data;
            this.depth = parent == null ? 0 : parent.depth + 1;
            Filter disabledNodeFilter = treeView.getDisabledNodeFilter();
            if (disabledNodeFilter != null) {
                this.setDisabled(disabledNodeFilter.include(data));
            }
            if ((disabledCheckmarkFilter = treeView.getDisabledCheckmarkFilter()) != null) {
                this.setCheckmarkDisabled(disabledCheckmarkFilter.include(data));
            }
        }

        private static NodeInfo newInstance(TreeView treeView, BranchInfo parent, Object data) {
            NodeInfo nodeInfo = null;
            nodeInfo = data instanceof List ? new BranchInfo(treeView, parent, (List)data) : new NodeInfo(treeView, parent, data);
            return nodeInfo;
        }

        public Sequence.Tree.Path getPath() {
            Sequence.Tree.Path path = Sequence.Tree.Path.forDepth((int)this.depth);
            NodeInfo nodeInfo = this;
            while (nodeInfo.parent != null) {
                List parentData = (List)nodeInfo.parent.data;
                int index = parentData.indexOf(nodeInfo.data);
                path.insert(Integer.valueOf(index), 0);
                nodeInfo = nodeInfo.parent;
            }
            return path;
        }

        public boolean isHighlighted() {
            return (this.fields & 1) != 0;
        }

        public void setHighlighted(boolean highlighted) {
            this.fields = highlighted ? (byte)(this.fields | 1) : (byte)(this.fields & 0xFFFFFFFE);
        }

        public boolean isSelected() {
            return (this.fields & 2) != 0;
        }

        public void setSelected(boolean selected) {
            this.fields = selected ? (byte)(this.fields | 2) : (byte)(this.fields & 0xFFFFFFFD);
        }

        public boolean isDisabled() {
            return (this.fields & 4) != 0;
        }

        public void setDisabled(boolean disabled) {
            this.fields = disabled ? (byte)(this.fields | 4) : (byte)(this.fields & 0xFFFFFFFB);
        }

        public boolean isCheckmarkDisabled() {
            return (this.fields & 8) != 0;
        }

        public void setCheckmarkDisabled(boolean checkmarkDisabled) {
            this.fields = checkmarkDisabled ? (byte)(this.fields | 8) : (byte)(this.fields & 0xFFFFFFF7);
        }

        public TreeView.NodeCheckState getCheckState() {
            TreeView.NodeCheckState checkState;
            switch (this.fields & 0x30) {
                case 16: {
                    checkState = TreeView.NodeCheckState.CHECKED;
                    break;
                }
                case 32: {
                    checkState = TreeView.NodeCheckState.MIXED;
                    break;
                }
                default: {
                    checkState = TreeView.NodeCheckState.UNCHECKED;
                }
            }
            return checkState;
        }

        public boolean isChecked() {
            return (this.fields & 0x10) != 0;
        }

        public void setCheckState(TreeView.NodeCheckState checkState) {
            this.fields = (byte)(this.fields & 0xFFFFFFCF);
            switch (checkState) {
                case CHECKED: {
                    this.fields = (byte)(this.fields | 0x10);
                    break;
                }
                case MIXED: {
                    this.fields = (byte)(this.fields | 0x20);
                    break;
                }
                case UNCHECKED: {
                    break;
                }
            }
        }

        public void clearField(byte mask) {
            this.fields = (byte)(this.fields & ~mask);
        }
    }

    protected final class VisibleNodeIterator
    implements Iterator<NodeInfo> {
        private int index;
        private int end;
        private Sequence.Tree.Path path = null;
        private NodeInfo previous = null;

        public VisibleNodeIterator() {
            this(0, terraTreeViewSkin.visibleNodes.getLength() - 1);
        }

        public VisibleNodeIterator(int start, int end) {
            if (start < 0 || end >= TerraTreeViewSkin.this.visibleNodes.getLength()) {
                throw new IndexOutOfBoundsException();
            }
            this.index = start;
            this.end = end;
        }

        @Override
        public boolean hasNext() {
            return this.index <= this.end;
        }

        @Override
        public NodeInfo next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            NodeInfo next = (NodeInfo)TerraTreeViewSkin.this.visibleNodes.get(this.index++);
            if (this.path == null) {
                this.path = next.getPath();
            } else if (next.parent == this.previous) {
                this.path.add(Integer.valueOf(0));
            } else {
                int n = this.path.getLength();
                while (next.parent != this.previous.parent) {
                    this.path.remove(--n, 1);
                    this.previous = this.previous.parent;
                }
                int tail = this.path.get(n - 1);
                this.path.update(n - 1, Integer.valueOf(tail + 1));
            }
            this.previous = next;
            return next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public int getRowIndex() {
            return this.path == null ? -1 : this.index - 1;
        }

        public Sequence.Tree.Path getPath() {
            return this.path;
        }
    }

    protected static interface NodeInfoVisitor {
        public void visit(NodeInfo var1);
    }
}

