/*
 * Decompiled with CFR 0.152.
 */
package org.apache.plc4x.java.api.value;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.plc4x.java.api.types.PlcValueType;

@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS, property="className")
public interface PlcValue {
    public PlcValueType getPlcValueType();

    public Object getObject();

    public boolean isSimple();

    public boolean isNullable();

    public boolean isNull();

    public boolean is(Class<?> var1);

    public boolean isConvertibleTo(Class<?> var1);

    public <T> T get(Class<T> var1);

    public boolean isBoolean();

    public boolean getBoolean();

    public boolean isByte();

    public byte getByte();

    public boolean isShort();

    public short getShort();

    public boolean isInteger();

    public int getInteger();

    public int getInt();

    public boolean isLong();

    public long getLong();

    public boolean isBigInteger();

    public BigInteger getBigInteger();

    public boolean isFloat();

    public float getFloat();

    public boolean isDouble();

    public double getDouble();

    public boolean isBigDecimal();

    public BigDecimal getBigDecimal();

    public boolean isString();

    public String getString();

    public boolean isDuration();

    public Duration getDuration();

    public boolean isTime();

    public LocalTime getTime();

    public boolean isDate();

    public LocalDate getDate();

    public boolean isDateTime();

    public LocalDateTime getDateTime();

    public byte[] getRaw();

    public boolean isList();

    public int getLength();

    public PlcValue getIndex(int var1);

    public List<? extends PlcValue> getList();

    public boolean isStruct();

    public Set<String> getKeys();

    public boolean hasKey(String var1);

    public PlcValue getValue(String var1);

    public Map<String, ? extends PlcValue> getStruct();
}

